/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.MacAlgorithm;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class SSLUtils {
    private static final MessageFormat ILLEGAL_MAC_ALGORITHM = new MessageFormat("{0}, is not a valid MacAlgorithm for SSLv3, only MD5 and SHA-1 are available.");
    public static final byte[] MD5_PAD1 = ArrayConverter.hexStringToByteArray((String)StringUtils.repeat((String)"36", (int)48));
    public static final byte[] MD5_PAD2 = ArrayConverter.hexStringToByteArray((String)StringUtils.repeat((String)"5c", (int)48));
    public static final byte[] SHA_PAD1 = ArrayConverter.hexStringToByteArray((String)StringUtils.repeat((String)"36", (int)40));
    public static final byte[] SHA_PAD2 = ArrayConverter.hexStringToByteArray((String)StringUtils.repeat((String)"5c", (int)40));
    public static final byte[][] SSL3_CONST = SSLUtils.genSSL3Const();

    private static byte[][] genSSL3Const() {
        int n = 10;
        byte[][] arr = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] b = new byte[i + 1];
            Arrays.fill((byte[])b, (byte)((byte)(65 + i)));
            arr[i] = b;
        }
        return arr;
    }

    public static byte[] calculateMasterSecretSSL3(byte[] pre_master_secret, byte[] random) {
        Digest md5 = TlsUtils.createHash((short)1);
        Digest sha1 = TlsUtils.createHash((short)2);
        int md5Size = md5.getDigestSize();
        byte[] shatmp = new byte[sha1.getDigestSize()];
        byte[] rval = new byte[md5Size * 3];
        int pos = 0;
        for (int i = 0; i < 3; ++i) {
            byte[] ssl3Const = SSL3_CONST[i];
            sha1.update(ssl3Const, 0, ssl3Const.length);
            sha1.update(pre_master_secret, 0, pre_master_secret.length);
            sha1.update(random, 0, random.length);
            sha1.doFinal(shatmp, 0);
            md5.update(pre_master_secret, 0, pre_master_secret.length);
            md5.update(shatmp, 0, shatmp.length);
            md5.doFinal(rval, pos);
            pos += md5Size;
        }
        return rval;
    }

    public static byte[] calculateKeyBlockSSL3(byte[] master_secret, byte[] random, int size) {
        Digest md5 = TlsUtils.createHash((short)1);
        Digest sha1 = TlsUtils.createHash((short)2);
        int md5Size = md5.getDigestSize();
        byte[] shatmp = new byte[sha1.getDigestSize()];
        byte[] tmp = new byte[size + md5Size];
        int i = 0;
        int pos = 0;
        while (pos < size) {
            if (SSL3_CONST.length <= i) {
                i = 0;
            }
            byte[] ssl3Const = SSL3_CONST[i];
            sha1.update(ssl3Const, 0, ssl3Const.length);
            sha1.update(master_secret, 0, master_secret.length);
            sha1.update(random, 0, random.length);
            sha1.doFinal(shatmp, 0);
            md5.update(master_secret, 0, master_secret.length);
            md5.update(shatmp, 0, shatmp.length);
            md5.doFinal(tmp, pos);
            pos += md5Size;
            ++i;
        }
        return Arrays.copyOfRange((byte[])tmp, (int)0, (int)size);
    }

    public static byte[] getSenderConstant(Chooser chooser) {
        return SSLUtils.getSenderConstant(chooser.getConnectionEndType());
    }

    public static byte[] getSenderConstant(ConnectionEndType connectionEndType) {
        if (null == connectionEndType) {
            throw new IllegalStateException("The ConnectionEnd should be either of Type Client or Server but it is " + connectionEndType);
        }
        switch (connectionEndType) {
            case SERVER: {
                return Sender.SERVER.getValue();
            }
            case CLIENT: {
                return Sender.CLIENT.getValue();
            }
        }
        throw new IllegalStateException("The ConnectionEnd should be either of Type Client or Server but it is " + connectionEndType);
    }

    public static byte[] getPad1(MacAlgorithm macAlgorithm) {
        if (null == macAlgorithm) {
            throw new IllegalArgumentException(ILLEGAL_MAC_ALGORITHM.format(macAlgorithm.getJavaName()));
        }
        switch (macAlgorithm) {
            case SSLMAC_MD5: {
                return MD5_PAD1;
            }
            case SSLMAC_SHA1: {
                return SHA_PAD1;
            }
        }
        throw new IllegalArgumentException(ILLEGAL_MAC_ALGORITHM.format(macAlgorithm.getJavaName()));
    }

    public static byte[] getPad2(MacAlgorithm macAlgorithm) {
        if (null == macAlgorithm) {
            throw new IllegalArgumentException(ILLEGAL_MAC_ALGORITHM.format(macAlgorithm.getJavaName()));
        }
        switch (macAlgorithm) {
            case SSLMAC_MD5: {
                return MD5_PAD2;
            }
            case SSLMAC_SHA1: {
                return SHA_PAD2;
            }
        }
        throw new IllegalArgumentException(ILLEGAL_MAC_ALGORITHM.format(macAlgorithm.getJavaName()));
    }

    private static String getHashAlgorithm(MacAlgorithm macAlgorithm) {
        if (null == macAlgorithm) {
            throw new IllegalArgumentException(ILLEGAL_MAC_ALGORITHM.format(macAlgorithm.getJavaName()));
        }
        switch (macAlgorithm) {
            case SSLMAC_MD5: {
                return "MD5";
            }
            case SSLMAC_SHA1: {
                return "SHA-1";
            }
        }
        throw new IllegalArgumentException(ILLEGAL_MAC_ALGORITHM.format(macAlgorithm.getJavaName()));
    }

    public static byte[] calculateSSLMac(byte[] input, byte[] macWriteSecret, MacAlgorithm macAlgorithm) {
        byte[] pad1 = SSLUtils.getPad1(macAlgorithm);
        byte[] pad2 = SSLUtils.getPad2(macAlgorithm);
        try {
            String hashName = SSLUtils.getHashAlgorithm(macAlgorithm);
            MessageDigest hashFunction = MessageDigest.getInstance(hashName);
            byte[] innerInput = ArrayConverter.concatenate((byte[][])new byte[][]{macWriteSecret, pad1, input});
            byte[] innerHash = hashFunction.digest(innerInput);
            byte[] outerInput = ArrayConverter.concatenate((byte[][])new byte[][]{macWriteSecret, pad2, innerHash});
            byte[] outerHash = hashFunction.digest(outerInput);
            return outerHash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(ILLEGAL_MAC_ALGORITHM.format(macAlgorithm.getJavaName()));
        }
    }

    public static byte[] calculateSSLCertificateVerifySignature(byte[] handshakeMessages, byte[] masterSecret) {
        return SSLUtils.calculateSSLMd5SHASignature(handshakeMessages, masterSecret);
    }

    public static byte[] calculateFinishedData(byte[] handshakeMessages, byte[] masterSecret, ConnectionEndType connectionEndType) {
        byte[] input = ArrayConverter.concatenate((byte[][])new byte[][]{handshakeMessages, SSLUtils.getSenderConstant(connectionEndType)});
        return SSLUtils.calculateSSLMd5SHASignature(input, masterSecret);
    }

    private static byte[] calculateSSLMd5SHASignature(byte[] input, byte[] masterSecret) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] innerMD5Content = ArrayConverter.concatenate((byte[][])new byte[][]{input, masterSecret, MD5_PAD1});
            byte[] innerSHAContent = ArrayConverter.concatenate((byte[][])new byte[][]{input, masterSecret, SHA_PAD1});
            byte[] innerMD5 = md5.digest(innerMD5Content);
            byte[] innerSHA = sha.digest(innerSHAContent);
            byte[] outerMD5Content = ArrayConverter.concatenate((byte[][])new byte[][]{masterSecret, MD5_PAD2, innerMD5});
            byte[] outerSHAContent = ArrayConverter.concatenate((byte[][])new byte[][]{masterSecret, SHA_PAD2, innerSHA});
            byte[] outerMD5 = md5.digest(outerMD5Content);
            byte[] outerSHA = sha.digest(outerSHAContent);
            return ArrayConverter.concatenate((byte[][])new byte[][]{outerMD5, outerSHA});
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Either MD5 or SHA-1 algorithm is not provided by the Execution-Enviroment, check your providers.", e);
        }
    }

    private SSLUtils() {
    }

    private static enum Sender {
        CLIENT("434C4E54"),
        SERVER("53525652");

        private final byte[] value;

        private Sender(String hex) {
            this.value = ArrayConverter.hexStringToByteArray((String)hex);
        }

        public byte[] getValue() {
            return this.value;
        }
    }
}

