/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.internal.ConstructionProxy;
import com.google.inject.internal.ConstructionProxyFactory;
import com.google.inject.spi.InjectionPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

final class DefaultConstructionProxyFactory<T>
implements ConstructionProxyFactory<T> {
    private final InjectionPoint injectionPoint;

    DefaultConstructionProxyFactory(InjectionPoint injectionPoint) {
        this.injectionPoint = injectionPoint;
    }

    @Override
    public ConstructionProxy<T> create() {
        final Constructor constructor = (Constructor)this.injectionPoint.getMember();
        if (Modifier.isPublic(constructor.getModifiers())) {
            Class classToConstruct = constructor.getDeclaringClass();
            if (!Modifier.isPublic(classToConstruct.getModifiers())) {
                constructor.setAccessible(true);
            }
        } else {
            constructor.setAccessible(true);
        }
        return new ConstructionProxy<T>(){

            @Override
            public T newInstance(Object ... arguments) throws InvocationTargetException {
                try {
                    return constructor.newInstance(arguments);
                }
                catch (InstantiationException e2) {
                    throw new AssertionError((Object)e2);
                }
                catch (IllegalAccessException e3) {
                    throw new AssertionError((Object)e3);
                }
            }

            @Override
            public InjectionPoint getInjectionPoint() {
                return DefaultConstructionProxyFactory.this.injectionPoint;
            }

            @Override
            public Constructor<T> getConstructor() {
                return constructor;
            }
        };
    }
}

