/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class XmlWriter {
    List<String> tags = new ArrayList<String>();
    StringBuilder sb = new StringBuilder();

    public XmlWriter start(String name2) {
        this.sb.append("<").append(name2).append(">");
        this.tags.add(name2);
        return this;
    }

    public XmlWriter start(String name2, String attr, String value) {
        this.sb.append("<").append(name2);
        this.writeAttr(attr, value);
        this.sb.append(">");
        this.tags.add(name2);
        return this;
    }

    public XmlWriter start(String name2, String[] attrs, String[] values) {
        this.sb.append("<").append(name2);
        for (int i = 0; i < Math.min(attrs.length, values.length); ++i) {
            this.writeAttr(attrs[i], values[i]);
        }
        this.sb.append(">");
        this.tags.add(name2);
        return this;
    }

    public XmlWriter end() {
        assert (this.tags.size() > 0);
        String name2 = this.tags.remove(this.tags.size() - 1);
        this.sb.append("</").append(name2).append(">");
        return this;
    }

    public byte[] getBytes() {
        assert (this.tags.size() == 0);
        return this.toString().getBytes(StringUtils.UTF8);
    }

    public String toString() {
        return this.sb.toString();
    }

    public XmlWriter value(String value) {
        this.appendEscapedString(value, this.sb);
        return this;
    }

    private void writeAttr(String name2, String value) {
        this.sb.append(' ').append(name2).append("=\"");
        this.appendEscapedString(value, this.sb);
        this.sb.append("\"");
    }

    private void appendEscapedString(String s, StringBuilder builder) {
        int pos;
        if (s == null) {
            s = "";
        }
        int start = 0;
        int len = s.length();
        for (pos = 0; pos < len; ++pos) {
            String escape2;
            char ch = s.charAt(pos);
            switch (ch) {
                case '\t': {
                    escape2 = "&#9;";
                    break;
                }
                case '\n': {
                    escape2 = "&#10;";
                    break;
                }
                case '\r': {
                    escape2 = "&#13;";
                    break;
                }
                case '&': {
                    escape2 = "&amp;";
                    break;
                }
                case '\"': {
                    escape2 = "&quot;";
                    break;
                }
                case '<': {
                    escape2 = "&lt;";
                    break;
                }
                case '>': {
                    escape2 = "&gt;";
                    break;
                }
                default: {
                    escape2 = null;
                }
            }
            if (escape2 == null) continue;
            if (start < pos) {
                builder.append(s, start, pos);
            }
            this.sb.append(escape2);
            start = pos + 1;
        }
        if (start < pos) {
            this.sb.append(s, start, pos);
        }
    }
}

