"""Generated message classes for clouddeploy version v1alpha1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'clouddeploy'


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class BuildArtifact(_messages.Message):
  r"""An artifact created from a render operation.

  Fields:
    imageName: Name of an image. Format is {hostname}/{projectID}/{imageName}
    tag: Tag of the image.
  """

  imageName = _messages.StringField(1)
  tag = _messages.StringField(2)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class ClouddeployProjectsLocationsDeliveryPipelinesCreateRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesCreateRequest object.

  Fields:
    deliveryPipeline: A DeliveryPipeline resource to be passed as the request
      body.
    deliveryPipelineId: ID of the `DeliveryPipeline`.
    parent: Required. The parent collection in which the `DeliveryPipeline`
      should be created. Format should be
      projects/{projectID}/locations/{locationName}.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    validateOnly: If set to true, the request is validated and the user is
      provided with an expected result, but no actual change is made.
  """

  deliveryPipeline = _messages.MessageField('DeliveryPipeline', 1)
  deliveryPipelineId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class ClouddeployProjectsLocationsDeliveryPipelinesDeleteRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesDeleteRequest object.

  Fields:
    allowMissing: If set to true, then deleting an already deleted or non-
      existing `DeliveryPipeline` will succeed.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    name: Required. The name of the `DeliveryPipeline` to delete. Format
      should be projects/{projectID}/locations/{locationName}/deliveryPipeline
      s/{pipelineName}.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    validateOnly: If set, validate the request and preview the review, but do
      not actually post it.
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class ClouddeployProjectsLocationsDeliveryPipelinesGetIamPolicyRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesGetRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesGetRequest object.

  Fields:
    name: Required. Name of the `DeliveryPipeline`. Format must be projects/{p
      rojectID}/locations/{locationName}/deliveryPipelines/{pipelineName}.
  """

  name = _messages.StringField(1, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesListRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesListRequest object.

  Fields:
    filter: Filter builds to be returned. See https://google.aip.dev/160 for
      more details.
    orderBy: Field to sort by. See https://google.aip.dev/132#ordering for
      more details.
    pageSize: The maximum number of pipelines to return. The service may
      return fewer than this value. If unspecified, at most 50 pipelines will
      be returned. The maximum value is 1000; values above 1000 will be set to
      1000.
    pageToken: A page token, received from a previous `ListDeliveryPipelines`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other provided parameters match the call that provided the page token.
    parent: Required. The parent, which owns this collection of pipelines.
      Format must be projects/{projectID}/locations/{locationName}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesPatchRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesPatchRequest object.

  Fields:
    allowMissing: If set to true, updating a `DeliveryPipeline` that does not
      exist will result in the creation of a new `DeliveryPipeline`.
    deliveryPipeline: A DeliveryPipeline resource to be passed as the request
      body.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    name: Required. Name of the `DeliveryPipeline`. Format is
      projects/{project}/ locations/{location}/deliveryPipelines/a-z{0,62}.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Field mask is used to specify the fields to be overwritten in
      the `DeliveryPipeline` resource by the update. The fields specified in
      the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
    validateOnly: If set to true, the request is validated and the user is
      provided with an expected result, but no actual change is made.
  """

  allowMissing = _messages.BooleanField(1)
  deliveryPipeline = _messages.MessageField('DeliveryPipeline', 2)
  etag = _messages.StringField(3)
  name = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  updateMask = _messages.StringField(6)
  validateOnly = _messages.BooleanField(7)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesCreateRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesReleasesCreateRequest
  object.

  Fields:
    parent: Required. The parent collection in which the `Release` should be
      created. Format should be projects/{projectID}/locations/{locationName}/
      deliveryPipelines/{pipelineName}.
    release: A Release resource to be passed as the request body.
    releaseId: ID of the `Release`.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    validateOnly: If set to true, the request is validated and the user is
      provided with an expected result, but no actual change is made.
  """

  parent = _messages.StringField(1, required=True)
  release = _messages.MessageField('Release', 2)
  releaseId = _messages.StringField(3)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesDeleteRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesReleasesDeleteRequest
  object.

  Fields:
    allowMissing: If set to true, then deleting an already deleted or non-
      existing `DeliveryPipeline` will succeed.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    name: Required. The name of the `Release` to delete. Format is projects/{p
      rojectID}/locations/{locationName}/deliveryPipelines/{pipelineName}/rele
      ase/{releaseName}.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    validateOnly: If set, validate the request and preview the review, but do
      not actually post it.
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesGetIamPolicyRequest(_messages.Message):
  r"""A
  ClouddeployProjectsLocationsDeliveryPipelinesReleasesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesGetRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesReleasesGetRequest
  object.

  Fields:
    name: Required. Name of the `Release`. Format must be projects/{projectID}
      /locations/{locationName}/deliveryPipelines/{pipelineName}/releases/{rel
      easeName}.
  """

  name = _messages.StringField(1, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesListRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesReleasesListRequest
  object.

  Fields:
    filter: Filter builds to be returned. See https://google.aip.dev/160 for
      more details.
    orderBy: Field to sort by. See https://google.aip.dev/132#ordering for
      more details.
    pageSize: The maximum number of `Release` objects to return. The service
      may return fewer than this value. If unspecified, at most 50 `Release`
      objects will be returned. The maximum value is 1000; values above 1000
      will be set to 1000.
    pageToken: A page token, received from a previous `ListReleases` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      provided parameters match the call that provided the page token.
    parent: Required. The `DeliveryPipeline` which owns this collection of
      `Release` objects.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesPromoteRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesReleasesPromoteRequest
  object.

  Fields:
    name: Required. The `Release` being promoted. Format is projects/{projectI
      D}/locations/{locationName}/deliveryPipelines/{pipelineName}/release/{re
      leaseName}.
    toTarget: [Optional] The name of the `Target` to which we are promoting
      the Release.
  """

  name = _messages.StringField(1, required=True)
  toTarget = _messages.StringField(2)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsCreateRequest(_messages.Message):
  r"""A
  ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsCreateRequest
  object.

  Fields:
    parent: Required. The parent collection in which the `Rollout` should be
      created. Format should be projects/{projectID}/locations/{locationName}/
      deliveryPipelines/{pipelineName}/releases/{releaseName}.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    rollout: A Rollout resource to be passed as the request body.
    rolloutId: ID of the `Rollout`.
    validateOnly: If set to true, the request is validated and the user is
      provided with an expected result, but no actual change is made.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  rollout = _messages.MessageField('Rollout', 3)
  rolloutId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsGetIamPolicyRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsGetIamPol
  icyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsGetRequest(_messages.Message):
  r"""A
  ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsGetRequest
  object.

  Fields:
    name: Required. Name of the `Rollout`. Format must be projects/{projectID}
      /locations/{locationName}/deliveryPipelines/{pipelineName}/releases/{rel
      easeName}/rollouts/{rolloutName}.
  """

  name = _messages.StringField(1, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsListRequest(_messages.Message):
  r"""A
  ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsListRequest
  object.

  Fields:
    filter: Filter builds to be returned. See https://google.aip.dev/160 for
      more details.
    orderBy: Field to sort by. See https://google.aip.dev/132#ordering for
      more details.
    pageSize: The maximum number of `Rollout` objects to return. The service
      may return fewer than this value. If unspecified, at most 50 `Rollout`
      objects will be returned. The maximum value is 1000; values above 1000
      will be set to 1000.
    pageToken: A page token, received from a previous `ListRollouts` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      provided parameters match the call that provided the page token.
    parent: Required. The `Release` which owns this collection of `Rollout`
      objects.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsSetIamPolicyRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsSetIamPol
  icyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsTestIamPermissionsRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesReleasesRolloutsTestIamPe
  rmissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesSetIamPolicyRequest(_messages.Message):
  r"""A
  ClouddeployProjectsLocationsDeliveryPipelinesReleasesSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ClouddeployProjectsLocationsDeliveryPipelinesReleasesTestIamPermissionsRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesReleasesTestIamPermission
  sRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ClouddeployProjectsLocationsDeliveryPipelinesSetIamPolicyRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ClouddeployProjectsLocationsDeliveryPipelinesTargetsCreateRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesTargetsCreateRequest
  object.

  Fields:
    parent: Required. The parent collection in which the `Target` should be
      created. Format should be projects/{projectID}/locations/{locationName}/
      deliverPiplines/{pipelineName}.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    target: A Target resource to be passed as the request body.
    targetId: ID of the `Target`.
    validateOnly: If set to true, the request is validated and the user is
      provided with an expected result, but no actual change is made.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  target = _messages.MessageField('Target', 3)
  targetId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class ClouddeployProjectsLocationsDeliveryPipelinesTargetsDeleteRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesTargetsDeleteRequest
  object.

  Fields:
    allowMissing: If set to true, then deleting an already deleted or non-
      existing DeliveryPipeline will succeed.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    name: Required. The name of the `Target` to delete. Format should be proje
      cts/{projectID}/locations/{locationName}/deliveryPipelines/{pipelineName
      }/targets/{targetName}.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    validateOnly: If set, validate the request and preview the review, but do
      not actually post it.
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class ClouddeployProjectsLocationsDeliveryPipelinesTargetsGetIamPolicyRequest(_messages.Message):
  r"""A
  ClouddeployProjectsLocationsDeliveryPipelinesTargetsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesTargetsGetRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesTargetsGetRequest object.

  Fields:
    name: Required. Name of the `Target`. Format must be projects/{projectID}/
      locations/{locationName}/deliveryPipelines/{pipelineName}/targets/{targe
      tName}.
  """

  name = _messages.StringField(1, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesTargetsListRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesTargetsListRequest
  object.

  Fields:
    filter: Filter builds to be returned. See https://google.aip.dev/160 for
      more details.
    orderBy: Field to sort by. See https://google.aip.dev/132#ordering for
      more details.
    pageSize: The maximum number of `Target` objects to return. The service
      may return fewer than this value. If unspecified, at most 50 `Target`
      objects will be returned. The maximum value is 1000; values above 1000
      will be set to 1000.
    pageToken: A page token, received from a previous `ListTargets` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      provided parameters match the call that provided the page token.
    parent: Required. The `DeliveryPipeline` which owns this collection of
      `Target` objects.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ClouddeployProjectsLocationsDeliveryPipelinesTargetsPatchRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesTargetsPatchRequest
  object.

  Fields:
    allowMissing: If set to true, updating a `Target` that does not exist will
      result in the creation of a new `Target`.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    name: Required. Name of the `Target`. Format is
      projects/{project}/locations/{location}/
      deliveryPipelines/{deliveryPipeline}/targets/a-z{0,62}.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    target: A Target resource to be passed as the request body.
    updateMask: Field mask is used to specify the fields to be overwritten in
      the Target resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then all fields will be overwritten.
    validateOnly: If set to true, the request is validated and the user is
      provided with an expected result, but no actual change is made.
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  target = _messages.MessageField('Target', 5)
  updateMask = _messages.StringField(6)
  validateOnly = _messages.BooleanField(7)


class ClouddeployProjectsLocationsDeliveryPipelinesTargetsSetIamPolicyRequest(_messages.Message):
  r"""A
  ClouddeployProjectsLocationsDeliveryPipelinesTargetsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ClouddeployProjectsLocationsDeliveryPipelinesTargetsTestIamPermissionsRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesTargetsTestIamPermissions
  Request object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ClouddeployProjectsLocationsDeliveryPipelinesTestIamPermissionsRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsDeliveryPipelinesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ClouddeployProjectsLocationsGetRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ClouddeployProjectsLocationsListRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      will select a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ClouddeployProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ClouddeployProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ClouddeployProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ClouddeployProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ClouddeployProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DeliveryPipeline(_messages.Message):
  r"""A `DeliveryPipeline` resource in the Cloud Deploy API. A
  `DeliveryPipeline` defines a pipeline through which a Skaffold configuration
  can progress.

  Messages:
    AnnotationsValue: User annotations. These attributes can only be set and
      used by the user, and not by Cloud Deploy. See
      https://google.aip.dev/128#annotations for more details such as format
      and size limitations.
    LabelsValue: Labels are attributes that can be set and used by both the
      user and by Cloud Deploy. Labels must meet the following constraints:
      Each resource is limited to 64 labels. Keys must conform to the regexp:
      a-zA-Z{0,62} Values must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both
      keys and values are additionally constrained to be <= 128 bytes in size.

  Fields:
    annotations: User annotations. These attributes can only be set and used
      by the user, and not by Cloud Deploy. See
      https://google.aip.dev/128#annotations for more details such as format
      and size limitations.
    condition: Output only. Information around the state of the Delivery
      Pipeline.
    createTime: Output only. Time at which the pipeline was created.
    description: Description of the `DeliveryPipeline`. Max length is 255
      characters.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    labels: Labels are attributes that can be set and used by both the user
      and by Cloud Deploy. Labels must meet the following constraints: Each
      resource is limited to 64 labels. Keys must conform to the regexp:
      a-zA-Z{0,62} Values must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both
      keys and values are additionally constrained to be <= 128 bytes in size.
    name: Required. Name of the `DeliveryPipeline`. Format is
      projects/{project}/ locations/{location}/deliveryPipelines/a-z{0,62}.
    renderServiceAccount: Service account used to render a `Release`. If
      unset, the compute service account will be used.
    serialPipeline: A SerialPipeline attribute.
    uid: Output only. Unique identifier of the `DeliveryPipeline`.
    updateTime: Output only. Most recent time at which the pipeline was
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""User annotations. These attributes can only be set and used by the
    user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
    for more details such as format and size limitations.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are attributes that can be set and used by both the user and by
    Cloud Deploy. Labels must meet the following constraints: Each resource is
    limited to 64 labels. Keys must conform to the regexp: a-zA-Z{0,62} Values
    must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both keys and values are
    additionally constrained to be <= 128 bytes in size.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  condition = _messages.MessageField('PipelineCondition', 2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  etag = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  renderServiceAccount = _messages.StringField(8)
  serialPipeline = _messages.MessageField('SerialPipeline', 9)
  uid = _messages.StringField(10)
  updateTime = _messages.StringField(11)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GKECluster(_messages.Message):
  r"""Information specifying a GKE Cluster.

  Fields:
    cluster: Name of the cluster.
    location: Location of the cluster.
    project: Project in which the cluster is located.
  """

  cluster = _messages.StringField(1)
  location = _messages.StringField(2)
  project = _messages.StringField(3)


class ListDeliveryPipelinesResponse(_messages.Message):
  r"""The response object from `ListDeliveryPipelines`.

  Fields:
    deliveryPipelines: The `DeliveryPipeline` objects.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Locations that could not be reached.
  """

  deliveryPipelines = _messages.MessageField('DeliveryPipeline', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListReleasesResponse(_messages.Message):
  r"""The response object from `ListReleases`.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    releases: The `Release` objects.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  releases = _messages.MessageField('Release', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListRolloutsResponse(_messages.Message):
  r"""ListRolloutsResponse is the response object reutrned by `ListRollouts`.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    rollouts: The `Rollout` objects.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  rollouts = _messages.MessageField('Rollout', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListTargetsResponse(_messages.Message):
  r"""The response object from `ListTargets`.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    targets: The `Target` objects.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  targets = _messages.MessageField('Target', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class MissingTargetsCondition(_messages.Message):
  r"""MissingTargetCondition contains information on any Targets defined in
  the Delivery Pipeline that do not actually exist.

  Fields:
    changeTime: Last time the condition was updated.
    missingTargets: The list of Target names that are missing. For example, pr
      ojects/{projectName}/locations/{locationName}/deliveryPipelines/{pipelin
      eName}/targets/{targetName}.
    ready: True if there aren't any missing Targets.
  """

  changeTime = _messages.StringField(1)
  missingTargets = _messages.StringField(2, repeated=True)
  ready = _messages.BooleanField(3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class PipelineCondition(_messages.Message):
  r"""PipelineCondition contains all conditions relevant to a Delivery
  Pipeline.

  Fields:
    missingTargetsCondition: Details around missing targets.
    pipelineReadyCondition: Details around the Pipeline's overall status.
  """

  missingTargetsCondition = _messages.MessageField('MissingTargetsCondition', 1)
  pipelineReadyCondition = _messages.MessageField('PipelineReadyCondition', 2)


class PipelineReadyCondition(_messages.Message):
  r"""PipelineReadyCondition contains information around the status of the
  Pipeline.

  Fields:
    changeTime: Last time the condition was updated.
    ready: True if the Pipeline is in a valid state.
  """

  changeTime = _messages.StringField(1)
  ready = _messages.BooleanField(2)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= -
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class PromoteReleaseResponse(_messages.Message):
  r"""The response object from `PromoteRelease`.

  Fields:
    release: The `Release` being deployed.
    rollout: `Rollout` that was created from this promotion.
  """

  release = _messages.StringField(1)
  rollout = _messages.MessageField('Promotion', 2)


class Promotion(_messages.Message):
  r"""Details around a `Release` promotion.

  Fields:
    operation: The name of the operation that is tracking the `Rollout`
      creation.
    rollout: The name of the `Rollout` that is being deployed.
    target: The name of the `Target` to which is being deployed.
  """

  operation = _messages.StringField(1)
  rollout = _messages.StringField(2)
  target = _messages.StringField(3)


class Release(_messages.Message):
  r"""A `Release` resource in the Cloud Deploy API. A `Release` defines a
  specific Skaffold configuration instance that can be deployed.

  Enums:
    RenderStateValueValuesEnum: Current state of the render operation.

  Messages:
    AnnotationsValue: User annotations. These attributes can only be set and
      used by the user, and not by Cloud Deploy. See
      https://google.aip.dev/128#annotations for more details such as format
      and size limitations.
    LabelsValue: Labels are attributes that can be set and used by both the
      user and by Cloud Deploy. Labels must meet the following constraints:
      Each resource is limited to 64 labels. Keys must conform to the regexp:
      a-zA-Z{0,62} Values must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both
      keys and values are additionally constrained to be <= 128 bytes in size.
    RenderedManifestsValue: Output only. Map from target ID to GCS path of the
      rendered manifest for that target.

  Fields:
    annotations: User annotations. These attributes can only be set and used
      by the user, and not by Cloud Deploy. See
      https://google.aip.dev/128#annotations for more details such as format
      and size limitations.
    buildArtifacts: List of artifacts to pass through to Skaffold command.
    createTime: Output only. Time at which the `Release` was created.
    deliveryPipelineSnapshot: Releases take a snapshot of the world at
      creation time.
    description: Description of the `Release`. Max length is 255 characters.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    labels: Labels are attributes that can be set and used by both the user
      and by Cloud Deploy. Labels must meet the following constraints: Each
      resource is limited to 64 labels. Keys must conform to the regexp:
      a-zA-Z{0,62} Values must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both
      keys and values are additionally constrained to be <= 128 bytes in size.
    manifestBucket: GCS bucket to store the rendered manifests. If empty, a
      bucket will be provided.
    name: Required. Name of the `Release`. Format is projects/{project}/
      locations/{location}/deliveryPipelines/{deliveryPipeline}/
      releases/a-z{0,62}.
    renderBuild: Output only. The resource name of the Cloud Build `Build`
      object that is used to render the manifests. Format is
      `projects/{project}/builds/{build}` or
      `projects/{project}/locations/{location}/builds/{build}`
    renderEndTime: Output only. Time at which the render completed.
    renderStartTime: Output only. Time at which the render began.
    renderState: Current state of the render operation.
    renderedManifests: Output only. Map from target ID to GCS path of the
      rendered manifest for that target.
    skaffoldConfigPath: Filepath of the Skaffold config inside of the config
      URI.
    skaffoldConfigUri: GCS URI of tar.gz archive containing Skaffold
      configuration.
    targetSnapshot: A Target attribute.
    uid: Output only. Unique identifier of the `Release`.
  """

  class RenderStateValueValuesEnum(_messages.Enum):
    r"""Current state of the render operation.

    Values:
      RENDER_STATE_UNSPECIFIED: <no description>
      SUCCESS: The render operation has completed successfully.
      FAILURE: The render operation has failed.
      IN_PROGRESS: The render operation is in progress.
    """
    RENDER_STATE_UNSPECIFIED = 0
    SUCCESS = 1
    FAILURE = 2
    IN_PROGRESS = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""User annotations. These attributes can only be set and used by the
    user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
    for more details such as format and size limitations.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are attributes that can be set and used by both the user and by
    Cloud Deploy. Labels must meet the following constraints: Each resource is
    limited to 64 labels. Keys must conform to the regexp: a-zA-Z{0,62} Values
    must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both keys and values are
    additionally constrained to be <= 128 bytes in size.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RenderedManifestsValue(_messages.Message):
    r"""Output only. Map from target ID to GCS path of the rendered manifest
    for that target.

    Messages:
      AdditionalProperty: An additional property for a RenderedManifestsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        RenderedManifestsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RenderedManifestsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  buildArtifacts = _messages.MessageField('BuildArtifact', 2, repeated=True)
  createTime = _messages.StringField(3)
  deliveryPipelineSnapshot = _messages.MessageField('DeliveryPipeline', 4)
  description = _messages.StringField(5)
  etag = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  manifestBucket = _messages.StringField(8)
  name = _messages.StringField(9)
  renderBuild = _messages.StringField(10)
  renderEndTime = _messages.StringField(11)
  renderStartTime = _messages.StringField(12)
  renderState = _messages.EnumField('RenderStateValueValuesEnum', 13)
  renderedManifests = _messages.MessageField('RenderedManifestsValue', 14)
  skaffoldConfigPath = _messages.StringField(15)
  skaffoldConfigUri = _messages.StringField(16)
  targetSnapshot = _messages.MessageField('Target', 17, repeated=True)
  uid = _messages.StringField(18)


class Rollout(_messages.Message):
  r"""A `Rollout` resource in the Cloud Deploy API. A `Rollout` contains
  information around a specific deployment to a `Target`.

  Enums:
    ApprovalStateValueValuesEnum: Approval state of the `Rollout`.
    StateValueValuesEnum: Output only. Current state of the `Rollout`.

  Messages:
    AnnotationsValue: User annotations. These attributes can only be set and
      used by the user, and not by Cloud Deploy. See
      https://google.aip.dev/128#annotations for more details such as format
      and size limitations.
    LabelsValue: Labels are attributes that can be set and used by both the
      user and by Cloud Deploy. Labels must meet the following constraints:
      Each resource is limited to 64 labels. Keys must conform to the regexp:
      a-zA-Z{0,62} Values must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both
      keys and values are additionally constrained to be <= 128 bytes in size.

  Fields:
    annotations: User annotations. These attributes can only be set and used
      by the user, and not by Cloud Deploy. See
      https://google.aip.dev/128#annotations for more details such as format
      and size limitations.
    approvalState: Approval state of the `Rollout`.
    approveTime: Output only. Time at which the `Rollout` was approved.
    createTime: Output only. Time at which the `Rollout` was created.
    deployBuild: Output only. The resource name of the Cloud Build `Build`
      object that is used to deploy the Rollout. Format is
      `projects/{project}/builds/{build}` or
      `projects/{project}/locations/{location}/builds/{build}`
    deployEndTime: Output only. Time at which the `Rollout` finished
      deploying.
    deployStartTime: Output only. Time at which the `Rollout` started
      deploying.
    description: Description of the `Rollout` for user purposes. Max length is
      255 characters.
    enqueueTime: Output only. Time at which the `Rollout` was enqueued.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    failureReason: Output only. Reason the build failed. Empty if the build
      succeeded.
    labels: Labels are attributes that can be set and used by both the user
      and by Cloud Deploy. Labels must meet the following constraints: Each
      resource is limited to 64 labels. Keys must conform to the regexp:
      a-zA-Z{0,62} Values must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both
      keys and values are additionally constrained to be <= 128 bytes in size.
    name: Required. Name of the `Rollout`. Format is projects/{project}/
      locations/{location}/deliveryPipelines/{deliveryPipeline}/
      releases/{release}/rollouts/a-z{0,62}.
    state: Output only. Current state of the `Rollout`.
    target: The Target to which this `Rollout` is deploying.
    uid: Output only. Unique identifier of the `Rollout`.
  """

  class ApprovalStateValueValuesEnum(_messages.Enum):
    r"""Approval state of the `Rollout`.

    Values:
      APPROVAL_STATE_UNSPECIFIED: <no description>
      NEEDS_APPROVAL: The `Rollout` requires approval.
      DOES_NOT_NEED_APPROVAL: The `Rollout` does not require approval.
      APPROVED: The `Rollout` has been approved.
      REJECTED: The `Rollout` has been rejected.
    """
    APPROVAL_STATE_UNSPECIFIED = 0
    NEEDS_APPROVAL = 1
    DOES_NOT_NEED_APPROVAL = 2
    APPROVED = 3
    REJECTED = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the `Rollout`.

    Values:
      STATE_UNSPECIFIED: <no description>
      SUCCESS: The `Rollout` has completed successfully.
      FAILURE: The `Rollout` has failed.
      IN_PROGRESS: The `Rollout` is being deployed.
      PENDING_APPROVAL: The `Rollout` needs approval.
      APPROVAL_REJECTED: An approver rejected the `Rollout`.
      PENDING: The `Rollout` is waiting for an earlier Rollout(s) to complete
        on this `Target`.
      PENDING_RELEASE: The `Rollout` is waiting for the `Release` to be fully
        rendered.
    """
    STATE_UNSPECIFIED = 0
    SUCCESS = 1
    FAILURE = 2
    IN_PROGRESS = 3
    PENDING_APPROVAL = 4
    APPROVAL_REJECTED = 5
    PENDING = 6
    PENDING_RELEASE = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""User annotations. These attributes can only be set and used by the
    user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
    for more details such as format and size limitations.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are attributes that can be set and used by both the user and by
    Cloud Deploy. Labels must meet the following constraints: Each resource is
    limited to 64 labels. Keys must conform to the regexp: a-zA-Z{0,62} Values
    must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both keys and values are
    additionally constrained to be <= 128 bytes in size.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  approvalState = _messages.EnumField('ApprovalStateValueValuesEnum', 2)
  approveTime = _messages.StringField(3)
  createTime = _messages.StringField(4)
  deployBuild = _messages.StringField(5)
  deployEndTime = _messages.StringField(6)
  deployStartTime = _messages.StringField(7)
  description = _messages.StringField(8)
  enqueueTime = _messages.StringField(9)
  etag = _messages.StringField(10)
  failureReason = _messages.StringField(11)
  labels = _messages.MessageField('LabelsValue', 12)
  name = _messages.StringField(13)
  state = _messages.EnumField('StateValueValuesEnum', 14)
  target = _messages.StringField(15)
  uid = _messages.StringField(16)


class SerialPipeline(_messages.Message):
  r"""SerialPipeline defines a sequential set of stages for a
  `DeliveryPipeline`.

  Fields:
    stages: Each stage specifies configuration for a `Target`. The ordering of
      this list defines the promotion flow.
  """

  stages = _messages.MessageField('Stage', 1, repeated=True)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class Stage(_messages.Message):
  r"""Stage specifies a location to which to deploy.

  Fields:
    profiles: Profiles to use when rendering the manifest for this stage's
      `Target`.
    targetId: The target_id to which this stage points. Format is
      "targetName". The parent of the `Target` is the `DeliveryPipeline` in
      which this stage lives.
  """

  profiles = _messages.StringField(1, repeated=True)
  targetId = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Target(_messages.Message):
  r"""A `Target` resource in the Cloud Deploy API. A `Target` defines a
  location to which a Skaffold configuration can be deployed.

  Messages:
    AnnotationsValue: User annotations. These attributes can only be set and
      used by the user, and not by Cloud Deploy. See
      https://google.aip.dev/128#annotations for more details such as format
      and size limitations.
    LabelsValue: Labels are attributes that can be set and used by both the
      user and by Cloud Deploy. Labels must meet the following constraints:
      Each resource is limited to 64 labels. Keys must conform to the regexp:
      a-zA-Z{0,62} Values must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both
      keys and values are additionally constrained to be <= 128 bytes in size.

  Fields:
    annotations: User annotations. These attributes can only be set and used
      by the user, and not by Cloud Deploy. See
      https://google.aip.dev/128#annotations for more details such as format
      and size limitations.
    approvalRequired: Whether or not the `Target` requires approval.
    createTime: Output only. Time at which the `Target` was created.
    deployServiceAccount: Service account used to deploy a `Rollout`. If
      unset, the compute service account will be used.
    description: Description of the `Target`. Max length is 255 characters.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding.
    gkeCluster: A GKECluster attribute.
    labels: Labels are attributes that can be set and used by both the user
      and by Cloud Deploy. Labels must meet the following constraints: Each
      resource is limited to 64 labels. Keys must conform to the regexp:
      a-zA-Z{0,62} Values must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both
      keys and values are additionally constrained to be <= 128 bytes in size.
    name: Required. Name of the `Target`. Format is
      projects/{project}/locations/{location}/
      deliveryPipelines/{deliveryPipeline}/targets/a-z{0,62}.
    targetId: Output only. Resource id of the `Target`.
    uid: Output only. Unique identifier of the `Target`.
    updateTime: Output only. Most recent time at which the `Target` was
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""User annotations. These attributes can only be set and used by the
    user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
    for more details such as format and size limitations.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are attributes that can be set and used by both the user and by
    Cloud Deploy. Labels must meet the following constraints: Each resource is
    limited to 64 labels. Keys must conform to the regexp: a-zA-Z{0,62} Values
    must conform to the regexp: [a-zA-Z0-9_-]{0,63} Both keys and values are
    additionally constrained to be <= 128 bytes in size.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  approvalRequired = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  deployServiceAccount = _messages.StringField(4)
  description = _messages.StringField(5)
  etag = _messages.StringField(6)
  gkeCluster = _messages.MessageField('GKECluster', 7)
  labels = _messages.MessageField('LabelsValue', 8)
  name = _messages.StringField(9)
  targetId = _messages.StringField(10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
