(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/text/utf32#string->utf32__%
    (lambda (_str498_ _endianness499_ _BOM?500_)
      (if (string? _str498_) '#!void (error '"Expected string" _str498_))
      (let ((_u32-set!505_
             (let ((_$e502_ _endianness499_))
               (if (eq? 'big _$e502_)
                   std/text/utf32#u32-set!/be
                   (if (eq? 'little _$e502_)
                       std/text/utf32#u32-set!/le
                       (if (eq? 'native _$e502_)
                           (std/misc/bytes#&u8vector-u32-set!/native)
                           (error '"Bad endianness" _endianness499_)))))))
        (std/text/utf32#utf32-encode _str498_ _u32-set!505_ _BOM?500_))))
  (define std/text/utf32#string->utf32__0
    (lambda (_str510_)
      (let* ((_endianness512_ std/misc/bytes#big) (_BOM?514_ '#f))
        (std/text/utf32#string->utf32__% _str510_ _endianness512_ _BOM?514_))))
  (define std/text/utf32#string->utf32__1
    (lambda (_str516_ _endianness517_)
      (let ((_BOM?519_ '#f))
        (std/text/utf32#string->utf32__% _str516_ _endianness517_ _BOM?519_))))
  (define std/text/utf32#string->utf32
    (lambda _g4162_
      (let ((_g4161_ (##length _g4162_)))
        (cond ((##fx= _g4161_ 1)
               (apply std/text/utf32#string->utf32__0 _g4162_))
              ((##fx= _g4161_ 2)
               (apply std/text/utf32#string->utf32__1 _g4162_))
              ((##fx= _g4161_ 3)
               (apply std/text/utf32#string->utf32__% _g4162_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/utf32#string->utf32
                _g4162_))))))
  (define std/text/utf32#utf32-encode
    (lambda (_str489_ _u32-set!490_ _BOM?491_)
      (if _BOM?491_
          (let ((_bytes493_
                 (make-u8vector (fx* '4 (fx+ (string-length _str489_) '1)))))
            (_u32-set!490_ _bytes493_ '0 '65279)
            (std/text/utf32#utf32-encode!
             _str489_
             _bytes493_
             '4
             _u32-set!490_))
          (let ((_bytes495_ (make-u8vector (fx* '4 (string-length _str489_)))))
            (std/text/utf32#utf32-encode!
             _str489_
             _bytes495_
             '0
             _u32-set!490_)))))
  (define std/text/utf32#utf32-encode!
    (lambda (_str472_ _bytes473_ _j474_ _u32-set!475_)
      (letrec* ((_end477_ (string-length _str472_)))
        (let _lp479_ ((_i481_ '0) (_j482_ _j474_))
          (if (fx< _i481_ _end477_)
              (let* ((_char484_ (string-ref _str472_ _i481_))
                     (_int486_ (char->integer _char484_)))
                (_u32-set!475_ _bytes473_ _j482_ _int486_)
                (_lp479_ (fx+ _i481_ '1) (fx+ _j482_ '4)))
              _bytes473_)))))
  (define std/text/utf32#utf32->string__%
    (lambda (_bytes445_ _endianness446_ _endianness-mandatory?447_)
      (if (u8vector? _bytes445_)
          '#!void
          (error '"Expected u8vector" _bytes445_))
      (let ((_u32-ref452_
             (let ((_$e449_ _endianness446_))
               (if (eq? 'big _$e449_)
                   std/text/utf32#u32-ref/be
                   (if (eq? 'little _$e449_)
                       std/text/utf32#u32-ref/le
                       (if (eq? 'native _$e449_)
                           std/misc/bytes#&u8vector-u32-ref/native
                           (error '"Bad endianness" _endianness446_)))))))
        (std/text/utf32#utf32-decode
         _bytes445_
         _u32-ref452_
         (not _endianness-mandatory?447_)))))
  (define std/text/utf32#utf32->string__0
    (lambda (_bytes457_)
      (let* ((_endianness459_ std/misc/bytes#big)
             (_endianness-mandatory?461_ '#f))
        (std/text/utf32#utf32->string__%
         _bytes457_
         _endianness459_
         _endianness-mandatory?461_))))
  (define std/text/utf32#utf32->string__1
    (lambda (_bytes463_ _endianness464_)
      (let ((_endianness-mandatory?466_ '#f))
        (std/text/utf32#utf32->string__%
         _bytes463_
         _endianness464_
         _endianness-mandatory?466_))))
  (define std/text/utf32#utf32->string
    (lambda _g4164_
      (let ((_g4163_ (##length _g4164_)))
        (cond ((##fx= _g4163_ 1)
               (apply std/text/utf32#utf32->string__0 _g4164_))
              ((##fx= _g4163_ 2)
               (apply std/text/utf32#utf32->string__1 _g4164_))
              ((##fx= _g4163_ 3)
               (apply std/text/utf32#utf32->string__% _g4164_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/utf32#utf32->string
                _g4164_))))))
  (define std/text/utf32#utf32-decode
    (lambda (_bytes433_ _u32-ref434_ _BOM?435_)
      (letrec* ((_len437_ (u8vector-length _bytes433_)))
        (if (fx= (fxremainder _len437_ '4) '0)
            '#!void
            (std/error#raise-io-error
             'utf32-decode
             '"Cannot decode UTF-32; u8vector length is not a multiple of 4"
             _bytes433_))
        (if _BOM?435_
            (if (fx>= _len437_ '4)
                (let ((_b0439_ (u8vector-ref _bytes433_ '0))
                      (_b1440_ (u8vector-ref _bytes433_ '1))
                      (_b2441_ (u8vector-ref _bytes433_ '2))
                      (_b3442_ (u8vector-ref _bytes433_ '3)))
                  (if (and (fx= _b0439_ '0)
                           (fx= _b1440_ '0)
                           (fx= _b2441_ '254)
                           (fx= _b3442_ '255))
                      (std/text/utf32#utf32-decode!
                       _bytes433_
                       '4
                       std/text/utf32#u32-ref/be)
                      (if (and (fx= _b0439_ '255)
                               (fx= _b1440_ '254)
                               (fx= _b2441_ '0)
                               (fx= _b3442_ '0))
                          (std/text/utf32#utf32-decode!
                           _bytes433_
                           '4
                           std/text/utf32#u32-ref/le)
                          (std/text/utf32#utf32-decode!
                           _bytes433_
                           '0
                           _u32-ref434_))))
                '"")
            (std/text/utf32#utf32-decode! _bytes433_ '0 _u32-ref434_)))))
  (define std/text/utf32#utf32-decode!
    (lambda (_bytes413_ _i414_ _u32-ref415_)
      (letrec* ((_end417_ (u8vector-length _bytes413_))
                (_str418_ (make-string (fxquotient (fx- _end417_ _i414_) '4))))
        (let _lp420_ ((_i422_ _i414_) (_j423_ '0))
          (if (fx< _i422_ _end417_)
              (let ((_int425_ (_u32-ref415_ _bytes413_ _i422_)))
                (if (or (and (fixnum? _int425_)
                             (or (fx<= '0 _int425_ '55295)
                                 (fx<= '57344 _int425_ '65535)))
                        (<= '65536 _int425_ '1114111))
                    (begin
                      (string-set! _str418_ _j423_ (integer->char _int425_))
                      (_lp420_ (fx+ _i422_ '4) (fx+ _j423_ '1)))
                    (begin
                      (string-set! _str418_ _j423_ '#\�)
                      (_lp420_ (fx+ _i422_ '4) (fx+ _j423_ '1)))))
              _str418_)))))
  (define std/text/utf32#u32-ref/be
    (if (eq? std/misc/bytes#native-endianness std/misc/bytes#big)
        std/misc/bytes#&u8vector-u32-ref/native
        (lambda (_v410_ _i411_)
          (std/misc/bytes#&u8vector-uint-ref/be _v410_ _i411_ '4))))
  (define std/text/utf32#u32-ref/le
    (if (eq? std/misc/bytes#native-endianness std/misc/bytes#little)
        std/misc/bytes#&u8vector-u32-ref/native
        (lambda (_v407_ _i408_)
          (std/misc/bytes#&u8vector-uint-ref/le _v407_ _i408_ '4))))
  (define std/text/utf32#u32-set!/be
    (if (eq? std/misc/bytes#native-endianness std/misc/bytes#big)
        std/misc/bytes#&u8vector-u32-set!/native
        (lambda (_v403_ _i404_ _n405_)
          (std/misc/bytes#&u8vector-uint-set!/be _v403_ _i404_ _n405_ '4))))
  (define std/text/utf32#u32-set!/le
    (if (eq? std/misc/bytes#native-endianness std/misc/bytes#little)
        std/misc/bytes#&u8vector-u32-set!/native
        (lambda (_v399_ _i400_ _n401_)
          (std/misc/bytes#&u8vector-uint-set!/le _v399_ _i400_ _n401_ '4)))))
