(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/misc/uuid#uuid-length '16)
  (define std/misc/uuid#uuid::t
    (make-struct-type
     'std/misc/uuid#uuid::t
     '#f
     '2
     'uuid
     '((equal: bytes) (final: . #t))
     '#f
     '(bytes str)))
  (define std/misc/uuid#uuid? (make-struct-predicate std/misc/uuid#uuid::t))
  (define std/misc/uuid#make-uuid
    (lambda _$args521_
      (apply make-struct-instance std/misc/uuid#uuid::t _$args521_)))
  (define std/misc/uuid#uuid-bytes
    (make-struct-field-accessor std/misc/uuid#uuid::t '0))
  (define std/misc/uuid#uuid-str
    (make-struct-field-accessor std/misc/uuid#uuid::t '1))
  (define std/misc/uuid#uuid-bytes-set!
    (make-struct-field-mutator std/misc/uuid#uuid::t '0))
  (define std/misc/uuid#uuid-str-set!
    (make-struct-field-mutator std/misc/uuid#uuid::t '1))
  (define std/misc/uuid#uuid=?
    (lambda (_a518_ _b519_)
      (equal? (##direct-structure-ref _a518_ '1 std/misc/uuid#uuid::t '#f)
              (##direct-structure-ref _b519_ '1 std/misc/uuid#uuid::t '#f))))
  (define std/misc/uuid#uuid-hash
    (lambda (_uuid516_)
      (equal?-hash
       (##direct-structure-ref _uuid516_ '1 std/misc/uuid#uuid::t '#f))))
  (define std/misc/uuid#UUID
    (lambda (_obj514_)
      (if (let ()
            (declare (not safe))
            (##structure-direct-instance-of? _obj514_ 'std/misc/uuid#uuid::t))
          _obj514_
          (if (string? _obj514_)
              (std/misc/uuid#text->uuid _obj514_)
              (if (symbol? _obj514_)
                  (std/misc/uuid#text->uuid (symbol->string _obj514_))
                  (if (u8vector? _obj514_)
                      (std/misc/uuid#u8vector->uuid _obj514_)
                      (error '"bad uuid identifier" _obj514_)))))))
  (define std/misc/uuid#random-uuid
    (lambda ()
      (let ((_bytes512_ (make-u8vector std/misc/uuid#uuid-length)))
        (std/crypto/etc#random-bytes!__0 _bytes512_)
        (let ()
          (declare (not safe))
          (##structure std/misc/uuid#uuid::t _bytes512_ '#f)))))
  (define std/misc/uuid#content-uuid
    (lambda (_str504_)
      (let* ((_bytes506_ (std/text/utf8#string->utf8__0 _str504_))
             (_hash508_ (std/crypto/digest#md5 _bytes506_)))
        (let ()
          (declare (not safe))
          (##structure std/misc/uuid#uuid::t _hash508_ '#f)))))
  (define std/misc/uuid#uuid-re
    (std/pregexp#pregexp
     '"[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"))
  (define std/misc/uuid#uuid-re-capture
    (std/pregexp#pregexp
     '"([0-9a-fA-F]{8})-([0-9a-fA-F]{4})-([0-9a-fA-F]{4})-([0-9a-fA-F]{4})-([0-9a-fA-F]{12})"))
  (define std/misc/uuid#text->uuid
    (lambda (_str502_)
      (if (std/pregexp#pregexp-match std/misc/uuid#uuid-re _str502_)
          (std/misc/uuid#string->uuid _str502_)
          (std/misc/uuid#content-uuid _str502_))))
  (define std/misc/uuid#u8vector->uuid
    (lambda (_u8v500_)
      (if (let ((__tmp4179 (u8vector-length _u8v500_)))
            (declare (not safe))
            (##fx= __tmp4179 std/misc/uuid#uuid-length))
          (let ()
            (declare (not safe))
            (##structure std/misc/uuid#uuid::t _u8v500_ '#f))
          (error '"Bad argument; invalid u8vector length" _u8v500_))))
  (define std/misc/uuid#uuid->u8vector
    (lambda (_uuid498_)
      (##direct-structure-ref _uuid498_ '1 std/misc/uuid#uuid::t '#f)))
  (define std/misc/uuid#string->uuid
    (lambda (_str421_)
      (let* ((_g422440_
              (std/pregexp#pregexp-match
               std/misc/uuid#uuid-re-capture
               _str421_))
             (_else424448_
              (lambda () (error '"Bad argument; malformed uuid" _str421_)))
             (_K426457_
              (lambda (_e451_ _d452_ _c453_ _b454_ _a455_)
                (let ((__tmp4180
                       (u8vector-append
                        (std/text/hex#hex-decode__0 _a455_)
                        (std/text/hex#hex-decode__0 _b454_)
                        (std/text/hex#hex-decode__0 _c453_)
                        (std/text/hex#hex-decode__0 _d452_)
                        (std/text/hex#hex-decode__0 _e451_))))
                  (declare (not safe))
                  (##structure std/misc/uuid#uuid::t __tmp4180 _str421_)))))
        (if (let () (declare (not safe)) (##pair? _g422440_))
            (let ((_tl428460_ (let () (declare (not safe)) (##cdr _g422440_))))
              (if (let () (declare (not safe)) (##pair? _tl428460_))
                  (let ((_hd429463_
                         (let () (declare (not safe)) (##car _tl428460_)))
                        (_tl430465_
                         (let () (declare (not safe)) (##cdr _tl428460_))))
                    (let ((_a468_ _hd429463_))
                      (if (let () (declare (not safe)) (##pair? _tl430465_))
                          (let ((_hd431470_
                                 (let ()
                                   (declare (not safe))
                                   (##car _tl430465_)))
                                (_tl432472_
                                 (let ()
                                   (declare (not safe))
                                   (##cdr _tl430465_))))
                            (let ((_b475_ _hd431470_))
                              (if (let ()
                                    (declare (not safe))
                                    (##pair? _tl432472_))
                                  (let ((_hd433477_
                                         (let ()
                                           (declare (not safe))
                                           (##car _tl432472_)))
                                        (_tl434479_
                                         (let ()
                                           (declare (not safe))
                                           (##cdr _tl432472_))))
                                    (let ((_c482_ _hd433477_))
                                      (if (let ()
                                            (declare (not safe))
                                            (##pair? _tl434479_))
                                          (let ((_hd435484_
                                                 (let ()
                                                   (declare (not safe))
                                                   (##car _tl434479_)))
                                                (_tl436486_
                                                 (let ()
                                                   (declare (not safe))
                                                   (##cdr _tl434479_))))
                                            (let ((_d489_ _hd435484_))
                                              (if (let ()
                                                    (declare (not safe))
                                                    (##pair? _tl436486_))
                                                  (let ((_hd437491_
                                                         (let ()
                                                           (declare (not safe))
                                                           (##car _tl436486_)))
                                                        (_tl438493_
                                                         (let ()
                                                           (declare (not safe))
                                                           (##cdr _tl436486_))))
                                                    (let ((_e496_ _hd437491_))
                                                      (if (let ()
                                                            (declare
                                                              (not safe))
                                                            (##null? _tl438493_))
                                                          (_K426457_
                                                           _e496_
                                                           _d489_
                                                           _c482_
                                                           _b475_
                                                           _a468_)
                                                          (_else424448_))))
                                                  (_else424448_))))
                                          (_else424448_))))
                                  (_else424448_))))
                          (_else424448_))))
                  (_else424448_)))
            (_else424448_)))))
  (define std/misc/uuid#uuid->string
    (lambda (_uuid401_)
      (let ((_$e403_ (##direct-structure-ref
                      _uuid401_
                      '2
                      std/misc/uuid#uuid::t
                      '#f)))
        (if _$e403_
            (values _$e403_)
            (let* ((_bytes406_
                    (##direct-structure-ref
                     _uuid401_
                     '1
                     std/misc/uuid#uuid::t
                     '#f))
                   (_a408_ (std/text/hex#hex-encode__% _bytes406_ '0 '4))
                   (_b410_ (std/text/hex#hex-encode__% _bytes406_ '4 '6))
                   (_c412_ (std/text/hex#hex-encode__% _bytes406_ '6 '8))
                   (_d414_ (std/text/hex#hex-encode__% _bytes406_ '8 '10))
                   (_e416_ (std/text/hex#hex-encode__% _bytes406_ '10 '16))
                   (_str418_
                    (string-append
                     _a408_
                     '"-"
                     _b410_
                     '"-"
                     _c412_
                     '"-"
                     _d414_
                     '"-"
                     _e416_)))
              (##direct-structure-set!
               _uuid401_
               _str418_
               '2
               std/misc/uuid#uuid::t
               '#f)
              _str418_))))))
