/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Year;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiParameter;

public class RustAPIGenerator
extends AbstractAPIGenerator {
    private static final String DEFAULT_OUTPUT_DIR = "../zap-api-rust/src";
    private static final String HEADER = "/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright " + Year.now() + " the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private static final Map<String, String> nameMap;

    public RustAPIGenerator() {
        super(DEFAULT_OUTPUT_DIR);
    }

    public RustAPIGenerator(String path, boolean optional) {
        super(path, optional);
    }

    public RustAPIGenerator(String path, boolean optional, ResourceBundle resourceBundle) {
        super(path, optional, resourceBundle);
    }

    private void generateRustElement(ApiElement element, String component, String type, Writer out) throws IOException {
        block10: {
            String descTag = element.getDescriptionTag();
            try {
                String desc = this.getMessages().getString(descTag);
                out.write("/**\n");
                out.write(" * " + desc + "\n");
                if (this.isOptional()) {
                    out.write(" * <p>\n");
                    out.write(" * This component is optional and therefore the API will only work if it is installed\n");
                }
                out.write("*/\n");
                if (element.isDeprecated()) {
                    out.write("#[deprecated");
                    String deprecationDesc = element.getDeprecatedDescription();
                    if (deprecationDesc != null && !deprecationDesc.isEmpty()) {
                        out.write("(note=\"" + deprecationDesc + "\")");
                    }
                    out.write("]\n");
                }
            }
            catch (Exception e) {
                System.out.println("No i18n for: " + descTag);
                if (!this.isOptional()) break block10;
                out.write("/**\n");
                out.write(" * This component is optional and therefore the API will only work if it is installed\n");
                out.write(" */\n");
            }
        }
        int paramCount = element.getParameters().size();
        if (paramCount > 6) {
            out.write("#[allow(clippy::too_many_arguments)]\n");
        }
        out.write("pub fn " + RustAPIGenerator.getSafeName(element.getName()) + "(service: &ZapService");
        for (ApiParameter parameter : element.getParameters()) {
            out.write(", ");
            out.write(RustAPIGenerator.getSafeName(parameter.getName().toLowerCase(Locale.ROOT)));
            out.write(": String");
        }
        out.write(") -> Result<Value, ZapApiError> {\n");
        if (paramCount > 0) {
            out.write("    let mut params = HashMap::new();\n");
        } else {
            out.write("    let params = HashMap::new();\n");
        }
        for (ApiParameter parameter : element.getParameters()) {
            String name = parameter.getName();
            String varName = RustAPIGenerator.getSafeName(name.toLowerCase(Locale.ROOT));
            out.write("    params.insert(\"" + name + "\".to_string(), " + varName + ");\n");
        }
        out.write("    super::call(service, \"" + component + "\", \"" + type + "\", \"" + element.getName() + "\", params)\n");
        out.write("}\n\n");
    }

    private static String getSafeName(String name) {
        if (nameMap.containsKey(name)) {
            name = nameMap.get(name);
        }
        return RustAPIGenerator.removeAllFullStopCharacters(RustAPIGenerator.camelCaseToLcUnderscores(name));
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    public static String camelCaseToLcUnderscores(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "_").replaceAll("__", "_").toLowerCase();
    }

    @Override
    protected void generateAPIFiles(ApiImplementor imp) throws IOException {
        Path file = this.getDirectory().resolve(RustAPIGenerator.getSafeName(imp.getPrefix()) + ".rs");
        System.out.println("pub mod " + RustAPIGenerator.getSafeName(imp.getPrefix()) + ";");
        try (BufferedWriter out = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write(HEADER);
            out.write("use super::ZapApiError;\n");
            out.write("use super::ZapService;\n");
            out.write("use serde_json::Value;\n");
            out.write("use std::collections::HashMap;\n");
            out.write("\n");
            out.write("\n");
            out.write("/**\n");
            out.write(" * This file was automatically generated.\n");
            out.write(" */\n");
            for (ApiElement apiElement : imp.getApiViews()) {
                this.generateRustElement(apiElement, imp.getPrefix(), "view", out);
            }
            for (ApiElement apiElement : imp.getApiActions()) {
                this.generateRustElement(apiElement, imp.getPrefix(), "action", out);
            }
            for (ApiElement apiElement : imp.getApiOthers()) {
                this.generateRustElement(apiElement, imp.getPrefix(), "other", out);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (!Files.exists(Paths.get(DEFAULT_OUTPUT_DIR, new String[0]), new LinkOption[0])) {
            System.err.println("The directory does not exist: " + Paths.get(DEFAULT_OUTPUT_DIR, new String[0]).toAbsolutePath());
            System.exit(1);
        }
        RustAPIGenerator wapi = new RustAPIGenerator();
        wapi.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> initMap = new HashMap<String, String>();
        initMap.put("break", "brk");
        initMap.put("continue", "cont");
        initMap.put("match", "mtch");
        initMap.put("type", "typ");
        nameMap = Collections.unmodifiableMap(initMap);
    }
}

