/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;

public class VariantDdnPath
implements Variant {
    private static final Logger LOGGER = Logger.getLogger(VariantDdnPath.class);
    private final List<NameValuePair> stringParam = new ArrayList<NameValuePair>();

    @Override
    public void setMessage(HttpMessage msg) {
        try {
            List<String> treePaths = Model.getSingleton().getSession().getTreePath(msg);
            int position = 1;
            for (String path : treePaths) {
                if (path.startsWith("\u00ab")) {
                    this.stringParam.add(new NameValuePair(16, path, path, position));
                }
                ++position;
            }
        }
        catch (URIException uRIException) {
            // empty catch block
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.stringParam;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, true);
    }

    private String getEscapedValue(String value) {
        if (value != null) {
            try {
                return URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }

    private String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value, boolean escaped) {
        URI uri = msg.getRequestHeader().getURI();
        CharSequence[] paths = uri.getEscapedPath().split("/");
        if (originalPair.getPosition() < paths.length) {
            String encodedValue;
            paths[originalPair.getPosition()] = encodedValue = escaped ? value : this.getEscapedValue(value);
            String path = String.join((CharSequence)"/", paths);
            try {
                uri.setEscapedPath(path);
            }
            catch (URIException e) {
                try {
                    uri.setPath(path);
                }
                catch (URIException e1) {
                    LOGGER.debug((Object)e1.getMessage(), (Throwable)e1);
                }
                LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }
}

