/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.common.SolrException;

class StringIfFunction
extends StringValue.AbstractStringValue {
    private final BooleanValue ifExpr;
    private final StringValue thenExpr;
    private final StringValue elseExpr;
    public static final String name = "if";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;

    public StringIfFunction(BooleanValue ifExpr, StringValue thenExpr, StringValue elseExpr) throws SolrException {
        this.ifExpr = ifExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, ifExpr, thenExpr, elseExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
    }

    @Override
    public String getString() {
        this.exists = false;
        String value = null;
        boolean ifValue = this.ifExpr.getBoolean();
        if (this.ifExpr.exists()) {
            if (ifValue) {
                value = this.thenExpr.getString();
                this.exists = this.thenExpr.exists();
            } else {
                value = this.elseExpr.getString();
                this.exists = this.elseExpr.exists();
            }
        }
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

