/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.solr.cluster.api.SimpleMap;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.util.PropertiesUtil;

public class DataConfigNode
implements ConfigNode {
    final String name;
    final SimpleMap<String> attributes;
    private final Map<String, List<ConfigNode>> kids = new HashMap<String, List<ConfigNode>>();
    private final String textData;

    public DataConfigNode(ConfigNode root) {
        this.name = root.name();
        this.attributes = this.wrap((SimpleMap<String>)root.attributes());
        this.textData = root.textValue();
        root.forEachChild(it -> {
            List nodes = this.kids.computeIfAbsent(it.name(), k -> new ArrayList());
            nodes.add(new DataConfigNode((ConfigNode)it));
            return Boolean.TRUE;
        });
        for (Map.Entry<String, List<ConfigNode>> e : this.kids.entrySet()) {
            if (e.getValue() == null) continue;
            e.setValue(Collections.unmodifiableList(e.getValue()));
        }
    }

    public String subtituteVal(String s) {
        Function props = (Function)SUBSTITUTES.get();
        if (props == null) {
            return s;
        }
        return PropertiesUtil.substitute((String)s, (Function)props);
    }

    private SimpleMap<String> wrap(final SimpleMap<String> delegate) {
        return new SimpleMap<String>(){

            public String get(String key) {
                return DataConfigNode.this.subtituteVal((String)delegate.get(key));
            }

            public void forEachEntry(BiConsumer<String, ? super String> fun) {
                delegate.forEachEntry((k, v) -> fun.accept((String)k, DataConfigNode.this.subtituteVal((String)v)));
            }

            public int size() {
                return delegate.size();
            }
        };
    }

    public String name() {
        return this.name;
    }

    public String textValue() {
        return this.subtituteVal(this.textData);
    }

    public SimpleMap<String> attributes() {
        return this.attributes;
    }

    public ConfigNode child(String name) {
        List<ConfigNode> val = this.kids.get(name);
        return val == null || val.isEmpty() ? null : val.get(0);
    }

    public List<ConfigNode> children(String name) {
        return this.kids.getOrDefault(name, Collections.emptyList());
    }

    public List<ConfigNode> children(Predicate<ConfigNode> test, Set<String> matchNames) {
        ArrayList<ConfigNode> result = new ArrayList<ConfigNode>();
        for (String s : matchNames) {
            List<ConfigNode> vals = this.kids.get(s);
            if (vals == null) continue;
            vals.forEach(it -> {
                if (test == null || test.test((ConfigNode)it)) {
                    result.add((ConfigNode)it);
                }
            });
        }
        return result;
    }

    public void forEachChild(Function<ConfigNode, Boolean> fun) {
        this.kids.forEach((s, configNodes) -> {
            if (configNodes != null) {
                configNodes.forEach(fun::apply);
            }
        });
    }
}

