/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.solr.cluster.api.SimpleMap;

public interface ConfigNode {
    public static final ThreadLocal<Function<String, String>> SUBSTITUTES = new ThreadLocal();

    public String name();

    public String textValue();

    public SimpleMap<String> attributes();

    default public ConfigNode child(String name) {
        return this.child(null, name);
    }

    default public ConfigNode child(Predicate<ConfigNode> test, String name) {
        ConfigNode[] result = new ConfigNode[1];
        this.forEachChild(it -> {
            if (name != null && !name.equals(it.name())) {
                return Boolean.TRUE;
            }
            if (test == null || test.test((ConfigNode)it)) {
                result[0] = it;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        return result[0];
    }

    default public List<ConfigNode> children(Predicate<ConfigNode> test, String ... nodeNames) {
        return this.children(test, (Set<String>)(nodeNames == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(nodeNames))));
    }

    default public List<ConfigNode> children(Predicate<ConfigNode> test, Set<String> matchNames) {
        ArrayList<ConfigNode> result = new ArrayList<ConfigNode>();
        this.forEachChild(it -> {
            if (matchNames != null && !matchNames.isEmpty() && !matchNames.contains(it.name())) {
                return Boolean.TRUE;
            }
            if (test == null || test.test((ConfigNode)it)) {
                result.add((ConfigNode)it);
            }
            return Boolean.TRUE;
        });
        return result;
    }

    default public List<ConfigNode> children(String name) {
        return this.children(null, Collections.singleton(name));
    }

    public void forEachChild(Function<ConfigNode, Boolean> var1);
}

