/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.ByteVector;

public class TypePath {
    private final byte[] typePathContainer;
    private final int typePathOffset;

    TypePath(byte[] byArray, int n) {
        this.typePathContainer = byArray;
        this.typePathOffset = n;
    }

    public int getLength() {
        return this.typePathContainer[this.typePathOffset];
    }

    public int getStep(int n) {
        return this.typePathContainer[this.typePathOffset + 2 * n + 1];
    }

    public int getStepArgument(int n) {
        return this.typePathContainer[this.typePathOffset + 2 * n + 2];
    }

    public String toString() {
        int n = this.getLength();
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        block6: for (int i = 0; i < n; ++i) {
            switch (this.getStep(i)) {
                case 0: {
                    stringBuilder.append('[');
                    continue block6;
                }
                case 1: {
                    stringBuilder.append('.');
                    continue block6;
                }
                case 2: {
                    stringBuilder.append('*');
                    continue block6;
                }
                case 3: {
                    stringBuilder.append(this.getStepArgument(i)).append(';');
                    continue block6;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return stringBuilder.toString();
    }

    static void put(TypePath typePath, ByteVector byteVector) {
        if (typePath == null) {
            byteVector.putByte(0);
        } else {
            int n = typePath.typePathContainer[typePath.typePathOffset] * 2 + 1;
            byteVector.putByteArray(typePath.typePathContainer, typePath.typePathOffset, n);
        }
    }
}

