/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;

public class SqlJsonApiCommonSyntaxOperator
extends SqlSpecialOperator {
    public SqlJsonApiCommonSyntaxOperator() {
        super("JSON_API_COMMON_SYNTAX", SqlKind.JSON_API_COMMON_SYNTAX, 100, true, (SqlReturnTypeInference)ReturnTypes.explicit(SqlTypeName.ANY), null, (SqlOperandTypeChecker)OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING));
    }

    @Override
    protected void checkOperandCount(SqlValidator validator, SqlOperandTypeChecker argType, SqlCall call) {
        if (call.operandCount() != 2) {
            throw new UnsupportedOperationException("json passing syntax is not yet supported");
        }
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep(",", true);
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        if (call.operandCount() > 2) {
            writer.keyword("PASSING");
            for (int i = 2; i < call.getOperandList().size(); i += 2) {
                ((SqlNode)call.operand(i)).unparse(writer, 0, 0);
                writer.keyword("AS");
                ((SqlNode)call.operand(i + 1)).unparse(writer, 0, 0);
            }
        }
        writer.endFunCall(frame);
    }
}

