/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.URLDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinURLDataSource
extends DataSource<InputStream> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String baseUrl;
    private int connectionTimeout = 5000;
    private int readTimeout = 10000;
    private Context context;
    private Properties initProps;

    @Override
    public void init(Context context, Properties initProps) {
        this.context = context;
        this.initProps = initProps;
        this.baseUrl = this.getInitPropWithReplacements("baseUrl");
        String cTimeout = this.getInitPropWithReplacements("connectionTimeout");
        String rTimeout = this.getInitPropWithReplacements("readTimeout");
        if (cTimeout != null) {
            try {
                this.connectionTimeout = Integer.parseInt(cTimeout);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid connection timeout: {}", (Object)cTimeout);
            }
        }
        if (rTimeout != null) {
            try {
                this.readTimeout = Integer.parseInt(rTimeout);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid read timeout: {}", (Object)rTimeout);
            }
        }
    }

    @Override
    public InputStream getData(String query) {
        URL url = null;
        try {
            url = URLDataSource.URIMETHOD.matcher(query).find() ? new URL(query) : new URL(this.baseUrl + query);
            log.debug("Accessing URL: {}", (Object)url);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(this.connectionTimeout);
            conn.setReadTimeout(this.readTimeout);
            return conn.getInputStream();
        }
        catch (Exception e) {
            log.error("Exception thrown while getting data", (Throwable)e);
            DataImportHandlerException.wrapAndThrow(500, e, "Exception in invoking url " + url);
            return null;
        }
    }

    @Override
    public void close() {
    }

    private String getInitPropWithReplacements(String propertyName) {
        String expr = this.initProps.getProperty(propertyName);
        if (expr == null) {
            return null;
        }
        return this.context.replaceTokens(expr);
    }
}

