/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DtlsHandshakeMessageFragmentParser
extends HandshakeMessageParser<DtlsHandshakeMessageFragment> {
    private static final Logger LOGGER = LogManager.getLogger();

    public DtlsHandshakeMessageFragmentParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, HandshakeMessageType.UNKNOWN, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(DtlsHandshakeMessageFragment msg) {
        this.parseMessageSequence(msg);
        this.parseFragmentOffset(msg);
        this.parseFragmentLength(msg);
        msg.setContent(this.parseByteArrayField((Integer)msg.getFragmentLength().getValue()));
    }

    private void parseFragmentOffset(DtlsHandshakeMessageFragment msg) {
        msg.setFragmentOffset(this.parseIntField(3));
        LOGGER.debug("FragmentOffset:" + msg.getFragmentOffset().getValue());
    }

    private void parseFragmentLength(DtlsHandshakeMessageFragment msg) {
        msg.setFragmentLength(this.parseIntField(3));
        LOGGER.debug("FragmentLength:" + msg.getFragmentLength().getValue());
    }

    private void parseMessageSequence(DtlsHandshakeMessageFragment msg) {
        msg.setMessageSeq(this.parseIntField(2));
        LOGGER.debug("MessageSequence:" + msg.getMessageSeq().getValue());
    }

    @Override
    protected DtlsHandshakeMessageFragment createHandshakeMessage() {
        return new DtlsHandshakeMessageFragment();
    }
}

