/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.riff;

import com.drew.imaging.riff.RiffHandler;
import com.drew.imaging.riff.RiffProcessingException;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import java.io.IOException;

public class RiffReader {
    public void processRiff(@NotNull SequentialReader reader, @NotNull RiffHandler handler) throws RiffProcessingException, IOException {
        int fileSize;
        reader.setMotorolaByteOrder(false);
        String fileFourCC = reader.getString(4);
        if (!fileFourCC.equals("RIFF")) {
            throw new RiffProcessingException("Invalid RIFF header: " + fileFourCC);
        }
        int sizeLeft = fileSize = reader.getInt32();
        String identifier = reader.getString(4);
        sizeLeft -= 4;
        if (!handler.shouldAcceptRiffIdentifier(identifier)) {
            return;
        }
        this.processChunks(reader, sizeLeft, handler);
    }

    public void processChunks(SequentialReader reader, int sectionSize, RiffHandler handler) throws IOException {
        while (reader.getPosition() < (long)sectionSize) {
            String fourCC = new String(reader.getBytes(4));
            int size = reader.getInt32();
            if (fourCC.equals("LIST") || fourCC.equals("RIFF")) {
                String listName = new String(reader.getBytes(4));
                if (handler.shouldAcceptList(listName)) {
                    this.processChunks(reader, size - 4, handler);
                    continue;
                }
                reader.skip(size - 4);
                continue;
            }
            if (handler.shouldAcceptChunk(fourCC)) {
                handler.processChunk(fourCC, reader.getBytes(size));
            } else {
                reader.skip(size);
            }
            if (size % 2 != 1) continue;
            reader.skip(1L);
        }
    }
}

