/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.CurrencyValue;
import org.apache.solr.schema.ExchangeRateProvider;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.LongValueFieldType;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.apache.solr.uninverting.UninvertingReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrencyFieldType
extends FieldType
implements SchemaAware,
ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String PARAM_DEFAULT_CURRENCY = "defaultCurrency";
    protected static final String DEFAULT_DEFAULT_CURRENCY = "USD";
    protected static final String PARAM_RATE_PROVIDER_CLASS = "providerClass";
    protected static final String DEFAULT_RATE_PROVIDER_CLASS = "solr.FileExchangeRateProvider";
    protected static final String PARAM_FIELD_SUFFIX_AMOUNT_RAW = "amountLongSuffix";
    protected static final String PARAM_FIELD_SUFFIX_CURRENCY = "codeStrSuffix";
    protected IndexSchema schema;
    protected FieldType fieldTypeCurrency;
    protected FieldType fieldTypeAmountRaw;
    protected String fieldSuffixAmountRaw;
    protected String fieldSuffixCurrency;
    private String exchangeRateProviderClass;
    private String defaultCurrency;
    private ExchangeRateProvider provider;

    public static Currency getCurrency(String code) {
        try {
            return Currency.getInstance(code);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        if (this.isMultiValued()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.getClass().getSimpleName() + " types can not be multiValued: " + this.typeName);
        }
        this.schema = schema;
        this.defaultCurrency = args.get(PARAM_DEFAULT_CURRENCY);
        if (this.defaultCurrency == null) {
            this.defaultCurrency = DEFAULT_DEFAULT_CURRENCY;
        } else {
            args.remove(PARAM_DEFAULT_CURRENCY);
        }
        if (null == CurrencyFieldType.getCurrency(this.defaultCurrency)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Default currency code is not supported by this JVM: " + this.defaultCurrency);
        }
        this.exchangeRateProviderClass = args.get(PARAM_RATE_PROVIDER_CLASS);
        if (this.exchangeRateProviderClass == null) {
            this.exchangeRateProviderClass = DEFAULT_RATE_PROVIDER_CLASS;
        } else {
            args.remove(PARAM_RATE_PROVIDER_CLASS);
        }
        try {
            Class<ExchangeRateProvider> c = schema.getResourceLoader().findClass(this.exchangeRateProviderClass, ExchangeRateProvider.class);
            this.provider = c.newInstance();
            this.provider.init(args);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating exchange rate provider " + this.exchangeRateProviderClass + ": " + e.getMessage(), (Throwable)e);
        }
        if (this.fieldTypeAmountRaw == null) {
            this.fieldSuffixAmountRaw = args.get(PARAM_FIELD_SUFFIX_AMOUNT_RAW);
            if (this.fieldSuffixAmountRaw == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required param amountLongSuffix");
            }
            args.remove(PARAM_FIELD_SUFFIX_AMOUNT_RAW);
        }
        if (this.fieldTypeCurrency == null) {
            this.fieldSuffixCurrency = args.get(PARAM_FIELD_SUFFIX_CURRENCY);
            if (this.fieldSuffixCurrency == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required param codeStrSuffix");
            }
            args.remove(PARAM_FIELD_SUFFIX_CURRENCY);
        }
    }

    @Override
    public boolean isPolyField() {
        return true;
    }

    @Override
    public void checkSchemaField(SchemaField field) throws SolrException {
        super.checkSchemaField(field);
        if (field.multiValued()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.getClass().getSimpleName() + " fields can not be multiValued: " + field.getName());
        }
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object externalVal) {
        CurrencyValue value = CurrencyValue.parse(externalVal.toString(), this.defaultCurrency);
        ArrayList<IndexableField> f = new ArrayList<IndexableField>();
        SchemaField amountField = this.getAmountField(field);
        f.add(amountField.createField(String.valueOf(value.getAmount())));
        SchemaField currencyField = this.getCurrencyField(field);
        f.add(currencyField.createField(value.getCurrencyCode()));
        if (field.stored()) {
            String storedValue = externalVal.toString().trim();
            if (storedValue.indexOf(",") < 0) {
                storedValue = storedValue + "," + this.defaultCurrency;
            }
            f.add(this.createField(field.getName(), storedValue, (IndexableFieldType)StoredField.TYPE));
        }
        return f;
    }

    private SchemaField getAmountField(SchemaField field) {
        return this.schema.getField(field.getName() + "___" + this.fieldSuffixAmountRaw);
    }

    private SchemaField getCurrencyField(SchemaField field) {
        return this.schema.getField(field.getName() + "___" + this.fieldSuffixCurrency);
    }

    @Override
    public void inform(IndexSchema schema) {
        SchemaField field;
        this.schema = schema;
        if (null == this.fieldTypeAmountRaw) {
            assert (null != this.fieldSuffixAmountRaw) : "How did we get here?";
            field = schema.getFieldOrNull("___" + this.fieldSuffixAmountRaw);
            if (field == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Field type \"" + this.getTypeName() + "\": Undefined dynamic field for " + PARAM_FIELD_SUFFIX_AMOUNT_RAW + "=\"" + this.fieldSuffixAmountRaw + "\"");
            }
            this.fieldTypeAmountRaw = field.getType();
            if (!(this.fieldTypeAmountRaw instanceof LongValueFieldType)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Field type \"" + this.getTypeName() + "\": Dynamic field for " + PARAM_FIELD_SUFFIX_AMOUNT_RAW + "=\"" + this.fieldSuffixAmountRaw + "\" must have type class extending LongValueFieldType");
            }
        }
        if (null == this.fieldTypeCurrency) {
            assert (null != this.fieldSuffixCurrency) : "How did we get here?";
            field = schema.getFieldOrNull("___" + this.fieldSuffixCurrency);
            if (field == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Field type \"" + this.getTypeName() + "\": Undefined dynamic field for " + PARAM_FIELD_SUFFIX_CURRENCY + "=\"" + this.fieldSuffixCurrency + "\"");
            }
            this.fieldTypeCurrency = field.getType();
            if (!(this.fieldTypeCurrency instanceof StrField)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Field type \"" + this.getTypeName() + "\": Dynamic field for " + PARAM_FIELD_SUFFIX_CURRENCY + "=\"" + this.fieldSuffixCurrency + "\" must have type class of (or extending) StrField");
            }
        }
    }

    public void inform(ResourceLoader resourceLoader) {
        this.provider.inform(resourceLoader);
        boolean reloaded = this.provider.reload();
        if (!reloaded) {
            log.warn("Failed reloading currencies");
        }
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        CurrencyValue value = CurrencyValue.parse(externalVal, this.defaultCurrency);
        CurrencyValue valueDefault = value.convertTo(this.provider, this.defaultCurrency);
        return this.getRangeQuery(parser, field, valueDefault, valueDefault, true, true);
    }

    @Override
    public RawCurrencyValueSource getValueSource(SchemaField field, QParser parser) {
        this.getAmountField(field).checkFieldCacheSource();
        this.getCurrencyField(field).checkFieldCacheSource();
        return new RawCurrencyValueSource(field, this.defaultCurrency, parser);
    }

    public ValueSource getConvertedValueSource(String targetCurrencyCode, RawCurrencyValueSource source) {
        if (null == targetCurrencyCode) {
            targetCurrencyCode = this.defaultCurrency;
        }
        return new ConvertedCurrencyValueSource(targetCurrencyCode, source);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        CurrencyValue p1 = CurrencyValue.parse(part1, this.defaultCurrency);
        CurrencyValue p2 = CurrencyValue.parse(part2, this.defaultCurrency);
        if (p1 != null && p2 != null && !p1.getCurrencyCode().equals(p2.getCurrencyCode())) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot parse range query " + part1 + " to " + part2 + ": range queries only supported when upper and lower bound have same currency.");
        }
        return this.getRangeQuery(parser, field, p1, p2, minInclusive, maxInclusive);
    }

    public Query getRangeQuery(QParser parser, SchemaField field, CurrencyValue p1, CurrencyValue p2, boolean minInclusive, boolean maxInclusive) {
        String currencyCode = p1 != null ? p1.getCurrencyCode() : (p2 != null ? p2.getCurrencyCode() : this.defaultCurrency);
        DocValuesFieldExistsQuery docsWithValues = new DocValuesFieldExistsQuery(this.getAmountField(field).getName());
        ValueSourceRangeFilter vsRangeFilter = new ValueSourceRangeFilter(new RawCurrencyValueSource(field, currencyCode, parser), p1 == null ? null : p1.getAmount() + "", p2 == null ? null : p2.getAmount() + "", minInclusive, maxInclusive);
        return new ConstantScoreQuery((Query)new BooleanQuery.Builder().add((Query)docsWithValues, BooleanClause.Occur.FILTER).add((Query)vsRangeFilter, BooleanClause.Occur.FILTER).build());
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return new RawCurrencyValueSource(field, this.defaultCurrency, null).getSortField(reverse);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return null;
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField field) throws IOException {
        writer.writeStr(name, field.stringValue(), true);
    }

    public ExchangeRateProvider getProvider() {
        return this.provider;
    }

    class RawCurrencyValueSource
    extends ValueSource {
        private static final long serialVersionUID = 1L;
        private final Currency targetCurrency;
        private ValueSource currencyValues;
        private ValueSource amountValues;
        private final SchemaField sf;

        public RawCurrencyValueSource(SchemaField sfield, String targetCurrencyCode, QParser parser) {
            this.sf = sfield;
            this.targetCurrency = CurrencyFieldType.getCurrency(targetCurrencyCode);
            if (null == this.targetCurrency) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Currency code not supported by this JVM: " + targetCurrencyCode);
            }
            SchemaField amountField = CurrencyFieldType.this.getAmountField(this.sf);
            SchemaField currencyField = CurrencyFieldType.this.getCurrencyField(this.sf);
            this.currencyValues = currencyField.getType().getValueSource(currencyField, parser);
            this.amountValues = amountField.getType().getValueSource(amountField, parser);
        }

        public SchemaField getField() {
            return this.sf;
        }

        public Currency getTargetCurrency() {
            return this.targetCurrency;
        }

        public FunctionValues getValues(Map context, LeafReaderContext reader) throws IOException {
            final FunctionValues amounts = this.amountValues.getValues(context, reader);
            final FunctionValues currencies = this.currencyValues.getValues(context, reader);
            return new FunctionValues(){
                private static final int MAX_CURRENCIES_TO_CACHE = 256;
                private final int[] fractionDigitCache = new int[256];
                private final String[] currencyOrdToCurrencyCache = new String[256];
                private final double[] exchangeRateCache = new double[256];
                private int targetFractionDigits = -1;
                private int targetCurrencyOrd = -1;
                private boolean initializedCache;

                private String getDocCurrencyCode(int doc, int currencyOrd) throws IOException {
                    if (currencyOrd < 256) {
                        String currency = this.currencyOrdToCurrencyCache[currencyOrd];
                        if (currency == null) {
                            this.currencyOrdToCurrencyCache[currencyOrd] = currency = currencies.strVal(doc);
                        }
                        if (currency == null) {
                            currency = CurrencyFieldType.this.defaultCurrency;
                        }
                        if (this.targetCurrencyOrd == -1 && currency.equals(RawCurrencyValueSource.this.targetCurrency.getCurrencyCode())) {
                            this.targetCurrencyOrd = currencyOrd;
                        }
                        return currency;
                    }
                    return currencies.strVal(doc);
                }

                private Currency getDocCurrency(int doc, int currencyOrd) throws IOException {
                    String code = this.getDocCurrencyCode(doc, currencyOrd);
                    Currency c = CurrencyFieldType.getCurrency(code);
                    if (null == c) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Currency code of document is not supported by this JVM: " + code);
                    }
                    return c;
                }

                public boolean exists(int doc) throws IOException {
                    return amounts.exists(doc);
                }

                public long longVal(int doc) throws IOException {
                    int sourceFractionDigits;
                    double exchangeRate;
                    int currencyOrd;
                    long amount = amounts.longVal(doc);
                    if (!this.exists(doc)) {
                        return amount;
                    }
                    if (!this.initializedCache) {
                        for (int i = 0; i < this.fractionDigitCache.length; ++i) {
                            this.fractionDigitCache[i] = -1;
                        }
                        this.initializedCache = true;
                    }
                    if ((currencyOrd = currencies.ordVal(doc)) == this.targetCurrencyOrd) {
                        return amount;
                    }
                    if (this.targetFractionDigits == -1) {
                        this.targetFractionDigits = RawCurrencyValueSource.this.targetCurrency.getDefaultFractionDigits();
                    }
                    if (currencyOrd < 256) {
                        exchangeRate = this.exchangeRateCache[currencyOrd];
                        if (exchangeRate <= 0.0) {
                            String sourceCurrencyCode = this.getDocCurrencyCode(doc, currencyOrd);
                            exchangeRate = this.exchangeRateCache[currencyOrd] = CurrencyFieldType.this.provider.getExchangeRate(sourceCurrencyCode, RawCurrencyValueSource.this.targetCurrency.getCurrencyCode());
                        }
                        if ((sourceFractionDigits = this.fractionDigitCache[currencyOrd]) == -1) {
                            sourceFractionDigits = this.fractionDigitCache[currencyOrd] = this.getDocCurrency(doc, currencyOrd).getDefaultFractionDigits();
                        }
                    } else {
                        Currency source = this.getDocCurrency(doc, currencyOrd);
                        exchangeRate = CurrencyFieldType.this.provider.getExchangeRate(source.getCurrencyCode(), RawCurrencyValueSource.this.targetCurrency.getCurrencyCode());
                        sourceFractionDigits = source.getDefaultFractionDigits();
                    }
                    return CurrencyValue.convertAmount(exchangeRate, sourceFractionDigits, amount, this.targetFractionDigits);
                }

                public int intVal(int doc) throws IOException {
                    return (int)this.longVal(doc);
                }

                public double doubleVal(int doc) throws IOException {
                    return this.longVal(doc);
                }

                public float floatVal(int doc) throws IOException {
                    return this.longVal(doc);
                }

                public String strVal(int doc) throws IOException {
                    return Long.toString(this.longVal(doc));
                }

                public String toString(int doc) throws IOException {
                    return RawCurrencyValueSource.this.name() + '(' + amounts.toString(doc) + ',' + currencies.toString(doc) + ')';
                }
            };
        }

        public String name() {
            return "rawcurrency";
        }

        public String description() {
            return this.name() + "(" + this.sf.getName() + ",target=" + this.targetCurrency.getCurrencyCode() + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            RawCurrencyValueSource that = (RawCurrencyValueSource)((Object)o);
            return !((this.amountValues == null ? that.amountValues != null : !this.amountValues.equals((Object)that.amountValues)) || (this.currencyValues == null ? that.currencyValues != null : !this.currencyValues.equals((Object)that.currencyValues)) || (this.targetCurrency == null ? that.targetCurrency != null : !this.targetCurrency.equals(that.targetCurrency)));
        }

        public int hashCode() {
            int result = this.targetCurrency != null ? this.targetCurrency.hashCode() : 0;
            result = 31 * result + (this.currencyValues != null ? this.currencyValues.hashCode() : 0);
            result = 31 * result + (this.amountValues != null ? this.amountValues.hashCode() : 0);
            return result;
        }
    }

    class ConvertedCurrencyValueSource
    extends ValueSource {
        private final Currency targetCurrency;
        private final RawCurrencyValueSource source;
        private final double rate;

        public ConvertedCurrencyValueSource(String targetCurrencyCode, RawCurrencyValueSource source) {
            this.source = source;
            this.targetCurrency = CurrencyFieldType.getCurrency(targetCurrencyCode);
            if (null == this.targetCurrency) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Currency code not supported by this JVM: " + targetCurrencyCode);
            }
            this.rate = CurrencyFieldType.this.provider.getExchangeRate(source.getTargetCurrency().getCurrencyCode(), this.targetCurrency.getCurrencyCode());
        }

        public FunctionValues getValues(Map context, LeafReaderContext reader) throws IOException {
            final FunctionValues amounts = this.source.getValues(context, reader);
            final String sourceCurrencyCode = this.source.getTargetCurrency().getCurrencyCode();
            final double divisor = Math.pow(10.0, this.targetCurrency.getDefaultFractionDigits());
            return new FunctionValues(){

                public boolean exists(int doc) throws IOException {
                    return amounts.exists(doc);
                }

                public long longVal(int doc) throws IOException {
                    return (long)this.doubleVal(doc);
                }

                public int intVal(int doc) throws IOException {
                    return (int)this.doubleVal(doc);
                }

                public double doubleVal(int doc) throws IOException {
                    return (double)CurrencyValue.convertAmount(ConvertedCurrencyValueSource.this.rate, sourceCurrencyCode, amounts.longVal(doc), ConvertedCurrencyValueSource.this.targetCurrency.getCurrencyCode()) / divisor;
                }

                public float floatVal(int doc) throws IOException {
                    return (float)CurrencyValue.convertAmount(ConvertedCurrencyValueSource.this.rate, sourceCurrencyCode, amounts.longVal(doc), ConvertedCurrencyValueSource.this.targetCurrency.getCurrencyCode()) / (float)divisor;
                }

                public String strVal(int doc) throws IOException {
                    return Double.toString(this.doubleVal(doc));
                }

                public String toString(int doc) throws IOException {
                    return ConvertedCurrencyValueSource.this.name() + '(' + this.strVal(doc) + ')';
                }
            };
        }

        public String name() {
            return "currency";
        }

        public String description() {
            return this.name() + "(" + this.source.getField().getName() + "," + this.targetCurrency.getCurrencyCode() + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ConvertedCurrencyValueSource that = (ConvertedCurrencyValueSource)((Object)o);
            return !(this.source == null ? that.source != null : !this.source.equals((Object)that.source)) && this.rate == that.rate && !(this.targetCurrency == null ? that.targetCurrency != null : !this.targetCurrency.equals(that.targetCurrency));
        }

        public int hashCode() {
            int result = this.targetCurrency != null ? this.targetCurrency.hashCode() : 0;
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            result = 31 * (int)Double.doubleToLongBits(this.rate);
            return result;
        }
    }
}

