/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TotalHits;

public abstract class TopScoreDocCollector
extends TopDocsCollector<ScoreDoc> {
    final int totalHitsThreshold;
    ScoreDoc pqTop;

    public static TopScoreDocCollector create(int numHits, int totalHitsThreshold) {
        return TopScoreDocCollector.create(numHits, null, totalHitsThreshold);
    }

    public static TopScoreDocCollector create(int numHits, ScoreDoc after, int totalHitsThreshold) {
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        if (totalHitsThreshold < 0) {
            throw new IllegalArgumentException("totalHitsThreshold must be >= 0, got " + totalHitsThreshold);
        }
        if (after == null) {
            return new SimpleTopScoreDocCollector(numHits, totalHitsThreshold);
        }
        return new PagingTopScoreDocCollector(numHits, after, totalHitsThreshold);
    }

    TopScoreDocCollector(int numHits, int totalHitsThreshold) {
        super(new HitQueue(numHits, true));
        this.totalHitsThreshold = totalHitsThreshold;
        this.pqTop = (ScoreDoc)this.pq.top();
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            return EMPTY_TOPDOCS;
        }
        return new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.totalHitsThreshold == Integer.MAX_VALUE ? ScoreMode.COMPLETE : ScoreMode.TOP_SCORES;
    }

    protected void updateMinCompetitiveScore(Scorable scorer) throws IOException {
        if (this.totalHits > this.totalHitsThreshold && this.pqTop != null && this.pqTop.score != Float.NEGATIVE_INFINITY) {
            scorer.setMinCompetitiveScore(Math.nextUp(this.pqTop.score));
            this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
        }
    }

    private static class PagingTopScoreDocCollector
    extends TopScoreDocCollector {
        private final ScoreDoc after;
        private int collectedHits;

        PagingTopScoreDocCollector(int numHits, ScoreDoc after, int totalHitsThreshold) {
            super(numHits, totalHitsThreshold);
            this.after = after;
            this.collectedHits = 0;
        }

        @Override
        protected int topDocsSize() {
            return this.collectedHits < this.pq.size() ? this.collectedHits : this.pq.size();
        }

        @Override
        protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
            return results == null ? new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), new ScoreDoc[0]) : new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final int docBase = context.docBase;
            final int afterDoc = this.after.doc - context.docBase;
            return new ScorerLeafCollector(){

                @Override
                public void collect(int doc) throws IOException {
                    float score = this.scorer.score();
                    assert (score >= 0.0f);
                    ++totalHits;
                    if (score > ((PagingTopScoreDocCollector)this).after.score || score == ((PagingTopScoreDocCollector)this).after.score && doc <= afterDoc) {
                        if (totalHitsRelation == TotalHits.Relation.EQUAL_TO && totalHits > totalHitsThreshold) {
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                        return;
                    }
                    if (score <= pqTop.score) {
                        return;
                    }
                    collectedHits++;
                    pqTop.doc = doc + docBase;
                    pqTop.score = score;
                    pqTop = (ScoreDoc)pq.updateTop();
                    this.updateMinCompetitiveScore(this.scorer);
                }
            };
        }
    }

    private static class SimpleTopScoreDocCollector
    extends TopScoreDocCollector {
        SimpleTopScoreDocCollector(int numHits, int totalHitsThreshold) {
            super(numHits, totalHitsThreshold);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final int docBase = context.docBase;
            return new ScorerLeafCollector(){

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    super.setScorer(scorer);
                    this.updateMinCompetitiveScore(scorer);
                }

                @Override
                public void collect(int doc) throws IOException {
                    float score = this.scorer.score();
                    assert (score >= 0.0f);
                    ++totalHits;
                    if (score <= pqTop.score) {
                        if (totalHitsRelation == TotalHits.Relation.EQUAL_TO && totalHits > totalHitsThreshold) {
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                        return;
                    }
                    pqTop.doc = doc + docBase;
                    pqTop.score = score;
                    pqTop = (ScoreDoc)pq.updateTop();
                    this.updateMinCompetitiveScore(this.scorer);
                }
            };
        }
    }

    static abstract class ScorerLeafCollector
    implements LeafCollector {
        Scorable scorer;

        ScorerLeafCollector() {
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.scorer = scorer;
        }
    }
}

