/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.inference.MannWhitneyUTest;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericListEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MannWhitneyUEvaluator
extends RecursiveNumericListEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public MannWhitneyUEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        List mannWhitneyUInput = Arrays.stream(values).map(value -> ((List)value).stream().mapToDouble(Number::doubleValue).toArray()).collect(Collectors.toList());
        if (mannWhitneyUInput.size() == 2) {
            MannWhitneyUTest mannwhitneyutest = new MannWhitneyUTest();
            double u = mannwhitneyutest.mannWhitneyU((double[])mannWhitneyUInput.get(0), (double[])mannWhitneyUInput.get(1));
            double p = mannwhitneyutest.mannWhitneyUTest((double[])mannWhitneyUInput.get(0), (double[])mannWhitneyUInput.get(1));
            HashMap<String, Double> m = new HashMap<String, Double>();
            m.put("u-statistic", u);
            m.put("p-value", p);
            return new Tuple(m);
        }
        throw new IOException(String.format(Locale.ROOT, "%s(...) only works with a list of 2 arrays but a list of %d array(s) was provided.", this.constructingFactory.getFunctionName(this.getClass()), mannWhitneyUInput.size()));
    }
}

