/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompDecoder;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;

public class BufferingStompDecoder {
    private final StompDecoder stompDecoder;
    private final int bufferSizeLimit;
    private final Queue<ByteBuffer> chunks = new LinkedBlockingQueue<ByteBuffer>();
    private volatile Integer expectedContentLength;

    public BufferingStompDecoder(StompDecoder stompDecoder, int bufferSizeLimit) {
        Assert.notNull(stompDecoder, "'stompDecoder' is required");
        Assert.isTrue(bufferSizeLimit > 0, "Buffer size must be greater than 0");
        this.stompDecoder = stompDecoder;
        this.bufferSizeLimit = bufferSizeLimit;
    }

    public StompDecoder getStompDecoder() {
        return this.stompDecoder;
    }

    public int getBufferSizeLimit() {
        return this.bufferSizeLimit;
    }

    public int getBufferSize() {
        int size2 = 0;
        for (ByteBuffer buffer : this.chunks) {
            size2 += buffer.remaining();
        }
        return size2;
    }

    public Integer getExpectedContentLength() {
        return this.expectedContentLength;
    }

    public List<Message<byte[]>> decode(ByteBuffer newBuffer) {
        this.chunks.add(newBuffer);
        this.checkBufferLimits();
        if (this.getExpectedContentLength() != null && this.getBufferSize() < this.expectedContentLength) {
            return Collections.emptyList();
        }
        ByteBuffer bufferToDecode = this.assembleChunksAndReset();
        LinkedMultiValueMap<String, String> headers = new LinkedMultiValueMap<String, String>();
        List<Message<byte[]>> messages = this.stompDecoder.decode(bufferToDecode, headers);
        if (bufferToDecode.hasRemaining()) {
            this.chunks.add(bufferToDecode);
            this.expectedContentLength = StompHeaderAccessor.getContentLength(headers);
        }
        return messages;
    }

    private void checkBufferLimits() {
        if (this.getExpectedContentLength() != null && this.getExpectedContentLength() > this.getBufferSizeLimit()) {
            throw new StompConversionException("The 'content-length' header " + this.getExpectedContentLength() + "  exceeds the configured message buffer size limit " + this.getBufferSizeLimit());
        }
        if (this.getBufferSize() > this.getBufferSizeLimit()) {
            throw new StompConversionException("The configured stomp frame buffer size limit of " + this.getBufferSizeLimit() + " bytes has been exceeded");
        }
    }

    private ByteBuffer assembleChunksAndReset() {
        ByteBuffer result;
        if (this.chunks.size() == 1) {
            result = this.chunks.remove();
        } else {
            result = ByteBuffer.allocate(this.getBufferSize());
            for (ByteBuffer partial : this.chunks) {
                result.put(partial);
            }
            result.flip();
        }
        this.chunks.clear();
        this.expectedContentLength = null;
        return result;
    }
}

