/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="dataformat,transformation,json", title="JSon")
@XmlRootElement(name="json")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JsonDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private Boolean prettyPrint;
    @XmlAttribute
    @Metadata(defaultValue="XStream")
    private JsonLibrary library = JsonLibrary.XStream;
    @XmlAttribute
    private String unmarshalTypeName;
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute
    private Class<?> jsonView;
    @XmlAttribute
    private String include;
    @XmlAttribute
    private Boolean allowJmsType;
    @XmlAttribute
    private String collectionTypeName;
    @XmlTransient
    private Class<?> collectionType;
    @XmlAttribute
    private Boolean useList;
    @XmlAttribute
    private Boolean enableJaxbAnnotationModule;
    @XmlAttribute
    private String moduleClassNames;
    @XmlAttribute
    private String moduleRefs;
    @XmlAttribute
    private String enableFeatures;
    @XmlAttribute
    private String disableFeatures;
    @XmlAttribute
    private String permissions;

    public JsonDataFormat() {
        super("json");
    }

    public JsonDataFormat(JsonLibrary library) {
        this.library = library;
    }

    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public JsonLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(JsonLibrary library) {
        this.library = library;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public Boolean getAllowJmsType() {
        return this.allowJmsType;
    }

    public void setAllowJmsType(Boolean allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Boolean getUseList() {
        return this.useList;
    }

    public void setUseList(Boolean useList) {
        this.useList = useList;
    }

    public Boolean getEnableJaxbAnnotationModule() {
        return this.enableJaxbAnnotationModule;
    }

    public void setEnableJaxbAnnotationModule(Boolean enableJaxbAnnotationModule) {
        this.enableJaxbAnnotationModule = enableJaxbAnnotationModule;
    }

    public String getModuleClassNames() {
        return this.moduleClassNames;
    }

    public void setModuleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
    }

    public String getModuleRefs() {
        return this.moduleRefs;
    }

    public void setModuleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public void setPermissions(Class<?> ... type) {
        CollectionStringBuffer csb = new CollectionStringBuffer(",");
        for (Class<?> clazz : type) {
            csb.append("+");
            csb.append(clazz.getName());
        }
        this.setPermissions(csb.toString());
    }

    @Override
    public String getDataFormatName() {
        return "json-" + this.library.name().toLowerCase();
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.library == JsonLibrary.XStream) {
            this.setProperty(routeContext.getCamelContext(), this, "dataFormatName", "json-xstream");
        } else if (this.library == JsonLibrary.Jackson) {
            this.setProperty(routeContext.getCamelContext(), this, "dataFormatName", "json-jackson");
        } else {
            this.setProperty(routeContext.getCamelContext(), this, "dataFormatName", "json-gson");
        }
        if (this.unmarshalType == null && this.unmarshalTypeName != null) {
            try {
                this.unmarshalType = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.unmarshalTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if (this.collectionType == null && this.collectionTypeName != null) {
            try {
                this.collectionType = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.collectionTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createDataFormat(routeContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.unmarshalType != null) {
            this.setProperty(camelContext, dataFormat, "unmarshalType", this.unmarshalType);
        }
        if (this.prettyPrint != null) {
            this.setProperty(camelContext, dataFormat, "prettyPrint", this.prettyPrint);
        }
        if (this.jsonView != null) {
            this.setProperty(camelContext, dataFormat, "jsonView", this.jsonView);
        }
        if (this.include != null) {
            this.setProperty(camelContext, dataFormat, "include", this.include);
        }
        if (this.allowJmsType != null) {
            this.setProperty(camelContext, dataFormat, "allowJmsType", this.allowJmsType);
        }
        if (this.collectionType != null) {
            this.setProperty(camelContext, dataFormat, "collectionType", this.collectionType);
        }
        if (this.useList != null) {
            this.setProperty(camelContext, dataFormat, "useList", this.useList);
        }
        if (this.enableJaxbAnnotationModule != null) {
            this.setProperty(camelContext, dataFormat, "enableJaxbAnnotationModule", this.enableJaxbAnnotationModule);
        }
        if (this.moduleClassNames != null) {
            this.setProperty(camelContext, dataFormat, "modulesClassNames", this.moduleClassNames);
        }
        if (this.moduleRefs != null) {
            this.setProperty(camelContext, dataFormat, "moduleRefs", this.moduleRefs);
        }
        if (this.enableFeatures != null) {
            this.setProperty(camelContext, dataFormat, "enableFeatures", this.enableFeatures);
        }
        if (this.disableFeatures != null) {
            this.setProperty(camelContext, dataFormat, "disableFeatures", this.disableFeatures);
        }
        if (this.permissions != null) {
            this.setProperty(camelContext, dataFormat, "permissions", this.permissions);
        }
        if (this.permissions == null && this.unmarshalType != null) {
            String allow = "+" + this.unmarshalType.getName();
            this.setProperty(camelContext, dataFormat, "permissions", allow);
        }
    }
}

