/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.ram;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.linkedin.util.clock.Clock;
import org.linkedin.util.clock.SystemClock;
import org.linkedin.util.io.ram.RAMEntry;
import org.linkedin.util.io.ram.RAMFile;
import org.linkedin.util.io.resource.RAMResource;
import org.linkedin.util.io.resource.Resource;

public class RAMDirectory
extends RAMEntry {
    private final Map<String, RAMEntry> _directoryContent;

    public RAMDirectory() {
        this(SystemClock.instance(), "");
    }

    public RAMDirectory(Clock clock) {
        this(clock, "");
    }

    public RAMDirectory(Clock clock, String name, Map<String, RAMEntry> directoryContent) {
        super(clock, name);
        this._directoryContent = directoryContent;
    }

    public RAMDirectory(Clock clock, String name, long lastModifiedDate, Map<String, RAMEntry> directoryContent) {
        super(clock, name, lastModifiedDate);
        this._directoryContent = directoryContent;
    }

    public RAMDirectory(Clock clock, String name, long lastModifiedDate) {
        this(clock, name, lastModifiedDate, new HashMap<String, RAMEntry>());
    }

    public RAMDirectory(Clock clock, String name) {
        this(clock, name, new HashMap<String, RAMEntry>());
    }

    public RAMDirectory cd(String path) throws FileNotFoundException {
        RAMEntry ramEntry = this.getEntryByPath(path);
        if (ramEntry instanceof RAMDirectory) {
            return (RAMDirectory)ramEntry;
        }
        throw new FileNotFoundException(path);
    }

    public RAMEntry getEntry(String name) {
        return this._directoryContent.get(name);
    }

    public RAMEntry getEntryByPath(String path) {
        String[] pathComponents;
        RAMEntry entry = this;
        for (String pathComponent : pathComponents = path.split("/")) {
            if (pathComponent.equals("")) continue;
            if (entry instanceof RAMDirectory) {
                RAMDirectory ramDirectory = entry;
                entry = ramDirectory.getEntry(pathComponent);
            } else {
                entry = null;
            }
            if (entry == null) break;
        }
        return entry;
    }

    @Override
    public long getContentLength() {
        return 0L;
    }

    public RAMEntry touch(String name) {
        return this.touch(name, this._clock.currentTimeMillis());
    }

    public RAMEntry touch(String name, long lastModifiedDate) {
        RAMEntry ramEntry = this._directoryContent.get(name);
        if (ramEntry == null) {
            ramEntry = this.add(new RAMFile(this._clock, name, new byte[0]));
        }
        ramEntry.touch(lastModifiedDate);
        return ramEntry;
    }

    public RAMEntry add(RAMEntry entry) {
        this.touch();
        this._directoryContent.put(entry.name(), entry);
        return entry;
    }

    public RAMFile add(String name, byte[] content) {
        return (RAMFile)this.add(new RAMFile(this._clock, name, content));
    }

    public RAMFile add(String name, String content) {
        try {
            return this.add(name, content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public RAMDirectory mkdir(String name) throws IOException {
        RAMEntry entry = this.getEntry(name);
        if (entry instanceof RAMDirectory) {
            RAMDirectory ramDirectory = (RAMDirectory)entry;
            return ramDirectory;
        }
        if (entry == null) {
            RAMDirectory directory = new RAMDirectory(this._clock, name);
            return (RAMDirectory)this.add(directory);
        }
        throw new IOException("File exists: " + name);
    }

    public RAMEntry rm(String name) {
        return this._directoryContent.remove(name);
    }

    public RAMDirectory mkdirhier(String path) throws IOException {
        String[] pathComponents;
        RAMDirectory directory = this;
        for (String pathComponent : pathComponents = path.split("/")) {
            if (pathComponent.equals("")) continue;
            RAMEntry entry = directory.getEntry(pathComponent);
            if (entry == null) {
                directory = directory.mkdir(pathComponent);
                continue;
            }
            if (entry instanceof RAMDirectory) {
                directory = (RAMDirectory)entry;
                continue;
            }
            throw new IOException("File exists: " + pathComponent);
        }
        return directory;
    }

    public Collection<RAMEntry> ls() {
        return this._directoryContent.values();
    }

    public Resource toResource() {
        return RAMResource.create(this);
    }
}

