/**
 * Iterators are used to step through a set of nodes, e.g. the set of nodes in a NodeList, the document subtree governed by a particular Node, the results of a query, or any other set of nodes. The set of nodes to be iterated is determined by the implementation of the NodeIterator. DOM Level 2 specifies a single NodeIterator implementation for document-order traversal of a document subtree. Instances of these iterators are created by calling DocumentTraversal .createNodeIterator().
 */
var NodeIterator = {
}
/**
 * This attribute determines which node types are presented via the iterator. The available set of constants is defined in the NodeFilter interface. Nodes not accepted by whatToShow will be skipped, but their children may still be considered. Note that this skip takes precedence over the filter, if any.
 * @syntax nodeIterator.whatToShow
 * @returns {Number} 
 */
NodeIterator.prototype.whatToShow = new Number();

/**
 * Detaches the NodeIterator from the set which it iterated over, releasing any computational resources and placing the iterator in the INVALID state. After detach has been invoked, calls to nextNode or previousNode will raise the exception INVALID_STATE_ERR.
 * @syntax nodeIterator.detach()
 * @returns {undefined} 
 */
NodeIterator.prototype.detach = function() {};

/**
 * The root node of the NodeIterator, as specified when it was created.
 * @syntax nodeIterator.root
 * @returns {Node} 
 */
NodeIterator.prototype.root = new Node();

/**
 * The value of this flag determines whether the children of entity reference nodes are visible to the iterator. If false, they and their descendants will be rejected. Note that this rejection takes precedence over whatToShow and the filter. Also note that this is currently the only situation where NodeIterators may reject a complete subtree rather than skipping individual nodes. To produce a view of the document that has entity references expanded and does not expose the entity reference node itself, use the whatToShow flags to hide the entity reference node and set expandEntityReferences to true when creating the iterator. To produce a view of the document that has entity reference nodes but no entity expansion, use the whatToShow flags to show the entity reference node and set expandEntityReferences to false.
 * @syntax nodeIterator.expandEntityReferences
 * @returns {boolean} 
 */
NodeIterator.prototype.expandEntityReferences = new boolean();

/**
 * Returns the next node in the set
 * @syntax nodeIterator.nextNode()
 * @returns {Node} The next Node in the set being iterated over, or null if there are no more members in that set.
 */
NodeIterator.prototype.nextNode = function() {};

/**
 * The NodeFilter used to screen nodes.
 * @syntax nodeIterator.filter
 * @returns {NodeFilter} 
 */
NodeIterator.prototype.filter = new NodeFilter();

/**
 * Returns the previous node in the set
 * @syntax nodeIterator.previousNode()
 * @returns {Node} The previous Node in the set being iterated over, or null if there are no more members in that set.
 */
NodeIterator.prototype.previousNode = function() {};

/**
 * Represents the NodeIterator prototype object.
 * @syntax NodeIterator.prototype
 * @static
 */
NodeIterator.prototype;

