/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.editor;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import jdk.jshell.Snippet;
import jdk.jshell.VarSnippet;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.templates.FileBuilder;
import org.netbeans.lib.nbjshell.JShellAccessor;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.java.hints.friendapi.SourceChangeUtils;
import org.netbeans.modules.jshell.editor.Bundle;
import org.netbeans.modules.jshell.support.ShellSession;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SnippetClassGenerator
implements Runnable {
    private final Project project;
    private final ShellSession shellSession;
    private final FileObject targetFolder;
    private final String className;
    private FileObject javaFile;
    private StringBuilder executableContent = new StringBuilder();
    private StringBuilder declarativeConent = new StringBuilder();
    private List<Snippet> liveSnippets;
    private Set<Snippet> processed = new HashSet<Snippet>();
    private Set<Snippet> declared = new HashSet<Snippet>();
    private Throwable error;
    private WorkingCopy copy;

    public SnippetClassGenerator(Project project, ShellSession shellSession, FileObject targetFolder, String className) {
        this.project = project;
        this.shellSession = shellSession;
        this.targetFolder = targetFolder;
        this.className = className;
    }

    public Throwable getError() {
        return this.error;
    }

    private FileObject createJavaFile() throws IOException {
        FileObject template = FileUtil.getConfigFile((String)"Templates/Classes/ShellClass.java");
        if (template == null) {
            throw new IOException(Bundle.EXC_ShellTemplateMissing());
        }
        FileBuilder builder = new FileBuilder(template, this.targetFolder);
        builder.name(this.className);
        builder.param("executables", (Object)this.executableContent.toString());
        builder.param("declaratives", (Object)this.declarativeConent.toString());
        List l = builder.build();
        if (l.size() != 1) {
            throw new IOException(Bundle.EXC_UnexpectedTemplateContents());
        }
        return (FileObject)l.iterator().next();
    }

    private void createStatementsText() {
        for (Snippet s : this.liveSnippets) {
            if (s.kind().isPersistent() && s.subKind() != Snippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND || !this.processed.add(s)) continue;
            String text = s.source();
            if (s.subKind() == Snippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND) {
                VarSnippet vs = (VarSnippet)s;
                if (!this.declared.contains(s)) {
                    this.executableContent.append(vs.typeName()).append(" ");
                }
                this.executableContent.append(vs.name()).append(" = ");
            }
            this.executableContent.append(text);
            if (!text.endsWith(";") && !text.endsWith("}")) {
                this.executableContent.append(";");
            }
            this.executableContent.append("\n");
        }
    }

    private boolean declarationsDependsOn(Snippet snip) {
        ArrayDeque<Snippet> candidates = new ArrayDeque<Snippet>();
        candidates.add(snip);
        while (!candidates.isEmpty()) {
            Snippet c = (Snippet)candidates.poll();
            Collection<Snippet> deps = JShellAccessor.getDependents(this.shellSession.ensureShell(), c);
            for (Snippet s : deps) {
                if (!s.kind().isPersistent() || s.kind() == Snippet.Kind.IMPORT) continue;
                if (s.subKind() == Snippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND) {
                    candidates.push(s);
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    private void prepareDeclarations() {
        for (Snippet s : this.liveSnippets) {
            String text;
            if (!s.kind().isPersistent() || s.kind() == Snippet.Kind.IMPORT || s.subKind() == Snippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND && !this.declarationsDependsOn(s)) continue;
            this.declared.add(s);
            if (this.declarativeConent.length() > 0) {
                this.declarativeConent.append("\n");
            }
            if (s.subKind() == Snippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND) {
                VarSnippet vs = (VarSnippet)s;
                text = vs.typeName() + " " + vs.name();
                this.declarativeConent.append(text);
            } else {
                text = s.source();
                this.declarativeConent.append(text);
                this.processed.add(s);
            }
            if (!text.endsWith(";") && !text.endsWith("}")) {
                this.declarativeConent.append(";");
            }
            this.declarativeConent.append("\n");
        }
    }

    private void prepareImports() {
    }

    private void copyImports() {
        ArrayList<ImportTree> imps = new ArrayList<ImportTree>();
        for (Snippet s : this.shellSession.getSnippets(false, true)) {
            boolean stat;
            String importText;
            int ii;
            if (s.kind() != Snippet.Kind.IMPORT || (ii = (importText = s.source()).indexOf("import")) == -1) continue;
            String ident = importText.substring(ii + 6).trim();
            if (ident.endsWith(";")) {
                ident = ident.substring(0, ident.length() - 1);
            }
            if ((stat = ident.startsWith("static")) && (ident = ident.substring(6).trim()).startsWith("REPL.$$")) continue;
            ExpressionTree qi = this.copy.getTreeMaker().QualIdent(ident);
            imps.add(this.copy.getTreeMaker().Import((Tree)qi, stat));
        }
        CompilationUnitTree t = this.copy.getCompilationUnit();
        for (ImportTree i : imps) {
            t = this.copy.getTreeMaker().addCompUnitImport(t, i);
        }
        this.copy.rewrite((Tree)this.copy.getCompilationUnit(), (Tree)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.liveSnippets = this.shellSession.getSnippets(true, true);
        this.prepareDeclarations();
        this.createStatementsText();
        this.prepareImports();
        try {
            FileObject replaced = this.targetFolder.getFileObject(this.className, "java");
            if (replaced != null) {
                replaced.delete();
            }
            this.javaFile = this.createJavaFile();
            JavaSource src = JavaSource.forFileObject((FileObject)this.javaFile);
            if (src == null) {
                return;
            }
            src.runModificationTask(wc -> {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                this.copy = wc;
                this.copyImports();
            }).commit();
            EditorCookie editor = (EditorCookie)this.javaFile.getLookup().lookup(EditorCookie.class);
            StyledDocument d = editor.openDocument();
            Reformat r = Reformat.get((Document)d);
            r.lock();
            try {
                r.reformat(0, d.getLength());
            }
            finally {
                r.unlock();
            }
            src.runModificationTask(wc -> {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                this.copy = wc;
                SourceChangeUtils.doOrganizeImports((WorkingCopy)this.copy, null, (boolean)true);
            }).commit();
            editor.saveDocument();
        }
        catch (IOException ex) {
            this.error = ex;
        }
        catch (BadLocationException ex) {
            this.error = ex;
        }
    }

    public FileObject getJavaFile() {
        return this.javaFile;
    }
}

