/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.lib2.DocUtils;
import org.netbeans.modules.editor.lib2.RectangularSelectionUtils;
import org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.PositionsBag;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public abstract class CaretBasedBlockHighlighting
implements HighlightsContainer,
ChangeListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(CaretBasedBlockHighlighting.class.getName());
    private boolean inited;
    private final MimePath mimePath;
    private final JTextComponent component;
    private Caret caret;
    private ChangeListener caretListener;
    private final String coloringName;
    private final boolean extendsEOL;
    private final boolean extendsEmptyLine;
    private final PositionsBag selectionsBag;
    private AttributeSet attribs;
    private LookupListener lookupListener;

    protected CaretBasedBlockHighlighting(JTextComponent component, String coloringName, boolean extendsEOL, boolean extendsEmptyLine) {
        String mimeType = BlockHighlighting.getMimeType(component);
        this.mimePath = mimeType == null ? MimePath.EMPTY : MimePath.parse((String)mimeType);
        this.coloringName = coloringName;
        this.extendsEOL = extendsEOL;
        this.extendsEmptyLine = extendsEmptyLine;
        this.component = component;
        this.selectionsBag = new PositionsBag(component.getDocument(), false);
    }

    private void init() {
        this.component.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.component));
        this.caret = this.component.getCaret();
        if (this.caret != null) {
            this.caretListener = WeakListeners.change((ChangeListener)this, (Object)this.caret);
            this.caret.addChangeListener(this.caretListener);
        }
        this.updateLineInfo(false);
    }

    protected final JTextComponent component() {
        return this.component;
    }

    protected final Caret caret() {
        return this.caret;
    }

    @Override
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        if (!this.inited) {
            this.inited = true;
            this.init();
        }
        return this.selectionsBag.getHighlights(startOffset, endOffset);
    }

    @Override
    public void addHighlightsChangeListener(HighlightsChangeListener listener) {
        this.selectionsBag.addHighlightsChangeListener(listener);
    }

    @Override
    public void removeHighlightsChangeListener(HighlightsChangeListener listener) {
        this.selectionsBag.removeHighlightsChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null || "caret".equals(evt.getPropertyName())) {
            if (this.caret != null) {
                this.caret.removeChangeListener(this.caretListener);
                this.caretListener = null;
            }
            this.caret = this.component.getCaret();
            if (this.caret != null) {
                this.caretListener = WeakListeners.change((ChangeListener)this, (Object)this.caret);
                this.caret.addChangeListener(this.caretListener);
            }
            this.updateLineInfo(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateLineInfo(true);
    }

    protected abstract PositionsBag getCurrentBlockPositions(Document var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateLineInfo(boolean fire) {
        ((AbstractDocument)this.component.getDocument()).readLock();
        try {
            PositionsBag newPositions = this.getCurrentBlockPositions(this.component.getDocument());
            CaretBasedBlockHighlighting caretBasedBlockHighlighting = this;
            synchronized (caretBasedBlockHighlighting) {
                if (newPositions != null) {
                    this.selectionsBag.setHighlights(newPositions);
                } else {
                    this.selectionsBag.clear();
                }
            }
        }
        finally {
            ((AbstractDocument)this.component.getDocument()).readUnlock();
        }
    }

    protected final AttributeSet getAttribs() {
        if (this.lookupListener == null) {
            this.lookupListener = new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    Lookup.Result result = (Lookup.Result)ev.getSource();
                    CaretBasedBlockHighlighting.this.setAttrs((Lookup.Result<FontColorSettings>)result);
                }
            };
            Lookup lookup = MimeLookup.getLookup((MimePath)this.mimePath);
            Lookup.Result result = lookup.lookupResult(FontColorSettings.class);
            this.setAttrs((Lookup.Result<FontColorSettings>)result);
            result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, (Object)result));
        }
        return this.attribs;
    }

    void setAttrs(Lookup.Result<FontColorSettings> result) {
        if (Boolean.TRUE.equals(this.component.getClientProperty("AsTextField"))) {
            if (UIManager.get("TextField.selectionBackground") != null) {
                this.attribs = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, (Color)UIManager.get("TextField.selectionBackground"), StyleConstants.Foreground, (Color)UIManager.get("TextField.selectionForeground")});
            } else {
                JTextField referenceTextField = (JTextField)new JComboBox().getEditor().getEditorComponent();
                this.attribs = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, referenceTextField.getSelectionColor(), StyleConstants.Foreground, referenceTextField.getSelectedTextColor()});
            }
            return;
        }
        FontColorSettings fcs = (FontColorSettings)result.allInstances().iterator().next();
        this.attribs = fcs.getFontColors(this.coloringName);
        if (this.attribs == null) {
            this.attribs = SimpleAttributeSet.EMPTY;
        } else if (this.extendsEOL || this.extendsEmptyLine) {
            this.attribs = AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{this.attribs, AttributesUtilities.createImmutable((Object[])new Object[]{"org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", this.extendsEOL, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE", this.extendsEmptyLine})});
        }
    }

    private static String positionToString(Position p) {
        return p == null ? "null" : p.toString();
    }

    private static String s2s(Object o) {
        return o == null ? "null" : o.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    public static final class TextSelectionHighlighting
    extends CaretBasedBlockHighlighting
    implements HighlightsChangeListener {
        public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.TextSelectionHighlighting";
        private int hlChangeStartOffset = -1;
        private int hlChangeEndOffset;
        private PositionsBag rectangularSelectionBag;

        public TextSelectionHighlighting(JTextComponent component) {
            super(component, "selection", true, true);
        }

        @Override
        protected PositionsBag getCurrentBlockPositions(Document document) {
            PositionsBag selections;
            block5: {
                int markOffset;
                Caret caret;
                block6: {
                    caret = this.caret();
                    selections = null;
                    if (document == null || caret == null) break block5;
                    selections = new PositionsBag(document);
                    if (!(caret instanceof EditorCaret)) break block6;
                    EditorCaret editorCaret = (EditorCaret)caret;
                    for (CaretInfo caretInfo : editorCaret.getCarets()) {
                        int markOffset2;
                        int caretOffset = caretInfo.getDot();
                        if (caretOffset == (markOffset2 = caretInfo.getMark())) continue;
                        try {
                            Position start = document.createPosition(Math.min(caretOffset, markOffset2));
                            Position end = document.createPosition(Math.max(caretOffset, markOffset2));
                            selections.addHighlight(start, end, this.getAttribs());
                        }
                        catch (BadLocationException e) {
                            LOG.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                    break block5;
                }
                int caretOffset = caret.getDot();
                if (caretOffset == (markOffset = caret.getMark())) break block5;
                try {
                    Position start = document.createPosition(Math.min(caretOffset, markOffset));
                    Position end = document.createPosition(Math.max(caretOffset, markOffset));
                    selections.addHighlight(start, end, this.getAttribs());
                }
                catch (BadLocationException e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return selections;
        }

        @Override
        public HighlightsSequence getHighlights(int startOffset, int endOffset) {
            if (!RectangularSelectionUtils.isRectangularSelection(this.component())) {
                return super.getHighlights(startOffset, endOffset);
            }
            return this.rectangularSelectionBag != null ? this.rectangularSelectionBag.getHighlights(startOffset, endOffset) : HighlightsSequence.EMPTY;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            if (RectangularSelectionUtils.getRectangularSelectionProperty().equals(evt.getPropertyName())) {
                // empty if block
            }
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            Document doc;
            super.stateChanged(evt);
            JTextComponent c = this.component();
            if (RectangularSelectionUtils.isRectangularSelection(c) && (doc = c.getDocument()) != null) {
                List<Position> regions;
                if (this.rectangularSelectionBag == null) {
                    this.rectangularSelectionBag = new PositionsBag(doc);
                    this.rectangularSelectionBag.addHighlightsChangeListener(this);
                }
                if ((regions = RectangularSelectionUtils.regionsCopy(c)) != null) {
                    AttributeSet attrs = this.getAttribs();
                    this.rectangularSelectionBag.clear();
                    int size = regions.size();
                    int i = 0;
                    while (i < size) {
                        Position startPos = regions.get(i++);
                        Position endPos = regions.get(i++);
                        this.rectangularSelectionBag.addHighlight(startPos, endPos, attrs);
                    }
                    if (this.hlChangeStartOffset != -1) {
                        this.hlChangeStartOffset = -1;
                    }
                }
            }
        }

        @Override
        public void highlightChanged(HighlightsChangeEvent evt) {
            if (this.hlChangeStartOffset == -1) {
                this.hlChangeStartOffset = evt.getStartOffset();
                this.hlChangeEndOffset = evt.getEndOffset();
            } else {
                this.hlChangeStartOffset = Math.min(this.hlChangeStartOffset, evt.getStartOffset());
                this.hlChangeEndOffset = Math.max(this.hlChangeEndOffset, evt.getEndOffset());
            }
        }
    }

    public static final class CaretRowHighlighting
    extends CaretBasedBlockHighlighting {
        public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting";

        public CaretRowHighlighting(JTextComponent component) {
            super(component, "highlight-caret-row", true, false);
        }

        @Override
        protected PositionsBag getCurrentBlockPositions(Document document) {
            PositionsBag selections;
            block7: {
                Caret caret = this.caret();
                selections = null;
                if (document == null || caret == null) break block7;
                selections = new PositionsBag(document);
                if (caret instanceof EditorCaret) {
                    EditorCaret editorCaret = (EditorCaret)caret;
                    List<CaretInfo> carets = editorCaret.getCarets();
                    for (CaretInfo c : carets) {
                        int caretOffset = c.getDot();
                        try {
                            int startOffset = DocUtils.getRowStart(document, caretOffset, 0);
                            int endOffset = DocUtils.getRowEnd(document, caretOffset);
                            Position startPos = document.createPosition(startOffset);
                            Position endPos = document.createPosition(++endOffset);
                            selections.addHighlight(startPos, endPos, this.getAttribs());
                        }
                        catch (BadLocationException e) {
                            LOG.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                } else {
                    int caretOffset = caret.getDot();
                    try {
                        int startOffset = DocUtils.getRowStart(document, caretOffset, 0);
                        int endOffset = DocUtils.getRowEnd(document, caretOffset);
                        Position startPos = document.createPosition(startOffset);
                        Position endPos = document.createPosition(++endOffset);
                        selections.addHighlight(startPos, endPos, this.getAttribs());
                    }
                    catch (BadLocationException e) {
                        LOG.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
            return selections;
        }
    }
}

