/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.osgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class OSGiInstalledFileLocator
extends InstalledFileLocator {
    private static final String FILES = "OSGI-INF/files/";
    private final BundleContext context;

    public OSGiInstalledFileLocator(BundleContext context) {
        this.context = context;
    }

    public File locate(String relativePath, String codeNameBase, boolean localized) {
        block41: {
            block40: {
                String ext;
                String baseName;
                if (!localized) break block40;
                int i = relativePath.lastIndexOf(46);
                if (i == -1 || i < relativePath.lastIndexOf(47)) {
                    baseName = relativePath;
                    ext = "";
                } else {
                    baseName = relativePath.substring(0, i);
                    ext = relativePath.substring(i);
                }
                Iterator it = NbBundle.getLocalizingSuffixes();
                while (it.hasNext()) {
                    String locName = baseName + (String)it.next() + ext;
                    File f = this.locate(locName, codeNameBase, false);
                    if (f == null) continue;
                    return f;
                }
                break block41;
            }
            if (codeNameBase != null && relativePath.equals("modules/" + codeNameBase.replace('.', '-') + ".jar")) {
                for (Bundle owner : this.context.getBundles()) {
                    String loc;
                    if (!owner.getSymbolicName().equals(codeNameBase) || !(loc = owner.getLocation()).startsWith("file:")) continue;
                    return Utilities.toFile((URI)URI.create(loc));
                }
                return null;
            }
            String storage = this.context.getProperty("org.osgi.framework.storage");
            if (storage == null) {
                return null;
            }
            File f = this.unpackedLocation(storage, relativePath);
            if (f.exists()) {
                return f;
            }
            block25: for (Bundle owner : this.context.getBundles()) {
                if (codeNameBase != null && !owner.getSymbolicName().equals(codeNameBase)) continue;
                switch (owner.getState()) {
                    case 1: 
                    case 2: {
                        continue block25;
                    }
                    default: {
                        if (owner.getResource(FILES + relativePath) == null) continue block25;
                        String execFilesS = (String)owner.getHeaders().get("NetBeans-Executable-Files");
                        List execFiles = execFilesS == null ? Collections.emptyList() : Arrays.asList(execFilesS.split(","));
                        try {
                            for (URL resource : NbCollections.iterable((Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)owner.findEntries(FILES, null, true), URL.class, (boolean)true))) {
                                String bundlepath = resource.getPath();
                                if (bundlepath.endsWith("/")) continue;
                                String name = bundlepath.substring("/OSGI-INF/files/".length());
                                File f2 = this.unpackedLocation(storage, name);
                                File dir = f2.getParentFile();
                                if (!dir.isDirectory() && !dir.mkdirs()) {
                                    throw new IOException("Could not make " + dir);
                                }
                                try (InputStream is = resource.openStream();
                                     OutputStream os = Files.newOutputStream(f2.toPath(), new OpenOption[0]);){
                                    int read;
                                    byte[] buf = new byte[4096];
                                    while ((read = is.read(buf)) != -1) {
                                        os.write(buf, 0, read);
                                    }
                                }
                                if (!execFiles.contains(name)) continue;
                                f2.setExecutable(true);
                            }
                            return f;
                        }
                        catch (IOException | InvalidPathException x) {
                            Exceptions.printStackTrace((Throwable)x);
                        }
                    }
                }
            }
        }
        return null;
    }

    private File unpackedLocation(String storage, String relativePath) {
        return new File(storage, "files/" + relativePath.replace('/', File.separatorChar));
    }
}

