/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client.jetty;

import java.net.URI;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketHandlerAdapter;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketSession;
import org.springframework.web.socket.adapter.jetty.WebSocketToJettyExtensionConfigAdapter;
import org.springframework.web.socket.client.AbstractWebSocketClient;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class JettyWebSocketClient
extends AbstractWebSocketClient
implements SmartLifecycle {
    private final WebSocketClient client;
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private final Object lifecycleMonitor = new Object();
    private AsyncListenableTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor("WebSocketClient-");

    public JettyWebSocketClient() {
        this.client = new WebSocketClient();
    }

    public JettyWebSocketClient(WebSocketClient client) {
        this.client = client;
    }

    public void setTaskExecutor(AsyncListenableTaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"TaskExecutor must not be null");
        this.taskExecutor = taskExecutor;
    }

    public AsyncListenableTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.client.isStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Starting Jetty WebSocketClient");
                    }
                    this.client.start();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to start Jetty client", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Stopping Jetty WebSocketClient");
                    }
                    this.client.stop();
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error stopping Jetty WebSocketClient", (Throwable)e);
                }
            }
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    @Override
    public ListenableFuture<WebSocketSession> doHandshake(WebSocketHandler webSocketHandler, String uriTemplate, Object ... uriVars) {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)uriTemplate).buildAndExpand(uriVars).encode();
        return this.doHandshake(webSocketHandler, null, uriComponents.toUri());
    }

    @Override
    public ListenableFuture<WebSocketSession> doHandshakeInternal(WebSocketHandler wsHandler, HttpHeaders headers, final URI uri, List<String> protocols, List<WebSocketExtension> extensions, Map<String, Object> handshakeAttributes) {
        final ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setSubProtocols(protocols);
        for (WebSocketExtension e : extensions) {
            request.addExtensions(new ExtensionConfig[]{new WebSocketToJettyExtensionConfigAdapter(e)});
        }
        for (String header : headers.keySet()) {
            request.setHeader(header, headers.get((Object)header));
        }
        Principal user = this.getUser();
        final JettyWebSocketSession wsSession = new JettyWebSocketSession(handshakeAttributes, user);
        final JettyWebSocketHandlerAdapter listener = new JettyWebSocketHandlerAdapter(wsHandler, wsSession);
        return this.taskExecutor.submitListenable((Callable)new Callable<WebSocketSession>(){

            @Override
            public WebSocketSession call() throws Exception {
                Future future = JettyWebSocketClient.this.client.connect((Object)listener, uri, request);
                future.get();
                return wsSession;
            }
        });
    }

    protected Principal getUser() {
        return null;
    }
}

