/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.packer;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.maven.index.context.IndexingContext;

public class IndexPackingRequest {
    public static final int MAX_CHUNKS = 30;
    private final IndexingContext context;
    private final IndexReader indexReader;
    private final File targetDir;
    private boolean createIncrementalChunks;
    private boolean createChecksumFiles;
    private int maxIndexChunks;
    private boolean useTargetProperties;
    private Collection<IndexFormat> formats;

    public IndexPackingRequest(IndexingContext context, IndexReader indexReader, File targetDir) {
        this.context = (IndexingContext)Preconditions.checkNotNull((Object)context);
        this.indexReader = (IndexReader)Preconditions.checkNotNull((Object)indexReader);
        this.targetDir = (File)Preconditions.checkNotNull((Object)targetDir);
        this.createIncrementalChunks = true;
        this.createChecksumFiles = false;
        this.maxIndexChunks = 30;
        this.useTargetProperties = false;
        this.formats = Arrays.asList(IndexFormat.FORMAT_V1);
    }

    public IndexingContext getContext() {
        return this.context;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public void setFormats(Collection<IndexFormat> formats) {
        this.formats = formats;
    }

    public Collection<IndexFormat> getFormats() {
        return this.formats;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public boolean isCreateIncrementalChunks() {
        return this.createIncrementalChunks;
    }

    public void setCreateIncrementalChunks(boolean createIncrementalChunks) {
        this.createIncrementalChunks = createIncrementalChunks;
    }

    public boolean isCreateChecksumFiles() {
        return this.createChecksumFiles;
    }

    public void setCreateChecksumFiles(boolean createChecksumFiles) {
        this.createChecksumFiles = createChecksumFiles;
    }

    public int getMaxIndexChunks() {
        return this.maxIndexChunks;
    }

    public void setMaxIndexChunks(int maxIndexChunks) {
        this.maxIndexChunks = maxIndexChunks;
    }

    public boolean isUseTargetProperties() {
        return this.useTargetProperties;
    }

    public void setUseTargetProperties(boolean useTargetProperties) {
        this.useTargetProperties = useTargetProperties;
    }

    public static enum IndexFormat {
        FORMAT_V1;

    }
}

