/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlElementHandle;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

final class HtmlStructureItem
implements StructureItem {
    private final HtmlElementHandle handle;
    private final OffsetRange documentOffsetRange;
    private final String idAttributeValue;
    private final String classAttributeValue;
    private List<StructureItem> items;
    private final MimePath mimePath;
    private final boolean isLeaf;

    public HtmlStructureItem(OpenTag node, HtmlElementHandle handle, Snapshot snapshot) {
        this.handle = handle;
        int dfrom = snapshot.getOriginalOffset(node.from());
        int dto = snapshot.getOriginalOffset(node.semanticEnd());
        this.documentOffsetRange = dfrom == -1 && dto == -1 ? OffsetRange.NONE : (dfrom == -1 || dto == -1 ? OffsetRange.NONE : (dfrom > dto ? OffsetRange.NONE : new OffsetRange(dfrom, dto)));
        this.idAttributeValue = this.getAttributeValue((Element)node, "id");
        this.classAttributeValue = this.getAttributeValue((Element)node, "class");
        this.mimePath = snapshot.getMimePath();
        this.isLeaf = node.children(OpenTag.class).isEmpty();
    }

    public ElementHandle getElementHandle() {
        return this.handle;
    }

    public String getName() {
        return this.handle.getName();
    }

    public String getSortText() {
        return Integer.toHexString(10000 + (int)this.getPosition());
    }

    public String getHtml(HtmlFormatter formatter) {
        formatter.appendHtml(this.getName());
        if (this.idAttributeValue != null) {
            formatter.appendHtml("&nbsp;<font color=808080>id=");
            formatter.appendText(this.idAttributeValue);
            formatter.appendHtml("</font>");
        }
        if (this.classAttributeValue != null) {
            formatter.appendHtml("&nbsp;<font color=808080>class=");
            formatter.appendText(this.classAttributeValue);
            formatter.appendHtml("</font>");
        }
        return formatter.getText();
    }

    public boolean equals(Object o) {
        if (!(o instanceof HtmlStructureItem)) {
            return false;
        }
        HtmlStructureItem item = (HtmlStructureItem)o;
        return item.getElementHandle().equals(this.getElementHandle());
    }

    public int hashCode() {
        return this.getElementHandle().hashCode();
    }

    public ElementKind getKind() {
        return ElementKind.TAG;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void runTask(final Task task) throws ParseException {
        Source source = Source.create((FileObject)this.getElementHandle().getFileObject());
        if (source == null) {
            return;
        }
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                HtmlParserResult result;
                if (HtmlStructureItem.this.mimePath.size() == 1) {
                    result = (HtmlParserResult)resultIterator.getParserResult();
                } else {
                    for (int i = 0; i < HtmlStructureItem.this.mimePath.size(); ++i) {
                        String mimeType = HtmlStructureItem.this.mimePath.getMimeType(i);
                        for (Embedding embedding : resultIterator.getEmbeddings()) {
                            if (!embedding.getMimeType().equals(mimeType)) continue;
                            resultIterator = resultIterator.getResultIterator(embedding);
                        }
                    }
                    result = (HtmlParserResult)resultIterator.getParserResult();
                }
                task.run(result);
            }
        });
    }

    public synchronized List<? extends StructureItem> getNestedItems() {
        if (this.items == null) {
            try {
                this.runTask(new Task(){

                    @Override
                    public void run(HtmlParserResult result) {
                        OpenTag node = HtmlStructureItem.this.handle.resolve(result);
                        HtmlStructureItem.this.items = new ArrayList();
                        if (node != null) {
                            List<OpenTag> nonVirtualChildren = HtmlStructureItem.gatherNonVirtualChildren((Node)node);
                            for (OpenTag child : nonVirtualChildren) {
                                HtmlElementHandle childHandle = new HtmlElementHandle(child, HtmlStructureItem.this.handle.getFileObject());
                                HtmlStructureItem.this.items.add(new HtmlStructureItem(child, childHandle, result.getSnapshot()));
                            }
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (this.items == null) {
            return Collections.emptyList();
        }
        return this.items;
    }

    public long getPosition() {
        return this.documentOffsetRange.getStart();
    }

    public long getEndPosition() {
        return this.documentOffsetRange.getEnd();
    }

    public ImageIcon getCustomIcon() {
        return null;
    }

    private String getAttributeValue(Element node, String key) {
        String value = this._getAttributeValue(node, key.toUpperCase(Locale.ENGLISH));
        if (value == null) {
            return this._getAttributeValue(node, key.toLowerCase(Locale.ENGLISH));
        }
        return value;
    }

    private String _getAttributeValue(Element node, String key) {
        if (node.type() != ElementType.OPEN_TAG) {
            return null;
        }
        OpenTag t = (OpenTag)node;
        Attribute attr = t.getAttribute(key);
        if (attr == null) {
            return null;
        }
        CharSequence value = attr.unquotedValue();
        return value != null ? value.toString() : null;
    }

    static List<OpenTag> gatherNonVirtualChildren(Node element) {
        LinkedList<OpenTag> collected = new LinkedList<OpenTag>();
        for (OpenTag child : element.children(OpenTag.class)) {
            if (child.type() != ElementType.OPEN_TAG) continue;
            if (!ElementUtils.isVirtualNode((Element)child)) {
                collected.add(child);
                continue;
            }
            collected.addAll(HtmlStructureItem.gatherNonVirtualChildren((Node)child));
        }
        return collected;
    }

    public static interface Task {
        public void run(HtmlParserResult var1);
    }
}

