/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core.spi;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.versioning.core.APIAccessor;
import org.netbeans.modules.versioning.core.SPIAccessor;
import org.netbeans.modules.versioning.core.Utils;
import org.netbeans.modules.versioning.core.VersioningManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.SPIAccessorImpl;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class VCSContext {
    public static final VCSContext EMPTY = new VCSContext((Node[])null, VCSContext.emptySet(), VCSContext.emptySet());
    private static final Logger LOG = Logger.getLogger(VCSContext.class.getName());
    private static Reference<VCSContext> contextCached = new WeakReference<Object>(null);
    private static Reference<Node[]> contextNodesCached = new WeakReference<Object>(null);
    private final Lookup elements;
    private final Set<VCSFileProxy> unfilteredRootFiles;
    private final Set<VCSFileProxy> rootFiles;
    private final Set<VCSFileProxy> exclusions;
    private Set<VCSFileProxy> computedFilesCached;
    private FileFilter fileFilterCached;

    static VCSContext forFiles(Set<VCSFileProxy> rootFiles, Set<? extends FileObject> originalFiles) {
        return new VCSContext(originalFiles, rootFiles, VCSContext.emptySet());
    }

    public static synchronized VCSContext forNodes(Node[] nodes) {
        VCSContext ctx;
        if (Arrays.equals(contextNodesCached.get(), nodes) && (ctx = contextCached.get()) != null) {
            return ctx;
        }
        HashSet<VCSFileProxy> rootFiles = new HashSet<VCSFileProxy>(nodes.length);
        HashSet<SourceGroup> sourceGroups = new HashSet<SourceGroup>();
        LinkedHashMap<FileObject, VCSFileProxy> rootFileExclusions = new LinkedHashMap<FileObject, VCSFileProxy>(5);
        int numberOfProjects = 0;
        for (int i = 0; i < nodes.length; ++i) {
            Project project;
            Node node = nodes[i];
            File aFile = (File)node.getLookup().lookup(File.class);
            if (aFile != null) {
                rootFiles.add(VCSFileProxy.createFileProxy(aFile));
                continue;
            }
            VCSFileProxy aFileProxy = (VCSFileProxy)node.getLookup().lookup(VCSFileProxy.class);
            if (aFileProxy != null) {
                rootFiles.add(aFileProxy);
                continue;
            }
            if (!Boolean.TRUE.equals(node.getValue("VCS_PHYSICAL")) && (project = (Project)node.getLookup().lookup(Project.class)) != null) {
                ++numberOfProjects;
                VCSContext.addProjectFiles(rootFiles, rootFileExclusions, project, sourceGroups);
                continue;
            }
            VCSContext.addFileObjects(node, rootFiles);
        }
        if (numberOfProjects > 1) {
            VCSContext.removeContainedExclusions(rootFileExclusions, sourceGroups);
        }
        if (rootFiles.isEmpty()) {
            LOG.fine("forNodes: context contains no root files");
        }
        ArrayList<VCSFileProxy> unversionedFiles = new ArrayList<VCSFileProxy>(rootFiles.size());
        HashSet<VCSSystemProvider.VersioningSystem> projectOwners = new HashSet<VCSSystemProvider.VersioningSystem>(2);
        for (VCSFileProxy root : rootFiles) {
            if (root != null) {
                VCSSystemProvider.VersioningSystem owner = VersioningManager.getInstance().getOwner(root);
                if (owner == null) {
                    unversionedFiles.add(root);
                    continue;
                }
                projectOwners.add(owner);
                continue;
            }
            LOG.warning("trying to add a null root to context");
        }
        if (!projectOwners.isEmpty()) {
            if (projectOwners.size() == 1) {
                for (VCSFileProxy unversionedFile : unversionedFiles) {
                    Iterator i = rootFileExclusions.entrySet().iterator();
                    while (i.hasNext()) {
                        VCSFileProxy exclusion = (VCSFileProxy)i.next().getValue();
                        if (!Utils.isAncestorOrEqual(unversionedFile, exclusion)) continue;
                        i.remove();
                    }
                }
                rootFiles.removeAll(unversionedFiles);
            } else {
                rootFileExclusions.clear();
                rootFiles.clear();
            }
        }
        VCSContext ctx2 = new VCSContext(nodes, rootFiles, rootFileExclusions.values());
        contextCached = new WeakReference<VCSContext>(ctx2);
        contextNodesCached = new WeakReference<Node[]>(nodes);
        return ctx2;
    }

    public synchronized Set<VCSFileProxy> computeFiles(FileFilter filter) {
        if (this.computedFilesCached == null || filter != this.fileFilterCached) {
            this.computedFilesCached = VCSContext.substract(this.rootFiles, this.exclusions, filter);
            this.fileFilterCached = filter;
        }
        return this.computedFilesCached;
    }

    public Lookup getElements() {
        return this.elements;
    }

    public Set<VCSFileProxy> getFiles() {
        return this.unfilteredRootFiles;
    }

    public Set<VCSFileProxy> getRootFiles() {
        return this.rootFiles;
    }

    public Set<VCSFileProxy> getExclusions() {
        return this.exclusions;
    }

    public boolean contains(VCSFileProxy file) {
        block0: for (VCSFileProxy root : this.rootFiles) {
            if (!Utils.isAncestorOrEqual(root, file)) continue;
            for (VCSFileProxy excluded : this.exclusions) {
                if (!Utils.isAncestorOrEqual(excluded, file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    static synchronized void flushCached() {
        contextNodesCached.clear();
        contextCached.clear();
    }

    private static void addProjectFiles(Collection<VCSFileProxy> rootFiles, Map<FileObject, VCSFileProxy> rootFilesExclusions, Project project, Set<SourceGroup> srcGroups) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        srcGroups.addAll(Arrays.asList(sourceGroups));
        block2: for (int j = 0; j < sourceGroups.length; ++j) {
            SourceGroup sourceGroup = sourceGroups[j];
            FileObject srcRootFo = sourceGroup.getRootFolder();
            VCSFileProxy rootFile = VCSFileProxy.createFileProxy(srcRootFo);
            if (rootFile == null) continue;
            if (!srcRootFo.isValid()) {
                LOG.log(Level.WARNING, "addProjectFiles: invalid source root {0}", srcRootFo);
                continue;
            }
            rootFiles.add(rootFile);
            FileObject[] rootChildren = srcRootFo.getChildren();
            for (int i = 0; i < rootChildren.length; ++i) {
                FileObject rootChildFo = rootChildren[i];
                VCSFileProxy child = VCSFileProxy.createFileProxy(rootChildFo);
                try {
                    if (!srcRootFo.isValid()) {
                        LOG.log(Level.WARNING, "addProjectFiles: source root {0} changed from valid to invalid", srcRootFo);
                        continue block2;
                    }
                    if (rootChildFo == null || !rootChildFo.isValid() || sourceGroup.contains(rootChildFo) || (rootChildFo = (child = child.normalizeFile()).toFileObject()) == null || SharabilityQuery.getSharability((FileObject)rootChildFo) == SharabilityQuery.Sharability.NOT_SHARABLE) continue;
                    rootFilesExclusions.put(rootChildFo, child);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    Logger logger = LOG;
                    logger.log(Level.WARNING, "addProjectFiles: IAE");
                    logger.log(Level.WARNING, "rootFO: {0}", srcRootFo);
                    if (srcRootFo != sourceGroup.getRootFolder()) {
                        logger.log(Level.WARNING, "root FO has changed");
                    }
                    String children = "[";
                    for (FileObject fo : rootChildren) {
                        children = children + "\"" + fo.getPath() + "\", ";
                    }
                    children = children + "]";
                    logger.log(Level.WARNING, "srcRootFo.getChildren(): {0}", children);
                    if (rootChildFo != null) {
                        if (!rootChildFo.isValid()) {
                            logger.log(Level.WARNING, "{0} does not exist ", rootChildFo);
                        }
                        if (!FileUtil.isParentOf((FileObject)srcRootFo, (FileObject)rootChildFo)) {
                            logger.log(Level.WARNING, "{0} is not under {1}", new Object[]{rootChildFo, srcRootFo});
                        }
                    }
                    logger.log(Level.WARNING, null, ex);
                }
            }
        }
    }

    private static void removeContainedExclusions(Map<FileObject, VCSFileProxy> rootFilesExclusions, Set<SourceGroup> sourceGroups) {
        for (SourceGroup sourceGroup : sourceGroups) {
            Iterator<Map.Entry<FileObject, VCSFileProxy>> it = rootFilesExclusions.entrySet().iterator();
            while (it.hasNext()) {
                FileObject exclusion = it.next().getKey();
                if (!sourceGroup.contains(exclusion)) continue;
                it.remove();
            }
        }
    }

    private static void addFileObjects(Node node, Set<VCSFileProxy> rootFiles) {
        Collection folders = node.getLookup().lookup(new Lookup.Template(NonRecursiveFolder.class)).allInstances();
        ArrayList<VCSFileProxy> nodeFiles = new ArrayList<VCSFileProxy>();
        if (folders.size() > 0) {
            for (NonRecursiveFolder nonRecursiveFolder : folders) {
                VCSFileProxy proxy = Utils.createFlatFileProxy(nonRecursiveFolder.getFolder());
                if (proxy != null) {
                    nodeFiles.add(proxy);
                    continue;
                }
                LOG.log(Level.WARNING, "null VCSFileProxy for non recursive folder FileObject {0}", nonRecursiveFolder.getFolder());
            }
        } else {
            Collection fileObjects = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (fileObjects.size() > 0) {
                nodeFiles.addAll(VCSContext.toFileCollection(fileObjects));
            } else {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (dataObject != null) {
                    Collection<VCSFileProxy> doFiles = VCSContext.toFileCollection(dataObject.files());
                    nodeFiles.addAll(doFiles);
                }
            }
        }
        rootFiles.addAll(nodeFiles);
    }

    private static Collection<VCSFileProxy> toFileCollection(Collection<? extends FileObject> fileObjects) {
        HashSet<VCSFileProxy> files = new HashSet<VCSFileProxy>(fileObjects.size() * 4 / 3 + 1);
        for (FileObject fileObject : fileObjects) {
            VCSFileProxy proxy = VCSFileProxy.createFileProxy(fileObject);
            if (proxy != null) {
                files.add(proxy);
                continue;
            }
            LOG.log(Level.WARNING, "null VCSFileProxy for FileObject {0}", fileObject);
        }
        files.remove(null);
        return files;
    }

    private VCSContext(Set<VCSFileProxy> rootFiles, Collection<VCSFileProxy> exclusions, Object ... elements) {
        HashSet<VCSFileProxy> tempRootFiles = new HashSet<VCSFileProxy>(rootFiles);
        HashSet<VCSFileProxy> tempExclusions = new HashSet<VCSFileProxy>(exclusions);
        this.unfilteredRootFiles = Collections.unmodifiableSet(new HashSet<VCSFileProxy>(tempRootFiles));
        tempExclusions.removeAll(tempRootFiles);
        while (this.normalize(tempRootFiles, tempExclusions)) {
        }
        tempRootFiles.remove(null);
        tempExclusions.remove(null);
        this.rootFiles = Collections.unmodifiableSet(tempRootFiles);
        this.exclusions = Collections.unmodifiableSet(tempExclusions);
        this.elements = Lookups.fixed((Object[])elements);
    }

    private VCSContext(Node[] nodes, Set<VCSFileProxy> rootFiles, Collection<VCSFileProxy> exclusions) {
        this(rootFiles, exclusions, nodes != null ? (Object[])nodes : new Node[]{});
    }

    private VCSContext(Set<? extends FileObject> elements, Set<VCSFileProxy> rootFiles, Collection<VCSFileProxy> exclusions) {
        this(rootFiles, exclusions, elements != null ? elements : Collections.EMPTY_SET);
    }

    private boolean normalize(Set<VCSFileProxy> rootFiles, Set<VCSFileProxy> exclusions) {
        for (VCSFileProxy root : rootFiles) {
            Iterator<VCSFileProxy> j = exclusions.iterator();
            while (j.hasNext()) {
                VCSFileProxy exclusion = j.next();
                if (!Utils.isAncestorOrEqual(exclusion, root)) continue;
                j.remove();
                this.exclusionRemoved(exclusions, exclusion, root);
                return true;
            }
        }
        this.removeDuplicates(rootFiles);
        this.removeDuplicates(exclusions);
        return false;
    }

    private void exclusionRemoved(Set<VCSFileProxy> exclusions, VCSFileProxy exclusion, VCSFileProxy root) {
        VCSFileProxy[] exclusionChildren = exclusion.listFiles();
        if (exclusionChildren == null) {
            return;
        }
        for (int i = 0; i < exclusionChildren.length; ++i) {
            VCSFileProxy child = exclusionChildren[i];
            if (child == null || Utils.isAncestorOrEqual(root, child)) continue;
            exclusions.add(child);
        }
    }

    private static Set<VCSFileProxy> substract(Set<VCSFileProxy> roots, Set<VCSFileProxy> exclusions, FileFilter filter) {
        HashSet<VCSFileProxy> files = new HashSet<VCSFileProxy>(roots);
        HashSet<VCSFileProxy> checkedFiles = new HashSet<VCSFileProxy>();
        for (VCSFileProxy exclusion : exclusions) {
            assert (exclusion != null);
            if (exclusion == null) continue;
            do {
                VCSFileProxy parent = exclusion.getParentFile();
                if (!checkedFiles.contains(exclusion.getParentFile())) {
                    VCSContext.addSiblings(files, exclusion, filter);
                    checkedFiles.add(parent);
                }
                exclusion = parent;
                files.remove(exclusion);
            } while (!roots.contains(exclusion));
        }
        files.removeAll(exclusions);
        return files;
    }

    private static void addSiblings(Set<VCSFileProxy> files, VCSFileProxy exclusion, FileFilter filter) {
        if (exclusion.getParentFile() == null) {
            return;
        }
        VCSFileProxy[] siblings = exclusion.getParentFile().listFiles();
        if (siblings != null) {
            for (VCSFileProxy sibling : siblings) {
                if (!filter.accept(sibling)) continue;
                files.add(sibling);
            }
        } else {
            LOG.log(Level.WARNING, "no children found for {0}", exclusion.getParentFile());
        }
        files.remove(exclusion);
    }

    private static Set<VCSFileProxy> emptySet() {
        return Collections.emptySet();
    }

    private void removeDuplicates(Set<VCSFileProxy> files) {
        ArrayList<VCSFileProxy> newFiles = new ArrayList<VCSFileProxy>();
        block0: for (VCSFileProxy file : files) {
            Iterator j = newFiles.iterator();
            while (j.hasNext()) {
                VCSFileProxy includedFile = (VCSFileProxy)j.next();
                if (Utils.isAncestorOrEqual(includedFile, file) && (file.isFile() || !APIAccessor.IMPL.isFlat(includedFile))) continue block0;
                if (!Utils.isAncestorOrEqual(file, includedFile) || !includedFile.isFile() && APIAccessor.IMPL.isFlat(file)) continue;
                j.remove();
            }
            newFiles.add(file);
        }
        files.clear();
        files.addAll(newFiles);
    }

    static {
        SPIAccessor.IMPL = new SPIAccessorImpl();
    }

    public static interface FileFilter {
        public boolean accept(VCSFileProxy var1);
    }
}

