/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.update.RevertModifications;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RevertModificationsAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/subversion/resources/icons/get_clean.png";

    public RevertModificationsAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Revert";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 89592;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 89592;
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        SVNUrl url;
        SVNUrl rootUrl;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        final Context ctx = this.getContext(nodes);
        File[] roots = ctx.getRootFiles();
        ArrayList<File> l = new ArrayList<File>();
        for (File file : roots) {
            if (!SvnUtils.isManaged(file)) continue;
            l.add(file);
        }
        roots = l.toArray(new File[l.size()]);
        if (roots == null || roots.length == 0) {
            return;
        }
        File interestingFile = roots.length == 1 ? roots[0] : SvnUtils.getPrimaryFile(roots[0]);
        try {
            rootUrl = SvnUtils.getRepositoryRootUrl(interestingFile);
            url = SvnUtils.getRepositoryUrl(interestingFile);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(rootUrl, url, SVNRevision.HEAD);
        final RevertModifications revertModifications = new RevertModifications(repositoryFile);
        if (!revertModifications.showDialog()) {
            return;
        }
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes, ctx){

            @Override
            public void perform() {
                RevertModificationsAction.performRevert(revertModifications.getRevisionInterval(), revertModifications.revertNewFiles(), !revertModifications.revertRecursively(), ctx, this);
            }
        };
        support.start(this.createRequestProcessor(ctx));
    }

    public static void performRevert(final RevertModifications.RevisionInterval revisions, boolean revertNewFiles, final boolean onlySelectedFiles, final Context ctx, final SvnProgressSupport support) {
        SvnClient client;
        try {
            client = Subversion.getInstance().getClient(ctx, support);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        File[] files = ctx.getFiles();
        final File[][] split = onlySelectedFiles ? new File[2][0] : Utils.splitFlatOthers((File[])files);
        try {
            SvnUtils.runWithoutIndexing(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (int c = 0; c < split.length; ++c) {
                        boolean recursive;
                        if (support.isCanceled()) {
                            return null;
                        }
                        File[] files = split[c];
                        boolean bl = recursive = c == 1;
                        if (!recursive && revisions == null) {
                            files = onlySelectedFiles ? ctx.getFiles() : SvnUtils.flatten(files, 88528);
                        }
                        try {
                            if (revisions != null) {
                                for (int i = 0; i < files.length; ++i) {
                                    if (support.isCanceled()) {
                                        return null;
                                    }
                                    SVNUrl url = SvnUtils.getRepositoryUrl(files[i]);
                                    RevertModifications.RevisionInterval targetInterval = RevertModificationsAction.recountStartRevision(client, url, revisions);
                                    if (files[i].exists()) {
                                        client.merge(url, targetInterval.endRevision, url, targetInterval.startRevision, files[i], false, recursive);
                                        continue;
                                    }
                                    assert (targetInterval.startRevision instanceof SVNRevision.Number) : "The revision has to be a Number when trying to undelete file!";
                                    client.copy(url, files[i], targetInterval.startRevision);
                                }
                                continue;
                            }
                            if (support.isCanceled()) {
                                return null;
                            }
                            if (files.length <= 0) continue;
                            HashSet deletedFiles = new HashSet();
                            for (File file : files) {
                                deletedFiles.addAll(RevertModificationsAction.getDeletedParents(file));
                            }
                            this.handleCopiedFiles(client, files, recursive);
                            for (File file : files) {
                                client.revert(file, recursive);
                            }
                            if (deletedFiles.size() <= 0) continue;
                            for (File file : deletedFiles) {
                                client.revert(file, false);
                            }
                            continue;
                        }
                        catch (SVNClientException ex) {
                            support.annotate(ex);
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                private void handleCopiedFiles(SvnClient client2, File[] files, boolean recursively) {
                    FileStatusCache cache = Subversion.getInstance().getStatusCache();
                    if (recursively) {
                        files = cache.listFiles(files, 4096);
                    }
                    for (File f : files) {
                        ISVNStatus entry;
                        FileInformation fi = cache.getStatus(f);
                        if (fi.getStatus() != 4096 || (entry = fi.getEntry(f)) == null || !entry.isCopied()) continue;
                        File temporary = FileUtils.generateTemporaryFile((File)f.getParentFile(), (String)f.getName());
                        if (f.renameTo(temporary)) {
                            client2.remove(new File[]{f}, true);
                        } else {
                            Subversion.LOG.log(Level.WARNING, "RevertModifications.handleCopiedFiles: cannot rename {0} to {1}", new Object[]{f, temporary});
                        }
                        if (!temporary.exists()) continue;
                        try {
                            if (temporary.renameTo(f)) continue;
                            FileUtils.copyFile((File)temporary, (File)f);
                            continue;
                        }
                        catch (IOException ex) {
                            Subversion.LOG.log(Level.INFO, "RevertModifications.handleCopiedFiles: cannot copy {0} back to {1}", new Object[]{temporary, f});
                            continue;
                        }
                        finally {
                            temporary.delete();
                        }
                        catch (SVNClientException ex) {
                            try {
                                Subversion.LOG.log(Level.INFO, null, ex);
                                if (!temporary.exists()) continue;
                            }
                            catch (Throwable throwable) {
                                if (temporary.exists()) {
                                    try {
                                        if (!temporary.renameTo(f)) {
                                            FileUtils.copyFile((File)temporary, (File)f);
                                        }
                                    }
                                    catch (IOException ex2) {
                                        Subversion.LOG.log(Level.INFO, "RevertModifications.handleCopiedFiles: cannot copy {0} back to {1}", new Object[]{temporary, f});
                                    }
                                    finally {
                                        temporary.delete();
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                if (temporary.renameTo(f)) continue;
                                FileUtils.copyFile((File)temporary, (File)f);
                            }
                            catch (IOException ex3) {
                                Subversion.LOG.log(Level.INFO, "RevertModifications.handleCopiedFiles: cannot copy {0} back to {1}", new Object[]{temporary, f});
                            }
                            finally {
                                temporary.delete();
                            }
                        }
                    }
                }
            }, files);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, false);
        }
        if (support.isCanceled()) {
            return;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (File file : cache.listFiles(ctx, 6400)) {
            FileInformation fi;
            if (!file.isDirectory() && ((fi = cache.getCachedStatus(file)) == null || (fi.getStatus() & 0x1000) == 0)) continue;
            cache.refresh(file, null);
        }
        if (support.isCanceled()) {
            return;
        }
        if (revertNewFiles) {
            File[] newfiles;
            for (File file : newfiles = Subversion.getInstance().getStatusCache().listFiles(ctx.getRootFiles(), 4100)) {
                if (onlySelectedFiles && !ctx.getRoots().contains(file)) continue;
                FileObject fo = FileUtil.toFileObject((File)file);
                try {
                    if (fo == null) continue;
                    fo.delete();
                }
                catch (IOException ex) {
                    Subversion.LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private static List<File> getDeletedParents(File file) {
        ArrayList<File> ret = new ArrayList<File>();
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            FileInformation info = Subversion.getInstance().getStatusCache().getStatus(parent);
            if ((info.getStatus() & 0x100) == 0 && (info.getStatus() & 0x800) == 0) {
                return ret;
            }
            ret.add(parent);
        }
        return ret;
    }

    private static RevertModifications.RevisionInterval recountStartRevision(SvnClient client, SVNUrl repository, RevertModifications.RevisionInterval ret) throws SVNClientException {
        long currStartRevNum;
        SVNRevision currStartRevision = ret.startRevision;
        SVNRevision currEndRevision = ret.endRevision;
        if (currStartRevision.equals((Object)SVNRevision.HEAD)) {
            ISVNInfo info = client.getInfo(repository);
            currStartRevision = info.getRevision();
        }
        long newStartRevNum = (currStartRevNum = Long.parseLong(currStartRevision.toString())) > 0L ? currStartRevNum - 1L : currStartRevNum;
        return new RevertModifications.RevisionInterval((SVNRevision)new SVNRevision.Number(newStartRevNum), currEndRevision);
    }
}

