/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.annotations;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.annotations.UserAnnotationTag;
import org.openide.util.NbPreferences;

public final class UserAnnotations {
    private static final String PREFERENCES_PATH = "annotations";
    private static final UserAnnotations INSTANCE = new UserAnnotations(NbPreferences.forModule(UserAnnotations.class).node("annotations"), "");
    private static final String TAG_KEY = "%stag.%d.%s";
    private static final String ATTR_TYPES = "types";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_INSERT_TEMPLATE = "insertTemplate";
    private static final String ATTR_DOCUMENTATION = "documentation";
    private static final String DELIMITER = ",";
    private final Preferences preferences;
    private final String tagKeyPrefix;

    public UserAnnotations(Preferences preferences, String tagKeyPrefix) {
        assert (preferences != null);
        this.preferences = preferences;
        this.tagKeyPrefix = tagKeyPrefix;
    }

    public static UserAnnotations getGlobal() {
        return INSTANCE;
    }

    public static UserAnnotations forProject(Project project) {
        return new UserAnnotations(ProjectUtils.getPreferences((Project)project, UserAnnotations.class, (boolean)true), "annotation.");
    }

    public List<UserAnnotationTag> getAnnotations() {
        LinkedList<UserAnnotationTag> annotations = new LinkedList<UserAnnotationTag>();
        int i = 0;
        String types;
        while ((types = this.preferences.get(this.getTypesKey(i), null)) != null) {
            String name = this.preferences.get(this.getNameKey(i), null);
            String insertTemplate = this.preferences.get(this.getInsertTemplateKey(i), null);
            String documentation = this.preferences.get(this.getDocumentationKey(i), null);
            annotations.add(new UserAnnotationTag(this.unmarshallTypes(types), name, insertTemplate, documentation));
            ++i;
        }
        return annotations;
    }

    public void setAnnotations(List<UserAnnotationTag> annotations) {
        this.clearAnnotations();
        int i = 0;
        for (UserAnnotationTag annotation : annotations) {
            this.preferences.put(this.getTypesKey(i), this.marshallTypes(annotation.getTypes()));
            this.preferences.put(this.getNameKey(i), annotation.getName());
            this.preferences.put(this.getInsertTemplateKey(i), annotation.getInsertTemplate());
            this.preferences.put(this.getDocumentationKey(i), annotation.getDocumentation());
            ++i;
        }
    }

    void clearAnnotations() {
        int i = 0;
        String type;
        while ((type = this.preferences.get(this.getTypesKey(i), null)) != null) {
            this.preferences.remove(this.getTypesKey(i));
            this.preferences.remove(this.getNameKey(i));
            this.preferences.remove(this.getInsertTemplateKey(i));
            this.preferences.remove(this.getDocumentationKey(i));
            ++i;
        }
        return;
    }

    private String getTypesKey(int i) {
        return this.getKey(i, ATTR_TYPES);
    }

    private String getNameKey(int i) {
        return this.getKey(i, ATTR_NAME);
    }

    private String getInsertTemplateKey(int i) {
        return this.getKey(i, ATTR_INSERT_TEMPLATE);
    }

    private String getDocumentationKey(int i) {
        return this.getKey(i, ATTR_DOCUMENTATION);
    }

    private String getKey(int i, String attr) {
        return String.format(TAG_KEY, this.tagKeyPrefix, i, attr);
    }

    String marshallTypes(EnumSet<UserAnnotationTag.Type> types) {
        ArrayList<String> list = new ArrayList<String>(types.size());
        for (UserAnnotationTag.Type type : types) {
            list.add(type.name());
        }
        return StringUtils.implode(list, (String)DELIMITER);
    }

    EnumSet<UserAnnotationTag.Type> unmarshallTypes(String types) {
        List list = StringUtils.explode((String)types, (String)DELIMITER);
        EnumSet<UserAnnotationTag.Type> result = EnumSet.noneOf(UserAnnotationTag.Type.class);
        for (String type : list) {
            result.add(UserAnnotationTag.Type.valueOf(type));
        }
        return result;
    }
}

