/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api;

import org.netbeans.api.debugger.Session;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.spi.BrowserConsoleLoggerFactory;
import org.netbeans.modules.web.webkit.debugging.spi.JavaScriptDebuggerFactory;
import org.netbeans.modules.web.webkit.debugging.spi.NetworkMonitorFactory;
import org.openide.util.Lookup;

public final class WebKitUIManager {
    private static final WebKitUIManager DEFAULT = new WebKitUIManager();
    private JavaScriptDebuggerFactory debuggerFactory;
    private BrowserConsoleLoggerFactory browserLoggerFactory;
    private NetworkMonitorFactory networkMonitorFactory;

    private WebKitUIManager() {
    }

    public static WebKitUIManager getDefault() {
        return DEFAULT;
    }

    private synchronized JavaScriptDebuggerFactory getDebuggerFactory() {
        if (this.debuggerFactory == null) {
            this.debuggerFactory = (JavaScriptDebuggerFactory)Lookup.getDefault().lookup(JavaScriptDebuggerFactory.class);
        }
        return this.debuggerFactory;
    }

    public Session createDebuggingSession(WebKitDebugging webkit, Lookup projectContext) {
        JavaScriptDebuggerFactory fact = this.getDebuggerFactory();
        if (fact == null) {
            return null;
        }
        return fact.createDebuggingSession(webkit, projectContext);
    }

    public void stopDebuggingSession(Session session) {
        JavaScriptDebuggerFactory fact = this.getDebuggerFactory();
        if (fact == null) {
            return;
        }
        fact.stopDebuggingSession(session);
    }

    private synchronized BrowserConsoleLoggerFactory getBrowserLoggerFactory() {
        if (this.browserLoggerFactory == null) {
            this.browserLoggerFactory = (BrowserConsoleLoggerFactory)Lookup.getDefault().lookup(BrowserConsoleLoggerFactory.class);
        }
        return this.browserLoggerFactory;
    }

    public Lookup createBrowserConsoleLogger(WebKitDebugging webkit, Lookup projectContext) {
        BrowserConsoleLoggerFactory fact = this.getBrowserLoggerFactory();
        if (fact == null) {
            return null;
        }
        return fact.createBrowserConsoleLogger(webkit, projectContext);
    }

    public void stopBrowserConsoleLogger(Lookup session) {
        BrowserConsoleLoggerFactory fact = this.getBrowserLoggerFactory();
        if (fact == null) {
            return;
        }
        fact.stopBrowserConsoleLogger(session);
    }

    private synchronized NetworkMonitorFactory getNetworkMonitorFactory() {
        if (this.networkMonitorFactory == null) {
            this.networkMonitorFactory = (NetworkMonitorFactory)Lookup.getDefault().lookup(NetworkMonitorFactory.class);
        }
        return this.networkMonitorFactory;
    }

    public Lookup createNetworkMonitor(WebKitDebugging webkit, Lookup projectContext) {
        NetworkMonitorFactory fact = this.getNetworkMonitorFactory();
        if (fact == null) {
            return null;
        }
        return fact.createNetworkMonitor(webkit, projectContext);
    }

    public void stopNetworkMonitor(Lookup session) {
        NetworkMonitorFactory fact = this.getNetworkMonitorFactory();
        if (fact == null) {
            return;
        }
        fact.stopNetworkMonitor(session);
    }
}

