/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.i18n.I18nPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.netbeans.modules.i18n.form.FormI18nInteger;
import org.netbeans.modules.i18n.form.FormI18nSupport;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormI18nIntegerEditor
extends PropertyEditorSupport
implements FormAwareEditor,
NamedPropertyEditor,
ExPropertyEditor,
XMLPropertyEditor {
    private FormI18nInteger formI18nInteger;
    private FormDataObject sourceDataObject;
    private PropertyEnv env;
    public static final String XML_RESOURCESTRING = "ResourceString";
    public static final String XML_ARGUMENT = "Argument";
    public static final String ATTR_BUNDLE = "bundle";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_IDENTIFIER = "identifier";
    public static final String ATTR_REPLACE_FORMAT = "replaceFormat";
    public static final String ATTR_INDEX = "index";
    public static final String ATTR_JAVACODE = "javacode";
    private static final int MAX_INDEX = 1000;
    private final ResourceBundle bundle = NbBundle.getBundle(FormI18nIntegerEditor.class);

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void setAsText(String text) {
    }

    @Override
    public String getAsText() {
        FormI18nInteger value = (FormI18nInteger)((Object)this.getValue());
        DataObject dataObject = value.getSupport().getResourceHolder().getResource();
        if (dataObject == null || value.getKey() == null) {
            return this.bundle.getString("TXT_InvalidValue");
        }
        String resourceName = Util.getResourceName((FileObject)value.getSupport().getSourceDataObject().getPrimaryFile(), (FileObject)dataObject.getPrimaryFile(), (char)'/', (boolean)false);
        return MessageFormat.format(this.bundle.getString("TXT_Key"), value.getKey(), resourceName);
    }

    @Override
    public String getJavaInitializationString() {
        return ((FormI18nInteger)((Object)this.getValue())).getReplaceString();
    }

    @Override
    public Component getCustomEditor() {
        return new CustomEditor((I18nString)new FormI18nInteger((FormI18nInteger)((Object)this.getValue())), this.getProject(), this.sourceDataObject.getPrimaryFile());
    }

    private Project getProject() {
        return Util.getProjectFor((DataObject)this.sourceDataObject);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Object getValue() {
        if (this.formI18nInteger == null) {
            this.formI18nInteger = this.createFormI18nInteger();
            if (I18nUtil.getOptions().getLastResource2((DataObject)this.sourceDataObject) != null) {
                this.formI18nInteger.getSupport().getResourceHolder().setResource(I18nUtil.getOptions().getLastResource2((DataObject)this.sourceDataObject));
            }
        }
        return this.formI18nInteger;
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof FormI18nInteger) {
            this.formI18nInteger = (FormI18nInteger)((Object)object);
        } else {
            this.formI18nInteger = this.createFormI18nInteger();
            if (I18nUtil.getOptions().getLastResource2((DataObject)this.sourceDataObject) != null) {
                this.formI18nInteger.getSupport().getResourceHolder().setResource(I18nUtil.getOptions().getLastResource2((DataObject)this.sourceDataObject));
            }
        }
    }

    private FormI18nInteger createFormI18nInteger() {
        return new FormI18nInteger(new FormI18nSupport.Factory().createI18nSupport((DataObject)this.sourceDataObject));
    }

    public void setContext(FormModel model, FormProperty property) {
        this.sourceDataObject = FormEditor.getFormEditor((FormModel)model).getFormDataObject();
    }

    public void updateFormVersionLevel() {
    }

    public String getDisplayName() {
        return NbBundle.getMessage(FormI18nIntegerEditor.class, (String)"PROP_IntegerEditor_name");
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    public void readFromXML(Node domNode) throws IOException {
        if (!XML_RESOURCESTRING.equals(domNode.getNodeName())) {
            throw new IOException();
        }
        FormI18nInteger value = this.createFormI18nInteger();
        NamedNodeMap namedNodes = domNode.getAttributes();
        try {
            FileObject fileObject;
            FileObject sourceFo;
            String key;
            Node node = namedNodes.getNamedItem(ATTR_BUNDLE);
            String bundleName = node == null ? null : node.getNodeValue();
            node = namedNodes.getNamedItem(ATTR_KEY);
            String string = key = node == null ? null : node.getNodeValue();
            if (bundleName != null && (sourceFo = this.sourceDataObject.getPrimaryFile()) != null && (fileObject = Util.getResource((FileObject)sourceFo, (String)bundleName)) != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    if (dataObject.getClass().equals(value.getSupport().getResourceHolder().getResourceClasses()[0])) {
                        value.getSupport().getResourceHolder().setResource(dataObject);
                    }
                }
                catch (IOException dataObject) {
                    // empty catch block
                }
            }
            if (key != null && key.length() > 0) {
                value.setKey(key);
                value.setValue(value.getSupport().getResourceHolder().getValueForKey(key));
                value.setComment(value.getSupport().getResourceHolder().getCommentForKey(key));
            }
            ((JavaI18nSupport)value.getSupport()).createIdentifier();
            node = namedNodes.getNamedItem(ATTR_IDENTIFIER);
            if (node != null) {
                String identifier;
                String string2 = identifier = node == null ? null : node.getNodeValue();
                if (identifier != null) {
                    ((JavaI18nSupport)value.getSupport()).setIdentifier(identifier);
                }
            }
            if ((node = namedNodes.getNamedItem(ATTR_REPLACE_FORMAT)) != null) {
                String replaceFormat = node.getNodeValue();
                if (replaceFormat != null && replaceFormat.length() > 0) {
                    HashMap<String, String> map = new HashMap<String, String>(6);
                    map.put("0", "{identifier}");
                    map.put("1", "{key}");
                    map.put("2", "{bundleNameSlashes}");
                    map.put("3", "{bundleNameDots}");
                    map.put("4", "{sourceFileName}");
                    map.put("fileName", "{sourceFileName}");
                    String newReplaceFormat = MapFormat.format((String)replaceFormat, map);
                    value.setReplaceFormat(newReplaceFormat);
                }
            } else {
                value.setReplaceFormat(I18nUtil.getDefaultReplaceFormat((boolean)false));
            }
        }
        catch (NullPointerException npe) {
            throw new IOException();
        }
        if (domNode instanceof Element) {
            int i;
            Element domElement = (Element)domNode;
            NodeList argNodeList = domElement.getElementsByTagName(XML_ARGUMENT);
            int highest = -1;
            for (int i2 = 0; i2 < argNodeList.getLength(); ++i2) {
                String indexString;
                NamedNodeMap attributes = argNodeList.item(i2).getAttributes();
                Node indexNode = attributes.getNamedItem(ATTR_INDEX);
                String string = indexString = indexNode == null ? null : indexNode.getNodeValue();
                if (indexString == null) continue;
                try {
                    int index = Integer.parseInt(indexString);
                    if (index <= highest || index >= 1000) continue;
                    highest = index;
                    continue;
                }
                catch (Exception index) {
                    // empty catch block
                }
            }
            String[] parameters = new String[highest + 1];
            for (i = 0; i < argNodeList.getLength(); ++i) {
                String indexString;
                NamedNodeMap attr = argNodeList.item(i).getAttributes();
                Node indexNode = attr.getNamedItem(ATTR_INDEX);
                String string = indexString = indexNode == null ? null : indexNode.getNodeValue();
                if (indexString == null) continue;
                try {
                    String javaCode;
                    int index = Integer.parseInt(indexString);
                    if (index >= 1000) continue;
                    Node javaCodeNode = attr.getNamedItem(ATTR_JAVACODE);
                    parameters[index] = javaCode = javaCodeNode == null ? null : javaCodeNode.getNodeValue();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (i = 0; i < parameters.length; ++i) {
                if (parameters[i] != null) continue;
                parameters[i] = "";
            }
            value.setArguments(parameters);
        }
        this.setValue((Object)value);
    }

    public Node storeToXML(Document doc) {
        String bundleName;
        Element element = doc.createElement(XML_RESOURCESTRING);
        if (this.formI18nInteger.getSupport().getResourceHolder().getResource() == null) {
            bundleName = "";
        } else {
            bundleName = Util.getResourceName((FileObject)this.formI18nInteger.getSupport().getSourceDataObject().getPrimaryFile(), (FileObject)this.formI18nInteger.getSupport().getResourceHolder().getResource().getPrimaryFile(), (char)'/', (boolean)true);
            if (bundleName == null) {
                bundleName = "";
            }
        }
        element.setAttribute(ATTR_BUNDLE, bundleName);
        element.setAttribute(ATTR_KEY, this.formI18nInteger.getKey() == null ? "" : this.formI18nInteger.getKey());
        JavaI18nSupport support = (JavaI18nSupport)this.formI18nInteger.getSupport();
        if (support.getIdentifier() == null) {
            support.createIdentifier();
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(ATTR_IDENTIFIER, support.getIdentifier());
        element.setAttribute(ATTR_REPLACE_FORMAT, this.formI18nInteger.getReplaceFormat() == null ? "" : MapFormat.format((String)this.formI18nInteger.getReplaceFormat(), map));
        String[] arguments = this.formI18nInteger.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            Element childElement = doc.createElement(XML_ARGUMENT);
            childElement.setAttribute(ATTR_INDEX, "" + i);
            childElement.setAttribute(ATTR_JAVACODE, arguments[i]);
            try {
                element.appendChild(childElement);
                continue;
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return element;
    }

    private static boolean isNonNegativeInteger(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        char ch = value.charAt(0);
        if (ch < '0' || ch > '9') {
            return false;
        }
        if (value.length() == 1) {
            return true;
        }
        for (char c : value.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private class CustomEditor
    extends I18nPanel
    implements VetoableChangeListener {
        private final ResourceBundle bundle;

        public CustomEditor(I18nString i18nString, Project project, FileObject file) {
            super(i18nString.getSupport().getPropertyPanel(), false, project, file);
            this.bundle = NbBundle.getBundle(FormI18nIntegerEditor.class);
            this.setI18nString(i18nString);
            FormI18nIntegerEditor.this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            FormI18nIntegerEditor.this.env.addVetoableChangeListener((VetoableChangeListener)this);
            HelpCtx.setHelpIDString((JComponent)((Object)this), (String)"internation.formed");
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if ("state".equals(evt.getPropertyName()) && this.isVisible()) {
                String errMsgKey = null;
                I18nString i18nString = this.getI18nString();
                errMsgKey = i18nString == null || !(i18nString instanceof FormI18nInteger) ? "MSG_InvalidValue" : (i18nString.getSupport().getResourceHolder().getResource() == null ? "MSG_BundleNotSpecified" : (i18nString.getKey() == null ? "MSG_KeyNotSpecified" : this.checkMnemonicIndex(i18nString.getValue())));
                if (errMsgKey != null) {
                    throw new PropertyVetoException(this.bundle.getString(errMsgKey), evt);
                }
                i18nString.getSupport().getResourceHolder().addProperty((Object)i18nString.getKey(), (Object)i18nString.getValue(), i18nString.getComment(), false);
                FormI18nIntegerEditor.this.setValue(i18nString);
            }
        }

        private String checkMnemonicIndex(String value) {
            if (value == null || value.length() == 0) {
                return "MSG_MnemonicIndexNotSpecified";
            }
            if (!FormI18nIntegerEditor.isNonNegativeInteger(value)) {
                return "MSG_MnemonicIndexIsInvalid";
            }
            return null;
        }
    }
}

