/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.spring.beans.refactoring.Modifications;
import org.netbeans.modules.spring.beans.refactoring.Occurrences;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SpringRefactoringElement
extends SimpleRefactoringElementImplementation {
    private final Occurrences.Occurrence occurrence;

    public static SpringRefactoringElement create(Occurrences.Occurrence occurrence) {
        return new SpringRefactoringElement(occurrence);
    }

    public static SpringRefactoringElement createJavaElementRefModification(Occurrences.Occurrence occurrence, Modifications mods, String oldSimpleName, String newBinaryName) {
        return new JavaElementRefModification(occurrence, mods, oldSimpleName, newBinaryName);
    }

    public static SpringRefactoringElement createPropertyRefModification(Occurrences.Occurrence occurrence, Modifications mods, String oldName, String newName) {
        return new PropertyRefModification(occurrence, mods, oldName, newName);
    }

    private SpringRefactoringElement(Occurrences.Occurrence occurrence) {
        this.occurrence = occurrence;
    }

    public String getText() {
        return this.getDisplayText();
    }

    public String getDisplayText() {
        return this.occurrence.getDisplayText();
    }

    public void performChange() {
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public FileObject getParentFile() {
        return this.occurrence.getFileObject();
    }

    public PositionBounds getPosition() {
        return this.occurrence.getPosition();
    }

    protected String getNewFileContent() {
        return null;
    }

    private static class PropertyRefModification
    extends SpringRefactoringElement {
        protected final Modifications mods;
        private final Modifications.Difference diff;
        private final String oldSimpleName;
        private WeakReference<String> newFileContent;

        public PropertyRefModification(Occurrences.Occurrence occurrence, Modifications mods, String oldSimpleName, String newBinaryName) {
            super(occurrence);
            this.mods = mods;
            this.oldSimpleName = oldSimpleName;
            this.diff = new Modifications.Difference(Modifications.Difference.Kind.CHANGE, occurrence.getPosition(), newBinaryName);
            mods.addDifference(occurrence.getFileObject(), this.diff);
        }

        @Override
        public String getDisplayText() {
            if (this.oldSimpleName != null) {
                return NbBundle.getMessage(JavaElementRefModification.class, (String)"MSG_UpdateReference", (Object)this.oldSimpleName);
            }
            return NbBundle.getMessage(JavaElementRefModification.class, (String)"MSG_Update");
        }

        public void setEnabled(boolean enabled) {
            this.diff.setExcluded(!enabled);
            this.newFileContent = null;
            super.setEnabled(enabled);
        }

        @Override
        protected String getNewFileContent() {
            String content;
            if (this.newFileContent != null && (content = (String)this.newFileContent.get()) != null) {
                return content;
            }
            try {
                content = this.mods.getResultingSource(this.getParentFile());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            this.newFileContent = new WeakReference<String>(content);
            return content;
        }
    }

    private static class JavaElementRefModification
    extends SpringRefactoringElement {
        protected final Modifications mods;
        private final Modifications.Difference diff;
        private final String oldSimpleName;
        private WeakReference<String> newFileContent;

        public JavaElementRefModification(Occurrences.Occurrence occurrence, Modifications mods, String oldSimpleName, String newBinaryName) {
            super(occurrence);
            this.mods = mods;
            this.oldSimpleName = oldSimpleName;
            this.diff = new Modifications.Difference(Modifications.Difference.Kind.CHANGE, occurrence.getPosition(), newBinaryName);
            mods.addDifference(occurrence.getFileObject(), this.diff);
        }

        @Override
        public String getDisplayText() {
            if (this.oldSimpleName != null) {
                return NbBundle.getMessage(JavaElementRefModification.class, (String)"MSG_UpdateReference", (Object)this.oldSimpleName);
            }
            return NbBundle.getMessage(JavaElementRefModification.class, (String)"MSG_Update");
        }

        public void setEnabled(boolean enabled) {
            this.diff.setExcluded(!enabled);
            this.newFileContent = null;
            super.setEnabled(enabled);
        }

        @Override
        protected String getNewFileContent() {
            String content;
            if (this.newFileContent != null && (content = (String)this.newFileContent.get()) != null) {
                return content;
            }
            try {
                content = this.mods.getResultingSource(this.getParentFile());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            this.newFileContent = new WeakReference<String>(content);
            return content;
        }
    }
}

