/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipException;
import org.netbeans.jemmy.Bundle;

public class BundleManager {
    private Hashtable bundles = new Hashtable();

    public BundleManager() {
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Bundle addBundle(Bundle bundle, String ID) {
        if (this.getBundle(ID) != null) {
            return null;
        }
        this.bundles.put(ID, bundle);
        return bundle;
    }

    public Bundle removeBundle(String ID) {
        Bundle value = this.getBundle(ID);
        this.bundles.remove(ID);
        return value;
    }

    public Bundle getBundle(String ID) {
        return (Bundle)this.bundles.get(ID);
    }

    public Bundle loadBundleFromFile(String fileName, String ID) throws IOException, FileNotFoundException {
        if (this.getBundle(ID) != null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.loadFromFile(fileName);
        return this.addBundle(bundle, ID);
    }

    public Bundle loadBundleFromStream(InputStream stream, String ID) throws IOException, FileNotFoundException {
        if (this.getBundle(ID) != null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.load(stream);
        return this.addBundle(bundle, ID);
    }

    public Bundle loadBundleFromResource(ClassLoader cl, String resource, String ID) throws IOException, FileNotFoundException {
        return this.loadBundleFromStream(cl.getResourceAsStream(resource), ID);
    }

    public Bundle load() throws IOException, FileNotFoundException {
        if (System.getProperty("jemmy.resources") != null && !System.getProperty("jemmy.resources").equals("")) {
            return this.loadBundleFromFile(System.getProperty("jemmy.resources"), "");
        }
        return null;
    }

    public Bundle loadBundleFromJar(String fileName, String entryName, String ID) throws IOException, FileNotFoundException {
        if (this.getBundle(ID) != null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.loadFromJar(fileName, entryName);
        return this.addBundle(bundle, ID);
    }

    public Bundle loadBundleFromZip(String fileName, String entryName, String ID) throws IOException, FileNotFoundException, ZipException {
        if (this.getBundle(ID) != null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.loadFromZip(fileName, entryName);
        return this.addBundle(bundle, ID);
    }

    public void print(PrintWriter writer) {
        Enumeration keys = this.bundles.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            writer.println("\"" + key + "\" bundle contents");
            Bundle bundle = this.getBundle(key);
            bundle.print(writer);
        }
    }

    public void print(PrintStream stream) {
        this.print(new PrintWriter(stream));
    }

    public String getResource(String bundleID, String key) {
        Bundle bundle = this.getBundle(bundleID);
        if (bundle != null) {
            return bundle.getResource(key);
        }
        return null;
    }

    public String getResource(String key) {
        Enumeration data = this.bundles.elements();
        while (data.hasMoreElements()) {
            String value = ((Bundle)data.nextElement()).getResource(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public int calculateResources(String key) {
        Enumeration data = this.bundles.elements();
        int count = 0;
        while (data.hasMoreElements()) {
            if (((Bundle)data.nextElement()).getResource(key) == null) continue;
            ++count;
        }
        return count;
    }

    public BundleManager cloneThis() {
        BundleManager result = new BundleManager();
        Enumeration keys = this.bundles.keys();
        Enumeration elements = this.bundles.elements();
        while (keys.hasMoreElements()) {
            result.bundles.put(keys.nextElement(), elements.nextElement());
        }
        return result;
    }
}

