/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.javadoc.ClassDoc;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javadoc.main.AnnotationTypeDocImpl;
import com.sun.tools.javadoc.main.AnnotationTypeElementDocImpl;
import com.sun.tools.javadoc.main.ClassDocImpl;
import com.sun.tools.javadoc.main.ConstructorDocImpl;
import com.sun.tools.javadoc.main.DocEnv;
import com.sun.tools.javadoc.main.ExecutableMemberDocImpl;
import com.sun.tools.javadoc.main.FieldDocImpl;
import com.sun.tools.javadoc.main.MethodDocImpl;
import com.sun.tools.javadoc.main.ModifierFilter;
import com.sun.tools.javadoc.main.PackageDocImpl;
import com.sun.tools.javadoc.main.ProgramElementDocImpl;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JavadocEnv
extends DocEnv {
    private ClasspathInfo cpInfo;
    private Context ctx;

    public static void preRegister(Context context, final ClasspathInfo cpInfo) {
        context.put(docEnvKey, new Context.Factory<DocEnv>(){

            @Override
            public DocEnv make(Context c) {
                return new JavadocEnv(c, cpInfo);
            }
        });
    }

    private JavadocEnv(Context context, ClasspathInfo cpInfo) {
        super(context);
        this.ctx = context;
        this.cpInfo = cpInfo;
        this.showAccess = new ModifierFilter(-9223372036854775801L);
        this.legacyDoclet = false;
    }

    public ClassDocImpl getClassDoc(Symbol.ClassSymbol clazz) {
        if (clazz.type.hasTag(TypeTag.UNKNOWN)) {
            return null;
        }
        Object result = (ClassDocImpl)this.classMap.get(clazz);
        if (result != null) {
            return result;
        }
        result = JavadocEnv.isAnnotationType((Symbol.ClassSymbol)clazz) ? new JavadocAnnotation((DocEnv)this, clazz) : new JavadocClass((DocEnv)this, clazz);
        this.classMap.put(clazz, result);
        return result;
    }

    protected void makeClassDoc(Symbol.ClassSymbol clazz, TreePath treePath) {
        if (clazz.type.hasTag(TypeTag.UNKNOWN)) {
            return;
        }
        Object result = (ClassDocImpl)this.classMap.get(clazz);
        if (result != null) {
            if (treePath != null) {
                this.setTreePath((ProgramElementDocImpl)result, treePath);
            }
            return;
        }
        result = JavadocEnv.isAnnotationType((JCTree.JCClassDecl)((JCTree.JCClassDecl)treePath.getLeaf())) ? new JavadocAnnotation(this, clazz, treePath) : new JavadocClass(this, clazz, treePath);
        this.classMap.put(clazz, result);
    }

    public FieldDocImpl getFieldDoc(Symbol.VarSymbol var) {
        FieldDocImpl result = (FieldDocImpl)this.fieldMap.get(var);
        if (result != null) {
            return result;
        }
        result = new JavadocField((DocEnv)this, var);
        this.fieldMap.put(var, result);
        return result;
    }

    protected void makeFieldDoc(Symbol.VarSymbol var, TreePath treePath) {
        FieldDocImpl result = (FieldDocImpl)this.fieldMap.get(var);
        if (result != null) {
            if (treePath != null) {
                this.setTreePath((ProgramElementDocImpl)result, treePath);
            }
        } else {
            result = new JavadocField(this, var, treePath);
            this.fieldMap.put(var, result);
        }
    }

    public MethodDocImpl getMethodDoc(Symbol.MethodSymbol meth) {
        ExecutableMemberDocImpl docImpl = (ExecutableMemberDocImpl)this.methodMap.get(meth);
        if (docImpl != null && !docImpl.isMethod()) {
            return null;
        }
        MethodDocImpl result = (MethodDocImpl)docImpl;
        if (result != null) {
            return result;
        }
        result = new JavadocMethod((DocEnv)this, meth);
        this.methodMap.put(meth, result);
        return result;
    }

    protected void makeMethodDoc(Symbol.MethodSymbol meth, TreePath treePath) {
        MethodDocImpl result = (MethodDocImpl)this.methodMap.get(meth);
        if (result != null) {
            if (treePath != null) {
                this.setTreePath((ProgramElementDocImpl)result, treePath);
            }
        } else {
            result = new JavadocMethod(this, meth, treePath);
            this.methodMap.put(meth, result);
        }
    }

    public ConstructorDocImpl getConstructorDoc(Symbol.MethodSymbol meth) {
        ExecutableMemberDocImpl docImpl = (ExecutableMemberDocImpl)this.methodMap.get(meth);
        if (docImpl != null && !docImpl.isConstructor()) {
            return null;
        }
        ConstructorDocImpl result = (ConstructorDocImpl)docImpl;
        if (result != null) {
            return result;
        }
        result = new JavadocConstructor((DocEnv)this, meth);
        this.methodMap.put(meth, result);
        return result;
    }

    protected void makeConstructorDoc(Symbol.MethodSymbol meth, TreePath treePath) {
        ConstructorDocImpl result = (ConstructorDocImpl)this.methodMap.get(meth);
        if (result != null) {
            if (treePath != null) {
                this.setTreePath((ProgramElementDocImpl)result, treePath);
            }
        } else {
            result = new JavadocConstructor(this, meth, treePath);
            this.methodMap.put(meth, result);
        }
    }

    public AnnotationTypeElementDocImpl getAnnotationTypeElementDoc(Symbol.MethodSymbol meth) {
        ExecutableMemberDocImpl docImpl = (ExecutableMemberDocImpl)this.methodMap.get(meth);
        if (docImpl != null && !docImpl.isAnnotationTypeElement()) {
            return null;
        }
        AnnotationTypeElementDocImpl result = (AnnotationTypeElementDocImpl)docImpl;
        if (result != null) {
            return result;
        }
        result = new JavadocAnnotationTypeElement((DocEnv)this, meth);
        this.methodMap.put(meth, result);
        return result;
    }

    protected void makeAnnotationTypeElementDoc(Symbol.MethodSymbol meth, TreePath treePath) {
        AnnotationTypeElementDocImpl result = (AnnotationTypeElementDocImpl)this.methodMap.get(meth);
        if (result != null) {
            if (treePath != null) {
                this.setTreePath((ProgramElementDocImpl)result, treePath);
            }
        } else {
            result = new JavadocAnnotationTypeElement(this, meth, treePath);
            this.methodMap.put(meth, result);
        }
    }

    private void setTreePath(ProgramElementDocImpl pe, TreePath treePath) {
        try {
            Method setTreePath = ProgramElementDocImpl.class.getDeclaredMethod("setTreePath", TreePath.class);
            setTreePath.setAccessible(true);
            setTreePath.invoke((Object)pe, treePath);
        }
        catch (Throwable ex) {
            Logger.getLogger(JavadocEnv.class.getName()).log(Level.FINE, null, ex);
        }
    }

    public PackageDocImpl getPackageDoc(Symbol.PackageSymbol pack) {
        PackageDocImpl result = (PackageDocImpl)this.packageMap.get(pack);
        if (result != null) {
            return result;
        }
        result = new JavaDocPackage(this, pack, this.ctx);
        this.packageMap.put(pack, result);
        return result;
    }

    public ClassDocImpl lookupClass(String name) {
        ClassDocImpl cls = super.lookupClass(name);
        if (cls == null && name != null && !name.isEmpty()) {
            cls = this.loadClass(name);
        }
        return cls;
    }

    private String getRawCommentFor(Element element) {
        try {
            JavaSource js;
            FileObject fo = SourceUtils.getFile(element, this.cpInfo);
            if (fo != null && (js = JavaSource.forFileObject(fo)) != null) {
                final String[] ret = new String[1];
                final ElementHandle<Element> handle = ElementHandle.create(element);
                js.runUserActionTask(new Task<CompilationController>(){

                    @Override
                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Object e = handle.resolve(controller);
                        if (e != null) {
                            ret[0] = controller.getElements().getDocComment((Element)e);
                        }
                    }
                }, true);
                return ret[0] != null ? ret[0] : "";
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return "";
    }

    private class JavaDocPackage
    extends PackageDocImpl
    implements ElementHolder {
        private JavaDocPackage(DocEnv env, Symbol.PackageSymbol sym, Context ctx) {
            super(env, sym);
        }

        public ClassDoc findClass(String className) {
            Names nameTable = Names.instance(JavadocEnv.this.ctx);
            StringTokenizer st = new StringTokenizer(className, ".");
            Symbol.PackageSymbol s = this.sym;
            while (s != null && st.hasMoreTokens()) {
                Name clsName = nameTable.fromString(st.nextToken());
                Symbol.TypeSymbol ts = null;
                for (Symbol symbol : ((Symbol)s).members().getSymbolsByName(clsName)) {
                    if (symbol.kind != Kinds.Kind.TYP || (symbol.flags_field & 0x1000L) != 0L) continue;
                    ts = (Symbol.TypeSymbol)symbol;
                    break;
                }
                s = ts;
            }
            return s instanceof Symbol.ClassSymbol ? this.env.getClassDoc((Symbol.ClassSymbol)((Object)s)) : null;
        }

        @Override
        public Element getElement() {
            return this.sym;
        }
    }

    private class JavadocAnnotationTypeElement
    extends AnnotationTypeElementDocImpl
    implements ElementHolder {
        private JavadocAnnotationTypeElement(DocEnv env, Symbol.MethodSymbol sym) {
            super(env, sym);
        }

        private JavadocAnnotationTypeElement(DocEnv env, Symbol.MethodSymbol sym, TreePath treePath) {
            super(env, sym, treePath);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        @Override
        public Element getElement() {
            return this.sym;
        }
    }

    private class JavadocConstructor
    extends ConstructorDocImpl
    implements ElementHolder {
        private JavadocConstructor(DocEnv env, Symbol.MethodSymbol sym) {
            super(env, sym);
        }

        private JavadocConstructor(DocEnv env, Symbol.MethodSymbol sym, TreePath treePath) {
            super(env, sym, treePath);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        @Override
        public Element getElement() {
            return this.sym;
        }
    }

    private class JavadocMethod
    extends MethodDocImpl
    implements ElementHolder {
        private JavadocMethod(DocEnv env, Symbol.MethodSymbol sym) {
            super(env, sym);
        }

        private JavadocMethod(DocEnv env, Symbol.MethodSymbol sym, TreePath treePath) {
            super(env, sym, treePath);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        @Override
        public Element getElement() {
            return this.sym;
        }
    }

    private class JavadocField
    extends FieldDocImpl
    implements ElementHolder {
        private JavadocField(DocEnv env, Symbol.VarSymbol sym) {
            super(env, sym);
        }

        private JavadocField(DocEnv env, Symbol.VarSymbol sym, TreePath treePath) {
            super(env, sym, treePath);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        @Override
        public Element getElement() {
            return this.sym;
        }
    }

    private class JavadocAnnotation
    extends AnnotationTypeDocImpl
    implements ElementHolder {
        private JavadocAnnotation(DocEnv env, Symbol.ClassSymbol sym) {
            super(env, sym);
        }

        private JavadocAnnotation(DocEnv env, Symbol.ClassSymbol sym, TreePath treePath) {
            super(env, sym, treePath);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        @Override
        public Element getElement() {
            return this.tsym;
        }
    }

    private class JavadocClass
    extends ClassDocImpl
    implements ElementHolder {
        private JavadocClass(DocEnv env, Symbol.ClassSymbol sym) {
            super(env, sym);
        }

        private JavadocClass(DocEnv env, Symbol.ClassSymbol sym, TreePath treePath) {
            super(env, sym, treePath);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        @Override
        public Element getElement() {
            return this.tsym;
        }
    }

    public static interface ElementHolder {
        public Element getElement();
    }
}

