/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.List;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;

public final class TypeUtilities {
    private final CompilationInfo info;
    private static final Types.SimpleVisitor<Boolean, Void> denotableChecker = new Types.SimpleVisitor<Boolean, Void>(){

        @Override
        public Boolean visitType(Type t, Void s) {
            return true;
        }

        @Override
        public Boolean visitClassType(Type.ClassType t, Void s) {
            if (t.isUnion() || t.isIntersection()) {
                return false;
            }
            for (Type targ : t.allparams()) {
                if (((Boolean)this.visit(targ, s)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar t, Void s) {
            return (t.tsym.flags() & 0x1000L) == 0L;
        }

        @Override
        public Boolean visitCapturedType(Type.CapturedType t, Void s) {
            return false;
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType t, Void s) {
            return (Boolean)this.visit(t.elemtype, s);
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType t, Void s) {
            return (Boolean)this.visit(t.type, s);
        }
    };
    private static final String UNKNOWN = "<unknown>";
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";

    TypeUtilities(CompilationInfo info) {
        assert (info != null);
        this.info = info;
    }

    public boolean isCastable(TypeMirror t1, TypeMirror t2) {
        switch (t1.getKind()) {
            case EXECUTABLE: 
            case PACKAGE: 
            case NONE: 
            case OTHER: {
                throw new IllegalArgumentException();
            }
        }
        return Types.instance(this.info.impl.getJavacTask().getContext()).isCastable((Type)t1, (Type)t2);
    }

    public TypeMirror substitute(TypeMirror type, java.util.List<? extends TypeMirror> from, java.util.List<? extends TypeMirror> to) {
        if (from.size() != to.size()) {
            throw new IllegalArgumentException();
        }
        List<Type> l1 = List.nil();
        for (TypeMirror typeMirror : from) {
            l1 = l1.prepend((Type)typeMirror);
        }
        List<Type> l2 = List.nil();
        for (TypeMirror typeMirror : to) {
            l2 = l2.prepend((Type)typeMirror);
        }
        return Types.instance(this.info.impl.getJavacTask().getContext()).subst((Type)type, l1, l2);
    }

    public ExecutableType getDescriptorType(DeclaredType origin) {
        Type dt;
        Types types = Types.instance(this.info.impl.getJavacTask().getContext());
        if (types.isFunctionalInterface(((Type)((Object)origin)).tsym) && (dt = types.findDescriptorType((Type)((Object)origin))) != null && dt.getKind() == TypeKind.EXECUTABLE) {
            return (ExecutableType)((Object)dt);
        }
        return null;
    }

    @NonNull
    @CheckReturnValue
    public CharSequence getTypeName(@NullAllowed TypeMirror type, TypeNameOptions ... options) {
        if (type == null) {
            return "";
        }
        EnumSet<TypeNameOptions> opt = EnumSet.noneOf(TypeNameOptions.class);
        opt.addAll(Arrays.asList(options));
        return ((StringBuilder)new TypeNameVisitor(opt.contains((Object)TypeNameOptions.PRINT_AS_VARARG)).visit(type, opt.contains((Object)TypeNameOptions.PRINT_FQN))).toString();
    }

    public TypeMirror getDenotableType(TypeMirror type) {
        Types types = Types.instance(this.info.impl.getJavacTask().getContext());
        if (type == null) {
            return types.createErrorType((Type)((Object)JavacTypes.instance(this.info.impl.getJavacTask().getContext()).getNoType(TypeKind.NONE)));
        }
        Type inType = (Type)type;
        TypeKind tk = type.getKind();
        if (tk == TypeKind.ERROR) {
            inType = (Type)this.info.getTrees().getOriginalType((ErrorType)type);
        } else if (tk == TypeKind.NONE || tk == TypeKind.OTHER) {
            return types.createErrorType(inType);
        }
        Type t = (Type)TypeUtilities.resolveCapturedType(this.info, type);
        if (t == null) {
            return types.createErrorType(inType);
        }
        if (!t.isErroneous() && !this.checkDenotable(t)) {
            return types.createErrorType(t);
        }
        if (t.hasTag(TypeTag.BOT)) {
            return types.createErrorType(t);
        }
        return t;
    }

    boolean checkDenotable(Type t) {
        return (Boolean)denotableChecker.visit(t, null);
    }

    private static TypeMirror resolveCapturedType(CompilationInfo info, TypeMirror tm) {
        TypeMirror type;
        if (tm == null) {
            return tm;
        }
        if (tm.getKind() == TypeKind.ERROR) {
            tm = info.getTrees().getOriginalType((ErrorType)tm);
        }
        if ((type = TypeUtilities.resolveCapturedTypeInt(info, tm)) == null) {
            return tm;
        }
        if (type.getKind() == TypeKind.WILDCARD) {
            TypeMirror tmirr = ((WildcardType)type).getExtendsBound();
            if (tmirr != null) {
                return tmirr;
            }
            TypeElement te = info.getElements().getTypeElement("java.lang.Object");
            return te == null ? null : te.asType();
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TypeMirror resolveCapturedTypeInt(CompilationInfo info, TypeMirror tm) {
        if (tm == null) {
            return tm;
        }
        WildcardType orig = SourceUtils.resolveCapturedType(tm);
        if (orig != null) {
            tm = orig;
        }
        if (tm.getKind() == TypeKind.WILDCARD) {
            TypeMirror extendsBound = ((WildcardType)tm).getExtendsBound();
            TypeMirror superBound = ((WildcardType)tm).getSuperBound();
            if (extendsBound != null || superBound != null) {
                TypeMirror rct = TypeUtilities.resolveCapturedTypeInt(info, extendsBound != null ? extendsBound : superBound);
                if (rct == null) return null;
                switch (rct.getKind()) {
                    case WILDCARD: {
                        return rct;
                    }
                    case OTHER: 
                    case ARRAY: 
                    case DECLARED: 
                    case ERROR: 
                    case TYPEVAR: {
                        return info.getTypes().getWildcardType((TypeMirror)(extendsBound != null ? rct : null), (TypeMirror)(superBound != null ? rct : null));
                    }
                }
            }
        } else if (tm.getKind() == TypeKind.INTERSECTION) {
            return null;
        }
        if (tm.getKind() == TypeKind.DECLARED) {
            TypeMirror enclosingType;
            DeclaredType dt = (DeclaredType)tm;
            LinkedList<TypeMirror> typeArguments = new LinkedList<TypeMirror>();
            for (TypeMirror typeMirror : dt.getTypeArguments()) {
                TypeMirror targ = TypeUtilities.resolveCapturedTypeInt(info, typeMirror);
                if (targ == null) {
                    if (typeMirror.getKind() == TypeKind.WILDCARD || typeMirror.getKind() == TypeKind.INTERSECTION) {
                        return null;
                    }
                    typeArguments.clear();
                    break;
                }
                typeArguments.add(targ);
            }
            if ((enclosingType = dt.getEnclosingType()).getKind() == TypeKind.DECLARED) {
                return info.getTypes().getDeclaredType((DeclaredType)enclosingType, (TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
            }
            if (dt.asElement() != null) return info.getTypes().getDeclaredType((TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
            return dt;
        }
        if (tm.getKind() != TypeKind.ARRAY) return tm;
        ArrayType at = (ArrayType)tm;
        TypeMirror tm2 = TypeUtilities.resolveCapturedTypeInt(info, at.getComponentType());
        return info.getTypes().getArrayType(tm2 != null ? tm2 : tm);
    }

    private static class TypeNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Boolean> {
        private boolean varArg;
        private boolean insideCapturedWildcard = false;

        private TypeNameVisitor(boolean varArg) {
            super(new StringBuilder());
            this.varArg = varArg;
        }

        @Override
        public StringBuilder defaultAction(TypeMirror t, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(t);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
                Iterator<? extends TypeMirror> it = t.getTypeArguments().iterator();
                if (it.hasNext()) {
                    ((StringBuilder)this.DEFAULT_VALUE).append("<");
                    while (it.hasNext()) {
                        this.visit(it.next(), p);
                        if (!it.hasNext()) continue;
                        ((StringBuilder)this.DEFAULT_VALUE).append(", ");
                    }
                    ((StringBuilder)this.DEFAULT_VALUE).append(">");
                }
                return (StringBuilder)this.DEFAULT_VALUE;
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(TypeUtilities.UNKNOWN);
        }

        @Override
        public StringBuilder visitArray(ArrayType t, Boolean p) {
            boolean isVarArg = this.varArg;
            this.varArg = false;
            this.visit(t.getComponentType(), p);
            return ((StringBuilder)this.DEFAULT_VALUE).append(isVarArg ? "..." : "[]");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable t, Boolean p) {
            String name;
            Element e = t.asElement();
            if (e != null && !TypeUtilities.CAPTURED_WILDCARD.equals(name = e.getSimpleName().toString())) {
                return ((StringBuilder)this.DEFAULT_VALUE).append(name);
            }
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            if (!this.insideCapturedWildcard) {
                this.insideCapturedWildcard = true;
                TypeMirror bound = t.getLowerBound();
                if (bound != null && bound.getKind() != TypeKind.NULL) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                    this.visit(bound, p);
                } else {
                    bound = t.getUpperBound();
                    if (bound != null && bound.getKind() != TypeKind.NULL) {
                        ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                        if (bound.getKind() == TypeKind.TYPEVAR) {
                            bound = ((TypeVariable)bound).getLowerBound();
                        }
                        this.visit(bound, p);
                    }
                }
                this.insideCapturedWildcard = false;
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType t, Boolean p) {
            int len = ((StringBuilder)this.DEFAULT_VALUE).length();
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror bound = t.getSuperBound();
            if (bound == null) {
                bound = t.getExtendsBound();
                if (bound != null) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (bound.getKind() == TypeKind.WILDCARD) {
                        bound = ((WildcardType)bound).getSuperBound();
                    }
                    this.visit(bound, p);
                } else if (!(len != 0 || (bound = SourceUtils.getBound(t)) == null || bound.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)bound).asElement()).getQualifiedName().contentEquals("java.lang.Object"))) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    this.visit(bound, p);
                }
            } else {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(bound, p);
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitError(ErrorType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitUnknown(TypeMirror t, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(TypeUtilities.UNKNOWN);
        }
    }

    public static enum TypeNameOptions {
        PRINT_FQN,
        PRINT_AS_VARARG;

    }
}

