/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.vars;

import java.util.function.Supplier;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariableImpl;

public class TruffleStackVariable
implements TruffleVariable {
    private final JPDADebugger debugger;
    private final String name;
    private String type;
    private final boolean readable;
    private final boolean writable;
    private final boolean internal;
    private String valueStr;
    private Supplier<SourcePosition> valueSourceSupp;
    private Supplier<SourcePosition> typeSourceSupp;
    private SourcePosition valueSource;
    private SourcePosition typeSource;
    private ObjectVariable guestObj;
    private boolean leaf;

    public TruffleStackVariable(JPDADebugger debugger, String name, String type, boolean readable, boolean writable, boolean internal, String valueStr, Supplier<SourcePosition> valueSource, Supplier<SourcePosition> typeSource, ObjectVariable truffleObj) {
        this.debugger = debugger;
        this.name = name;
        this.type = type;
        this.readable = readable;
        this.writable = writable;
        this.internal = internal;
        this.valueStr = valueStr;
        this.valueSourceSupp = valueSource;
        this.typeSourceSupp = typeSource;
        this.guestObj = truffleObj;
        this.leaf = TruffleVariableImpl.isLeaf(truffleObj);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isReadable() {
        return this.readable;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public Object getValue() {
        return this.valueStr;
    }

    @Override
    public ObjectVariable setValue(JPDADebugger debugger, String newExpression) {
        ObjectVariable newGuestObject = TruffleVariableImpl.setValue(debugger, this.guestObj, newExpression);
        if (newGuestObject != null) {
            this.guestObj = newGuestObject;
            TruffleVariableImpl newVar = TruffleVariableImpl.get((Variable)newGuestObject);
            this.type = newVar.getType();
            this.valueStr = newVar.getValue().toString();
            this.typeSource = null;
            this.valueSource = null;
            this.valueSourceSupp = () -> newVar.getValueSource();
            this.typeSourceSupp = () -> newVar.getTypeSource();
            this.leaf = TruffleVariableImpl.isLeaf(this.guestObj);
        }
        return newGuestObject;
    }

    @Override
    public synchronized SourcePosition getValueSource() {
        if (this.valueSource == null) {
            this.valueSource = this.valueSourceSupp.get();
        }
        return this.valueSource;
    }

    @Override
    public synchronized SourcePosition getTypeSource() {
        if (this.typeSource == null) {
            this.typeSource = this.typeSourceSupp.get();
        }
        return this.typeSource;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    @Override
    public Object[] getChildren() {
        return TruffleVariableImpl.getChildren(this.guestObj);
    }
}

