/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.util.Assert;
import org.springframework.web.portlet.handler.AbstractMapBasedHandlerMapping;
import org.springframework.web.portlet.handler.PortletModeParameterLookupKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletModeParameterHandlerMapping
extends AbstractMapBasedHandlerMapping<PortletModeParameterLookupKey> {
    public static final String DEFAULT_PARAMETER_NAME = "action";
    private String parameterName = "action";
    private Map<String, Map<String, ?>> portletModeParameterMap;
    private boolean allowDuplicateParameters = false;
    private final Set<String> parametersUsed = new HashSet<String>();

    public void setParameterName(String parameterName) {
        Assert.hasText((String)parameterName, (String)"'parameterName' must not be empty");
        this.parameterName = parameterName;
    }

    public void setPortletModeParameterMap(Map<String, Map<String, ?>> portletModeParameterMap) {
        this.portletModeParameterMap = portletModeParameterMap;
    }

    public void setAllowDuplicateParameters(boolean allowDuplicateParameters) {
        this.allowDuplicateParameters = allowDuplicateParameters;
    }

    @Override
    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.registerHandlersByModeAndParameter(this.portletModeParameterMap);
    }

    protected void registerHandlersByModeAndParameter(Map<String, Map<String, ?>> portletModeParameterMap) {
        Assert.notNull(portletModeParameterMap, (String)"'portletModeParameterMap' must not be null");
        for (Map.Entry<String, Map<String, ?>> entry : portletModeParameterMap.entrySet()) {
            PortletMode mode = new PortletMode(entry.getKey());
            this.registerHandler(mode, entry.getValue());
        }
    }

    protected void registerHandler(PortletMode mode, Map<String, ?> parameterMap) {
        for (Map.Entry<String, ?> entry : parameterMap.entrySet()) {
            this.registerHandler(mode, entry.getKey(), entry.getValue());
        }
    }

    protected void registerHandler(PortletMode mode, String parameter, Object handler) throws BeansException, IllegalStateException {
        if (!this.allowDuplicateParameters && this.parametersUsed.contains(parameter)) {
            throw new IllegalStateException("Duplicate entries for parameter [" + parameter + "] in different Portlet modes");
        }
        this.parametersUsed.add(parameter);
        this.registerHandler(new PortletModeParameterLookupKey(mode, parameter), handler);
    }

    @Override
    protected PortletModeParameterLookupKey getLookupKey(PortletRequest request) throws Exception {
        PortletMode mode = request.getPortletMode();
        String parameter = request.getParameter(this.parameterName);
        return new PortletModeParameterLookupKey(mode, parameter);
    }
}

