'\"
'\" Generated from file 'imap4\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "imap4" n 0\&.5\&.3 tcllib "imap client"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
imap4 \- imap client-side tcl implementation of imap protocol
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBimap4  ?0\&.5\&.2?\fR
.sp
\fB::imap4::open\fR \fIhostname\fR ?\fIport\fR?
.sp
\fB::imap4::starttls\fR \fIchan\fR
.sp
\fB::imap4::login\fR \fIchan\fR \fIuser\fR \fIpass\fR
.sp
\fB::imap4::folders\fR \fIchan\fR ?\fI-inline\fR? ?\fImboxref\fR? ?\fImboxname\fR?
.sp
\fB::imap4::select\fR \fIchan\fR ?\fImailbox\fR?
.sp
\fB::imap4::examine\fR \fIchan\fR ?\fImailbox\fR?
.sp
\fB::imap4::fetch\fR \fIchan\fR \fIrange\fR ?\fI-inline\fR? ?\fIattr \&.\&.\&.\fR?
.sp
\fB::imap4::noop\fR \fIchan\fR
.sp
\fB::imap4::check\fR \fIchan\fR
.sp
\fB::imap4::folderinfo\fR \fIchan\fR ?\fIinfo\fR?
.sp
\fB::imap4::msginfo\fR \fIchan\fR \fImsgid\fR ?\fIinfo\fR? ?\fIdefval\fR?
.sp
\fB::imap4::mboxinfo\fR \fIchan\fR ?\fIinfo\fR?
.sp
\fB::imap4::isableto\fR \fIchan\fR ?\fIcapability\fR?
.sp
\fB::imap4::create\fR \fIchan\fR \fImailbox\fR
.sp
\fB::imap4::delete\fR \fIchan\fR \fImailbox\fR
.sp
\fB::imap4::rename\fR \fIchan\fR \fIoldname\fR \fInewname\fR
.sp
\fB::imap4::subscribe\fR \fIchan\fR \fImailbox\fR
.sp
\fB::imap4::unsubscribe\fR \fIchan\fR \fImailbox\fR
.sp
\fB::imap4::search\fR \fIchan\fR \fIexpr\fR ?\fI\&.\&.\&.\fR?
.sp
\fB::imap4::close\fR \fIchan\fR
.sp
\fB::imap4::cleanup\fR \fIchan\fR
.sp
\fB::imap4::debugmode\fR \fIchan\fR ?\fIerrormsg\fR?
.sp
\fB::imap4::store\fR \fIchan\fR \fIrange\fR \fIdata\fR \fIflaglist\fR
.sp
\fB::imap4::expunge\fR \fIchan\fR
.sp
\fB::imap4::copy\fR \fIchan\fR \fImsgid\fR \fImailbox\fR
.sp
\fB::imap4::logout\fR \fIchan\fR
.sp
.BE
.SH DESCRIPTION
The \fBimap4\fR library package provides the client side of the
\fIInternet Message Access Protocol\fR (IMAP) using standard
sockets or secure connection via TLS/SSL\&.
The package is fully implemented in Tcl\&.
.PP
This document describes the procedures and explains their usage\&.
.SH PROCEDURES
This package defines the following public procedures:
.TP
\fB::imap4::open\fR \fIhostname\fR ?\fIport\fR?
.sp
Open a new IMAP connection and initalize the handler,
the imap communication channel (handler) is returned\&.
.sp
\fIhostname\fR - mail server
.sp
\fIport\fR - connection port, defaults to 143
.sp
The namespace variable \fB::imap4::use_ssl\fR
can be used to establish to a secure connection
via TSL/SSL if set to true\&. In this case default connection port
defaults to 993\&.
.sp
\fINote:\fR
For connecting via SSL the Tcl module \fItls\fR must be already
loaded otherwise an error is raised\&.
.CS


    package require tls              ; # must be loaded for TLS/SSL
    set ::imap4::use_ssl 1           ; # request a secure connection
    set chan [::imap4::open $server] ; # default port is now 993
.CE
.TP
\fB::imap4::starttls\fR \fIchan\fR
Use this when tasked with connecting to an unsecure port which must be
changed to a secure port prior to user login\&.  This feature is known
as \fISTARTTLS\fR\&.
.TP
\fB::imap4::login\fR \fIchan\fR \fIuser\fR \fIpass\fR
.sp
Login using the IMAP LOGIN command, 0 is returned on successful login\&.
.sp
\fIchan\fR - imap channel
.sp
\fIuser\fR - username
.sp
\fIpass\fR - password
.TP
\fB::imap4::folders\fR \fIchan\fR ?\fI-inline\fR? ?\fImboxref\fR? ?\fImboxname\fR?
.sp
Get list of matching folders, 0 is returned on success\&.
.sp
Wildcards '*' as '%' are allowed for \fImboxref\fR and \fImboxname\fR,
command \fB::imap4::folderinfo\fR can be used to retrieve folder information\&.
.sp
\fIchan\fR - imap channel
.sp
\fImboxref\fR - mailbox reference, defaults to ""
.sp
\fImboxname\fR - mailbox name, defaults to "*"
.sp
If \fB-inline\fR is specified a compact folderlist is
returned instead of the result code\&. All flags are converted to
lowercase and leading special characters are removed\&.
.CS

{{Arc08 noselect} {Arc08/Private {noinferiors unmarked}} {INBOX noinferiors}}
.CE
.TP
\fB::imap4::select\fR \fIchan\fR ?\fImailbox\fR?
.sp
Select a mailbox, 0 is returned on success\&.
.sp
\fIchan\fR - imap channel
.sp
\fImailbox\fR - Path of the mailbox,  defaults to \fIINBOX\fR
.sp
Prior to examine/select an open mailbox must be closed - see: \fB::imap4::close\fR\&.
.TP
\fB::imap4::examine\fR \fIchan\fR ?\fImailbox\fR?
.sp
"Examines" a mailbox, read-only equivalent of \fB::imap4::select\fR\&.
.sp
\fIchan\fR - imap channel
.sp
\fImailbox\fR - mailbox name or path to mailbox,
defaults to \fIINBOX\fR
.sp
Prior to examine/select an open mailbox must be closed - see: \fB::imap4::close\fR\&.
.TP
\fB::imap4::fetch\fR \fIchan\fR \fIrange\fR ?\fI-inline\fR? ?\fIattr \&.\&.\&.\fR?
.sp
Fetch attributes from messages\&.
.sp
The attributes are fetched and stored in the internal state
which can be retrieved with command \fB::imap4::msginfo\fR, 0 is returned
on success\&.
If \fB-inline\fR is specified, alle records are returned as list
in order as defined in the \fIattr\fR argument\&.
.sp
\fIchan\fR - imap channel
.sp
\fIrange\fR - message index in format \fIFROM\fR:\fITO\fR
.sp
\fIattr\fR - imap attributes to fetch
.sp
\fINote:\fR
If \fIFROM\fR is omitted, the 1st message is assumed,
if \fITO\fR is ommitted the last message is assumed\&.
All message index ranges are 1-based\&.
.TP
\fB::imap4::noop\fR \fIchan\fR
Send NOOP command to server\&. May get information as untagged data\&.
.sp
\fIchan\fR - imap channel
.TP
\fB::imap4::check\fR \fIchan\fR
Send CHECK command to server\&. Flush to disk\&.
.sp
\fIchan\fR - imap channel
.TP
\fB::imap4::folderinfo\fR \fIchan\fR ?\fIinfo\fR?
.sp
Get information on the recently selected folderlist\&.
If the \fIinfo\fR argument is omitted or a null string, the full list
of information available for the mailbox is returned\&.
.sp
If the required information name is suffixed with a ? character,
the command returns true if the information is available, or
false if it is not\&.
.sp
\fIchan\fR - imap channel
.sp
\fIinfo\fR - folderlist options to retrieve
.sp
Currently supported options:
\fIdelim\fR - hierarchy delimiter only,
\fImatch\fR - ref and mbox search patterns (see \fB::imap4::folders\fR),
\fInames\fR - list of folder names only,
\fIflags\fR - list of folder names with flags in format
\fI{ {name {flags}} \&.\&.\&. }\fR (see also compact format in function
\fB::imap4::folders\fR)\&.
.CS


{{Arc08 {{\\NoSelect}}} {Arc08/Private {{\\NoInferiors} {\\UnMarked}}} {INBOX {\\NoInferiors}}}

.CE
.TP
\fB::imap4::msginfo\fR \fIchan\fR \fImsgid\fR ?\fIinfo\fR? ?\fIdefval\fR?
.sp
Get information (from previously collected using fetch) from a given
\fImsgid\fR\&. If the 'info' argument is omitted or a null string,
the list of available information options for the given message is
returned\&.
.sp
If the required information name is suffixed with a ? character,
the command returns true if the information is available, or
false if it is not\&.
.sp
\fIchan\fR - imap channel
.sp
\fImsgid\fR - message number
.sp
\fIinfo\fR - imap keyword to retrieve
.sp
\fIdefval\fR - default value, returned if info is empty
.sp
\fINote:\fR
All message index ranges are 1-based\&.
.TP
\fB::imap4::mboxinfo\fR \fIchan\fR ?\fIinfo\fR?
.sp
Get information on the currently selected mailbox\&.
If the \fIinfo\fR argument is omitted or a null string, the list
of available information options for the mailbox is returned\&.
.sp
If the required information name is suffixed with a ? character,
the command returns true if the information is available, or
false if it is not\&.
.sp
\fIchan\fR - imap channel
.sp
\fIopt\fR - mailbox option to retrieve
.sp
Currently supported options:
\fIEXISTS\fR (noof msgs),
\fIRECENT\fR (noof 'recent' flagged msgs),
\fIFLAGS\fR
.sp
In conjunction with OK:
\fIPERMFLAGS\fR, \fIUIDNEXT\fR, \fIUIDVAL\fR, \fIUNSEEN\fR
.sp
Div\&. states:
\fICURRENT\fR, \fIFOUND\fR, \fIPERM\fR\&.
.CS


    ::imap4::select $chan INBOX
    puts "[::imap4::mboxinfo $chan exists] mails in INBOX"
.CE
.TP
\fB::imap4::isableto\fR \fIchan\fR ?\fIcapability\fR?
.sp
Test for capability\&.
It returns 1 if requested capability is supported, 0 otherwise\&.
If \fIcapability\fR is omitted all capability imap
codes are retured as list\&.
.sp
\fIchan\fR - imap channel
.sp
\fIinfo\fR - imap keyword to retrieve
.sp
\fINote:\fR
Use the capability command to ask the server if not
already done by the user\&.
.TP
\fB::imap4::create\fR \fIchan\fR \fImailbox\fR
.sp
Create a new mailbox\&.
.sp
\fIchan\fR - imap channel
.sp
\fImailbox\fR - mailbox name
.TP
\fB::imap4::delete\fR \fIchan\fR \fImailbox\fR
.sp
Delete a new mailbox\&.
.sp
\fIchan\fR - imap channel
.sp
\fImailbox\fR - mailbox name
.TP
\fB::imap4::rename\fR \fIchan\fR \fIoldname\fR \fInewname\fR
.sp
Rename a new mailbox\&.
.sp
\fIchan\fR - imap channel
.sp
\fImailbox\fR - old mailbox name
.sp
\fImailbox\fR - new mailbox name
.TP
\fB::imap4::subscribe\fR \fIchan\fR \fImailbox\fR
.sp
Subscribe a new mailbox\&.
.sp
\fIchan\fR - imap channel
.sp
\fImailbox\fR - mailbox name
.TP
\fB::imap4::unsubscribe\fR \fIchan\fR \fImailbox\fR
.sp
Unsubscribe a new mailbox\&.
.sp
\fIchan\fR - imap channel
.sp
\fImailbox\fR - mailbox name
.TP
\fB::imap4::search\fR \fIchan\fR \fIexpr\fR ?\fI\&.\&.\&.\fR?
.sp
Search for mails matching search criterions, 0 is returned on success\&.
.sp
\fIchan\fR - imap channel
.sp
\fIexpr\fR - imap search expression
.sp
\fINotes:\fR
Currently the following search expressions are handled:
.sp
\fIMail header flags:\fR
all mail header entries (ending with a colon ":"), like "From:", "Bcc:", \&.\&.\&.
.sp
\fIImap message search flags:\fR
ANSWERED, DELETED, DRAFT, FLAGGED, RECENT,
SEEN, NEW, OLD, UNANSWERED, UNDELETED,
UNDRAFT, UNFLAGGED, UNSEEN, ALL
.sp
\fIImap header search flags:\fR
BODY, CC, FROM, SUBJECT, TEXT, KEYWORD, BCC
.sp
\fIImap conditional search flags:\fR
SMALLER, LARGER, ON, SENTBEFORE, SENTON, SENTSINCE, SINCE,
BEFORE (not implemented),
UID (not implemented)
.sp
\fILogical search conditions:\fR
OR, NOT
.CS

::imap4::search $chan larger 4000 seen
puts "Found messages: [::imap4::mboxinfo $chan found]"
Found messages: 1 3 6 7 8 9 13 14 15 19 20
.CE
.TP
\fB::imap4::close\fR \fIchan\fR
.sp
Close the mailbox\&. Permanently removes \\Deleted messages and
return to the AUTH state\&.
.sp
\fIchan\fR - imap channel
.TP
\fB::imap4::cleanup\fR \fIchan\fR
.sp
Destroy an IMAP connection and free the used space\&.
Close the mailbox\&. Permanently removes \\Deleted messages
and return to the AUTH state\&.
.sp
\fIchan\fR - imap channel
.TP
\fB::imap4::debugmode\fR \fIchan\fR ?\fIerrormsg\fR?
Switch client into command line debug mode\&.
.sp
This is a developers mode only that pass the control to the
programmer\&. Every line entered is sent verbatim to the
server (after the addition of the request identifier)\&.
The ::imap4::debug variable is automatically set to '1' on enter\&.
.sp
It's possible to execute Tcl commands starting the line
with a slash\&.
.sp
\fIchan\fR - imap channel
.sp
\fIerrormsg\fR - optional error message to display
.TP
\fB::imap4::store\fR \fIchan\fR \fIrange\fR \fIdata\fR \fIflaglist\fR
.sp
Alters data associated with a message in the selected
mailbox\&.
.sp
\fIchan\fR - imap channel
.sp
\fIrange\fR - message index in format \fIFROM\fR:\fITO\fR
.sp
\fIflaglist\fR - Flags the \fIdata\fR operates on\&.
.sp
\fIdata\fR - The currently defined \fIdata\fR items that can be
stored are shown below\&. \fINote\fR that all of these data types may
also be suffixed with "\&.SILENT" to suppress the untagged FETCH
response\&.
.RS
.TP
FLAGS
Replace the flags for the message (other than \\Recent) with the
\fIflaglist\fR\&.
.TP
+FLAGS
Add the flags in \fIflaglist\fR to the existing flags for the message\&.
.TP
-FLAGS
Remove the flags in \fIflaglist\fR to the existing flags for the
message\&.
.RE
.IP
For example:
.CS


	::imap4::store $chan $start_msgid:$end_msgid +FLAGS "Deleted"

.CE
.TP
\fB::imap4::expunge\fR \fIchan\fR
.sp
Permanently removes all messages that have the \\Deleted flag
set from the currently selected mailbox, without the need to close the
connection\&.
.sp
\fIchan\fR - imap channel
.TP
\fB::imap4::copy\fR \fIchan\fR \fImsgid\fR \fImailbox\fR
.sp
Copies the specified message (identified by its message number)
to the named mailbox, i\&.e\&. imap folder\&.
.sp
\fIchan\fR - imap channel
.sp
\fImsgid\fR - message number
.sp
\fImailbox\fR - mailbox name
.TP
\fB::imap4::logout\fR \fIchan\fR
.sp
Informs the server that the client is done with the connection
and closes the network connection\&. Permanently removes \\Deleted
messages\&.
.sp
A new connection will need to be established to login once
more\&.
.sp
\fIchan\fR - imap channel
.PP
.SH EXAMPLES
.CS


    set user myusername
    set pass xtremescrt
    set server imap\&.test\&.tld
    set FOLDER INBOX
    # Connect to server
    set imap [::imap4::open $server]
    ::imap4::login $imap $user $pass
    ::imap4::select $imap $FOLDER
    # Output all the information about that mailbox
    foreach info [::imap4::mboxinfo $imap] {
        puts "$info -> [::imap4::mboxinfo $imap $info]"
    }
    # fetch 3 records inline
    set fields {from: to: subject: size}
    foreach rec [::imap4::fetch $imap :3 -inline {*}$fields] {
        puts -nonewline "#[incr idx])"
        for {set j 0} {$j<[llength $fields]} {incr j} {
            puts "\\t[lindex $fields $j] [lindex $rec $j]"
        }
    }

    # Show all the information available about the message ID 1
    puts "Available info about message 1: [::imap4::msginfo $imap 1]"

    # Use the capability stuff
    puts "Capabilities: [::imap4::isableto $imap]"
    puts "Is able to imap4rev1? [::imap4::isableto $imap imap4rev1]"

    # Cleanup
    ::imap4::cleanup $imap

.CE
.SH "TLS SECURITY CONSIDERATIONS"
This package uses the \fBTLS\fR package to handle the security
for \fBhttps\fR urls and other socket connections\&.
.PP
Policy decisions like the set of protocols to support and what
ciphers to use are not the responsibility of \fBTLS\fR, nor of
this package itself however\&.
Such decisions are the responsibility of whichever application is
using the package, and are likely influenced by the set of servers
the application will talk to as well\&.
.PP
For example, in light of the recent
\fIPOODLE attack\fR [http://googleonlinesecurity\&.blogspot\&.co\&.uk/2014/10/this-poodle-bites-exploiting-ssl-30\&.html] discovered by Google many servers will disable support
for the SSLv3 protocol\&.
To handle this change the applications using \fBTLS\fR must be
patched, and not this package, nor \fBTLS\fR itself\&.
Such a patch may be as simple as generally activating \fBtls1\fR
support, as shown in the example below\&.
.CS


    package require tls
    tls::init -tls1 1 ;# forcibly activate support for the TLS1 protocol

    \&.\&.\&. your own application code \&.\&.\&.

.CE
.SH REFERENCES
Mark R\&. Crispin, "INTERNET MESSAGE ACCESS PROTOCOL - VERSION 4rev1",
RFC 3501, March 2003, \fIhttp://www\&.rfc-editor\&.org/rfc/rfc3501\&.txt\fR
.PP
OpenSSL, \fIhttp://www\&.openssl\&.org/\fR
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIimap4\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
Only a small part of rfc3501 implemented\&.
.SH "SEE ALSO"
ftp, http, imap, mime, pop3, tls
.SH KEYWORDS
email, imap, internet, mail, net, rfc3501, ssl, tls