#ifndef KDB_CONFIG_H
#define KDB_CONFIG_H

/* config-kdb.h. Generated by cmake from config-kdb.h.cmake */

/*! @file config-kdb.h
    Global KDb configuration (build time)
*/

//! @def KDB_GIT_SHA1_STRING
//! @brief Indicates the git sha1 commit which was used for compilation of KDb
/* #undef KDB_GIT_SHA1_STRING */

//! @def KDB_GIT_BRANCH_STRING
//! @brief Indicates the git branch which was used for compilation of KDb
/* #undef KDB_GIT_BRANCH_STRING */

//! @def BIN_INSTALL_DIR
//! @brief The subdirectory relative to the install prefix for executables.
#define BIN_INSTALL_DIR "bin"

//! @def KDB_BASE_NAME
//! @brief Base name for the framework, based on major stable version.
//!        Useful for co-installability.
#define KDB_BASE_NAME "KDb3"

//! @def KDB_BASE_NAME_LOWER
//! @brief Like KDB_BASE_NAME but lowercase.
#define KDB_BASE_NAME_LOWER "kdb3"

//! @def KDB_STABLE_VERSION_MAJOR
//! @brief Extra version info, stable major, e.g. 3 for 3.1.0 Alpha (3.0.90)
#define KDB_STABLE_VERSION_MAJOR 3

//! @def KDB_STABLE_VERSION_MINOR
//! @brief Extra version info, stable minor, e.g. 1 for 3.1.0 Alpha (3.0.90)
#define KDB_STABLE_VERSION_MINOR 0

//! @def KDB_STABLE_VERSION_PATCH
//! @brief Extra version info, stable patch, e.g. 0 for 3.1.0 Alpha (3.0.90)
#define KDB_STABLE_VERSION_PATCH 2

//! @def KDB_TESTING_EXPORT
//! @brief Export symbols for testing
#ifdef BUILD_TESTING
#  define KDB_TESTING_EXPORT KDB_EXPORT
#else
#  define KDB_TESTING_EXPORT
#endif

//! @def KDB_EXPRESSION_DEBUG
//! @brief Defined if debugging for expressions is enabled
/* #undef KDB_EXPRESSION_DEBUG */

//! @def KDB_DRIVERMANAGER_DEBUG
//! @brief Defined if debugging for the driver manager is enabled
/* #undef KDB_DRIVERMANAGER_DEBUG */

//! @def KDB_DEBUG_GUI
//! @brief Defined if a GUI for debugging is enabled
/* #undef KDB_DEBUG_GUI */

//! @def KDB_UNFINISHED
//! @brief Defined if unfinished features of KDb are enabled
/* #undef KDB_UNFINISHED */

#endif
