# Volatility
# Copyright (c) 2008-2013 Volatility Foundation
#
# This file is part of Volatility.
#
# Volatility is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Volatility is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Volatility.  If not, see <http://www.gnu.org/licenses/>.
#

"""
@author:       MHL
@license:      GNU General Public License 2.0
@contact:      michael.ligh@mnin.org

This file provides support for Windows 2003 SP1 and SP2 x64.
"""

syscalls = [
    [
    'NtMapUserPhysicalPagesScatter', # 0x0
    'NtWaitForSingleObject', # 0x1
    'NtCallbackReturn', # 0x2
    'NtReadFile', # 0x3
    'NtDeviceIoControlFile', # 0x4
    'NtWriteFile', # 0x5
    'NtRemoveIoCompletion', # 0x6
    'NtReleaseSemaphore', # 0x7
    'NtReplyWaitReceivePort', # 0x8
    'NtReplyPort', # 0x9
    'NtSetInformationThread', # 0xa
    'NtSetEvent', # 0xb
    'NtClose', # 0xc
    'NtQueryObject', # 0xd
    'NtQueryInformationFile', # 0xe
    'NtOpenKey', # 0xf
    'NtEnumerateValueKey', # 0x10
    'NtFindAtom', # 0x11
    'NtQueryDefaultLocale', # 0x12
    'NtQueryKey', # 0x13
    'NtQueryValueKey', # 0x14
    'NtAllocateVirtualMemory', # 0x15
    'NtQueryInformationProcess', # 0x16
    'NtWaitForMultipleObjects32', # 0x17
    'NtWriteFileGather', # 0x18
    'NtSetInformationProcess', # 0x19
    'NtCreateKey', # 0x1a
    'NtFreeVirtualMemory', # 0x1b
    'NtImpersonateClientOfPort', # 0x1c
    'NtReleaseMutant', # 0x1d
    'NtQueryInformationToken', # 0x1e
    'NtRequestWaitReplyPort', # 0x1f
    'NtQueryVirtualMemory', # 0x20
    'NtOpenThreadToken', # 0x21
    'NtQueryInformationThread', # 0x22
    'NtOpenProcess', # 0x23
    'NtSetInformationFile', # 0x24
    'NtMapViewOfSection', # 0x25
    'NtAccessCheckAndAuditAlarm', # 0x26
    'NtUnmapViewOfSection', # 0x27
    'NtReplyWaitReceivePortEx', # 0x28
    'NtTerminateProcess', # 0x29
    'NtSetEventBoostPriority', # 0x2a
    'NtReadFileScatter', # 0x2b
    'NtOpenThreadTokenEx', # 0x2c
    'NtOpenProcessTokenEx', # 0x2d
    'NtQueryPerformanceCounter', # 0x2e
    'NtEnumerateKey', # 0x2f
    'NtOpenFile', # 0x30
    'NtDelayExecution', # 0x31
    'NtQueryDirectoryFile', # 0x32
    'NtQuerySystemInformation', # 0x33
    'NtOpenSection', # 0x34
    'NtQueryTimer', # 0x35
    'NtFsControlFile', # 0x36
    'NtWriteVirtualMemory', # 0x37
    'NtCloseObjectAuditAlarm', # 0x38
    'NtDuplicateObject', # 0x39
    'NtQueryAttributesFile', # 0x3a
    'NtClearEvent', # 0x3b
    'NtReadVirtualMemory', # 0x3c
    'NtOpenEvent', # 0x3d
    'NtAdjustPrivilegesToken', # 0x3e
    'NtDuplicateToken', # 0x3f
    'NtContinue', # 0x40
    'NtQueryDefaultUILanguage', # 0x41
    'NtQueueApcThread', # 0x42
    'NtYieldExecution', # 0x43
    'NtAddAtom', # 0x44
    'NtCreateEvent', # 0x45
    'NtQueryVolumeInformationFile', # 0x46
    'NtCreateSection', # 0x47
    'NtFlushBuffersFile', # 0x48
    'NtApphelpCacheControl', # 0x49
    'NtCreateProcessEx', # 0x4a
    'NtCreateThread', # 0x4b
    'NtIsProcessInJob', # 0x4c
    'NtProtectVirtualMemory', # 0x4d
    'NtQuerySection', # 0x4e
    'NtResumeThread', # 0x4f
    'NtTerminateThread', # 0x50
    'NtReadRequestData', # 0x51
    'NtCreateFile', # 0x52
    'NtQueryEvent', # 0x53
    'NtWriteRequestData', # 0x54
    'NtOpenDirectoryObject', # 0x55
    'NtAccessCheckByTypeAndAuditAlarm', # 0x56
    'NtQuerySystemTime', # 0x57
    'NtWaitForMultipleObjects', # 0x58
    'NtSetInformationObject', # 0x59
    'NtCancelIoFile', # 0x5a
    'NtTraceEvent', # 0x5b
    'NtPowerInformation', # 0x5c
    'NtSetValueKey', # 0x5d
    'NtCancelTimer', # 0x5e
    'NtSetTimer', # 0x5f
    'NtAcceptConnectPort', # 0x60
    'NtAccessCheck', # 0x61
    'NtAccessCheckByType', # 0x62
    'NtAccessCheckByTypeResultList', # 0x63
    'NtAccessCheckByTypeResultListAndAuditAlarm', # 0x64
    'NtAccessCheckByTypeResultListAndAuditAlarmByHandle', # 0x65
    'NtAddBootEntry', # 0x66
    'NtAddDriverEntry', # 0x67
    'NtAdjustGroupsToken', # 0x68
    'NtAlertResumeThread', # 0x69
    'NtAlertThread', # 0x6a
    'NtAllocateLocallyUniqueId', # 0x6b
    'NtAllocateUserPhysicalPages', # 0x6c
    'NtAllocateUuids', # 0x6d
    'NtAreMappedFilesTheSame', # 0x6e
    'NtAssignProcessToJobObject', # 0x6f
    'NtCancelDeviceWakeupRequest', # 0x70
    'NtCompactKeys', # 0x71
    'NtCompareTokens', # 0x72
    'NtCompleteConnectPort', # 0x73
    'NtCompressKey', # 0x74
    'NtConnectPort', # 0x75
    'NtCreateDebugObject', # 0x76
    'NtCreateDirectoryObject', # 0x77
    'NtCreateEventPair', # 0x78
    'NtCreateIoCompletion', # 0x79
    'NtCreateJobObject', # 0x7a
    'NtCreateJobSet', # 0x7b
    'NtCreateKeyedEvent', # 0x7c
    'NtCreateMailslotFile', # 0x7d
    'NtCreateMutant', # 0x7e
    'NtCreateNamedPipeFile', # 0x7f
    'NtCreatePagingFile', # 0x80
    'NtCreatePort', # 0x81
    'NtCreateProcess', # 0x82
    'NtCreateProfile', # 0x83
    'NtCreateSemaphore', # 0x84
    'NtCreateSymbolicLinkObject', # 0x85
    'NtCreateTimer', # 0x86
    'NtCreateToken', # 0x87
    'NtCreateWaitablePort', # 0x88
    'NtDebugActiveProcess', # 0x89
    'NtDebugContinue', # 0x8a
    'NtDeleteAtom', # 0x8b
    'NtDeleteBootEntry', # 0x8c
    'NtDeleteDriverEntry', # 0x8d
    'NtDeleteFile', # 0x8e
    'NtDeleteKey', # 0x8f
    'NtDeleteObjectAuditAlarm', # 0x90
    'NtDeleteValueKey', # 0x91
    'NtDisplayString', # 0x92
    'NtEnumerateBootEntries', # 0x93
    'NtEnumerateDriverEntries', # 0x94
    'NtEnumerateSystemEnvironmentValuesEx', # 0x95
    'NtExtendSection', # 0x96
    'NtFilterToken', # 0x97
    'NtFlushInstructionCache', # 0x98
    'NtFlushKey', # 0x99
    'NtFlushVirtualMemory', # 0x9a
    'NtFlushWriteBuffer', # 0x9b
    'NtFreeUserPhysicalPages', # 0x9c
    'NtGetContextThread', # 0x9d
    'NtGetCurrentProcessorNumber', # 0x9e
    'NtGetDevicePowerState', # 0x9f
    'NtGetPlugPlayEvent', # 0xa0
    'NtGetWriteWatch', # 0xa1
    'NtImpersonateAnonymousToken', # 0xa2
    'NtImpersonateThread', # 0xa3
    'NtInitializeRegistry', # 0xa4
    'NtInitiatePowerAction', # 0xa5
    'NtIsSystemResumeAutomatic', # 0xa6
    'NtListenPort', # 0xa7
    'NtLoadDriver', # 0xa8
    'NtLoadKey', # 0xa9
    'NtLoadKey2', # 0xaa
    'NtLoadKeyEx', # 0xab
    'NtLockFile', # 0xac
    'NtLockProductActivationKeys', # 0xad
    'NtLockRegistryKey', # 0xae
    'NtLockVirtualMemory', # 0xaf
    'NtMakePermanentObject', # 0xb0
    'NtMakeTemporaryObject', # 0xb1
    'NtMapUserPhysicalPages', # 0xb2
    'NtModifyBootEntry', # 0xb3
    'NtModifyDriverEntry', # 0xb4
    'NtNotifyChangeDirectoryFile', # 0xb5
    'NtNotifyChangeKey', # 0xb6
    'NtNotifyChangeMultipleKeys', # 0xb7
    'NtOpenEventPair', # 0xb8
    'NtOpenIoCompletion', # 0xb9
    'NtOpenJobObject', # 0xba
    'NtOpenKeyedEvent', # 0xbb
    'NtOpenMutant', # 0xbc
    'NtOpenObjectAuditAlarm', # 0xbd
    'NtOpenProcessToken', # 0xbe
    'NtOpenSemaphore', # 0xbf
    'NtOpenSymbolicLinkObject', # 0xc0
    'NtOpenThread', # 0xc1
    'NtOpenTimer', # 0xc2
    'NtPlugPlayControl', # 0xc3
    'NtPrivilegeCheck', # 0xc4
    'NtPrivilegeObjectAuditAlarm', # 0xc5
    'NtPrivilegedServiceAuditAlarm', # 0xc6
    'NtPulseEvent', # 0xc7
    'NtQueryBootEntryOrder', # 0xc8
    'NtQueryBootOptions', # 0xc9
    'NtQueryDebugFilterState', # 0xca
    'NtQueryDirectoryObject', # 0xcb
    'NtQueryDriverEntryOrder', # 0xcc
    'NtQueryEaFile', # 0xcd
    'NtQueryFullAttributesFile', # 0xce
    'NtQueryInformationAtom', # 0xcf
    'NtQueryInformationJobObject', # 0xd0
    'NtQueryInformationPort', # 0xd1
    'NtQueryInstallUILanguage', # 0xd2
    'NtQueryIntervalProfile', # 0xd3
    'NtQueryIoCompletion', # 0xd4
    'NtQueryMultipleValueKey', # 0xd5
    'NtQueryMutant', # 0xd6
    'NtQueryOpenSubKeys', # 0xd7
    'NtQueryOpenSubKeysEx', # 0xd8
    'NtQueryPortInformationProcess', # 0xd9
    'NtQueryQuotaInformationFile', # 0xda
    'NtQuerySecurityObject', # 0xdb
    'NtQuerySemaphore', # 0xdc
    'NtQuerySymbolicLinkObject', # 0xdd
    'NtQuerySystemEnvironmentValue', # 0xde
    'NtQuerySystemEnvironmentValueEx', # 0xdf
    'NtQueryTimerResolution', # 0xe0
    'NtRaiseException', # 0xe1
    'NtRaiseHardError', # 0xe2
    'NtRegisterThreadTerminatePort', # 0xe3
    'NtReleaseKeyedEvent', # 0xe4
    'NtRemoveProcessDebug', # 0xe5
    'NtRenameKey', # 0xe6
    'NtReplaceKey', # 0xe7
    'NtReplyWaitReplyPort', # 0xe8
    'NtRequestDeviceWakeup', # 0xe9
    'NtRequestPort', # 0xea
    'NtRequestWakeupLatency', # 0xeb
    'NtResetEvent', # 0xec
    'NtResetWriteWatch', # 0xed
    'NtRestoreKey', # 0xee
    'NtResumeProcess', # 0xef
    'NtSaveKey', # 0xf0
    'NtSaveKeyEx', # 0xf1
    'NtSaveMergedKeys', # 0xf2
    'NtSecureConnectPort', # 0xf3
    'NtSetBootEntryOrder', # 0xf4
    'NtSetBootOptions', # 0xf5
    'NtSetContextThread', # 0xf6
    'NtSetDebugFilterState', # 0xf7
    'NtSetDefaultHardErrorPort', # 0xf8
    'NtSetDefaultLocale', # 0xf9
    'NtSetDefaultUILanguage', # 0xfa
    'NtSetDriverEntryOrder', # 0xfb
    'NtSetEaFile', # 0xfc
    'NtSetHighEventPair', # 0xfd
    'NtSetHighWaitLowEventPair', # 0xfe
    'NtSetInformationDebugObject', # 0xff
    'NtSetInformationJobObject', # 0x100
    'NtSetInformationKey', # 0x101
    'NtSetInformationToken', # 0x102
    'NtSetIntervalProfile', # 0x103
    'NtSetIoCompletion', # 0x104
    'NtSetLdtEntries', # 0x105
    'NtSetLowEventPair', # 0x106
    'NtSetLowWaitHighEventPair', # 0x107
    'NtSetQuotaInformationFile', # 0x108
    'NtSetSecurityObject', # 0x109
    'NtSetSystemEnvironmentValue', # 0x10a
    'NtSetSystemEnvironmentValueEx', # 0x10b
    'NtSetSystemInformation', # 0x10c
    'NtSetSystemPowerState', # 0x10d
    'NtSetSystemTime', # 0x10e
    'NtSetThreadExecutionState', # 0x10f
    'NtSetTimerResolution', # 0x110
    'NtSetUuidSeed', # 0x111
    'NtSetVolumeInformationFile', # 0x112
    'NtShutdownSystem', # 0x113
    'NtSignalAndWaitForSingleObject', # 0x114
    'NtStartProfile', # 0x115
    'NtStopProfile', # 0x116
    'NtSuspendProcess', # 0x117
    'NtSuspendThread', # 0x118
    'NtSystemDebugControl', # 0x119
    'NtTerminateJobObject', # 0x11a
    'NtTestAlert', # 0x11b
    'NtTranslateFilePath', # 0x11c
    'NtUnloadDriver', # 0x11d
    'NtUnloadKey', # 0x11e
    'NtUnloadKey2', # 0x11f
    'NtUnloadKeyEx', # 0x120
    'NtUnlockFile', # 0x121
    'NtUnlockVirtualMemory', # 0x122
    'NtVdmControl', # 0x123
    'NtWaitForDebugEvent', # 0x124
    'NtWaitForKeyedEvent', # 0x125
    'NtWaitHighEventPair', # 0x126
    'NtWaitLowEventPair', # 0x127
    ],
    [
    'NtUserGetThreadState', # 0x0
    'NtUserPeekMessage', # 0x1
    'NtUserCallOneParam', # 0x2
    'NtUserGetKeyState', # 0x3
    'NtUserInvalidateRect', # 0x4
    'NtUserCallNoParam', # 0x5
    'NtUserGetMessage', # 0x6
    'NtUserMessageCall', # 0x7
    'NtGdiBitBlt', # 0x8
    'NtGdiGetCharSet', # 0x9
    'NtUserGetDC', # 0xa
    'NtGdiSelectBitmap', # 0xb
    'NtUserWaitMessage', # 0xc
    'NtUserTranslateMessage', # 0xd
    'NtUserPostMessage', # 0xe
    'NtUserQueryWindow', # 0xf
    'NtUserTranslateAccelerator', # 0x10
    'NtGdiFlush', # 0x11
    'NtUserRedrawWindow', # 0x12
    'NtUserWindowFromPoint', # 0x13
    'NtUserCallMsgFilter', # 0x14
    'NtUserValidateTimerCallback', # 0x15
    'NtUserBeginPaint', # 0x16
    'NtUserSetTimer', # 0x17
    'NtUserEndPaint', # 0x18
    'NtUserSetCursor', # 0x19
    'NtUserKillTimer', # 0x1a
    'NtUserBuildHwndList', # 0x1b
    'NtUserSelectPalette', # 0x1c
    'NtUserCallNextHookEx', # 0x1d
    'NtUserHideCaret', # 0x1e
    'NtGdiIntersectClipRect', # 0x1f
    'NtUserCallHwndLock', # 0x20
    'NtUserGetProcessWindowStation', # 0x21
    'NtGdiDeleteObjectApp', # 0x22
    'NtUserSetWindowPos', # 0x23
    'NtUserShowCaret', # 0x24
    'NtUserEndDeferWindowPosEx', # 0x25
    'NtUserCallHwndParamLock', # 0x26
    'NtUserVkKeyScanEx', # 0x27
    'NtGdiSetDIBitsToDeviceInternal', # 0x28
    'NtUserCallTwoParam', # 0x29
    'NtGdiGetRandomRgn', # 0x2a
    'NtUserCopyAcceleratorTable', # 0x2b
    'NtUserNotifyWinEvent', # 0x2c
    'NtGdiExtSelectClipRgn', # 0x2d
    'NtUserIsClipboardFormatAvailable', # 0x2e
    'NtUserSetScrollInfo', # 0x2f
    'NtGdiStretchBlt', # 0x30
    'NtUserCreateCaret', # 0x31
    'NtGdiRectVisible', # 0x32
    'NtGdiCombineRgn', # 0x33
    'NtGdiGetDCObject', # 0x34
    'NtUserDispatchMessage', # 0x35
    'NtUserRegisterWindowMessage', # 0x36
    'NtGdiExtTextOutW', # 0x37
    'NtGdiSelectFont', # 0x38
    'NtGdiRestoreDC', # 0x39
    'NtGdiSaveDC', # 0x3a
    'NtUserGetForegroundWindow', # 0x3b
    'NtUserShowScrollBar', # 0x3c
    'NtUserFindExistingCursorIcon', # 0x3d
    'NtGdiGetDCDword', # 0x3e
    'NtGdiGetRegionData', # 0x3f
    'NtGdiLineTo', # 0x40
    'NtUserSystemParametersInfo', # 0x41
    'NtGdiGetAppClipBox', # 0x42
    'NtUserGetAsyncKeyState', # 0x43
    'NtUserGetCPD', # 0x44
    'NtUserRemoveProp', # 0x45
    'NtGdiDoPalette', # 0x46
    'NtGdiPolyPolyDraw', # 0x47
    'NtUserSetCapture', # 0x48
    'NtUserEnumDisplayMonitors', # 0x49
    'NtGdiCreateCompatibleBitmap', # 0x4a
    'NtUserSetProp', # 0x4b
    'NtGdiGetTextCharsetInfo', # 0x4c
    'NtUserSBGetParms', # 0x4d
    'NtUserGetIconInfo', # 0x4e
    'NtUserExcludeUpdateRgn', # 0x4f
    'NtUserSetFocus', # 0x50
    'NtGdiExtGetObjectW', # 0x51
    'NtUserDeferWindowPos', # 0x52
    'NtUserGetUpdateRect', # 0x53
    'NtGdiCreateCompatibleDC', # 0x54
    'NtUserGetClipboardSequenceNumber', # 0x55
    'NtGdiCreatePen', # 0x56
    'NtUserShowWindow', # 0x57
    'NtUserGetKeyboardLayoutList', # 0x58
    'NtGdiPatBlt', # 0x59
    'NtUserMapVirtualKeyEx', # 0x5a
    'NtUserSetWindowLong', # 0x5b
    'NtGdiHfontCreate', # 0x5c
    'NtUserMoveWindow', # 0x5d
    'NtUserPostThreadMessage', # 0x5e
    'NtUserDrawIconEx', # 0x5f
    'NtUserGetSystemMenu', # 0x60
    'NtGdiDrawStream', # 0x61
    'NtUserInternalGetWindowText', # 0x62
    'NtUserGetWindowDC', # 0x63
    'NtGdiD3dDrawPrimitives2', # 0x64
    'NtGdiInvertRgn', # 0x65
    'NtGdiGetRgnBox', # 0x66
    'NtGdiGetAndSetDCDword', # 0x67
    'NtGdiMaskBlt', # 0x68
    'NtGdiGetWidthTable', # 0x69
    'NtUserScrollDC', # 0x6a
    'NtUserGetObjectInformation', # 0x6b
    'NtGdiCreateBitmap', # 0x6c
    'NtGdiConsoleTextOut', # 0x6d
    'NtUserFindWindowEx', # 0x6e
    'NtGdiPolyPatBlt', # 0x6f
    'NtUserUnhookWindowsHookEx', # 0x70
    'NtGdiGetNearestColor', # 0x71
    'NtGdiTransformPoints', # 0x72
    'NtGdiGetDCPoint', # 0x73
    'NtUserCheckImeHotKey', # 0x74
    'NtGdiCreateDIBBrush', # 0x75
    'NtGdiGetTextMetricsW', # 0x76
    'NtUserCreateWindowEx', # 0x77
    'NtUserSetParent', # 0x78
    'NtUserGetKeyboardState', # 0x79
    'NtUserToUnicodeEx', # 0x7a
    'NtUserGetControlBrush', # 0x7b
    'NtUserGetClassName', # 0x7c
    'NtGdiAlphaBlend', # 0x7d
    'NtGdiDdBlt', # 0x7e
    'NtGdiOffsetRgn', # 0x7f
    'NtUserDefSetText', # 0x80
    'NtGdiGetTextFaceW', # 0x81
    'NtGdiStretchDIBitsInternal', # 0x82
    'NtUserSendInput', # 0x83
    'NtUserGetThreadDesktop', # 0x84
    'NtGdiCreateRectRgn', # 0x85
    'NtGdiGetDIBitsInternal', # 0x86
    'NtUserGetUpdateRgn', # 0x87
    'NtGdiDeleteClientObj', # 0x88
    'NtUserGetIconSize', # 0x89
    'NtUserFillWindow', # 0x8a
    'NtGdiExtCreateRegion', # 0x8b
    'NtGdiComputeXformCoefficients', # 0x8c
    'NtUserSetWindowsHookEx', # 0x8d
    'NtUserNotifyProcessCreate', # 0x8e
    'NtGdiUnrealizeObject', # 0x8f
    'NtUserGetTitleBarInfo', # 0x90
    'NtGdiRectangle', # 0x91
    'NtUserSetThreadDesktop', # 0x92
    'NtUserGetDCEx', # 0x93
    'NtUserGetScrollBarInfo', # 0x94
    'NtGdiGetTextExtent', # 0x95
    'NtUserSetWindowFNID', # 0x96
    'NtGdiSetLayout', # 0x97
    'NtUserCalcMenuBar', # 0x98
    'NtUserThunkedMenuItemInfo', # 0x99
    'NtGdiExcludeClipRect', # 0x9a
    'NtGdiCreateDIBSection', # 0x9b
    'NtGdiGetDCforBitmap', # 0x9c
    'NtUserDestroyCursor', # 0x9d
    'NtUserDestroyWindow', # 0x9e
    'NtUserCallHwndParam', # 0x9f
    'NtGdiCreateDIBitmapInternal', # 0xa0
    'NtUserOpenWindowStation', # 0xa1
    'NtGdiDdDeleteSurfaceObject', # 0xa2
    'NtGdiEnumFontClose', # 0xa3
    'NtGdiEnumFontOpen', # 0xa4
    'NtGdiEnumFontChunk', # 0xa5
    'NtGdiDdCanCreateSurface', # 0xa6
    'NtGdiDdCreateSurface', # 0xa7
    'NtUserSetCursorIconData', # 0xa8
    'NtGdiDdDestroySurface', # 0xa9
    'NtUserCloseDesktop', # 0xaa
    'NtUserOpenDesktop', # 0xab
    'NtUserSetProcessWindowStation', # 0xac
    'NtUserGetAtomName', # 0xad
    'NtGdiDdResetVisrgn', # 0xae
    'NtGdiExtCreatePen', # 0xaf
    'NtGdiCreatePaletteInternal', # 0xb0
    'NtGdiSetBrushOrg', # 0xb1
    'NtUserBuildNameList', # 0xb2
    'NtGdiSetPixel', # 0xb3
    'NtUserRegisterClassExWOW', # 0xb4
    'NtGdiCreatePatternBrushInternal', # 0xb5
    'NtUserGetAncestor', # 0xb6
    'NtGdiGetOutlineTextMetricsInternalW', # 0xb7
    'NtGdiSetBitmapBits', # 0xb8
    'NtUserCloseWindowStation', # 0xb9
    'NtUserGetDoubleClickTime', # 0xba
    'NtUserEnableScrollBar', # 0xbb
    'NtGdiCreateSolidBrush', # 0xbc
    'NtUserGetClassInfoEx', # 0xbd
    'NtGdiCreateClientObj', # 0xbe
    'NtUserUnregisterClass', # 0xbf
    'NtUserDeleteMenu', # 0xc0
    'NtGdiRectInRegion', # 0xc1
    'NtUserScrollWindowEx', # 0xc2
    'NtGdiGetPixel', # 0xc3
    'NtUserSetClassLong', # 0xc4
    'NtUserGetMenuBarInfo', # 0xc5
    'NtGdiDdCreateSurfaceEx', # 0xc6
    'NtGdiDdCreateSurfaceObject', # 0xc7
    'NtGdiGetNearestPaletteIndex', # 0xc8
    'NtGdiDdLockD3D', # 0xc9
    'NtGdiDdUnlockD3D', # 0xca
    'NtGdiGetCharWidthW', # 0xcb
    'NtUserInvalidateRgn', # 0xcc
    'NtUserGetClipboardOwner', # 0xcd
    'NtUserSetWindowRgn', # 0xce
    'NtUserBitBltSysBmp', # 0xcf
    'NtGdiGetCharWidthInfo', # 0xd0
    'NtUserValidateRect', # 0xd1
    'NtUserCloseClipboard', # 0xd2
    'NtUserOpenClipboard', # 0xd3
    'NtGdiGetStockObject', # 0xd4
    'NtUserSetClipboardData', # 0xd5
    'NtUserEnableMenuItem', # 0xd6
    'NtUserAlterWindowStyle', # 0xd7
    'NtGdiFillRgn', # 0xd8
    'NtUserGetWindowPlacement', # 0xd9
    'NtGdiModifyWorldTransform', # 0xda
    'NtGdiGetFontData', # 0xdb
    'NtUserGetOpenClipboardWindow', # 0xdc
    'NtUserSetThreadState', # 0xdd
    'NtGdiOpenDCW', # 0xde
    'NtUserTrackMouseEvent', # 0xdf
    'NtGdiGetTransform', # 0xe0
    'NtUserDestroyMenu', # 0xe1
    'NtGdiGetBitmapBits', # 0xe2
    'NtUserConsoleControl', # 0xe3
    'NtUserSetActiveWindow', # 0xe4
    'NtUserSetInformationThread', # 0xe5
    'NtUserSetWindowPlacement', # 0xe6
    'NtUserGetControlColor', # 0xe7
    'NtGdiSetMetaRgn', # 0xe8
    'NtGdiSetMiterLimit', # 0xe9
    'NtGdiSetVirtualResolution', # 0xea
    'NtGdiGetRasterizerCaps', # 0xeb
    'NtUserSetWindowWord', # 0xec
    'NtUserGetClipboardFormatName', # 0xed
    'NtUserRealInternalGetMessage', # 0xee
    'NtUserCreateLocalMemHandle', # 0xef
    'NtUserAttachThreadInput', # 0xf0
    'NtGdiCreateHalftonePalette', # 0xf1
    'NtUserPaintMenuBar', # 0xf2
    'NtUserSetKeyboardState', # 0xf3
    'NtGdiCombineTransform', # 0xf4
    'NtUserCreateAcceleratorTable', # 0xf5
    'NtUserGetCursorFrameInfo', # 0xf6
    'NtUserGetAltTabInfo', # 0xf7
    'NtUserGetCaretBlinkTime', # 0xf8
    'NtGdiQueryFontAssocInfo', # 0xf9
    'NtUserProcessConnect', # 0xfa
    'NtUserEnumDisplayDevices', # 0xfb
    'NtUserEmptyClipboard', # 0xfc
    'NtUserGetClipboardData', # 0xfd
    'NtUserRemoveMenu', # 0xfe
    'NtGdiSetBoundsRect', # 0xff
    'NtUserSetInformationProcess', # 0x100
    'NtGdiGetBitmapDimension', # 0x101
    'NtUserConvertMemHandle', # 0x102
    'NtUserDestroyAcceleratorTable', # 0x103
    'NtUserGetGUIThreadInfo', # 0x104
    'NtGdiCloseFigure', # 0x105
    'NtUserSetWindowsHookAW', # 0x106
    'NtUserSetMenuDefaultItem', # 0x107
    'NtUserCheckMenuItem', # 0x108
    'NtUserSetWinEventHook', # 0x109
    'NtUserUnhookWinEvent', # 0x10a
    'NtGdiSetupPublicCFONT', # 0x10b
    'NtUserLockWindowUpdate', # 0x10c
    'NtUserSetSystemMenu', # 0x10d
    'NtUserThunkedMenuInfo', # 0x10e
    'NtGdiBeginPath', # 0x10f
    'NtGdiEndPath', # 0x110
    'NtGdiFillPath', # 0x111
    'NtUserCallHwnd', # 0x112
    'NtUserDdeInitialize', # 0x113
    'NtUserModifyUserStartupInfoFlags', # 0x114
    'NtUserCountClipboardFormats', # 0x115
    'NtGdiAddFontMemResourceEx', # 0x116
    'NtGdiEqualRgn', # 0x117
    'NtGdiGetSystemPaletteUse', # 0x118
    'NtGdiRemoveFontMemResourceEx', # 0x119
    'NtUserEnumDisplaySettings', # 0x11a
    'NtUserPaintDesktop', # 0x11b
    'NtGdiExtEscape', # 0x11c
    'NtGdiSetBitmapDimension', # 0x11d
    'NtGdiSetFontEnumeration', # 0x11e
    'NtUserChangeClipboardChain', # 0x11f
    'NtUserResolveDesktop', # 0x120
    'NtUserSetClipboardViewer', # 0x121
    'NtUserShowWindowAsync', # 0x122
    'NtUserSetConsoleReserveKeys', # 0x123
    'NtGdiCreateColorSpace', # 0x124
    'NtGdiDeleteColorSpace', # 0x125
    'NtUserActivateKeyboardLayout', # 0x126
    'NtGdiAbortDoc', # 0x127
    'NtGdiAbortPath', # 0x128
    'NtGdiAddEmbFontToDC', # 0x129
    'NtGdiAddFontResourceW', # 0x12a
    'NtGdiAddRemoteFontToDC', # 0x12b
    'NtGdiAddRemoteMMInstanceToDC', # 0x12c
    'NtGdiAngleArc', # 0x12d
    'NtGdiAnyLinkedFonts', # 0x12e
    'NtGdiArcInternal', # 0x12f
    'NtGdiBRUSHOBJ_DeleteRbrush', # 0x130
    'NtGdiBRUSHOBJ_hGetColorTransform', # 0x131
    'NtGdiBRUSHOBJ_pvAllocRbrush', # 0x132
    'NtGdiBRUSHOBJ_pvGetRbrush', # 0x133
    'NtGdiBRUSHOBJ_ulGetBrushColor', # 0x134
    'NtGdiCLIPOBJ_bEnum', # 0x135
    'NtGdiCLIPOBJ_cEnumStart', # 0x136
    'NtGdiCLIPOBJ_ppoGetPath', # 0x137
    'NtGdiCancelDC', # 0x138
    'NtGdiChangeGhostFont', # 0x139
    'NtGdiCheckBitmapBits', # 0x13a
    'NtGdiClearBitmapAttributes', # 0x13b
    'NtGdiClearBrushAttributes', # 0x13c
    'NtGdiColorCorrectPalette', # 0x13d
    'NtGdiConvertMetafileRect', # 0x13e
    'NtGdiCreateColorTransform', # 0x13f
    'NtGdiCreateEllipticRgn', # 0x140
    'NtGdiCreateHatchBrushInternal', # 0x141
    'NtGdiCreateMetafileDC', # 0x142
    'NtGdiCreateRoundRectRgn', # 0x143
    'NtGdiCreateServerMetaFile', # 0x144
    'NtGdiD3dContextCreate', # 0x145
    'NtGdiD3dContextDestroy', # 0x146
    'NtGdiD3dContextDestroyAll', # 0x147
    'NtGdiD3dValidateTextureStageState', # 0x148
    'NtGdiDdAddAttachedSurface', # 0x149
    'NtGdiDdAlphaBlt', # 0x14a
    'NtGdiDdAttachSurface', # 0x14b
    'NtGdiDdBeginMoCompFrame', # 0x14c
    'NtGdiDdCanCreateD3DBuffer', # 0x14d
    'NtGdiDdColorControl', # 0x14e
    'NtGdiDdCreateD3DBuffer', # 0x14f
    'NtGdiDdCreateDirectDrawObject', # 0x150
    'NtGdiDdCreateMoComp', # 0x151
    'NtGdiDdDeleteDirectDrawObject', # 0x152
    'NtGdiDdDestroyD3DBuffer', # 0x153
    'NtGdiDdDestroyMoComp', # 0x154
    'NtGdiDdEndMoCompFrame', # 0x155
    'NtGdiDdFlip', # 0x156
    'NtGdiDdFlipToGDISurface', # 0x157
    'NtGdiDdGetAvailDriverMemory', # 0x158
    'NtGdiDdGetBltStatus', # 0x159
    'NtGdiDdGetDC', # 0x15a
    'NtGdiDdGetDriverInfo', # 0x15b
    'NtGdiDdGetDriverState', # 0x15c
    'NtGdiDdGetDxHandle', # 0x15d
    'NtGdiDdGetFlipStatus', # 0x15e
    'NtGdiDdGetInternalMoCompInfo', # 0x15f
    'NtGdiDdGetMoCompBuffInfo', # 0x160
    'NtGdiDdGetMoCompFormats', # 0x161
    'NtGdiDdGetMoCompGuids', # 0x162
    'NtGdiDdGetScanLine', # 0x163
    'NtGdiDdLock', # 0x164
    'NtGdiDdQueryDirectDrawObject', # 0x165
    'NtGdiDdQueryMoCompStatus', # 0x166
    'NtGdiDdReenableDirectDrawObject', # 0x167
    'NtGdiDdReleaseDC', # 0x168
    'NtGdiDdRenderMoComp', # 0x169
    'NtGdiDdSetColorKey', # 0x16a
    'NtGdiDdSetExclusiveMode', # 0x16b
    'NtGdiDdSetGammaRamp', # 0x16c
    'NtGdiDdSetOverlayPosition', # 0x16d
    'NtGdiDdUnattachSurface', # 0x16e
    'NtGdiDdUnlock', # 0x16f
    'NtGdiDdUpdateOverlay', # 0x170
    'NtGdiDdWaitForVerticalBlank', # 0x171
    'NtGdiDeleteColorTransform', # 0x172
    'NtGdiDescribePixelFormat', # 0x173
    'NtGdiDoBanding', # 0x174
    'NtGdiDrawEscape', # 0x175
    'NtGdiDvpAcquireNotification', # 0x176
    'NtGdiDvpCanCreateVideoPort', # 0x177
    'NtGdiDvpColorControl', # 0x178
    'NtGdiDvpCreateVideoPort', # 0x179
    'NtGdiDvpDestroyVideoPort', # 0x17a
    'NtGdiDvpFlipVideoPort', # 0x17b
    'NtGdiDvpGetVideoPortBandwidth', # 0x17c
    'NtGdiDvpGetVideoPortConnectInfo', # 0x17d
    'NtGdiDvpGetVideoPortField', # 0x17e
    'NtGdiDvpGetVideoPortFlipStatus', # 0x17f
    'NtGdiDvpGetVideoPortInputFormats', # 0x180
    'NtGdiDvpGetVideoPortLine', # 0x181
    'NtGdiDvpGetVideoPortOutputFormats', # 0x182
    'NtGdiDvpGetVideoSignalStatus', # 0x183
    'NtGdiDvpReleaseNotification', # 0x184
    'NtGdiDvpUpdateVideoPort', # 0x185
    'NtGdiDvpWaitForVideoPortSync', # 0x186
    'NtGdiDxgGenericThunk', # 0x187
    'NtGdiEllipse', # 0x188
    'NtGdiEnableEudc', # 0x189
    'NtGdiEndDoc', # 0x18a
    'NtGdiEndPage', # 0x18b
    'NtGdiEngAlphaBlend', # 0x18c
    'NtGdiEngAssociateSurface', # 0x18d
    'NtGdiEngBitBlt', # 0x18e
    'NtGdiEngCheckAbort', # 0x18f
    'NtGdiEngComputeGlyphSet', # 0x190
    'NtGdiEngCopyBits', # 0x191
    'NtGdiEngCreateBitmap', # 0x192
    'NtGdiEngCreateClip', # 0x193
    'NtGdiEngCreateDeviceBitmap', # 0x194
    'NtGdiEngCreateDeviceSurface', # 0x195
    'NtGdiEngCreatePalette', # 0x196
    'NtGdiEngDeleteClip', # 0x197
    'NtGdiEngDeletePalette', # 0x198
    'NtGdiEngDeletePath', # 0x199
    'NtGdiEngDeleteSurface', # 0x19a
    'NtGdiEngEraseSurface', # 0x19b
    'NtGdiEngFillPath', # 0x19c
    'NtGdiEngGradientFill', # 0x19d
    'NtGdiEngLineTo', # 0x19e
    'NtGdiEngLockSurface', # 0x19f
    'NtGdiEngMarkBandingSurface', # 0x1a0
    'NtGdiEngPaint', # 0x1a1
    'NtGdiEngPlgBlt', # 0x1a2
    'NtGdiEngStretchBlt', # 0x1a3
    'NtGdiEngStretchBltROP', # 0x1a4
    'NtGdiEngStrokeAndFillPath', # 0x1a5
    'NtGdiEngStrokePath', # 0x1a6
    'NtGdiEngTextOut', # 0x1a7
    'NtGdiEngTransparentBlt', # 0x1a8
    'NtGdiEngUnlockSurface', # 0x1a9
    'NtGdiEnumObjects', # 0x1aa
    'NtGdiEudcLoadUnloadLink', # 0x1ab
    'NtGdiExtFloodFill', # 0x1ac
    'NtGdiFONTOBJ_cGetAllGlyphHandles', # 0x1ad
    'NtGdiFONTOBJ_cGetGlyphs', # 0x1ae
    'NtGdiFONTOBJ_pQueryGlyphAttrs', # 0x1af
    'NtGdiFONTOBJ_pfdg', # 0x1b0
    'NtGdiFONTOBJ_pifi', # 0x1b1
    'NtGdiFONTOBJ_pvTrueTypeFontFile', # 0x1b2
    'NtGdiFONTOBJ_pxoGetXform', # 0x1b3
    'NtGdiFONTOBJ_vGetInfo', # 0x1b4
    'NtGdiFlattenPath', # 0x1b5
    'NtGdiFontIsLinked', # 0x1b6
    'NtGdiForceUFIMapping', # 0x1b7
    'NtGdiFrameRgn', # 0x1b8
    'NtGdiFullscreenControl', # 0x1b9
    'NtGdiGetBoundsRect', # 0x1ba
    'NtGdiGetCharABCWidthsW', # 0x1bb
    'NtGdiGetCharacterPlacementW', # 0x1bc
    'NtGdiGetColorAdjustment', # 0x1bd
    'NtGdiGetColorSpaceforBitmap', # 0x1be
    'NtGdiGetDeviceCaps', # 0x1bf
    'NtGdiGetDeviceCapsAll', # 0x1c0
    'NtGdiGetDeviceGammaRamp', # 0x1c1
    'NtGdiGetDeviceWidth', # 0x1c2
    'NtGdiGetDhpdev', # 0x1c3
    'NtGdiGetETM', # 0x1c4
    'NtGdiGetEmbUFI', # 0x1c5
    'NtGdiGetEmbedFonts', # 0x1c6
    'NtGdiGetEudcTimeStampEx', # 0x1c7
    'NtGdiGetFontResourceInfoInternalW', # 0x1c8
    'NtGdiGetFontUnicodeRanges', # 0x1c9
    'NtGdiGetGlyphIndicesW', # 0x1ca
    'NtGdiGetGlyphIndicesWInternal', # 0x1cb
    'NtGdiGetGlyphOutline', # 0x1cc
    'NtGdiGetKerningPairs', # 0x1cd
    'NtGdiGetLinkedUFIs', # 0x1ce
    'NtGdiGetMiterLimit', # 0x1cf
    'NtGdiGetMonitorID', # 0x1d0
    'NtGdiGetObjectBitmapHandle', # 0x1d1
    'NtGdiGetPath', # 0x1d2
    'NtGdiGetPerBandInfo', # 0x1d3
    'NtGdiGetRealizationInfo', # 0x1d4
    'NtGdiGetServerMetaFileBits', # 0x1d5
    'NtGdiGetSpoolMessage', # 0x1d6
    'NtGdiGetStats', # 0x1d7
    'NtGdiGetStringBitmapW', # 0x1d8
    'NtGdiGetTextExtentExW', # 0x1d9
    'NtGdiGetUFI', # 0x1da
    'NtGdiGetUFIPathname', # 0x1db
    'NtGdiGradientFill', # 0x1dc
    'NtGdiHT_Get8BPPFormatPalette', # 0x1dd
    'NtGdiHT_Get8BPPMaskPalette', # 0x1de
    'NtGdiIcmBrushInfo', # 0x1df
    'NtGdiInit', # 0x1e0
    'NtGdiInitSpool', # 0x1e1
    'NtGdiMakeFontDir', # 0x1e2
    'NtGdiMakeInfoDC', # 0x1e3
    'NtGdiMakeObjectUnXferable', # 0x1e4
    'NtGdiMakeObjectXferable', # 0x1e5
    'NtGdiMirrorWindowOrg', # 0x1e6
    'NtGdiMonoBitmap', # 0x1e7
    'NtGdiMoveTo', # 0x1e8
    'NtGdiOffsetClipRgn', # 0x1e9
    'NtGdiPATHOBJ_bEnum', # 0x1ea
    'NtGdiPATHOBJ_bEnumClipLines', # 0x1eb
    'NtGdiPATHOBJ_vEnumStart', # 0x1ec
    'NtGdiPATHOBJ_vEnumStartClipLines', # 0x1ed
    'NtGdiPATHOBJ_vGetBounds', # 0x1ee
    'NtGdiPathToRegion', # 0x1ef
    'NtGdiPlgBlt', # 0x1f0
    'NtGdiPolyDraw', # 0x1f1
    'NtGdiPolyTextOutW', # 0x1f2
    'NtGdiPtInRegion', # 0x1f3
    'NtGdiPtVisible', # 0x1f4
    'NtGdiQueryFonts', # 0x1f5
    'NtGdiRemoveFontResourceW', # 0x1f6
    'NtGdiRemoveMergeFont', # 0x1f7
    'NtGdiResetDC', # 0x1f8
    'NtGdiResizePalette', # 0x1f9
    'NtGdiRoundRect', # 0x1fa
    'NtGdiSTROBJ_bEnum', # 0x1fb
    'NtGdiSTROBJ_bEnumPositionsOnly', # 0x1fc
    'NtGdiSTROBJ_bGetAdvanceWidths', # 0x1fd
    'NtGdiSTROBJ_dwGetCodePage', # 0x1fe
    'NtGdiSTROBJ_vEnumStart', # 0x1ff
    'NtGdiScaleViewportExtEx', # 0x200
    'NtGdiScaleWindowExtEx', # 0x201
    'GreSelectBrush', # 0x202
    'NtGdiSelectClipPath', # 0x203
    'NtGdiSelectPen', # 0x204
    'NtGdiSetBitmapAttributes', # 0x205
    'NtGdiSetBrushAttributes', # 0x206
    'NtGdiSetColorAdjustment', # 0x207
    'NtGdiSetColorSpace', # 0x208
    'NtGdiSetDeviceGammaRamp', # 0x209
    'NtGdiSetFontXform', # 0x20a
    'NtGdiSetIcmMode', # 0x20b
    'NtGdiSetLinkedUFIs', # 0x20c
    'NtGdiSetMagicColors', # 0x20d
    'NtGdiSetPUMPDOBJ', # 0x20e
    'NtGdiSetPixelFormat', # 0x20f
    'NtGdiSetRectRgn', # 0x210
    'NtGdiSetSizeDevice', # 0x211
    'NtGdiSetSystemPaletteUse', # 0x212
    'NtGdiSetTextJustification', # 0x213
    'NtGdiStartDoc', # 0x214
    'NtGdiStartPage', # 0x215
    'NtGdiStrokeAndFillPath', # 0x216
    'NtGdiStrokePath', # 0x217
    'NtGdiSwapBuffers', # 0x218
    'NtGdiTransparentBlt', # 0x219
    'NtGdiUMPDEngFreeUserMem', # 0x21a
    'NtGdiUnloadPrinterDriver', # 0x21b
    'EngRestoreFloatingPointState', # 0x21c
    'NtGdiUpdateColors', # 0x21d
    'NtGdiUpdateTransform', # 0x21e
    'NtGdiWidenPath', # 0x21f
    'NtGdiXFORMOBJ_bApplyXform', # 0x220
    'NtGdiXFORMOBJ_iGetXform', # 0x221
    'NtGdiXLATEOBJ_cGetPalette', # 0x222
    'NtGdiXLATEOBJ_hGetColorTransform', # 0x223
    'NtGdiXLATEOBJ_iXlate', # 0x224
    'NtUserAssociateInputContext', # 0x225
    'NtUserBlockInput', # 0x226
    'NtUserBuildHimcList', # 0x227
    'NtUserBuildPropList', # 0x228
    'NtUserCallHwndOpt', # 0x229
    'NtUserChangeDisplaySettings', # 0x22a
    'NtUserChildWindowFromPointEx', # 0x22b
    'NtUserClipCursor', # 0x22c
    'NtUserCreateDesktop', # 0x22d
    'NtUserCreateInputContext', # 0x22e
    'NtUserCreateWindowStation', # 0x22f
    'NtUserCtxDisplayIOCtl', # 0x230
    'NtUserDdeGetQualityOfService', # 0x231
    'NtUserDdeSetQualityOfService', # 0x232
    'NtUserDestroyInputContext', # 0x233
    'NtUserDisableThreadIme', # 0x234
    'NtUserDragDetect', # 0x235
    'NtUserDragObject', # 0x236
    'NtUserDrawAnimatedRects', # 0x237
    'NtUserDrawCaption', # 0x238
    'NtUserDrawCaptionTemp', # 0x239
    'NtUserDrawMenuBarTemp', # 0x23a
    'NtUserEndMenu', # 0x23b
    'NtUserEvent', # 0x23c
    'NtUserFlashWindowEx', # 0x23d
    'NtUserGetAppImeLevel', # 0x23e
    'NtUserGetCaretPos', # 0x23f
    'NtUserGetClipCursor', # 0x240
    'NtUserGetClipboardViewer', # 0x241
    'NtUserGetComboBoxInfo', # 0x242
    'NtUserGetCursorInfo', # 0x243
    'NtUserGetGuiResources', # 0x244
    'NtUserGetImeHotKey', # 0x245
    'NtUserGetImeInfoEx', # 0x246
    'NtUserGetInternalWindowPos', # 0x247
    'NtUserGetKeyNameText', # 0x248
    'NtUserGetKeyboardLayoutName', # 0x249
    'NtUserGetLayeredWindowAttributes', # 0x24a
    'NtUserGetListBoxInfo', # 0x24b
    'NtUserGetMenuIndex', # 0x24c
    'NtUserGetMenuItemRect', # 0x24d
    'NtUserGetMouseMovePointsEx', # 0x24e
    'NtUserGetPriorityClipboardFormat', # 0x24f
    'NtUserGetRawInputBuffer', # 0x250
    'NtUserGetRawInputData', # 0x251
    'NtUserGetRawInputDeviceInfo', # 0x252
    'NtUserGetRawInputDeviceList', # 0x253
    'NtUserGetRegisteredRawInputDevices', # 0x254
    'NtUserGetWOWClass', # 0x255
    'NtUserHardErrorControl', # 0x256
    'NtUserHiliteMenuItem', # 0x257
    'NtUserImpersonateDdeClientWindow', # 0x258
    'NtUserInitTask', # 0x259
    'NtUserInitialize', # 0x25a
    'NtUserInitializeClientPfnArrays', # 0x25b
    'NtUserLoadKeyboardLayoutEx', # 0x25c
    'NtUserLockWindowStation', # 0x25d
    'NtUserLockWorkStation', # 0x25e
    'NtUserMNDragLeave', # 0x25f
    'NtUserMNDragOver', # 0x260
    'NtUserMenuItemFromPoint', # 0x261
    'NtUserMinMaximize', # 0x262
    'NtUserNotifyIMEStatus', # 0x263
    'NtUserOpenInputDesktop', # 0x264
    'NtUserPrintWindow', # 0x265
    'NtUserQueryInformationThread', # 0x266
    'NtUserQueryInputContext', # 0x267
    'NtUserQuerySendMessage', # 0x268
    'NtUserRealChildWindowFromPoint', # 0x269
    'NtUserRealWaitMessageEx', # 0x26a
    'NtUserRegisterHotKey', # 0x26b
    'NtUserRegisterRawInputDevices', # 0x26c
    'NtUserRegisterTasklist', # 0x26d
    'NtUserRegisterUserApiHook', # 0x26e
    'NtUserRemoteConnect', # 0x26f
    'NtUserRemoteRedrawRectangle', # 0x270
    'NtUserRemoteRedrawScreen', # 0x271
    'NtUserRemoteStopScreenUpdates', # 0x272
    'NtUserResolveDesktopForWOW', # 0x273
    'NtUserSetAppImeLevel', # 0x274
    'NtUserSetClassWord', # 0x275
    'NtUserSetCursorContents', # 0x276
    'NtUserSetImeHotKey', # 0x277
    'NtUserSetImeInfoEx', # 0x278
    'NtUserSetImeOwnerWindow', # 0x279
    'NtUserSetInternalWindowPos', # 0x27a
    'NtUserSetLayeredWindowAttributes', # 0x27b
    'NtUserSetLogonNotifyWindow', # 0x27c
    'NtUserSetMenu', # 0x27d
    'NtUserSetMenuContextHelpId', # 0x27e
    'NtUserSetMenuFlagRtoL', # 0x27f
    'NtUserSetObjectInformation', # 0x280
    'NtUserSetShellWindowEx', # 0x281
    'NtUserSetSysColors', # 0x282
    'NtUserSetSystemCursor', # 0x283
    'NtUserSetSystemTimer', # 0x284
    'NtUserSetThreadLayoutHandles', # 0x285
    'NtUserSetWindowStationUser', # 0x286
    'NtUserSoundSentry', # 0x287
    'NtUserSwitchDesktop', # 0x288
    'NtUserTestForInteractiveUser', # 0x289
    'NtUserTrackPopupMenuEx', # 0x28a
    'NtUserUnloadKeyboardLayout', # 0x28b
    'NtUserUnlockWindowStation', # 0x28c
    'NtUserUnregisterHotKey', # 0x28d
    'NtUserUnregisterUserApiHook', # 0x28e
    'NtUserUpdateInputContext', # 0x28f
    'NtUserUpdateInstance', # 0x290
    'NtUserUpdateLayeredWindow', # 0x291
    'NtUserUpdatePerUserSystemParameters', # 0x292
    'NtUserUserHandleGrantAccess', # 0x293
    'NtUserValidateHandleSecure', # 0x294
    'NtUserWaitForInputIdle', # 0x295
    'NtUserWaitForMsgAndEvent', # 0x296
    'NtUserSetClassLongPtr', # 0x297
    'NtUserSetWindowLongPtr', # 0x298
    'NtUserWin32PoolAllocationStats', # 0x299
    'NtUserYieldTask', # 0x29a
    ],
]
