;; HEXAGON machine description.
;; Copyright (C) 1998, 1999, 2000, 2002 Free Software Foundation, Inc.

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.


;;-----------;;
;; Constants ;;
;;-----------;;

(define_constants
  [(PIC_REGNUM		      24) ; PIC register
   (TLS_REGNUM		      25) ; TLS pointer, or scratch when TLS not in use
   (SP_REGNUM		      29) ; stack pointer
   (FP_REGNUM		      30) ; frame pointer
   (LINK_REGNUM		      31) ; link register
   (P0_REGNUM		      32) ; p0
   (P1_REGNUM		      33) ; p1
   (P2_REGNUM		      34) ; p2
   (P3_REGNUM		      35) ; p3
   (SA0_REGNUM		      36) ; loop0 start address
   (LC0_REGNUM		      37) ; loop0 count
   (SA1_REGNUM		      38) ; loop1 start address
   (LC1_REGNUM		      39) ; loop1 count
   (M0_REGNUM		      40) ; modifier register 0
   (M1_REGNUM		      41) ; modifier register 1
   (DUPLEX_PRED_REG	      32) ; Duplex predicate register
   (DUPLEX_REG_LOW_START       0) ; First range of duplex registers
   (DUPLEX_REG_LOW_END	       7) ; First range of duplex registers
   (DUPLEX_REG_HIGH_START     16) ; Second range of duplex registers
   (DUPLEX_REG_HIGH_END       23) ; Second range of duplex registers
   (UNSPEC_SIBCALL	     100) ; call to sibling
   (UNSPEC_VEC_SHL	     101) ; whole-vector shift left
   (UNSPEC_VEC_SHR	     102) ; Whole-vector shift right
   (UNSPEC_REALIGN_LOAD	     103) ; Realignment of loaded vals
   (UNSPEC_REALIGN_SETUP     104) ; Realignment of loaded vals
   (UNSPEC_REDUC_SMIN	     105) ; Signed min across
   (UNSPEC_REDUC_SMAX	     106) ; Signed max across
   (UNSPEC_REDUC_UMIN	     107) ; Unsigned min across
   (UNSPEC_REDUC_UMAX	     108) ; Unsigned max across
   (UNSPEC_REDUC_SPLUS	     109) ; Sum of elements.  Non-widening, so why S/U
   (UNSPEC_MULDI_1	     110) ; First part of a muldi
   (UNSPEC_MULDI_2	     111) ; second part of a muldi
   (UNSPEC_NOP		     112) ; nop for appeasing Combine
   (UNSPEC_NEW_VALUE	     114) ; R.new
   (UNSPEC_MOVSI_CONST32     115) ; const32 a + b
   (UNSPEC_HEXAGON_vcmpb_eq  150)
   (UNSPEC_HEXAGON_vcmpb_gtu 151)
   (UNSPEC_HEXAGON_any	     152)
   (UNSPEC_HEXAGON_all	     153)
   (UNSPEC_HEXAGON_falign    154)
   (UNSPEC_DOLOOP_END	     160)
   (UNSPEC_PIC_SYM_GOTOFF    161) ; For PIC GOTOFF symbols
   (UNSPEC_PIC_SYM_GOT	     162) ; For PIC GOT symbols
   (UNSPEC_TLS		     163) ; For TLS symbols
   (UNSPEC_TPREL_TLS	     164) ; For TLS TPREL symbols
   (UNSPEC_HEXAGON_hintjr    165) ; For the hintjr instruction.
   (UNSPEC_LD_TLS_INDEX	     166) ; For the result of the LD_PLT call
  ]
)


;;------------;;
;; Attributes ;;
;;------------;;

;; The architecture currently being compiled for

(define_attr "arch" "v1,v2,v3,v4,v5,v55" (const (symbol_ref "hexagon_arch")))


;; Used to determine which slots an insn can use when scheduling insns

(define_attr "type"
  "A,X,Load,Store,Allocframe,Memop,NewValue,NewLoad,LoadStore,AStore,ALoadStore,
   M,S,J,JR,CR,loop,endloop0,endloop1,EA,EX,ELoad,EStore,EMemop,ENewValue,
   ENewLoad,Eloop,EM,ES,EJ,EJR,ECR,multiple,J_dotnew,NewValueJump,ENewValueJump,
   AJ,EAJ,XJ,EXJ,dcfetch"
  (const_string "multiple"))


;; Used to identify an insn that is implemented by a call

(define_attr "emulation_call" "no,yes" (const_string "no"))


;; Used to identify compound insns

(define_attr "compound" "no,yes" (const_string "no"))


(define_attr "length" ""
  (if_then_else
    (eq_attr "type" "EAJ,EXJ,endloop1")
    (const_string "12")
    (if_then_else
      (eq_attr "type" "EA,EX,ELoad,EStore,EMemop,ENewValue,ENewValueJump,
		       ENewLoad,Eloop,EM,ES,EJ,EJR,ECR,endloop1")
      (const_string "8")
      (const_string "4"))))


;; Predicable means that the insn can be conditionally executed based on
;; an automatically added predicate (additional patterns are generated by
;; gen...).

(define_attr "predicable" "no,yes" (const_string "no"))
(define_attr "enabled" "no,yes" (const_string "yes"))

(define_cond_exec
  [(match_operator 0 "predicate_operator"
       [(match_operand:BI 1 "pr_register_operand" "Rp")
        (const_int 0)])]
  "TARGET_V4_FEATURES"
  "if (%C0)"
)

;; Two duplex instructions can be paired to reduce code size
(define_attr "duplex" "no,yes" (const_string "no"))

;; Modes used for ALU insns which may be read-modify-write memops.
(define_mode_iterator AM [QI HI SI])
;; QImode and HImode.
(define_mode_iterator AQHM [QI HI])
(define_mode_attr access_size [(DI "d") (SI "w") (HI "h") (QI "b")])

;;-----------------------------;;
;; VLIW Scheduling Description ;;
;;-----------------------------;;

;; Defines the resources of the machine and which insns use which resources
;; based on the insn attributes

(define_automaton "hexagon")

(automata_option "ndfa")

(define_query_cpu_unit
  "Slot0,Slot1,Slot2,Slot3,Store0,Store1,PCadder,PCadder_dualjumps,endloop0,
   endloop1,endloop0_dualjumps,endloop1_dualjumps"
  "hexagon")

(define_reservation "control"
  "(endloop0 + endloop1)")

(define_reservation "control_dualjumps"
  "(endloop0_dualjumps + endloop1_dualjumps)")

(define_reservation "ESlot0" "(Slot0 + (Slot1 | Slot2 | Slot3))")

(define_reservation "ESlot1" "(Slot1 + (Slot0 | Slot2 | Slot3))")

(define_reservation "ESlot2" "(Slot2 + (Slot0 | Slot1 | Slot3))")

(define_reservation "ESlot3" "(Slot3 + (Slot0 | Slot1 | Slot2))")

;; Scheduling descriptions for particular architecture versions.

(include "hexagon-v1.md")
(include "hexagon-v2.md")
(include "hexagon-v3.md")
(include "hexagon-v4.md")
(include "hexagon-v5.md")

(define_insn_reservation "multiple" 1
  (eq_attr "type" "multiple")
  "Slot0 + Slot1 + Slot2 + Slot3 + endloop0 + endloop1")


;;----------------------------;;
;; Insn Predicate Definitions ;;
;;----------------------------;;

(include "predicates.md")


;;-----------------------------;;
;; Insn Constraint Definitions ;;
;;-----------------------------;;

(include "constraints.md")


;;-----------------;;
;; Vector Patterns ;;
;;-----------------;;

;;(include "vector.md")


;;---------------;;
;; Insn Patterns ;;
;;---------------;;

;;-----------;;
;; TLS loads ;;
;;-----------;;

(define_insn "load_tls_tprel_hi"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(high:SI (unspec:SI [(match_operand:SI 1 "tls_symbolic_operand" "")]
			    UNSPEC_TPREL_TLS)))]
  "TARGET_HAVE_TLS"
  "%0.h = #HI(%1@DTPREL)"
  [(set_attr "type" "A")]
)


(define_insn "load_tls_tprel_lo"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(lo_sum:SI (match_operand:SI 1 "gr_register_operand" "0")
		   (unspec:SI [(match_operand:SI 2 "tls_symbolic_operand" "")]
			      UNSPEC_TPREL_TLS)))]
  "TARGET_HAVE_TLS"
  "%0.l = #LO(%2@DTPREL)"
  [(set_attr "type" "A")]
)


(define_insn "load_tls_hi"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(high:SI (unspec:SI [(match_operand:SI 1 "tls_symbolic_operand" "")]
			    UNSPEC_TLS)))]
  "TARGET_HAVE_TLS"
  {
    int model = SYMBOL_REF_TLS_MODEL (operands[1]);

    switch (model)
      {
      case TLS_MODEL_GLOBAL_DYNAMIC:
	return "%0.h = #HI(%1@GDGOT)";

      case TLS_MODEL_LOCAL_DYNAMIC:
	return "%0.h = #HI(%1@LDGOT)";

      case TLS_MODEL_INITIAL_EXEC:
	if (!flag_pic)
	  return "%0.h = #HI(%1@IE)";
	else
	  return "%0.h = #HI(%1@IEGOT)";

      case TLS_MODEL_LOCAL_EXEC:
	return "%0.h = #HI(%1@TPREL)";

      default:
	gcc_unreachable ();
      }
  }
  [(set_attr "type" "A")]
)


(define_insn "load_tls_lo"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(lo_sum:SI (match_operand:SI 1 "gr_register_operand" "0")
		   (unspec:SI [(match_operand:SI 2 "tls_symbolic_operand" "")]
			      UNSPEC_TLS)))]
  "TARGET_HAVE_TLS"
  {
    int model = SYMBOL_REF_TLS_MODEL (operands[2]);

    switch (model)
      {
      case TLS_MODEL_GLOBAL_DYNAMIC:
	return "%0.l = #LO(%2@GDGOT)";

      case TLS_MODEL_LOCAL_DYNAMIC:
	return "%0.l = #LO(%2@LDGOT)";

      case TLS_MODEL_INITIAL_EXEC:
	if (!flag_pic)
	  return "%0.l = #LO(%2@IE)";
	else
	  return "%0.l = #LO(%2@IEGOT)";

      case TLS_MODEL_LOCAL_EXEC:
	return "%0.l = #LO(%2@TPREL)";

      default:
	gcc_unreachable ();
      }
  }
  [(set_attr "type" "A")]
)


;;---------;;
;; PIC mov ;;
;;---------;;

;; Compute offset for PIC mode via @GOTOFF

(define_insn "pic_movsi_hi_gotoff"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(high:SI (unspec:SI [(match_operand:SI 1 "sym_or_lab_operand" "")]
			    UNSPEC_PIC_SYM_GOTOFF)))]
  "flag_pic"
  "%0.h = #HI(%1@GOTOFF)"
  [(set_attr "type" "A")]
)

(define_insn "pic_movsi_lo_gotoff"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(lo_sum:SI (match_operand:SI 1 "gr_register_operand" "0")
		   (unspec:SI [(match_operand:SI 2 "sym_or_lab_operand" "")]
			      UNSPEC_PIC_SYM_GOTOFF)))]
  "flag_pic"
  "%0.l = #LO(%2@GOTOFF)"
  [(set_attr "type" "A")]
)

(define_insn "pic_movsi_pcrel"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(unspec:SI [(plus:SI (pc)
			     (match_operand:SI 1 "sym_or_lab_operand" ""))]
		   UNSPEC_PIC_SYM_GOTOFF))]
  "flag_pic && TARGET_V4_FEATURES"
  "%0 = add(pc,##%1@PCREL)"
  [(set_attr "type" "ECR")]
)

;; Compute global offset for PIC mode via @GOT

(define_insn "pic_movsi"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(unspec:SI [(match_operand:HI 1 "general_operand" "")]
		   UNSPEC_PIC_SYM_GOT))]
  "flag_pic"
  "%0 = #%1@GOT"
  [(set_attr "type" "A")]
)

(define_insn "pic_movsi_hi_got"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(high:SI (unspec:SI [(match_operand:SI 1 "sym_or_lab_operand" "")]
			    UNSPEC_PIC_SYM_GOT)))]
  "flag_pic"
  "%0.h = #HI(%1@GOT)"
  [(set_attr "type" "A")]
)

(define_insn "pic_movsi_lo_got"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(lo_sum:SI (match_operand:SI 1 "gr_register_operand" "0")
		   (unspec:SI [(match_operand:SI 2 "sym_or_lab_operand" "")]
			      UNSPEC_PIC_SYM_GOT)))]
  "flag_pic"
  "%0.l = #LO(%2@GOT)"
  [(set_attr "type" "A")]
)

(define_insn "pic_movsi_got_v4"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(unspec:SI [(plus:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			     (match_operand:SI 2 "sym_or_lab_operand" ""))]
		   UNSPEC_PIC_SYM_GOT))]
  "flag_pic && TARGET_V4_FEATURES"
  "%0 = memw(%1+##%2@GOT)"
  [(set_attr "type" "ELoad")]
)

;;--------;;
;; mov{m} ;;
;;--------;;

(define_expand "movbi"
  [(set (match_operand:BI 0 "nonimmediate_operand" "")
	(match_operand:BI 1 "general_operand" ""))]
  ""
  {
    if (GET_CODE (operands[0]) != REG)
      operands[1] = force_reg(BImode, operands[1]);
  }
)

(define_insn "movbi_real"
  [(set (match_operand:BI 0 "nonimmediate_operand"
	  "=Rp, Rp,Rp,?*Rg,?Rp,*Rg,?*Rg,?*Rg,?*Rg,?*Anx,?*m,?*Rg")
	(match_operand:BI 1 "general_operand"
	  "Iu0,Iu1,Rp,  Rp,*Rg,*Rg,*Ad3,*Anx,  *m,  *Rg,*Rg, Iu1"))]
  "!(memory_operand(operands[0], BImode)
     && immediate_operand(operands[1], BImode))"
  "@
   %0 = cmp.gt(r0,r0)
   %0 = cmp.eq(r0,r0)
   %0 = or(%1,%1) //pred=pred(BI)
   %0 = mux(%1,#1,#0) //reg=pred(BI)
   %0 = tstbit(%1,#0) //pred=reg(BI)
   %0 = %1 //reg=reg(BI)
   %0 = memub(%1) //load(BI)
   %0 = memub(%1) //load(BI)
   %0 = memub(%E1) //load(BI)
   memb(%0) = %1 //store(BI)
   memb(%E0) = %1 //store(BI)
   %0 = #%1"
  [(set_attr "type" "A,A,S,A,S,A,Load,Load,ELoad,Store,EStore,A")
   (set_attr "duplex" "no,no,no,no,no,no,yes,no,no,no,no,no")]
)

(define_insn "movbi_new_value"
  [(set (match_operand:BI 0 "nonimmediate_operand"	     "=Anx, m, Rg,Rg")
	(unspec:BI [(match_operand:BI 1 "nonimmediate_operand" "Rg,Rg,Anx, m")]
		   UNSPEC_NEW_VALUE))]
  "TARGET_V4_FEATURES"
  "@
   memb(%0) = %1.new //store(BI)
   memb(%E0) = %1.new //store(BI)
   %0 = memb(%1).new //load(BI)
   %0 = memb(%E1).new //load(BI)"
  [(set_attr "type" "NewValue,ENewValue,NewLoad,ENewLoad")]
)

;;-------;;
;; movqi ;;
;;-------;;

(define_expand "movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(match_operand:QI 1 "general_operand" ""))]
  ""
  {
    rtx reg;
    if (TARGET_SECTION_SORTING_CODE_SUPPORT && TARGET_SECTION_SORTING
	&& can_create_pseudo_p ())
      {
	if (MEM_P (operands[0]) && !GP_or_reg_operand (operands[0], QImode))
	  {
	    reg = gen_reg_rtx (Pmode);
	    emit_move_insn (reg, XEXP (operands[0], 0));
	    operands[0] = change_address (operands[0], QImode, reg);
	  }
	else if (MEM_P (operands[1])
		 && !GP_or_reg_operand (operands[1], QImode))
	  {
	    reg = gen_reg_rtx (Pmode);
	    emit_move_insn (reg, XEXP (operands[1], 0));
	    operands[1] = change_address (operands[1], QImode, reg);
	  }
      }
    if (!(register_operand (operands[0], QImode)
	  || (TARGET_V4_FEATURES && MEM_P (operands[0])
	      && hexagon_storeimm_mem_operand (QImode, operands[0])
	      && immediate_operand (operands[1], QImode))))
      operands[1] = force_reg (QImode, operands[1]);
  }
)

(define_insn "movqi_real_v4"
  [(set (match_operand:QI 0 "nonimmediate_operand_with_GP"
	   "=Rg, Rg, Rg,Rg,Ad4,Asi,Asi,Ad4,Anx, m, Rg, Rg,?Rg,?*Rp")
	(match_operand:QI 1 "GP_or_reg_operand"
	   " Rg,Ad3,Anx, m,Iu1,Is8,  i, Rg, Rg,Rg,Iu6,IsG,*Rp,  Rg"))]
  "TARGET_V4_FEATURES"
  "@
   %0 = %1
   %0 = memb(%1)
   %0 = memb(%1)
   %0 = memb(%E1)
   memb(%0) = #%1
   memb(%0) = #%1
   memb(%0) = ##%1
   memb(%0) = %1
   memb(%0) = %1
   memb(%E0) = %1
   %0 = #%1
   %0 = #%1
   %0 = %1
   %0 = %1"
  [(set_attr "type" "A,Load,Load,ELoad,Store,Store,EStore,Store,Store,EStore,
		     A,A,S,S")
   (set_attr "duplex" "yes,yes,no,no,yes,no,no,yes,no,no,yes,no,no,no")]
)

(define_insn "movqi_new_value"
  [(set (match_operand:QI 0 "nonimmediate_operand"	     "=Anx, m, Rg,Rg")
	(unspec:QI [(match_operand:QI 1 "nonimmediate_operand" "Rg,Rg,Anx, m")]
		   UNSPEC_NEW_VALUE))]
  "TARGET_V4_FEATURES"
  "@
   memb(%0) = %1.new
   memb(%E0) = %1.new
   %0 = memb(%1).new
   %0 = memb(%E1).new"
  [(set_attr "type" "NewValue,ENewValue,NewLoad,ENewLoad")]
)

(define_insn "movqi_real"
  [(set (match_operand:QI 0 "nonimmediate_operand_with_GP"
	  "=Rg,Rg, m, Rg,?Rg,?*Rp")
	(match_operand:QI 1 "GP_or_reg_operand"
	  " Rg, m,Rg,IsG,*Rp,  Rg"))]
  "!TARGET_V4_FEATURES
   && (!memory_operand(operands[0], QImode)
       || gr_register_operand(operands[1], QImode))"
  "@
   %0 = %1
   %0 = memb(%1)
   memb(%0) = %1
   %0 = #%1
   %0 = %1
   %0 = %1"
  [(set_attr "type" "A,Load,Store,A,S,S")]
)

(define_insn "cond_movqi"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"
        				   "Rp,  Rp, Rp, Rp, Rp, Rp, Rp, Rp")
	(const_int 0)])
     (set (match_operand:QI 0 "conditional_dest_operand"
					  "=Rg, Rg, Rg,Acs,Acs,Aco,Aec, Rg")
	  (match_operand:QI 1 "conditional_src_operand"
					  " Rg,Aco,Aec,Is6,  i, Rg, Rg,IsC")))]
  ""
  "@
   if (%C2) %0 = %1
   if (%C2) %0 = memb(%1)
   if (%C2) %0 = memb(%E1)
   if (%C2) memb(%0) = #%1
   if (%C2) memb(%0) = ##%1
   if (%C2) memb(%0) = %1
   if (%C2) memb(%E0) = %1
   if (%C2) %0 = #%1"
  [(set_attr "type" "A,Load,ELoad,Store,EStore,Store,EStore,A")]
)

(define_insn "cond_movqi_new_value"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"	      "Rp, Rp, Rp, Rp")
	(const_int 0)])
     (set (match_operand:QI 0 "nonimmediate_operand"	    "=Aco,Aec, Rg, Rg")
	  (unspec:QI [(match_operand:QI 1 "nonimmediate_operand"
							      "Rg, Rg,Aco,Aec")]
		     UNSPEC_NEW_VALUE)))]
  "TARGET_V4_FEATURES"
  "@
   if (%C2) memb(%0) = %1.new
   if (%C2) memb(%E0) = %1.new
   if (%C2) %0 = memb(%1).new
   if (%C2) %0 = memb(%E1).new"
  [(set_attr "type" "NewValue,ENewValue,NewLoad,ENewLoad")]
)

;;-------;;
;; movhi ;;
;;-------;;

(define_expand "movhi"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(match_operand:HI 1 "general_operand" ""))]
  ""
  {
    rtx reg;
    if (TARGET_SECTION_SORTING_CODE_SUPPORT && TARGET_SECTION_SORTING
	&& can_create_pseudo_p ())
      {
	if (MEM_P (operands[0]) && !GP_or_reg_operand (operands[0], HImode))
	  {
	    reg = gen_reg_rtx (Pmode);
	    emit_move_insn (reg, XEXP (operands[0], 0));
	    operands[0] = change_address (operands[0], HImode, reg);
	  }
	else if (MEM_P (operands[1])
		 && !GP_or_reg_operand (operands[1], HImode))
	  {
	    reg = gen_reg_rtx (Pmode);
	    emit_move_insn (reg, XEXP (operands[1], 0));
	    operands[1] = change_address (operands[1], HImode, reg);
	  }
      }
    if (!(register_operand (operands[0], HImode)
	  || (TARGET_V4_FEATURES && MEM_P (operands[0])
	      && hexagon_storeimm_mem_operand (HImode, operands[0])
	      && s8_const_int_operand (operands[1], HImode))))
      operands[1] = force_reg (HImode, operands[1]);
  }
)

(define_insn "movhi_real_v4"
  [(set (match_operand:HI 0 "nonimmediate_operand_with_GP"
				 "=Rg, Rg, Rg,Rg,Asi,Asi,Ad3,Anx, m, Rg, Rg")
	(match_operand:HI 1 "GP_or_reg_operand"
				  "Rg,Ad3,Anx, m,Is8,  i, Rg, Rg,Rg,Iu6,IsG"))]
  "TARGET_V4_FEATURES"
  "@
   %0 = %1
   %0 = memh(%1)
   %0 = memh(%1)
   %0 = memh(%E1)
   memh(%0) = #%1
   memh(%0) = ##%1
   memh(%0) = %1
   memh(%0) = %1
   memh(%E0) = %1
   %0 = #%1
   %0 = #%1"
  [(set_attr "type" "A,Load,Load,ELoad,Store,EStore,Store,Store,EStore,A,A")
   (set_attr "duplex" "yes,yes,no,no,no,no,yes,no,no,yes,no")]
)

(define_insn "movhi_new_value"
  [(set (match_operand:HI 0 "nonimmediate_operand"	      "=Anx, m, Rg,Rg")
	(unspec:HI [(match_operand:HI 1 "nonimmediate_operand" " Rg,Rg,Anx, m")]
		   UNSPEC_NEW_VALUE))]
  "TARGET_V4_FEATURES"
  "@
   memh(%0) = %1.new
   memh(%E0) = %1.new
   %0 = memh(%1).new
   %0 = memh(%E1).new"
  [(set_attr "type" "NewValue,ENewValue,NewLoad,ENewLoad")]
)

(define_insn "movhi_real"
  [(set (match_operand:HI 0 "nonimmediate_operand_with_GP" "=Rg,Rg, m, Rg")
	(match_operand:HI 1 "GP_or_reg_operand"		   " Rg, m,Rg,IsG"))]
  "!TARGET_V4_FEATURES
   && (!memory_operand(operands[0], HImode)
       || gr_register_operand(operands[1], HImode))"
  "@
   %0 = %1
   %0 = memh(%1)
   memh(%0) = %1
   %0 = #%1"
  [(set_attr "type" "A,Load,Store,A")]
)

(define_insn "cond_movhi"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"
				       " Rp, Rp, Rp, Rp, Rp, Rp, Rp, Rp,Rp")
	(const_int 0)])
     (set (match_operand:HI 0 "conditional_dest_operand"
				       "=Rg, Rg, Rg,Acs,Acs,Aco,Aec, Rg,Rg")
	  (match_operand:HI 1 "conditional_src_operand"
				       " Rg,Aco,Aec,Is6,  i, Rg, Rg,IsC, i")))]
  ""
  "@
   if (%C2) %0 = %1
   if (%C2) %0 = memh(%1)
   if (%C2) %0 = memh(%E1)
   if (%C2) memh(%0) = #%1
   if (%C2) memh(%0) = ##%1
   if (%C2) memh(%0) = %1
   if (%C2) memh(%E0) = %1
   if (%C2) %0 = #%1
   if (%C2) %0 = ##%1"
  [(set_attr "type" "A,Load,ELoad,Store,EStore,Store,EStore,A,EA")]
)

(define_insn "cond_movhi_new_value"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"    "  Rp, Rp, Rp, Rp")
	(const_int 0)])
     (set (match_operand:HI 0 "nonimmediate_operand" "=Aco,Aec, Rg, Rg")
	  (unspec:HI [(match_operand:HI 1 "nonimmediate_operand"
						     "  Rg, Rg,Aco,Aec")]
		     UNSPEC_NEW_VALUE)))]
  "TARGET_V4_FEATURES"
  "@
   if (%C2) memh(%0) = %1.new
   if (%C2) memh(%E0) = %1.new
   if (%C2) %0 = memh(%1).new
   if (%C2) %0 = memh(%E1).new"
  [(set_attr "type" "NewValue,ENewValue,NewLoad,ENewLoad")]
)

;;-------;;
;; movsi ;;
;;-------;;

(define_expand "movsi"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(match_operand:SI 1 "general_operand" ""))]
  ""
  {
    rtx reg;
    if (TARGET_SECTION_SORTING_CODE_SUPPORT && TARGET_SECTION_SORTING
	&& can_create_pseudo_p ())
      {
	if (MEM_P (operands[0]) && !GP_or_reg_operand (operands[0], SImode))
	  {
	    reg = gen_reg_rtx (Pmode);
	    emit_move_insn (reg, XEXP (operands[0], 0));
	    operands[0] = change_address (operands[0], SImode, reg);
	  }
	else if (MEM_P (operands[1])
		 && !GP_or_reg_operand (operands[1], SImode))
	  {
	    reg = gen_reg_rtx (Pmode);
	    emit_move_insn (reg, XEXP (operands[1], 0));
	    operands[1] = change_address (operands[1], SImode, reg);
	  }
      }
    if (!register_operand (operands[0], SImode)
	&& !(TARGET_V4_FEATURES && MEM_P (operands[0])
	     && hexagon_storeimm_mem_operand (SImode, operands[0])
	     && s8_const_int_operand (operands[1], SImode)))
      operands[1] = force_reg (SImode, operands[1]);

    if ((GET_CODE (operands[1]) == SYMBOL_REF
	 || (GET_CODE (operands[1]) == CONST
	     && GET_CODE (XEXP (operands[1], 0)) == PLUS))
	&& hexagon_tls_referenced_p (operands[1]))
      {
	rtx tmp = operands[1];
	rtx addend = NULL;

	if (GET_CODE (tmp) == CONST && GET_CODE (XEXP (tmp, 0)) == PLUS)
	  {
	    addend = XEXP (XEXP (tmp, 0), 1);
	    tmp = XEXP (XEXP (tmp, 0), 0);
	  }

	gcc_assert (GET_CODE (tmp) == SYMBOL_REF);
	gcc_assert (SYMBOL_REF_TLS_MODEL (tmp) != 0);

	tmp = legitimize_tls_address (tmp);
	if (addend)
	  {
	    tmp = gen_rtx_PLUS (SImode, tmp, addend);
	    tmp = force_operand (tmp, operands[0]);
	  }
	operands[1] = tmp;
      }
    else if (flag_pic
	     && (CONSTANT_P (operands[1])
		 || symbol_mentioned_p (operands[1])
		 || label_mentioned_p (operands[1])))
      operands[1] = legitimize_pic_address (operands[1], SImode,
					    (can_create_pseudo_p ()
					     ? NULL_RTX : operands[0]));
  }
)

(define_insn "movsi_high"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(high:SI (match_operand:SI 1 "immediate_operand" "i")))]
  ""
  "%0.h = #HI(%1)"
  [(set_attr "type" "A")]
)

(define_insn "movsi_low"
  [(set (match_operand:SI 0 "gr_register_operand" "+Rg")
	(lo_sum:SI (match_operand:SI 1 "gr_register_operand" "0")
		   (match_operand:SI 2 "immediate_operand" "i")))]
  ""
  "%0.l = #LO(%2)"
  [(set_attr "type" "A")]
)

(define_insn "movsi_real_v4"
  [(set (match_operand:SI 0 "nonimmediate_operand_with_GP"
	  "=Rg, Rg, Rg, Rg,Rg,Ad4,Asi,Asi,Au5,Anx, m,    Rg, Rg,Rg,Rg,Rc")
	(match_operand:SI 1 "general_operand"
	  " Rg,Ad4,Au5,Anx, m,Iu1,Is8,  i, Rg, Rg,Rg,Km1Iu6,IsG, i,Rc,Rg"))]
  "TARGET_V4_FEATURES"
  "@
   %0 = %1
   %0 = memw(%1)
   %0 = memw(%1)
   %0 = memw(%1)
   %0 = memw(%E1)
   memw(%0) = #%1
   memw(%0) = #%1
   memw(%0) = ##%1
   memw(%0) = %1
   memw(%0) = %1
   memw(%E0) = %1
   %0 = #%1
   %0 = #%1
   %0 = ##%1
   %0 = %1
   %0 = %1"
  [(set_attr "type" "A,Load,Load,Load,ELoad,Store,Store,EStore,Store,Store,
		     EStore,A,A,EA,CR,CR")
   (set_attr "duplex" "yes,yes,yes,no,no,yes,no,no,yes,no,no,yes,no,no,no,no")]
)

(define_insn "movsi_new_value"
  [(set (match_operand:SI 0 "nonimmediate_operand"	     "=Anx, m, Rg,Rg")
	(unspec:SI [(match_operand:SI 1 "nonimmediate_operand"
							     "  Rg,Rg,Anx, m")]
		   UNSPEC_NEW_VALUE))]
  "TARGET_V4_FEATURES"
  "@
   memw(%0) = %1.new
   memw(%E0) = %1.new
   %0 = memw(%1).new
   %0 = memw(%E1).new"
  [(set_attr "type" "NewValue,ENewValue,NewLoad,ENewLoad")]
)

(define_insn "movsi_const32"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(unspec:SI [(match_operand:SI 1 "GP_or_reg_operand" "i")
		    (match_operand:SI 2 "nonmemory_operand" "i")]
		   UNSPEC_MOVSI_CONST32))]
  ""
  "%0 = CONST32(%1 + %2)"
  [(set_attr "type" "Load")]
)

(define_insn "movsi_real"
  [(set (match_operand:SI 0 "nonimmediate_operand_with_GP"
						"=Rg,Rg, m, Rg,?Rg,Rg,Rc")
	(match_operand:SI 1 "GP_or_reg_operand" " Rg, m,Rg,IsG,  i,Rc,Rg"))]
  "!TARGET_V4_FEATURES
   && (!memory_operand(operands[0], SImode)
       || gr_register_operand(operands[1], SImode))"
  {
    switch (which_alternative)
      {
      case 0:
	return "%0 = %1";
      case 1:
	return "%0 = memw(%1)";
      case 2:
	return "memw(%0) = %1";
      case 3:
	return "%0 = #%1";
      case 4:
	if (TARGET_CONST32
	    && (TARGET_LITERAL_POOL_ADDRESSES
		|| GET_CODE (operands[1]) != SYMBOL_REF))
	  return "%0 = CONST32(#%1)";
	else
	  return "#";
      case 5:
	return "%0 = %1";
      case 6:
	return "%0 = %1";
      default:
	gcc_unreachable ();
      }
  }
  [(set_attr "type" "A,Load,Store,A,Load,CR,CR")]
)

;; Split load immediates that take two assembly instructions into two
;; RTL insns so they can be scheduled separately.

(define_split
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(match_operand:SI 1 "immediate_not_s16_operand" ""))]
  "!(TARGET_CONST32
     && (TARGET_LITERAL_POOL_ADDRESSES || GET_CODE (operands[1]) != SYMBOL_REF))
   && reload_completed
   && !TARGET_V4_FEATURES"
  [(set (match_dup 0) (high:SI (match_dup 1)))
   (set (match_dup 0) (lo_sum:SI (match_dup 0) (match_dup 1)))]
  ""
)

(define_insn "cond_movsi"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"
				   " Rp, Rp, Rp, Rp, Rp, Rp, Rp, Rp, Rp,Rp")
	(const_int 0)])
     (set (match_operand:SI 0 "conditional_dest_operand"
				   "=Rg, Rg, Rg,Acs,Acs,Aco,Aec, Rg, Rg,Rg")
	  (match_operand:SI 1 "conditional_src_operand"
				   " Rg,Aco,Aec,Is6,  i, Rg, Rg,Iu0,IsC, i")))]
  ""
  "@
   if (%C2) %0 = %1
   if (%C2) %0 = memw(%1)
   if (%C2) %0 = memw(%E1)
   if (%C2) memw(%0) = #%1
   if (%C2) memw(%0) = ##%1
   if (%C2) memw(%0) = %1
   if (%C2) memw(%E0) = %1
   if (%C2) %0 = #%1
   if (%C2) %0 = #%1
   if (%C2) %0 = ##%1"
  [(set_attr "type" "A,Load,ELoad,Store,EStore,Store,EStore,A,A,EA")
   (set_attr "duplex" "no,no,no,no,no,no,no,yes,no,no")]
)

(define_insn "cond_movsi_new_value"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"    "  Rp, Rp, Rp, Rp")
	(const_int 0)])
     (set (match_operand:SI 0 "nonimmediate_operand" "=Aco,Aec, Rg, Rg")
	  (unspec:SI [(match_operand:SI 1 "nonimmediate_operand"
						     "  Rg, Rg,Aco,Aec")]
		     UNSPEC_NEW_VALUE)))]
  "TARGET_V4_FEATURES"
  "@
   if (%C2) memw(%0) = %1.new
   if (%C2) memw(%E0) = %1.new
   if (%C2) %0 = memw(%1).new
   if (%C2) %0 = memw(%E1).new"
  [(set_attr "type" "NewValue,ENewValue,NewLoad,ENewLoad")]
)

;;-------;;
;; movdi ;;
;;-------;;

(define_expand "movdi"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(match_operand:DI 1 "general_operand" ""))]
  ""
  {
    if (GET_CODE (operands[0]) != REG)
      operands[1] = force_reg (DImode, operands[1]);
  }
)

(define_insn "movdi_real"
  [(set (match_operand:DI 0 "nonimmediate_operand"
			"=Rg, Rg, Rg,Rg,As6,Anx, m, Rg, Rg, Rg, Rg,Rg,Rg,Rc")
	(match_operand:DI 1 "general_operand"
			" Rg,Au5,Anx, m, Rg, Rg,Rg,Is8,K88,K83,K38, i,Rc,Rg"))]
  "!(memory_operand(operands[0], DImode)
     && immediate_operand(operands[1], DImode))"
  {
    switch (which_alternative)
      {
      case 0:
	return "%P0 = %P1";
      case 1:
	return "%P0 = memd(%1)";
      case 2:
	return "%P0 = memd(%1)";
      case 3:
	return "%P0 = memd(%E1)";
      case 4:
	return "memd(%0) = %P1";
      case 5:
	return "memd(%0) = %P1";
      case 6:
	return "memd(%E0) = %P1";
      case 7:
	return "%P0 = #%1";
      case 8:
	operands[2] = gen_int_mode (INTVAL (operands[1]) >> 32ULL, SImode);
	operands[1] = gen_int_mode (INTVAL (operands[1]) & 0xFFFFFFFFULL,
				    SImode);
	return "%P0 = combine(#%2,#%1)";
      case 9:
	operands[2] = gen_int_mode (INTVAL (operands[1]) >> 32ULL, SImode);
	operands[1] = gen_int_mode (INTVAL (operands[1]) & 0xFFFFFFFFULL,
				    SImode);
	return "%P0 = combine(#%2,##%1)";
      case 10:
	operands[2] = gen_int_mode (INTVAL (operands[1]) >> 32ULL, SImode);
	operands[1] = gen_int_mode (INTVAL (operands[1]) & 0xFFFFFFFFULL,
				    SImode);
	return "%P0 = combine(##%2,#%1)";
      case 11:
	if (TARGET_CONST64)
	  return "%P0 = CONST64(#%1)";
	else
	  return "#";
      case 12:
	return "%P0 = %P1";
      case 13:
	return "%P0 = %P1";
      default:
	gcc_unreachable ();
      }
  }
  [(set_attr "type" "A,Load,Load,ELoad,Store,Store,EStore,A,A,EA,EA,Load,CR,CR")
   (set_attr "duplex" "no,yes,no,no,yes,no,no,no,no,no,no,no,no,no")]
)

(define_insn "movdi_real_new_mem"
  [(set (match_operand:DI 0 "gr_register_operand"	 "=Rg,Rg")
	(unspec:DI [(match_operand:DI 1 "memory_operand" "Anx, m")]
		   UNSPEC_NEW_VALUE))]
  "TARGET_V5_FEATURES"
  "@
   %P0 = memd(%1).new
   %P0 = memd(%E1).new"
  [(set_attr "type"   "NewLoad,ENewLoad")]
)

;; Split moves of immediates to register pairs into separate moves to each
;; register.  Each of those moves might themselves be split.

(define_split
  [(set (match_operand:DI 0 "gr_register_operand" "")
	(match_operand:DI 1 "immediate_operand" ""))]
  "!((GET_CODE (operands[1]) == CONST_INT
      && satisfies_constraint_K88 (operands[1]))
     || TARGET_CONST64)
   && reload_completed"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
  {
    operands[2] = gen_highpart (SImode, operands[0]);
    operands[3] = gen_lowpart (SImode, operands[0]);
    operands[4] = gen_int_mode (INTVAL (operands[1]) >> 32ULL, SImode);
    operands[5] = gen_int_mode (INTVAL (operands[1]), SImode);
  }
)

;; Split CONST64, combine local pass will
;; produce a better code and save a load.

(define_split
  [(set (match_operand:DI 0 "gr_register_operand" "")
	(match_operand:DI 1 "immediate_operand" ""))]
  "TARGET_V4_FEATURES
   && TARGET_CONST64
   && reload_completed
   && GET_CODE (operands[1]) == CONST_INT
   && !satisfies_constraint_K88 (operands[1])
   && !satisfies_constraint_K83 (operands[1])
   && !satisfies_constraint_K38 (operands[1])
   && (satisfies_constraint_K13 (operands[1])
       || satisfies_constraint_K31 (operands[1]))"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
  {
    operands[2] = gen_highpart (SImode, operands[0]);
    operands[3] = gen_lowpart (SImode, operands[0]);
    operands[4] = gen_int_mode (INTVAL (operands[1]) >> 32ULL, SImode);
    operands[5] = gen_int_mode (INTVAL (operands[1]), SImode);
  }
)

(define_insn "cond_movdi"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"     " Rp, Rp, Rp, Rp, Rp")
	(const_int 0)])
     (set (match_operand:DI 0 "conditional_dest_operand"
						      "=Rg, Rg, Rg,Aco,Aec")
	  (match_operand:DI 1 "conditional_src_operand"
						      " Rg,Aco,Aec, Rg, Rg")))]
  "!memory_operand(operands[0], DImode)
   || gr_register_operand(operands[1], DImode)"
  "@
   if (%C2) %P0 = %P1
   if (%C2) %P0 = memd(%1)
   if (%C2) %P0 = memd(%E1)
   if (%C2) memd(%0) = %P1
   if (%C2) memd(%E0) = %P1"
  [(set_attr "type" "A,Load,ELoad,Store,EStore")]
)

(define_insn "cond_movdi_new_mem"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"	   " Rp, Rp")
	(const_int 0)])
     (set (match_operand:DI 0 "gr_register_operand"	   "=Rg, Rg")
	  (unspec:DI [(match_operand:DI 1 "memory_operand" "Aco,Aec")]
		     UNSPEC_NEW_VALUE)))]
  "TARGET_V5_FEATURES"
  "@
   if (%C2) %P0 = memd(%1).new
   if (%C2) %P0 = memd(%E1).new"
  [(set_attr "type" "NewLoad,ENewLoad")]
)

;; Special form used for prologue code, principally to get debug info right.

(define_insn "store_pair"
  [(set (match_operand:SI 0 "memory_operand"	  "=Anx,m")
	(match_operand:SI 1 "gr_register_operand"   "Rg,Rg"))
   (set (match_operand:SI 2 "memory_operand"	    "=m,m")
	(match_operand:SI 3 "gr_register_operand"   "Rg,Rg"))]
  "reload_completed && REGNO (operands[3]) == REGNO (operands[1]) + 1
   && hexagon_address_adjacent_p (operands[0], operands[2])"
  "@
  memd(%0) = %P1
  memd(%E0) = %P1"
  [(set_attr "type" "Store,EStore")]
)

;;-------;;
;; movsf ;;
;;-------;;

(define_expand "movsf"
  [(set (match_operand:SF 0 "nonimmediate_operand" "")
	(match_operand:SF 1 "general_operand" ""))]
  ""
  {
    rtx reg;
    if (TARGET_SECTION_SORTING_CODE_SUPPORT && TARGET_SECTION_SORTING
	&& can_create_pseudo_p ())
      {
	if (MEM_P (operands[0]) && !GP_or_reg_operand (operands[0], SFmode))
	  {
	    reg = gen_reg_rtx (Pmode);
	    emit_move_insn (reg, XEXP (operands[0], 0));
	    operands[0] = change_address (operands[0], SFmode, reg);
	  }
	else if (MEM_P (operands[1])
		 && !GP_or_reg_operand (operands[1], SFmode))
	  {
	    reg = gen_reg_rtx (Pmode);
	    emit_move_insn (reg, XEXP (operands[1], 0));
	    operands[1] = change_address (operands[1], SFmode, reg);
	  }
      }
    if (!(register_operand (operands[0], SFmode)
	  || (TARGET_V4_FEATURES && MEM_P (operands[0])
	      && hexagon_storeimm_mem_operand (SFmode, operands[0])
	      && satisfies_constraint_G (operands[1]))))
      operands[1] = force_reg (SFmode, operands[1]);

    if ((GET_CODE (operands[1]) == SYMBOL_REF
	 || (GET_CODE (operands[1]) == CONST
	     && GET_CODE (XEXP (operands[1], 0)) == PLUS))
	&& hexagon_tls_referenced_p (operands[1]))
      {
	rtx tmp = operands[1];
	rtx addend = NULL;

	if (GET_CODE (tmp) == CONST && GET_CODE (XEXP (tmp, 0)) == PLUS)
	  {
	    addend = XEXP (XEXP (tmp, 0), 1);
	    tmp = XEXP (XEXP (tmp, 0), 0);
	  }

	tmp = legitimize_tls_address (tmp);
	if (addend)
	  {
	    tmp = gen_rtx_PLUS (SImode, tmp, addend);
	    tmp = force_operand (tmp, operands[0]);
	  }
	operands[1] = tmp;
      }
    else if (flag_pic && CONSTANT_P (operands[1]))
      operands[1] = legitimize_pic_address (operands[1], SImode,
					    (can_create_pseudo_p ()? NULL_RTX
					     : operands[0]));
  }
)

(define_insn "movsf_real_v4"
  [(set (match_operand:SF 0 "nonimmediate_operand_with_GP"
					   "=Rg, Rg,Rg,Asi,Asi,Anx, m,Rg,Rg")
	(match_operand:SF 1 "GP_or_reg_operand"
					   " Rg,Anx, m,  G,  i, Rg,Rg, G, i"))]
  "TARGET_V4_FEATURES"
  "@
   %0 = %1
   %0 = memw(%1)
   %0 = memw(%E1)
   memw(%0) = #%1
   memw(%0) = ##%1
   memw(%0) = %1
   memw(%E0) = %1
   %0 = #%1
   %0 = ##%1"
  [(set_attr "type" "A,Load,ELoad,Store,EStore,Store,EStore,A,EA")]
)

(define_insn "movsf_new_value"
  [(set (match_operand:SF 0 "nonimmediate_operand"	     "=Anx, m, Rg,Rg")
	(unspec:SF [(match_operand:SF 1 "nonimmediate_operand"
							     "  Rg,Rg,Anx, m")]
		   UNSPEC_NEW_VALUE))]
  "TARGET_V4_FEATURES"
  "@
   memw(%0) = %1.new
   memw(%E0) = %1.new
   %0 = memw(%1).new
   %0 = memw(%E1).new"
  [(set_attr "type" "NewValue,ENewValue,NewLoad,ENewLoad")]
)

(define_insn "movsf_real"
  [(set (match_operand:SF 0 "nonimmediate_operand_with_GP" "=Rg,Rg, m,Rg,?Rg")
	(match_operand:SF 1 "GP_or_reg_operand"		   " Rg, m,Rg, G,  i"))]
  "!TARGET_V4_FEATURES
   && (!memory_operand(operands[0], SFmode)
       || gr_register_operand(operands[1], SFmode))"
  {
    switch (which_alternative)
      {
      case 0:
	return "%0 = %1";
      case 1:
	return "%0 = memw(%1)";
      case 2:
	return "memw(%0) = %1";
      case 3:
	return "%0 = #%1";
      case 4:
	if (TARGET_CONST32)
	  return "%0 = CONST32(#%1)";
	else
	  return "#";
      default:
	gcc_unreachable ();
      }
  }
  [(set_attr "type" "A,Load,Store,A,Load")]
)

;; After reload, replace floating immediate moves with integer immediate moves.

(define_split
  [(set (match_operand:SF 0 "gr_register_operand" "")
	(match_operand:SF 1 "immediate_operand" ""))]
  "!(TARGET_CONST32 || satisfies_constraint_G (operands[1]))
   && reload_completed
   && !TARGET_V4_FEATURES"
  [(set (match_dup 2) (match_dup 3))]
  {
    REAL_VALUE_TYPE rv;
    long l;

    REAL_VALUE_FROM_CONST_DOUBLE (rv, operands[1]);
    REAL_VALUE_TO_TARGET_SINGLE (rv, l);

    operands[2] = gen_rtx_REG (SImode, REGNO (operands[0]));
    ORIGINAL_REGNO (operands[2]) = ORIGINAL_REGNO (operands[0]);
    operands[3] = gen_int_mode (l, SImode);
  }
)

(define_insn "cond_movsf"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"
					" Rp, Rp, Rp, Rp, Rp, Rp, Rp,Rp,Rp")
	(const_int 0)])
     (set (match_operand:SF 0 "conditional_dest_operand"
					"=Rg, Rg, Rg,Acs,Acs,Aco,Aec,Rg,Rg")
	  (match_operand:SF 1 "conditional_src_operand"
					" Rg,Aco,Aec,  G,  i, Rg, Rg, G, i")))]
  ""
  "@
   if (%C2) %0 = %1
   if (%C2) %0 = memw(%1)
   if (%C2) %0 = memw(%E1)
   if (%C2) memw(%0) = #%1
   if (%C2) memw(%0) = ##%1
   if (%C2) memw(%0) = %1
   if (%C2) memw(%E0) = %1
   if (%C2) %0 = #%1
   if (%C2) %0 = ##%1"
  [(set_attr "type" "A,Load,ELoad,Store,EStore,Store,EStore,A,EA")]
)

(define_insn "cond_movsf_new_value"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"    "  Rp, Rp, Rp, Rp")
	(const_int 0)])
     (set (match_operand:SF 0 "nonimmediate_operand" "=Aco,Aec, Rg, Rg")
	  (unspec:SF [(match_operand:SF 1 "nonimmediate_operand"
						     "  Rg, Rg,Aco,Aec")]
		     UNSPEC_NEW_VALUE)))]
  "TARGET_V4_FEATURES"
  "@
   if (%C2) memw(%0) = %1.new
   if (%C2) memw(%E0) = %1.new
   if (%C2) %0 = memw(%1).new
   if (%C2) %0 = memw(%E1).new"
  [(set_attr "type" "NewValue,ENewValue,NewLoad,ENewLoad")]
)

;;-------;;
;; movdf ;;
;;-------;;

(define_expand "movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
	(match_operand:DF 1 "general_operand" ""))]
  ""
  {
    if (GET_CODE (operands[0]) != REG)
      operands[1] = force_reg (DFmode, operands[1]);
  }
)

(define_insn "movdf_real"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=Rg, Rg,Rg,Anx, m,Rg")
	(match_operand:DF 1 "general_operand"       "Rg,Anx, m, Rg,Rg, i"))]
  ""
  {
    switch (which_alternative)
      {
      case 0:
	return "%P0 = %P1";
      case 1:
	return "%P0 = memd(%1)";
      case 2:
	return "%P0 = memd(%E1)";
      case 3:
	return "memd(%0) = %P1";
      case 4:
	return "memd(%E0) = %P1";
      case 5:
	if (TARGET_CONST64)
	  return "%P0 = CONST64(#%1)";
	else
	  return "#";
      default:
	gcc_unreachable ();
      }
  }
  [(set_attr "type" "A,Load,ELoad,Store,EStore,Load")]
)

(define_insn "movdf_real_new_mem"
  [(set (match_operand:DF 0 "gr_register_operand"	       "=Rg,Rg")
	(unspec:DF [(match_operand:DF 1 "nonimmediate_operand" "Anx, m")]
		   UNSPEC_NEW_VALUE))]
  "TARGET_V5_FEATURES"
  "@
   %P0 = memd(%1).new
   %P0 = memd(%E1).new"
  [(set_attr "type" "NewLoad,ENewLoad")]
)

;; After reload, replace floating immediate moves with integer immediate moves.

(define_split
  [(set (match_operand:DF 0 "gr_register_operand" "")
	(match_operand:DF 1 "immediate_operand" ""))]
  "!TARGET_CONST64 && reload_completed"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
  {
    REAL_VALUE_TYPE rv;
    long l[2];

    REAL_VALUE_FROM_CONST_DOUBLE (rv, operands[1]);
    REAL_VALUE_TO_TARGET_DOUBLE (rv, l);

    operands[2] = gen_highpart (SImode, operands[0]);
    operands[3] = gen_lowpart (SImode, operands[0]);
    ORIGINAL_REGNO (operands[3]) = ORIGINAL_REGNO (operands[0]);
    operands[4] = gen_int_mode (WORDS_BIG_ENDIAN ? l[0] : l[1], SImode);
    operands[5] = gen_int_mode (WORDS_BIG_ENDIAN ? l[1] : l[0], SImode);
  }
)

(define_insn "cond_movdf"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"     " Rp, Rp, Rp, Rp, Rp")
	(const_int 0)])
     (set (match_operand:DF 0 "conditional_dest_operand"
						      "=Rg, Rg, Rg,Aco,Aec")
	  (match_operand:DF 1 "conditional_src_operand"
						      " Rg,Aco,Aec, Rg, Rg")))]
  "!memory_operand(operands[0], DFmode)
   || gr_register_operand(operands[1], DFmode)"
  "@
   if (%C2) %P0 = %P1
   if (%C2) %P0 = memd(%1)
   if (%C2) %P0 = memd(%E1)
   if (%C2) memd(%0) = %P1
   if (%C2) memd(%E0) = %P1"
  [(set_attr "type" "A,Load,ELoad,Store,EStore")]
)

(define_insn "cond_movdf_new_mem"
  [(cond_exec
     (match_operator 2 "predicate_operator"
       [(match_operand:BI 3 "pr_register_operand"	   " Rp, Rp")
	(const_int 0)])
     (set (match_operand:DF 0 "gr_register_operand"	   "=Rg, Rg")
	  (unspec:DF [(match_operand:DF 1 "memory_operand" "Aco,Aec")]
		     UNSPEC_NEW_VALUE)))]
  "TARGET_V5_FEATURES"
  "@
   if (%C2) %P0 = memd(%1).new
   if (%C2) %P0 = memd(%E1).new"
  [(set_attr "type" "NewLoad,ENewLoad")]
)

;;---------;;
;; add{m}3 ;;
;;---------;;

(define_expand "add<mode>3"
  [(set (match_operand:AM 0 "nonimmediate_operand" "")
	(plus:AM (match_operand:AM 1 "nonimmediate_operand" "")
		 (match_operand:AM 2 "nonmemory_operand" "")))]
  ""
  {
    hexagon_expand_binary_operator (PLUS, <MODE>mode, operands, 2,
				    &s16_const_int_operand,
				    &minus_31_to_31_operand, true);
    DONE;
  }
)

(define_insn "addsi3_real_v4"
  [(set (match_operand:SI 0 "gr_reg_or_rmw_mem_operand"
		       "=Rg, Rg,   Rq,Rg ,Rg,Rg,Rg,Amo,Aem,Amo,Aem,Amo,Aem")
	(plus:SI (match_operand:SI 1 "gr_reg_or_rmw_mem_operand"
		       "%Rg,  0,   Rq,Rg ,Rg, 0,Rg,  0,  0,  0,  0,  0,  0")
		 (match_operand:SI 2 "nonmemory_operand"
		    "K01Km1,Is7,Ju6_2,IsG, i,Rg,Rg,Iu5,Iu5,In5,In5, Rg, Rg")))]
  "TARGET_V4_FEATURES && TARGET_MEMOPS"
  "@
   %0 = add(%1,#%2)
   %0 = add(%1,#%2)
   %0 = add(%1,#%2)
   %0 = add(%1,#%2)
   %0 = add(%1,##%2)
   %0 = add(%1,%2)
   %0 = add(%1,%2)
   memw(%0) += #%2
   memw(%E0) += #%2
   memw(%0) -= #%n2
   memw(%E0) -= #%n2
   memw(%0) += %2
   memw(%E0) += %2"
  [(set_attr "type" "A,A,A,A,EA,A,A,Memop,EMemop,Memop,EMemop,Memop,EMemop")
   (set_attr "duplex" "yes,yes,yes,no,no,yes,no,no,no,no,no,no,no")]
)

(define_insn "addsi3_nomemops_v4"
  [(set (match_operand:SI 0 "gr_register_operand"
					       "=Rg, Rg,   Rq,Rg ,Rg,Rg,Rg")
	(plus:SI (match_operand:SI 1 "gr_register_operand"
					       "%Rg,  0,   Rq,Rg ,Rg, 0,Rg")
		 (match_operand:SI 2 "nonmemory_operand"
					    "K01Km1,Is7,Ju6_2,IsG, i,Rg,Rg")))]
  "TARGET_V4_FEATURES && !TARGET_MEMOPS"
  "@
   %0 = add(%1,#%2)
   %0 = add(%1,#%2)
   %0 = add(%1,#%2)
   %0 = add(%1,#%2)
   %0 = add(%1,##%2)
   %0 = add(%1,%2)
   %0 = add(%1,%2)"
  [(set_attr "type" "A,A,A,A,EA,A,A")
   (set_attr "duplex" "yes,yes,yes,no,no,yes,no")]
)

(define_insn "add<mode>3_real_v4"
  [(set (match_operand:AQHM 0 "rmw_memory_operand"
				   "=Amo,Aem,Amo,Aem,Amo,Aem, ?Rg,?Rg")
	(plus:AQHM (match_operand:AQHM 1 "rmw_memory_operand"
				     "%0,  0,  0,  0,  0,  0, ?Rg,?Rg")
		   (match_operand:AQHM 2 "nonmemory_operand"
				    "Iu5,Iu5,In5,In5, Rg, Rg,?IsG,?Rg")))]
  "TARGET_V4_FEATURES && TARGET_MEMOPS"
  "@
   mem<access_size>(%0) += #%2
   mem<access_size>(%E0) += #%2
   mem<access_size>(%0) -= #%n2
   mem<access_size>(%E0) -= #%n2
   mem<access_size>(%0) += %2
   mem<access_size>(%E0) += %2
   %0 = add(%1,#%2)
   %0 = add(%1,%2)"
  [(set_attr "type" "Memop,EMemop,Memop,EMemop,Memop,EMemop,A,A")
   (set_attr "duplex" "no")]
)

(define_insn "addsi3_real"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg,Rg")
	(plus:SI (match_operand:SI 1 "gr_register_operand" " Rg,Rg")
		 (match_operand:SI 2 "gr_or_s16_operand"   "IsG,Rg")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 = add(%1,#%2)
   %0 = add(%1,%2)"
  [(set_attr "type" "A,A")]
)

(define_insn "cond_add<mode>3"
  [(cond_exec
     (match_operator 3 "predicate_operator"
       [(match_operand:BI 4 "pr_register_operand"	      " Rp, Rp,Rp")
	(const_int 0)])
     (set (match_operand:AM 0 "gr_register_operand"	      "=Rg, Rg,Rg")
	  (plus:AM (match_operand:AM 1 "gr_register_operand"  " Rg, Rg,Rg")
		   (match_operand:AM 2 "conditional_add_operand"
							      " Rg,Is8, i"))))]
  ""
  "@
   if (%C3) %0 = add(%1,%2)
   if (%C3) %0 = add(%1,#%2)
   if (%C3) %0 = add(%1,##%2)"
  [(set_attr "type" "A,A,EA")]
)

(define_insn "adddi3"
  [(set (match_operand:DI 0 "gr_register_operand"	   "=Rg")
	(plus:DI (match_operand:DI 1 "gr_register_operand" " Rg")
		 (match_operand:DI 2 "gr_register_operand" " Rg")))]
  ""
  "%P0 = add(%P1,%P2)"
  [(set_attr "type" "X")]
)

(define_insn "adddisi3"
  [(set (match_operand:DI 0 "gr_register_operand"		      "=Rg")
	(plus:DI (sign_extend:DI (match_operand:SI 1 "gr_register_operand"
								      " Rg"))
		 (match_operand:DI 2 "gr_register_operand"	      " Rg")))]
  "TARGET_V3_FEATURES"
  "%0 = add(%1,%P2)"
  [(set_attr "type" "X")]
)


;;-----------;;
;; ssadd{m}3 ;;
;;-----------;;

(define_insn "ssaddsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	      "=Rg")
	(ss_plus:SI (match_operand:SI 1 "gr_register_operand" " Rg")
		    (match_operand:SI 2 "gr_register_operand" " Rg")))]
  "TARGET_V4_FEATURES"
  "%0 = add(%1,%2):sat"
  [(set_attr "type" "A")]
)


;;---------;;
;; sub{m}3 ;;
;;---------;;

(define_expand "sub<mode>3"
  [(set (match_operand:AM 0 "nonimmediate_operand" "")
	(minus:AM (match_operand:AM 1 "general_operand" "")
		  (match_operand:AM 2 "gr_register_operand" "")))]
  ""
  {
    hexagon_expand_binary_operator (MINUS, <MODE>mode, operands, 1,
				    &s10_const_int_operand, &no_int_operand,
				    false);
    DONE;
  }
)

(define_insn "subsi3_real_v4"
  [(set (match_operand:SI 0 "gr_reg_or_rmw_mem_operand"	"=Rg,Rg,Rg,Amo,Aem")
	(minus:SI (match_operand:SI 1 "gr_reg_rmw_or_imm_operand"
							"IsA, i,Rg,  0,  0")
		  (match_operand:SI 2 "gr_register_operand"
							" Rg,Rg,Rg, Rg, Rg")))]
  "TARGET_V4_FEATURES && TARGET_MEMOPS"
  "@
   %0 = sub(#%1,%2)
   %0 = sub(##%1,%2)
   %0 = sub(%1,%2)
   memw(%0) -= %2
   memw(%E0) -= %2"
  [(set_attr "type" "A,EA,A,Memop,EMemop")]
)

(define_insn "subsi3_nomemops_v4"
  [(set (match_operand:SI 0 "gr_register_operand"		"=Rg,Rg,Rg")
	(minus:SI (match_operand:SI 1 "gr_register_operand"	"IsA, i,Rg")
		  (match_operand:SI 2 "gr_register_operand"	" Rg,Rg,Rg")))]
  "TARGET_V4_FEATURES && !TARGET_MEMOPS"
  "@
   %0 = sub(#%1,%2)
   %0 = sub(##%1,%2)
   %0 = sub(%1,%2)"
  [(set_attr "type" "A,EA,A")]
)

(define_insn "sub<mode>3_real_v4"
  [(set (match_operand:AQHM 0 "rmw_memory_operand"	      "=Amo,Aem,?Rg")
	(minus:AQHM
	  (match_operand:AQHM 1 "rmw_memory_operand"		 "0,  0,?Rg")
	  (match_operand:AQHM 2 "gr_register_operand"		"Rg, Rg,?Rg")))]
  "TARGET_V4_FEATURES && TARGET_MEMOPS"
  "@
   mem<access_size>(%0) -= %2
   mem<access_size>(%E0) -= %2
   %0 = sub(%1,%2)"
  [(set_attr "type" "Memop,EMemop,A")]
)

(define_insn "subsi3_real"
  [(set (match_operand:SI 0 "gr_register_operand"	    "=Rg,Rg")
	(minus:SI (match_operand:SI 1 "nonmemory_operand"   "IsA,Rg")
		  (match_operand:SI 2 "gr_register_operand" " Rg,Rg")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 = sub(#%1,%2)
   %0 = sub(%1,%2)"
  [(set_attr "type" "A,A")]
)

(define_insn "cond_subsi3"
  [(cond_exec
     (match_operator 3 "predicate_operator"
       [(match_operand:BI 4 "pr_register_operand"	      " Rp")
	(const_int 0)])
     (set (match_operand:SI 0 "gr_register_operand"	      "=Rg")
	  (minus:SI (match_operand:SI 1 "gr_register_operand" " Rg")
		    (match_operand:SI 2 "gr_register_operand" " Rg"))))]
  ""
  "if (%C3) %0 = sub(%1,%2)"
  [(set_attr "type" "A")]
)

(define_insn "subdi3"
  [(set (match_operand:DI 0 "gr_register_operand"	    "=Rg")
	(minus:DI (match_operand:DI 1 "gr_register_operand" " Rg")
		  (match_operand:DI 2 "gr_register_operand" " Rg")))]
  ""
  "%P0 = sub(%P1,%P2)"
  [(set_attr "type" "X")]
)


;;-----------;;
;; sssub{m}3 ;;
;;-----------;;

(define_insn "sssubsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	       "=Rg")
	(ss_minus:SI (match_operand:SI 1 "gr_register_operand" " Rg")
		     (match_operand:SI 2 "gr_register_operand" " Rg")))]
  "TARGET_V4_FEATURES"
  "%0 = sub(%1,%2):sat"
  [(set_attr "type" "A")]
)


;;---------;;
;; mul{m}3 ;;
;;---------;;

(define_insn "mulsi3_real_v4"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg,Rg,Rg")
	(mult:SI (match_operand:SI 1 "gr_register_operand" " Rg,Rg,Rg")
		 (match_operand:SI 2 "nonmemory_operand"   "Im9, i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = mpyi(%1,#%2)
   %0 = mpyi(%1,##%2)
   %0 = mpyi(%1,%2)"
  [(set_attr "type" "M,EM,M")]
)

(define_insn "mulsi3_real"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg,Rg")
	(mult:SI (match_operand:SI 1 "gr_register_operand" " Rg,Rg")
		 (match_operand:SI 2 "gr_or_m9_operand"	   "Im9,Rg")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 = mpyi(%1,#%2)
   %0 = mpyi(%1,%2)"
  [(set_attr "type" "M,M")]
)

(define_expand "mulsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(mult:SI (match_operand:SI 1 "gr_register_operand" "")
		 (match_operand:SI 2 "nonmemory_operand" "")))]
  ""
  {
    if (!reload_completed
	&& !register_operand (operands[2], SImode)
	&& !m9_const_int_operand (operands[2], SImode))
      operands[2] = force_reg (SImode, operands[2]);
  }
)


;; Yes, it's true, we don't have a DImode multiply
;; But if we don't define it here then we miss some optimizations
;; where the combiner could turn it into a sidi but we've already
;; converted the DImode multiply into 3 SImode multiplies... bad news.

(define_insn_and_split "muldi3"
  [(set (match_operand:DI 0 "gr_register_operand"	   "=&Rg")
	(mult:DI (match_operand:DI 1 "gr_register_operand" "  Rg")
		 (match_operand:DI 2 "gr_register_operand" "  Rg")))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 0) (unspec:DI [(match_dup 1) (match_dup 2)] UNSPEC_MULDI_1))
   (set (match_dup 0) (unspec:DI [(match_dup 1) (match_dup 2) (match_dup 0)]
				 UNSPEC_MULDI_2))
   (set (match_dup 0) (unspec:DI [(match_dup 2) (match_dup 1) (match_dup 0)]
				 UNSPEC_MULDI_2))]
)

(define_insn "muldi3_helper_1"
  [(set (match_operand:DI 0 "gr_register_operand"	      "=Rg")
	(unspec:DI [(match_operand:DI 1 "gr_register_operand" " Rg")
		    (match_operand:DI 2 "gr_register_operand" " Rg")]
		   UNSPEC_MULDI_1))]
  ""
  "%P0 = mpyu(%L1,%L2)"
  [(set_attr "type" "M")]
)

(define_insn "muldi3_helper_2"
  [(set (match_operand:DI 0 "gr_register_operand"	      "=Rg")
	(unspec:DI [(match_operand:DI 1 "gr_register_operand" " Rg")
		    (match_operand:DI 2 "gr_register_operand" " Rg")
		    (match_operand:DI 3 "gr_register_operand" "  0")]
		   UNSPEC_MULDI_2))]
  ""
  "%H0 += mpyi(%L1,%H2)"
  [(set_attr "type" "M")]
)


;;----------;;
;; umin{m}3 ;;
;;----------;;

(define_insn "uminsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg")
	(umin:SI (match_operand:SI 1 "gr_register_operand" " Rg")
		 (match_operand:SI 2 "gr_register_operand" " Rg")))]
  ""
  "%0 = minu(%1,%2)"
  [(set_attr "type" "X")]
)


(define_insn "umindi3"
  [(set (match_operand:DI 0 "gr_register_operand"	   "=Rg")
	(umin:DI (match_operand:DI 1 "gr_register_operand" " Rg")
		 (match_operand:DI 2 "gr_register_operand" " Rg")))]
  "TARGET_V3_FEATURES"
  "%0 = minu(%1,%2)"
  [(set_attr "type" "X")]
)


;;----------;;
;; umax{m}3 ;;
;;----------;;

(define_insn "umaxsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg")
	(umax:SI (match_operand:SI 1 "gr_register_operand" " Rg")
		 (match_operand:SI 2 "gr_register_operand" " Rg")))]
  ""
  "%0 = maxu(%1,%2)"
  [(set_attr "type" "X")]
)


(define_insn "umaxdi3"
  [(set (match_operand:DI 0 "gr_register_operand"	   "=Rg")
	(umax:DI (match_operand:DI 1 "gr_register_operand" " Rg")
		 (match_operand:DI 2 "gr_register_operand" " Rg")))]
  "TARGET_V3_FEATURES"
  "%0 = maxu(%1,%2)"
  [(set_attr "type" "X")]
)


;;---------;;
;; and{m}3 ;;
;;---------;;

(define_insn "andbi3"
  [(set (match_operand:BI 0 "pr_register_operand"	 "=Rp")
	(and:BI (match_operand:BI 1 "pr_register_operand" "Rp")
		(match_operand:BI 2 "pr_register_operand" "Rp")))]
  ""
  "%0 = and(%1,%2)"
  [(set_attr "type" "S")]
)

(define_expand "and<mode>3"
  [(set (match_operand:AM 0 "nonimmediate_operand" "")
	(and:AM (match_operand:AM 1 "nonimmediate_operand" "")
		(match_operand:AM 2 "general_operand" "")))]
  ""
  {
    hexagon_expand_binary_operator (AND, <MODE>mode, operands, 2,
				    &s10_const_int_operand,
				    &inv_power_of_two_operand, true);
    DONE;
  }
)

(define_insn "andsi3_real_v4"
  [(set (match_operand:SI 0 "gr_reg_or_rmw_mem_operand"
					"=Rg, Rg, Rg,Rg,Rg,Amo,Aem,Amo,Aem")
	(and:SI (match_operand:SI 1 "gr_reg_or_rmw_mem_operand"
					"%Rg, Rg, Rg,Rg,Rg,  0,  0,  0,  0")
		(match_operand:SI 2 "nonmemory_operand"
					"K01,IsA,K1n, i,Rg,K1n,K1n, Rg, Rg")))]
  "TARGET_V4_FEATURES && TARGET_MEMOPS"
  "@
   %0 = and(%1,#%2)
   %0 = and(%1,#%2)
   %0 = clrbit(%1,#%K2)
   %0 = and(%1,##%2)
   %0 = and(%1,%2)
   memw(%0) = clrbit(#%K2)
   memw(%E0) = clrbit(#%K2)
   memw(%0) &= %2
   memw(%E0) &= %2"
  [(set_attr "type" "A,A,S,EA,A,Memop,EMemop,Memop,EMemop")
   (set_attr "duplex" "yes,no,no,no,no,no,no,no,no")]
)

(define_insn "andsi3_nomemops_v4"
  [(set (match_operand:SI 0 "gr_register_operand"	"=Rg, Rg, Rg,Rg,Rg")
	(and:SI (match_operand:SI 1 "gr_register_operand"
							"%Rg, Rg, Rg,Rg,Rg")
		(match_operand:SI 2 "nonmemory_operand" "K01,IsA,K1n, i,Rg")))]
  "TARGET_V4_FEATURES && !TARGET_MEMOPS"
  "@
   %0 = and(%1,#%2)
   %0 = and(%1,#%2)
   %0 = clrbit(%1,#%K2)
   %0 = and(%1,##%2)
   %0 = and(%1,%2)"
  [(set_attr "type" "A,A,S,EA,A")
   (set_attr "duplex" "yes,no,no,no,no")]
)

(define_insn "and<mode>3_real_v4"
  [(set (match_operand:AQHM 0 "rmw_memory_operand"
						 "=Amo,Aem,Amo,Aem, ?Rg,?Rg")
	(and:AQHM (match_operand:AQHM 1 "rmw_memory_operand"
						   "%0,  0,  0,  0, ?Rg,?Rg")
		  (match_operand:AQHM 2 "nonmemory_operand"
						  "K1n,K1n, Rg, Rg,?K1n,?Rg")))]
  "TARGET_V4_FEATURES && TARGET_MEMOPS"
  "@
   mem<access_size>(%0) = clrbit(#%K2)
   mem<access_size>(%E0) = clrbit(#%K2)
   mem<access_size>(%0) &= %2
   mem<access_size>(%E0) &= %2
   %0 = clrbit(%1,#%K2)
   %0 = and(%1,%2)"
  [(set_attr "type" "Memop,EMemop,Memop,EMemop,S,A")
   (set_attr "duplex" "no")]
)

(define_insn "andsi3_real"
  [(set (match_operand:SI 0 "gr_register_operand"	  "=Rg, Rg,Rg")
	(and:SI (match_operand:SI 1 "gr_register_operand" "%Rg, Rg,Rg")
		(match_operand:SI 2 "nonmemory_operand"	  "IsA,K1n,Rg")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 = and(%1,#%2)
   %0 = clrbit(%1,#%K2)
   %0 = and(%1,%2)"
  [(set_attr "type" "A,S,A")]
)

(define_insn "cond_andsi3"
  [(cond_exec
     (match_operator 3 "predicate_operator"
       [(match_operand:BI 4 "pr_register_operand"	    " Rp")
	(const_int 0)])
     (set (match_operand:SI 0 "gr_register_operand"	    "=Rg")
	  (and:SI (match_operand:SI 1 "gr_register_operand" " Rg")
		  (match_operand:SI 2 "gr_register_operand" " Rg"))))]
  ""
  "if (%C3) %0 = and(%1,%2)"
  [(set_attr "type" "A")]
)

(define_insn "anddi3"
  [(set (match_operand:DI 0 "gr_register_operand"	  "=Rg")
	(and:DI (match_operand:DI 1 "gr_register_operand" " Rg")
		(match_operand:DI 2 "gr_register_operand" " Rg")))]
  ""
  "%P0 = and(%P1,%P2)"
  [(set_attr "type" "X")]
)


;;---------;;
;; ior{m}3 ;;
;;---------;;

(define_insn "iorbi3"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp")
	(ior:BI (match_operand:BI 1 "pr_register_operand" " Rp")
		(match_operand:BI 2 "pr_register_operand" " Rp")))]
  ""
  "%0 = or(%1,%2)"
  [(set_attr "type" "S")]
)

(define_expand "ior<mode>3"
  [(set (match_operand:AM 0 "nonimmediate_operand" "")
	(ior:AM (match_operand:AM 1 "nonimmediate_operand" "")
		(match_operand:AM 2 "general_operand" "")))]
  ""
  {
    hexagon_expand_binary_operator (IOR, <MODE>mode, operands, 2,
				    &s10_const_int_operand,
				    &power_of_two_operand, true);
    DONE;
  }
)

(define_insn "iorsi3_real_v4"
  [(set (match_operand:SI 0 "gr_reg_or_rmw_mem_operand"
					    "=Rg, Rg,Rg,Rg,Amo,Aem,Amo,Aem")
	(ior:SI (match_operand:SI 1 "gr_reg_or_rmw_mem_operand"
					    "%Rg, Rg,Rg,Rg,  0,  0,  0,  0")
		(match_operand:SI 2 "nonmemory_operand"
					    "IsA,K1h, i,Rg,K1h,K1h, Rg, Rg")))]
  "TARGET_V4_FEATURES && TARGET_MEMOPS"
  "@
   %0 = or(%1,#%2)
   %0 = setbit(%1,#%J2)
   %0 = or(%1,##%2)
   %0 = or(%1,%2)
   memw(%0) = setbit(#%J2)
   memw(%E0) = setbit(#%J2)
   memw(%0) |= %2
   memw(%E0) |= %2"
  [(set_attr "type" "A,S,EA,A,Memop,EMemop,Memop,EMemop")]
)

(define_insn "iorsi3_nomemops_v4"
  [(set (match_operand:SI 0 "gr_register_operand"	    "=Rg, Rg,Rg,Rg")
	(ior:SI (match_operand:SI 1 "gr_register_operand"   "%Rg, Rg,Rg,Rg")
		(match_operand:SI 2 "nonmemory_operand"	    "IsA,K1h, i,Rg")))]
  "TARGET_V4_FEATURES && !TARGET_MEMOPS"
  "@
   %0 = or(%1,#%2)
   %0 = setbit(%1,#%J2)
   %0 = or(%1,##%2)
   %0 = or(%1,%2)"
  [(set_attr "type" "A,S,EA,A")]
)

(define_insn "ior<mode>3_real_v4"
  [(set (match_operand:AQHM 0 "rmw_memory_operand"
						 "=Amo,Aem,Amo,Aem, ?Rg,?Rg")
	(ior:AQHM (match_operand:AQHM 1 "rmw_memory_operand"
						   "%0,  0,  0,  0, ?Rg,?Rg")
		  (match_operand:AQHM 2 "nonmemory_operand"
						  "K1h,K1h, Rg, Rg,?K1h,?Rg")))]
  "TARGET_V4_FEATURES && TARGET_MEMOPS"
  "@
   mem<access_size>(%0) = setbit(#%J2)
   mem<access_size>(%E0) = setbit(#%J2)
   mem<access_size>(%0) |= %2
   mem<access_size>(%E0) |= %2
   %0 = setbit(%1,#%J2)
   %0 = or(%1,%2)"
  [(set_attr "type" "Memop,EMemop,Memop,EMemop,S,A")]
)

(define_insn "iorsi3_real"
  [(set (match_operand:SI 0 "gr_register_operand"	  "=Rg, Rg,Rg")
	(ior:SI (match_operand:SI 1 "gr_register_operand" "%Rg, Rg,Rg")
		(match_operand:SI 2 "nonmemory_operand"   "IsA,K1h,Rg")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 = or(%1,#%2)
   %0 = setbit(%1,#%J2)
   %0 = or(%1,%2)"
  [(set_attr "type" "A,S,A")]
)

(define_insn "cond_iorsi3"
  [(cond_exec
     (match_operator 3 "predicate_operator"
       [(match_operand:BI 4 "pr_register_operand"	    " Rp")
	(const_int 0)])
     (set (match_operand:SI 0 "gr_register_operand"	    "=Rg")
	  (ior:SI (match_operand:SI 1 "gr_register_operand" " Rg")
		  (match_operand:SI 2 "gr_register_operand" " Rg"))))]
  ""
  "if (%C3) %0 = or(%1,%2)"
  [(set_attr "type" "A")]
)

(define_insn "iordi3"
  [(set (match_operand:DI 0 "gr_register_operand"	  "=Rg")
	(ior:DI (match_operand:DI 1 "gr_register_operand" " Rg")
		(match_operand:DI 2 "gr_register_operand" " Rg")))]
  ""
  "%P0 = or(%P1,%P2)"
  [(set_attr "type" "X")]
)


;;---------;;
;; xor{m}3 ;;
;;---------;;

(define_insn "xorbi3"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp")
	(xor:BI (match_operand:BI 1 "pr_register_operand" " Rp")
		(match_operand:BI 2 "pr_register_operand" " Rp")))]
  ""
  "%0 = xor(%1,%2)"
  [(set_attr "type" "S")]
)

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	  "=Rg,Rg")
	(xor:SI (match_operand:SI 1 "gr_register_operand" "%Rg,Rg")
		(match_operand:SI 2 "nonmemory_operand"   "K1h,Rg")))]
  ""
  "@
   %0 = togglebit(%1,#%J2)
   %0 = xor(%1,%2)"
  [(set (attr "type")
	(cond [(eq_attr "arch" "v1") (cond [(eq_attr "alternative" "0")
					    (const_string "S")]
					    (const_string "X"))]
				     (cond [(eq_attr "alternative" "0")
					    (const_string "S")]
					    (const_string "A"))))]
)

(define_insn "cond_xorsi3"
  [(cond_exec
     (match_operator 3 "predicate_operator"
       [(match_operand:BI 4 "pr_register_operand"	    " Rp")
	(const_int 0)])
     (set (match_operand:SI 0 "gr_register_operand"	    "=Rg")
	  (xor:SI (match_operand:SI 1 "gr_register_operand" "%Rg")
		  (match_operand:SI 2 "gr_register_operand" " Rg"))))]
  ""
  "if (%C3) %0 = xor(%1,%2)"
  [(set_attr "type" "A")]
)

(define_insn "xordi3"
  [(set (match_operand:DI 0 "gr_register_operand"	  "=Rg")
	(xor:DI (match_operand:DI 1 "gr_register_operand" " Rg")
		(match_operand:DI 2 "gr_register_operand" " Rg")))]
  ""
  "%P0 = xor(%P1,%P2)"
  [(set_attr "type" "X")]
)


;;----------;;
;; smin{m}3 ;;
;;----------;;

(define_insn "sminsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg")
	(smin:SI (match_operand:SI 1 "gr_register_operand" " Rg")
		 (match_operand:SI 2 "gr_register_operand" " Rg")))]
  ""
  "%0 = min(%1,%2)"
  [(set_attr "type" "X")]
)


(define_insn "smindi3"
  [(set (match_operand:DI 0 "gr_register_operand"	   "=Rg")
	(smin:DI (match_operand:DI 1 "gr_register_operand" " Rg")
		 (match_operand:DI 2 "gr_register_operand" " Rg")))]
  "TARGET_V3_FEATURES"
  "%0 = min(%1,%2)"
  [(set_attr "type" "X")]
)


;;----------;;
;; smax{m}3 ;;
;;----------;;

(define_insn "smaxsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg")
	(smax:SI (match_operand:SI 1 "gr_register_operand" " Rg")
		 (match_operand:SI 2 "gr_register_operand" " Rg")))]
  ""
  "%0 = max(%1,%2)"
  [(set_attr "type" "X")]
)


(define_insn "smaxdi3"
  [(set (match_operand:DI 0 "gr_register_operand"	   "=Rg")
	(smax:DI (match_operand:DI 1 "gr_register_operand" " Rg")
		 (match_operand:DI 2 "gr_register_operand" " Rg")))]
  "TARGET_V3_FEATURES"
  "%0 = max(%1,%2)"
  [(set_attr "type" "X")]
)


;;----------;;
;; mulhisi3 ;;
;;----------;;

(define_insn "mulhisi3"
  [(set (match_operand:SI 0 "gr_register_operand"		    "=Rg")
	(mult:SI
	  (sign_extend:SI (match_operand:HI 1 "gr_register_operand" " Rg"))
	  (sign_extend:SI (match_operand:HI 2 "gr_register_operand" " Rg"))))]
  ""
  "%0 = mpy(%1.l,%2.l)"
  [(set_attr "type" "M")]
)


;;----------;;
;; mulsidi3 ;;
;;----------;;

(define_insn "mulsidi3"
  [(set (match_operand:DI 0 "gr_register_operand"		    "=Rg")
	(mult:DI
	  (sign_extend:DI (match_operand:SI 1 "gr_register_operand" " Rg"))
	  (sign_extend:DI (match_operand:SI 2 "gr_register_operand" " Rg"))))]
  ""
  "%P0 = mpy(%1,%2)"
  [(set_attr "type" "M")]
)


;;-----------;;
;; umulhisi3 ;;
;;-----------;;

(define_insn "umulhisi3"
  [(set (match_operand:SI 0 "gr_register_operand"		    "=Rg")
	(mult:SI
	  (zero_extend:SI (match_operand:HI 1 "gr_register_operand" " Rg"))
	  (zero_extend:SI (match_operand:HI 2 "gr_register_operand" " Rg"))))]
  ""
  "%0 = mpyu(%1.l,%2.l)"
  [(set_attr "type" "M")]
)


;;-----------;;
;; umulsidi3 ;;
;;-----------;;

(define_insn "umulsidi3"
  [(set (match_operand:DI 0 "gr_register_operand"		    "=Rg")
	(mult:DI
	  (zero_extend:DI (match_operand:SI 1 "gr_register_operand" " Rg"))
	  (zero_extend:DI (match_operand:SI 2 "gr_register_operand" " Rg"))))]
  ""
  "%P0 = mpyu(%1,%2)"
  [(set_attr "type" "M")]
)


;;-------------------;;
;; smul{m}3_highpart ;;
;;-------------------;;

(define_insn "smulsi3_highpart"
  [(set (match_operand:SI 0 "gr_register_operand"		 "=Rg")
	(truncate:SI
	  (lshiftrt:DI
	    (mult:DI (sign_extend:DI
		       (match_operand:SI 1 "gr_register_operand" " Rg"))
		     (sign_extend:DI
		       (match_operand:SI 2 "gr_register_operand" " Rg")))
	    (const_int 32))))]
  ""
  "%0 = mpy(%1,%2)"
  [(set_attr "type" "M")]
)


;;-------------------;;
;; umul{m}3_highpart ;;
;;-------------------;;

(define_insn "umulsi3_highpart"
  [(set (match_operand:SI 0 "gr_register_operand"		 "=Rg")
	(truncate:SI
	  (lshiftrt:DI
	    (mult:DI (zero_extend:DI
		       (match_operand:SI 1 "gr_register_operand" " Rg"))
		     (zero_extend:DI
		       (match_operand:SI 2 "gr_register_operand" " Rg")))
	    (const_int 32))))]
  ""
  "%0 = mpyu(%1,%2)"
  [(set_attr "type" "M")]
)

(define_expand "umuldi3_highpart"
  [(set (match_operand:DI 0 "gr_register_operand"		 "=&Rg")
	(truncate:DI
	  (lshiftrt:TI
	    (mult:TI (zero_extend:TI
		       (match_operand:DI 1 "gr_register_operand" "  Rg"))
		     (zero_extend:TI
		       (match_operand:DI 2 "gr_register_operand" "  Rg")))
	    (const_int 64))))]
  ""
  {
    rtx reg0, reg1, reg2;
    reg0 = gen_reg_rtx (DImode);
    reg1 = gen_reg_rtx (DImode);
    reg2 = gen_reg_rtx (DImode);
    emit_move_insn (gen_highpart (SImode, reg0), const0_rtx);
    emit_move_insn (gen_highpart (SImode, reg2), const0_rtx);
    emit_insn (gen_umulsi3_highpart (gen_lowpart (SImode, reg0),
				     gen_lowpart (SImode, operands[1]),
				     gen_lowpart (SImode, operands[2])));
    emit_insn (gen_umulsidi3 (reg1, gen_lowpart (SImode, operands[1]),
			      gen_highpart (SImode, operands[2])));
    emit_insn (gen_umacsidi3 (reg0, gen_highpart (SImode, operands[1]),
			      gen_lowpart (SImode, operands[2]), reg0));
    /* ??? The next two instructions could be combines. */
    emit_move_insn (gen_lowpart (SImode, reg2), gen_lowpart (SImode, reg1));
    emit_insn (gen_lshrdi3 (operands[0], reg1, gen_int_mode (32, DImode)));
    emit_insn (gen_adddi3 (reg0, reg0, reg2));
    emit_insn (gen_umacsidi3 (operands[0], gen_highpart (SImode, operands[1]),
			      gen_highpart (SImode, operands[2]),
					    operands[0]));
    emit_insn (gen_lshrdi3_acc (operands[0], reg0,
				gen_int_mode (32, DImode), operands[0]));
    DONE;
  }
)


;;----------;;
;; ashl{m}3 ;;
;;----------;;

(define_expand "ashlsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(ashift:SI (match_operand:SI 1 "nonmemory_operand" "")
		   (match_operand:SI 2 "nonmemory_operand" "")))]
  ""
  {
    if (!TARGET_V4_FEATURES
	&& !reload_completed && !gr_register_operand (operands[1], SImode))
      operands[1] = force_reg (SImode, operands[1]);
  }
)

(define_insn "ashlsi3_real_v4"
  [(set (match_operand:SI 0 "gr_register_operand"  "=Rg, Rg, Rg, Rg, Rg,Rg")
	(ashift:SI (match_operand:SI 1 "nonmemory_operand"
						   " Rg, Rg, Rg, Rg,Is6,Rg")
		   (match_operand:SI 2 "nonmemory_operand"
						   "K16,Iu0,Iu1,Iu5, Rg,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = aslh(%1)
   %0 = %1
   %0 = add(%1,%1)
   %0 = asl(%1,#%2)
   %0 = lsl(#%1,%2)
   %0 = asl(%1,%2)"
  [(set_attr "type" "A,A,A,S,S,S")
   (set_attr "predicable" "yes,no,no,no,no,no")]
)

(define_insn "ashlsi3_real"
  [(set (match_operand:SI 0 "gr_register_operand"      "=Rg, Rg, Rg, Rg,Rg")
	(ashift:SI (match_operand:SI 1 "gr_register_operand"
						       " Rg, Rg, Rg, Rg,Rg")
		   (match_operand:SI 2 "nonmemory_operand"
						       "K16,Iu0,Iu1,Iu5,Rg")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 = aslh(%1)
   %0 = %1
   %0 = add(%1,%1)
   %0 = asl(%1,#%2)
   %0 = asl(%1,%2)"
  [(set_attr "type" "A,A,A,S,S")
   (set_attr "predicable" "yes,no,no,no,no")]
)

(define_insn "ashldi3"
  [(set (match_operand:DI 0 "gr_register_operand"	     "=Rg, Rg")
	(ashift:DI (match_operand:DI 1 "gr_register_operand" " Rg, Rg")
		   (match_operand:SI 2 "nonmemory_operand"   " Rg,Iu6")))]
  ""
  "@
   %P0 = asl(%P1,%2)
   %P0 = asl(%P1,#%2)"
  [(set_attr "type" "S,S")]
)


;;----------;;
;; ashr{m}3 ;;
;;----------;;

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	       "=Rg, Rg, Rg")
	(ashiftrt:SI (match_operand:SI 1 "gr_register_operand" " Rg, Rg, Rg")
		     (match_operand:SI 2 "nonmemory_operand"   " Rg,K16,Iu5")))]
  ""
  "@
   %0 = asr(%1,%2)
   %0 = asrh(%1)
   %0 = asr(%1,#%2)"
  [(set_attr "type" "S,A,S")
   (set_attr "predicable" "no,yes,no")]
)

(define_insn "ashrdi3"
  [(set (match_operand:DI 0 "gr_register_operand"	       "=Rg, Rg, Rg")
	(ashiftrt:DI (match_operand:DI 1 "gr_register_operand" " Rg, Rg, Rg")
		     (match_operand:SI 2 "nonmemory_operand"   " Rg,K32,Iu6")))]
  ""
  "@
   %P0 = asr(%P1,%2)
   %P0 = sxtw(%H1)
   %P0 = asr(%P1,#%2)"
  [(set_attr "type" "S,X,S")]
)


;;----------;;
;; lshr{m}3 ;;
;;----------;;

(define_insn "lshrsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	       "=Rg, Rg")
	(lshiftrt:SI (match_operand:SI 1 "gr_register_operand" " Rg, Rg")
		     (match_operand:SI 2 "nonmemory_operand"   " Rg,Iu5")))]
  ""
  "@
   %0 = lsr(%1,%2)
   %0 = lsr(%1,#%2)"
  [(set_attr "type" "S,S")]
)

(define_insn "lshrdi3"
  [(set (match_operand:DI 0 "gr_register_operand"	       "=Rg, Rg")
	(lshiftrt:DI (match_operand:DI 1 "gr_register_operand" " Rg, Rg")
		     (match_operand:SI 2 "nonmemory_operand"   " Rg,Iu6")))]
  ""
  "@
   %P0 = lsr(%P1,%2)
   %P0 = lsr(%P1,#%2)"
  [(set_attr "type" "S,S")]
)


;;---------;;
;; neg{m}2 ;;
;;---------;;

(define_insn "negsi2"
  [(set (match_operand:SI 0 "gr_register_operand"	  "=Rg")
	(neg:SI (match_operand:SI 1 "gr_register_operand" " Rg")))]
  ""
  "%0 = neg(%1)"
  [(set_attr "type" "A")]
)

(define_insn "negdi2"
  [(set (match_operand:DI 0 "gr_register_operand"	  "=Rg")
	(neg:DI (match_operand:DI 1 "gr_register_operand" " Rg")))]
  ""
  "%P0 = neg(%P1)"
  [(set_attr "type" "X")]
)


;;---------;;
;; abs{m}2 ;;
;;---------;;

(define_insn "abssi2"
  [(set (match_operand:SI 0 "gr_register_operand"	  "=Rg")
	(abs:SI (match_operand:SI 1 "gr_register_operand" " Rg")))]
  ""
  "%0 = abs(%1)"
  [(set_attr "type" "X")]
)

(define_insn "absdi2"
  [(set (match_operand:DI 0 "gr_register_operand"	  "=Rg")
	(abs:DI (match_operand:DI 1 "gr_register_operand" " Rg")))]
  ""
  "%P0 = abs(%P1)"
  [(set_attr "type" "X")]
)


;;---------;;
;; clz{m}2 ;;
;;---------;;

(define_insn "clzsi2"
  [(set (match_operand:SI 0 "gr_register_operand"	  "=Rg")
	(clz:SI (match_operand:SI 1 "gr_register_operand" " Rg")))]
  ""
  "%0 = cl0(%1)"
  [(set_attr "type" "S")]
)


;;---------;;
;; ctz{m}2 ;;
;;---------;;

(define_insn "ctzsi2"
  [(set (match_operand:SI 0 "gr_register_operand"	  "=Rg")
	(ctz:SI (match_operand:SI 1 "gr_register_operand" " Rg")))]
  ""
  "%0 = ct0(%1)"
  [(set_attr "type" "S")]
)


;;--------------;;
;; one_cmpl{m}2 ;;
;;--------------;;

(define_insn "one_cmplbi2"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp")
	(not:BI (match_operand:BI 1 "pr_register_operand" " Rp")))]
  ""
  "%0 = not(%1)"
  [(set_attr "type" "S")]
)

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "gr_register_operand"	  "=Rg")
	(not:SI (match_operand:SI 1 "gr_register_operand" " Rg")))]
  ""
  "%0 = not(%1)"
  [(set (attr "type")
	(cond [(eq_attr "arch" "v1") (const_string "X")]
				     (const_string "A")))]
)

(define_insn "one_cmpldi2"
  [(set (match_operand:DI 0 "gr_register_operand"	"=Rg")
	(not:DI (match_operand:DI 1 "gr_register_operand" "Rg")))]
  ""
  "%P0 = not(%P1)"
  [(set_attr "type" "X")]
)


;;--------;;
;; cmp{m} ;;
;;--------;;

(define_insn "cmpsi_eq_v4"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp, Rp,Rp,Rp")
	(eq:BI (match_operand:SI 1 "gr_register_operand" " Rg, Rg,Rg,Rg")
	       (match_operand:SI 2 "nonmemory_operand"   "Iu2,IsA, i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = cmp.eq(%1,#%2)
   %0 = cmp.eq(%1,#%2)
   %0 = cmp.eq(%1,##%2)
   %0 = cmp.eq(%1,%2)"
  [(set_attr "type" "A,A,EA,A")
   (set_attr "duplex" "yes,no,no,no")]
)

(define_insn "cmpsi_gt_v4"
  [(set (match_operand:BI 0 "pr_register_operand"	 "=Rp,Rp,Rp")
	(gt:BI (match_operand:SI 1 "gr_register_operand" " Rg,Rg,Rg")
	       (match_operand:SI 2 "nonmemory_operand"	 "IsA, i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = cmp.gt(%1,#%2)
   %0 = cmp.gt(%1,##%2)
   %0 = cmp.gt(%1,%2)"
  [(set_attr "type" "A,EA,A")]
)

(define_insn "cmpsi_ge_v4"
  [(set (match_operand:BI 0 "pr_register_operand"	 "=Rp,Rp")
	(ge:BI (match_operand:SI 1 "gr_register_operand" " Rg,Rg")
	       (match_operand:SI 2 "immediate_operand"	 "KXp, i")))]
  "TARGET_V4_FEATURES"
  {
    operands[2] = plus_constant (operands[2], -1);
    if (which_alternative == 0)
      return "%0 = cmp.gt(%1,#%2)";
    else
      return "%0 = cmp.gt(%1,##%2)";
  }
  [(set_attr "type" "A,EA")]
)

(define_insn "cmpsi_gtu_v4"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp,Rp,Rp")
	(gtu:BI (match_operand:SI 1 "gr_register_operand" " Rg,Rg,Rg")
		(match_operand:SI 2 "nonmemory_operand"	  "Iu9, i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = cmp.gtu(%1,#%2)
   %0 = cmp.gtu(%1,##%2)
   %0 = cmp.gtu(%1,%2)"
  [(set_attr "type" "A,EA,A")]
)

(define_insn "cmpsi_geu_v4"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp,Rp")
	(geu:BI (match_operand:SI 1 "gr_register_operand" " Rg,Rg")
		(match_operand:SI 2 "immediate_operand"   "Ku9, i")))]
  "TARGET_V4_FEATURES"
  {
    operands[2] = plus_constant (operands[2], -1);
    if (which_alternative == 0)
      return "%0 = cmp.gtu(%1,#%2)";
    else
      return "%0 = cmp.gtu(%1,##%2)";
  }
  [(set_attr "type" "A,EA")]
)

(define_insn "cmpsi_ne"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp,Rp,Rp")
	(ne:BI (match_operand:SI 1 "gr_register_operand" " Rg,Rg,Rg")
	       (match_operand:SI 2 "nonmemory_operand"	 "IsA, i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = !cmp.eq(%1,#%2)
   %0 = !cmp.eq(%1,##%2)
   %0 = !cmp.eq(%1,%2)"
  [(set_attr "type" "A,EA,A")]
)

(define_insn "cmpsi_le"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp,Rp,Rp")
	(le:BI (match_operand:SI 1 "gr_register_operand" " Rg,Rg,Rg")
	       (match_operand:SI 2 "nonmemory_operand"	 "IsA, i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = !cmp.gt(%1,#%2)
   %0 = !cmp.gt(%1,##%2)
   %0 = !cmp.gt(%1,%2)"
  [(set_attr "type" "A,EA,A")]
)

(define_insn "cmpsi_lt_v4"
  [(set (match_operand:BI 0 "pr_register_operand"	 "=Rp,Rp")
	(lt:BI (match_operand:SI 1 "gr_register_operand" " Rg,Rg")
	       (match_operand:SI 2 "immediate_operand"	 "KXp, i")))]
  "TARGET_V4_FEATURES"
  {
    operands[2] = plus_constant (operands[2], -1);
    if (which_alternative == 0)
      return "%0 = !cmp.gt(%1,#%2)";
    else
      return "%0 = !cmp.gt(%1,##%2)";
  }
  [(set_attr "type" "A,EA")]
)

(define_insn "cmpsi_leu"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp,Rp,Rp")
	(leu:BI (match_operand:SI 1 "gr_register_operand" " Rg,Rg,Rg")
		(match_operand:SI 2 "nonmemory_operand"	  "Iu9, i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = !cmp.gtu(%1,#%2)
   %0 = !cmp.gtu(%1,##%2)
   %0 = !cmp.gtu(%1,%2)"
  [(set_attr "type" "A,EA,A")]
)

(define_insn "cmpsi_ltu_v4"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp,Rp")
	(ltu:BI (match_operand:SI 1 "gr_register_operand" " Rg,Rg")
		(match_operand:SI 2 "immediate_operand"   "Ku9, i")))]
  "TARGET_V4_FEATURES"
  {
    operands[2] = plus_constant (operands[2], -1);
    if (which_alternative == 0)
      return "%0 = !cmp.gtu(%1,#%2)";
    else
      return "%0 = !cmp.gtu(%1,##%2)";
  }
  [(set_attr "type" "A,EA")]
)

(define_insn "cmpsi_eq_imm"
  [(set (match_operand:BI 0 "pr_register_operand"	   "=Rp,Rp")
	(eq:BI (match_operand:SI 1 "gr_register_operand"   " Rg,Rg")
	       (match_operand:SI 2 "s10_const_int_operand" "IsA,Rg")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 = cmp.eq(%1,#%2)
   %0 = cmp.eq(%1,%2)"
  [(set_attr "type" "A,A")]
)

(define_insn "cmpsi_gt_imm"
  [(set (match_operand:BI 0 "pr_register_operand"	   "=Rp,Rp")
	(gt:BI (match_operand:SI 1 "gr_register_operand"   " Rg,Rg")
	       (match_operand:SI 2 "s10_const_int_operand" "IsA,Rg")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 = cmp.gt(%1,#%2)
   %0 = cmp.gt(%1,%2)"
  [(set_attr "type" "A,A")]
)

(define_insn "cmpsi_gtu_imm"
  [(set (match_operand:BI 0 "pr_register_operand"	   "=Rp,Rp")
	(gtu:BI (match_operand:SI 1 "gr_register_operand"  " Rg,Rg")
		(match_operand:SI 2 "u9_const_int_operand" "Iu9,Rg")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 = cmp.gtu(%1,#%2)
   %0 = cmp.gtu(%1,%2)"
  [(set_attr "type" "A,A")]
)

(define_insn "cmpsi_eq"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp")
	(eq:BI (match_operand:SI 1 "gr_register_operand" " Rg")
	       (match_operand:SI 2 "gr_register_operand" " Rg")))]
  "!TARGET_V4_FEATURES"
  "%0 = cmp.eq(%1,%2)"
  [(set_attr "type" "A")]
)

(define_insn "cmpsi_gt"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp")
	(gt:BI (match_operand:SI 1 "gr_register_operand" " Rg")
	       (match_operand:SI 2 "gr_register_operand" " Rg")))]
  "!TARGET_V4_FEATURES"
  "%0 = cmp.gt(%1,%2)"
  [(set_attr "type" "A")]
)

(define_insn "cmpsi_gtu"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp")
	(gtu:BI (match_operand:SI 1 "gr_register_operand" " Rg")
		(match_operand:SI 2 "gr_register_operand" " Rg")))]
  "!TARGET_V4_FEATURES"
  "%0 = cmp.gtu(%1,%2)"
  [(set_attr "type" "A")]
)

(define_insn "cmpsi_ne_zero"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp")
	(ne:BI (match_operand:SI 1 "gr_register_operand" " Rg")
	       (const_int 0)))]
  "!TARGET_V4_FEATURES"
  "%0 = cmp.gtu(%1,#0)  // %1 != 0"
  [(set_attr "type" "A")]
)

(define_insn "cmpdi_eq"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp")
	(eq:BI (match_operand:DI 1 "gr_register_operand" " Rg")
	       (match_operand:DI 2 "gr_register_operand" " Rg")))]
  ""
  "%0 = cmp.eq(%P1,%P2)"
  [(set_attr "type" "X")]
)

(define_insn "cmpdi_gt"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp")
	(gt:BI (match_operand:DI 1 "gr_register_operand" " Rg")
	       (match_operand:DI 2 "gr_register_operand" " Rg")))]
  ""
  "%0 = cmp.gt(%P1,%P2)"
  [(set_attr "type" "X")]
)

(define_insn "cmpdi_gtu"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp")
	(gtu:BI (match_operand:DI 1 "gr_register_operand" " Rg")
		(match_operand:DI 2 "gr_register_operand" " Rg")))]
  ""
  "%0 = cmp.gtu(%P1,%P2)"
  [(set_attr "type" "X")]
)


;;-----------;;
;; movmem{m} ;;
;;-----------;;

(define_expand "movmemsi"
  [(use (match_operand:BLK 0 "memory_operand" ""))
   (use (match_operand:BLK 1 "memory_operand" ""))
   (use (match_operand:SI 2 "nonmemory_operand" ""))
   (use (match_operand:SI 3 "const_int_operand" ""))
   (use (match_operand:SI 4 "const_int_operand" ""))
   (use (match_operand:SI 5 "const_int_operand" ""))]
  ""
  {
    if (hexagon_expand_movmem (operands[0], operands[1],
			       operands[2], operands[3]))
      DONE;
    else
      FAIL;
  }
)


;;-----------;;
;; setmem{m} ;;
;;-----------;;

(define_expand "setmemsi"
  [(use (match_operand:BLK 0 "memory_operand" ""))
   (use (match_operand:SI 1 "const_int_operand" ""))
   (use (match_operand:SI 2 "const_int_operand" ""))
   (use (match_operand:SI 3 "const_int_operand" ""))
   (use (match_operand:SI 4 "const_int_operand" ""))
   (use (match_operand:SI 5 "const_int_operand" ""))]
  "optimize && !optimize_size"
  {
    if (TARGET_HARDWARE_LOOPS && hexagon_expand_setmem (operands))
      DONE;
    else
      FAIL;
  }
)


;;---------------;;
;; extend{m}{n}2 ;;
;;---------------;;

;; char -> int

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg, Rg, Rg,Rg")
	(sign_extend:SI (match_operand:QI 1 "nonimmediate_operand_with_GP"
							   " Rg,Ad3,Anx, m")))]
  ""
  "@
   %0 = sxtb(%1)
   %0 = memb(%1)
   %0 = memb(%1)
   %0 = memb(%E1)"
  [(set_attr "type" "A,Load,Load,ELoad")
   (set_attr "duplex" "yes,yes,no,no")
   (set_attr "predicable" "yes,no,no,no")]
)

(define_insn "extendqisi2_new_mem"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg,Rg")
	(sign_extend:SI
	  (unspec:QI [(match_operand:QI 1 "memory_operand" "Anx, m")]
		     UNSPEC_NEW_VALUE)))]
  "TARGET_V5_FEATURES"
  "@
   %0 = memb(%1).new
   %0 = memb(%E1).new"
  [(set_attr "type" "NewLoad,ENewLoad")]
)

(define_insn_and_split "extendqidi2"
  [(set (match_operand:DI 0 "gr_register_operand"	     "=Rg,Rg")
	(sign_extend:DI
	  (match_operand:QI 1 "nonimmediate_operand_with_GP" " Rg, m")))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 2) (sign_extend:SI (match_dup 1)))
   (set (match_dup 0) (sign_extend:DI (match_dup 2)))]
  {
    operands[2] = gen_lowpart (SImode, operands[0]);
  }
  [(set_attr "type" "multiple,multiple")]
)

;; short -> int

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg, Rg, Rg,Rg")
	(sign_extend:SI
	  (match_operand:HI 1 "nonimmediate_operand_with_GP"
							   " Rg,Ad3,Anx, m")))]
  ""
  "@
   %0 = sxth(%1)
   %0 = memh(%1)
   %0 = memh(%1)
   %0 = memh(%E1)"
  [(set_attr "type" "A,Load,Load,ELoad")
   (set_attr "duplex" "yes,yes,no,no")
   (set_attr "predicable" "yes,no,no,no")]
)


(define_insn "extendhisi2_new_mem"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg,Rg")
	(sign_extend:SI
	  (unspec:HI [(match_operand:HI 1 "memory_operand" "Anx, m")]
		     UNSPEC_NEW_VALUE)))]
  "TARGET_V5_FEATURES"
  "@
   %0 = memh(%1).new
   %0 = memh(%E1).new"
  [(set_attr "type" "NewLoad,ENewLoad")]
)

;; short -> long long

(define_insn_and_split "extendhidi2"
  [(set (match_operand:DI 0 "gr_register_operand"	     "=Rg,Rg")
	(sign_extend:DI
	  (match_operand:HI 1 "nonimmediate_operand_with_GP" " Rg, m")))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 2) (sign_extend:SI (match_dup 1)))
   (set (match_dup 0) (sign_extend:DI (match_dup 2)))]
  {
    operands[2] = gen_lowpart (SImode, operands[0]);
  }
  [(set_attr "type" "multiple,multiple")]
)

(define_insn "extendsidi2"
  [(set (match_operand:DI 0 "gr_register_operand"		  "=Rg")
	(sign_extend:DI (match_operand:SI 1 "gr_register_operand" " Rg")))]
  ""
  "%P0 = sxtw(%1)"
  [(set_attr "type" "X")]
)

;; char -> int

(define_insn "zero_extendqisi2"
  [(set (match_operand:SI 0 "gr_register_operand"      "=Rg, Rg, Rg,Rg,?Rg")
	(zero_extend:SI (match_operand:QI 1 "nonimmediate_operand_with_GP"
						       " Rg,Ad4,Anx, m,*Rp")))]
  ""
  "@
   %0 = zxtb(%1)
   %0 = memub(%1)
   %0 = memub(%1)
   %0 = memub(%E1)
   %0 = %1"
  [(set_attr "type" "A,Load,Load,ELoad,S")
   (set_attr "duplex" "yes,yes,no,no,no")
   (set_attr "predicable" "yes,no,no,no,no")]
)

(define_insn "zero_extendqisi2_new_mem"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg,Rg")
	(zero_extend:SI
	  (unspec:QI [(match_operand:QI 1 "memory_operand" "Anx, m")]
				   UNSPEC_NEW_VALUE)))]
  "TARGET_V5_FEATURES"
  "@
   %0 = memub(%1).new
   %0 = memub(%E1).new"
  [(set_attr "type" "NewLoad,ENewLoad")]
)

;; char -> long long

(define_insn_and_split "zero_extendqidi2"
  [(set (match_operand:DI 0 "gr_register_operand"	     "=Rg,Rg")
	(zero_extend:DI
	  (match_operand:QI 1 "nonimmediate_operand_with_GP" " Rg, m")))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 2) (zero_extend:SI (match_dup 1)))
   (set (match_dup 3) (const_int 0))]
  {
    operands[2] = gen_lowpart (SImode, operands[0]);
    operands[3] = gen_highpart (SImode, operands[0]);
  }
  [(set_attr "type" "multiple,multiple")]
)

;; short -> int

(define_insn "zero_extendhisi2"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg, Rg, Rg,Rg")
	(zero_extend:SI (match_operand:HI 1 "nonimmediate_operand_with_GP"
							   " Rg,Ad3,Anx, m")))]
  ""
  "@
   %0 = zxth(%1)
   %0 = memuh(%1)
   %0 = memuh(%1)
   %0 = memuh(%E1)"
  [(set_attr "type" "A,Load,Load,ELoad")
   (set_attr "duplex" "yes,yes,no,no")
   (set_attr "predicable" "yes,no,no,no")]
)

(define_insn "zero_extendhisi2_new_mem"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg,Rg")
	(zero_extend:SI
	  (unspec:HI [(match_operand:HI 1 "memory_operand" "Anx, m")]
		     UNSPEC_NEW_VALUE)))]
  "TARGET_V5_FEATURES"
  "@
   %0 = memuh(%1).new
   %0 = memuh(%E1).new"
  [(set_attr "type" "NewLoad,ENewLoad")]
)

;; short -> long long

(define_insn_and_split "zero_extendhidi2"
  [(set (match_operand:DI 0 "gr_register_operand"	     "=Rg,Rg")
	(zero_extend:DI
	  (match_operand:HI 1 "nonimmediate_operand_with_GP" " Rg, m")))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 2) (zero_extend:SI (match_dup 1)))
   (set (match_dup 3) (const_int 0))]
  {
    operands[2] = gen_lowpart (SImode, operands[0]);
    operands[3] = gen_highpart (SImode, operands[0]);
  }
  [(set_attr "type" "multiple,multiple")]
)

;; int/long -> long long

(define_insn_and_split "zero_extendsidi2"
  [(set (match_operand:DI 0 "gr_register_operand"	     "=Rg,Rg")
	(zero_extend:DI
	  (match_operand:SI 1 "nonimmediate_operand_with_GP" " Rg, m")))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 3) (const_int 0))]
  {
    operands[2] = gen_lowpart (SImode, operands[0]);
    operands[3] = gen_highpart (SImode, operands[0]);
  }
  [(set_attr "type" "multiple,multiple")]
)


;;-------;;
;; extzv ;;
;;-------;;

(define_insn "extzv"
  [(set (match_operand:SI 0 "gr_register_operand"		    "=Rg")
	(zero_extract:SI (match_operand:SI 1 "gr_register_operand"  " Rg")
			 (match_operand:SI 2 "u5_const_int_operand" "Iu5")
			 (match_operand:SI 3 "u5_const_int_operand" "Iu5")))]
  ""
  "%0 = extractu(%1,#%2,#%3)"
  [(set_attr "type" "S")]
)


;;------;;
;; insv ;;
;;------;;

(define_insn "insv"
  [(set (zero_extract:SI (match_operand:SI 0 "gr_register_operand"  "+Rg")
			 (match_operand:SI 1 "u5_const_int_operand" "Iu5")
			 (match_operand:SI 2 "u5_const_int_operand" "Iu5"))
	(match_operand:SI 3 "gr_register_operand"		    " Rg"))]
  ""
  "%0 = insert(%3,#%1,#%2)"
  [(set_attr "type" "S")]
)


;;-----------;;
;; mux insns ;;
;;-----------;;

(define_insn "muxtsi_v4"
  [(set (match_operand:SI 0 "gr_register_operand"    "=Rg, Rg,Rg, Rg,Rg, Rg")
	(if_then_else:SI
	  (ne
	    (match_operand:BI 1 "pr_register_operand" "Rp, Rp,Rp, Rp,Rp, Rp")
	    (const_int 0))
	  (match_operand:SI 2 "nonmemory_operand"     "Rg, Rg,Rg,Is8, i,Is8")
	  (match_operand:SI 3 "nonmemory_operand"     "Rg,Is8, i, Rg,Rg,Is8")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = mux(%1,%2,%3)
   %0 = mux(%1,%2,#%3)
   %0 = mux(%1,%2,##%3)
   %0 = mux(%1,#%2,%3)
   %0 = mux(%1,##%2,%3)
   %0 = mux(%1,#%2,#%3)"
  [(set_attr "type" "A,A,EA,A,EA,A")]
)

(define_insn "muxfsi_v4"
  [(set (match_operand:SI 0 "gr_register_operand"    "=Rg, Rg,Rg, Rg,Rg, Rg")
	(if_then_else:SI
	  (eq
	    (match_operand:BI 1 "pr_register_operand" "Rp, Rp,Rp, Rp,Rp, Rp")
	    (const_int 0))
	  (match_operand:SI 2 "nonmemory_operand"     "Rg,Is8, i, Rg,Rg,Is8")
	  (match_operand:SI 3 "nonmemory_operand"     "Rg, Rg,Rg,Is8, i,Is8")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = mux(%1,%3,%2)
   %0 = mux(%1,%3,#%2)
   %0 = mux(%1,%3,##%2)
   %0 = mux(%1,#%3,%2)
   %0 = mux(%1,##%3,%2)
   %0 = mux(%1,#%3,#%2)"
  [(set_attr "type" "A,A,EA,A,EA,A")]
)

(define_insn "muxtsi"
  [(set (match_operand:SI 0 "gr_register_operand"     "=Rg, Rg, Rg, Rg")
	(if_then_else:SI
	  (ne
	    (match_operand:BI 1 "pr_register_operand" " Rp, Rp, Rp, Rp")
	    (const_int 0))
	  (match_operand:SI 2 "nonmemory_operand"     " Rg, Rg,Is8,Is8")
	  (match_operand:SI 3 "nonmemory_operand"     " Rg,Is8, Rg,Is8")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 = mux(%1,%2,%3)
   %0 = mux(%1,%2,#%3)
   %0 = mux(%1,#%2,%3)
   %0 = mux(%1,#%2,#%3)"
  [(set_attr "type" "A,A,A,A")]
)

(define_insn "muxfsi"
  [(set (match_operand:SI 0 "gr_register_operand"     "=Rg, Rg, Rg, Rg")
	(if_then_else:SI
	  (eq
	    (match_operand:BI 1 "pr_register_operand" " Rp, Rp, Rp, Rp")
	    (const_int 0))
	  (match_operand:SI 2 "nonmemory_operand"     " Rg,Is8, Rg,Is8")
	  (match_operand:SI 3 "nonmemory_operand"     " Rg, Rg,Is8,Is8")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 = mux(%1,%3,%2)
   %0 = mux(%1,%3,#%2)
   %0 = mux(%1,#%3,%2)
   %0 = mux(%1,#%3,#%2)"
  [(set_attr "type" "A,A,A,A")]
)


;;--------------;;
;; cstore insns ;;
;;--------------;;

(define_expand "cstoresi4"
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(match_operator:SI 1 "comparison_operator"
	  [(match_operand:SI 2 "gr_register_operand" "")
	   (match_operand:SI 3 "nonmemory_operand" "")]))]
  ""
{
  rtx cmp;

  switch (GET_CODE (operands[1]))
    {
    case EQ:
    case NE:
      if (!TARGET_V4_FEATURES)
	goto non_v4;
      break;

    default:
    non_v4:
      cmp = hexagon_expand_compare (GET_CODE (operands[1]), operands[2],
				    operands[3]);

      emit_insn (gen_hexagon_cstoresi (operands[0], cmp));
      DONE;
    }
})

(define_mode_iterator REGCMP [QI HI DI SF DF])

(define_expand "cstore<mode>4"
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(match_operator:SI 1 "comparison_operator"
	  [(match_operand:REGCMP 2 "gr_register_operand" "")
	   (match_operand:REGCMP 3 "nonmemory_operand" "")]))]
  "<MODE>mode == DImode || TARGET_V5_FEATURES
   || (TARGET_V4_FEATURES && GET_MODE_CLASS (<MODE>mode) == MODE_INT)"
  {
    rtx cmp = hexagon_expand_compare (GET_CODE (operands[1]), operands[2],
				      operands[3]);
    emit_insn (gen_hexagon_cstoresi (operands[0], cmp));
    DONE;
  }
)

; Helper expander for cstore<mode>4.

(define_expand "hexagon_cstoresi"
  [(set (match_operand:SI 0 "" "")
	(if_then_else:SI (match_operand 1 "" "") (const_int 1) (const_int 0)))]
  ""
  {})


;; GPR conditional jump introduced in v3

(define_insn "gpr_cond_jump"
  [(set (pc)
	(if_then_else (match_operator 0 "gpr_cond_jump_operator"
			[(match_operand:SI 1 "gr_register_operand" "*Rg")
			 (const_int 0)])
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  "TARGET_V3_FEATURES && !TARGET_V4_FEATURES"
  {
    int predict_taken;
    predict_taken = INTVAL (hexagon_branch_hint (insn));

  #define HEXAGON_FIXUP_GPR_JUMP(string)		\
    ((get_attr_length (insn) == 4)		\
      ? string					\
      : "jump %l4\n%l2:\;jump %l3\n%l4:\;" string)

    if (get_attr_length (insn) != 4)
      {
	/* Create a new label and swap that with the real target. */
	operands[3] = operands[2];
	operands[2] = gen_label_rtx ();
	operands[4] = gen_label_rtx ();
      }

    switch (GET_CODE (operands[0]))
      {
      case EQ:
	if (predict_taken)
	  return HEXAGON_FIXUP_GPR_JUMP ("if (%1==#0) jump:t %l2");
	else
	  return HEXAGON_FIXUP_GPR_JUMP ("if (%1==#0) jump:nt %l2");

      case NE:
	if (predict_taken)
	  return HEXAGON_FIXUP_GPR_JUMP ("if (%1!=#0) jump:t %l2");
	else
	  return HEXAGON_FIXUP_GPR_JUMP ("if (%1!=#0) jump:nt %l2");

      case GE:
	if (predict_taken)
	  return HEXAGON_FIXUP_GPR_JUMP ("if (%1>=#0) jump:t %l2");
	else
	  return HEXAGON_FIXUP_GPR_JUMP ("if (%1>=#0) jump:nt %l2");

      case LE:
	if (predict_taken)
	  return HEXAGON_FIXUP_GPR_JUMP ("if (%1<=#0) jump:t %l2");
	else
	  return HEXAGON_FIXUP_GPR_JUMP ("if (%1<=#0) jump:nt %l2");

      default:
        gcc_unreachable ();
      }
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "CR")
		      (const_string "multiple")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 2) (pc))) (const_int 15000))
		      (const_string "4")
		      (const_string "12")))]
)

(define_insn "cond_jump"
  [(set (pc)
	(if_then_else (match_operator 0 "predicate_operator"
			[(match_operand:BI 1 "pr_register_operand" "Rp")
			 (const_int 0)])
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  {
    if (get_attr_length (insn) == 4)
      {
	operands[3] = hexagon_branch_hint (insn);
	return "if (%C0) jump%h3 %l2";
      }
    else
      {
	operands[3] = gen_label_rtx ();
	return "if (%I0) jump %l3\;jump %l2\n%l3:";
      }
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "J")
		      (const_string "multiple")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 2) (pc))) (const_int 50000))
		      (const_string "4")
		      (const_string "8")))]
)

(define_insn "cond_jump_v4"
  [(set (pc)
	(if_then_else (match_operator 0 "predicate_operator"
			[(match_operand:BI 1 "pr_register_operand" "Rp")
			 (const_int 0)])
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  "TARGET_V4_FEATURES"
  {
    operands[3] = hexagon_branch_hint (insn);
    if (get_attr_length (insn) == 4)
      return "if (%C0) jump%h3 %l2";
    else
      return "if (%C0) jump%h3 ##%l2";
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "J")
		      (const_string "EJ")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 2) (pc))) (const_int 50000))
		      (const_string "4")
		      (const_string "8")))]
)

(define_insn "new_value_jump_tstbit"
  [(set (pc)
	(if_then_else
	  (match_operator 0 "predicate_operator"
	    [(zero_extract:SI (unspec:SI
				[(match_operand:SI 1 "gr_register_operand"
								       "Rg")]
				UNSPEC_NEW_VALUE)
			      (const_int 1)
			      (match_operand:SI 2 "immediate_operand"  "Iu0"))
			 (const_int 0)])
	  (label_ref (match_operand 3 "" ""))
	  (pc)))
  (set (match_operand:BI 4 "pr_register_operand" "=Rp")
       (if_then_else:BI
	 (match_op_dup 0
	   [(zero_extract:SI (unspec:SI [(match_dup 1)] UNSPEC_NEW_VALUE)
			     (const_int 1)
			     (match_dup 2))
	    (const_int 0)])
	 (const_int 1) (const_int 0)))]
  "TARGET_V4_FEATURES"
  {
    int predict_taken;
    enum rtx_code code;

    predict_taken = 0;
    code = GET_CODE (operands[0]);
    predict_taken = INTVAL (hexagon_branch_hint (insn));

    if (GET_CODE (operands[2]) == CONST_INT)
      switch (code)
	{
	case EQ:
	  if (predict_taken)
	    return "if (tstbit(%1.new,#%2)) jump:t %l3";
	  else
	    return "if (tstbit(%1.new,#%2)) jump:nt %l3";

	case NE:
	  if (predict_taken)
	    return "if (!tstbit(%1.new,#%2)) jump:t %l3";
	  else
	    return "if (!tstbit(%1.new,#%2)) jump:nt %l3";

	default:
	  gcc_unreachable ();
	}
    else
      switch (code)
	{
	case EQ:
	    if (predict_taken)
	      return "if (tstbit(%1.new,%2)) jump:t %l3";
	    else
	      return "if (tstbit(%1.new,%2)) jump:nt %l3";

	case NE:
	    if (predict_taken)
	      return "if (!tstbit(%1.new,%2)) jump:t %l3";
	    else
	      return "if (!tstbit(%1.new,%2)) jump:nt %l3";

	default:
	  gcc_unreachable ();
	}
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "NewValueJump")
		      (const_string "ENewValueJump")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 3) (pc))) (const_int 1000))
		      (const_string "4")
		      (const_string "8")))]
)

(define_insn "compare_and_jump_tstbit"
  [(set (pc)
	(if_then_else
	  (match_operator 0 "predicate_operator"
	    [(zero_extract:SI (match_operand:SI 1 "gr_register_operand" " Rg")
			      (const_int 1)
			      (match_operand:SI 2 "immediate_operand"   "Iu0"))
	     (const_int 0)])
	  (label_ref (match_operand 3 "" ""))
	  (pc)))
  (set (match_operand:BI 4 "pr_register_operand"		        "=Rp")
       (if_then_else:BI
	 (match_op_dup 0
	   [(zero_extract:SI (match_dup 1) (const_int 1) (match_dup 2))
	    (const_int 0)])
	 (const_int 1) (const_int 0)))]
  "TARGET_V4_FEATURES && reload_completed"
  {
    int predict_taken;
    enum rtx_code code;

    predict_taken = 0;
    code = GET_CODE (operands[0]);
    predict_taken = INTVAL (hexagon_branch_hint (insn));

    if (GET_CODE (operands[2]) == CONST_INT)
      switch (code)
	{
	case EQ:
	  if (predict_taken)
	    return "%4 = tstbit(%1,#%2); if (%4.new) jump:t %l3";
	  else
	    return "%4 = tstbit(%1,#%2); if (%4.new) jump:nt %l3";

	case NE:
	  if (predict_taken)
	    return "%4 = tstbit(%1,#%2); if (!%4.new) jump:t %l3";
	  else
	    return "%4 = tstbit(%1,#%2); if (!%4.new) jump:nt %l3";

	default:
	  gcc_unreachable ();
	}
    else
      switch (code)
	{
	case EQ:
	  if (predict_taken)
	    return "%4 = tstbit(%1,%2); if (%4.new) jump:t %l3";
	  else
	    return "%4 = tstbit(%1,%2); if (%4.new) jump:nt %l3";

	case NE:
	  if (predict_taken)
	    return "%4 = tstbit(%1,%2); if (!%4.new) jump:t %l3";
	  else
	    return "%4 = tstbit(%1,%2); if (!%4.new) jump:nt %l3";

	default:
	  gcc_unreachable ();
	}
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "8")
		      (const_string "XJ")
		      (const_string "EXJ")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 3) (pc))) (const_int 1000))
		      (const_string "8")
		      (const_string "12")))]
)


(define_insn "new_value_jump1"
  [(set (pc)
	(if_then_else
	  (match_operator 0 "comparison_operator"
	    [(unspec:SI [(match_operand:SI 1 "gr_register_operand"   "Rg,Rg")]
			UNSPEC_NEW_VALUE)
	     (match_operand:SI 2 "nonmemory_operand"             "Iu5Km1,Rg")])
	  (label_ref (match_operand 3 "" ""))
	  (pc)))
  (set (match_operand:BI 4 "pr_register_operand"		    "=Rp,Rp")
       (if_then_else:BI
	 (match_op_dup 0 [(unspec:SI [(match_dup 1)] UNSPEC_NEW_VALUE)
			  (match_dup 2)])
	 (const_int 1) (const_int 0)))]
  "TARGET_V4_FEATURES"
{
  enum rtx_code code = GET_CODE (operands[0]);
  operands[5] = hexagon_branch_hint (insn);

  if (GET_CODE (operands[2]) == CONST_INT)
    switch (code)
      {
      case EQ:
	return "if (cmp.eq(%1.new,#%2)) jump%h5 %l3";
      case NE:
	return "if (!cmp.eq(%1.new,#%2)) jump%h5 %l3";
      case GT:
	return "if (cmp.gt(%1.new,#%2)) jump%h5 %l3";
      case LE:
	return "if (!cmp.gt(%1.new,#%2)) jump%h5 %l3";
      case GTU:
	return "if (cmp.gtu(%1.new,#%2)) jump%h5 %l3";
      case LEU:
	return "if (!cmp.gtu(%1.new,#%2)) jump%h5 %l3";
      default:
	gcc_unreachable ();
      }
  else
    switch (code)
      {
      case EQ:
	return "if (cmp.eq(%1.new,%2)) jump%h5 %l3";
      case NE:
	return "if (!cmp.eq(%1.new,%2)) jump%h5 %l3";
      case GT:
	return "if (cmp.gt(%1.new,%2)) jump%h5 %l3";
      case LE:
	return "if (!cmp.gt(%1.new,%2)) jump%h5 %l3";
      case GTU:
	return "if (cmp.gtu(%1.new,%2)) jump%h5 %l3";
      case LEU:
	return "if (!cmp.gtu(%1.new,%2)) jump%h5 %l3";
      default:
	gcc_unreachable ();
      }
}
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "NewValueJump")
		      (const_string "ENewValueJump")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 3) (pc))) (const_int 1000))
		      (const_string "4")
		      (const_string "8")))]
)


(define_insn "compare_and_jump1"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand:SI 1 "gr_register_operand"    "Rg,Rg")
			 (match_operand:SI 2 "nonmemory_operand"  "Iu5Km1,Rg")])
		      (label_ref (match_operand 3 "" ""))
		      (pc)))
  (set (match_operand:BI 4 "pr_register_operand"		     "=Rp,Rp")
       (if_then_else:BI (match_op_dup 0 [(match_dup 1) (match_dup 2)])
			(const_int 1) (const_int 0)))]
  "TARGET_V4_FEATURES && reload_completed"
  {
    enum rtx_code code = GET_CODE (operands[0]);
    operands[5] = hexagon_branch_hint (insn);

    if (GET_CODE (operands[2]) == CONST_INT)
      switch (code)
	{
	case EQ:
	  return "%4 = cmp.eq(%1, #%2); if (%4.new) jump%h5 %l3";
	case NE:
	  return "%4 = cmp.eq(%1, #%2); if (!%4.new) jump%h5 %l3";
	case GT:
	  return "%4 = cmp.gt(%1, #%2); if (%4.new) jump%h5 %l3";
	case LE:
	  return "%4 = cmp.gt(%1, #%2); if (!%4.new) jump%h5 %l3";
	case GTU:
	  return "%4 = cmp.gtu(%1, #%2); if (%4.new) jump%h5 %l3";
	case LEU:
	  return "%4 = cmp.gtu(%1, #%2); if (!%4.new) jump%h5 %l3";
	default:
	  gcc_unreachable ();
	}
    else
      switch (code)
	{
	case EQ:
	  return "%4 = cmp.eq(%1, %2); if (%4.new) jump%h5 %l3";
	case NE:
	  return "%4 = cmp.eq(%1, %2); if (!%4.new) jump%h5 %l3";
	case GT:
	  return "%4 = cmp.gt(%1, %2); if (%4.new) jump%h5 %l3";
	case LE:
	  return "%4 = cmp.gt(%1, %2); if (!%4.new) jump%h5 %l3";
	case GTU:
	  return "%4 = cmp.gtu(%1, %2); if (%4.new) jump%h5 %l3";
	case LEU:
	  return "%4 = cmp.gtu(%1, %2); if (!%4.new) jump%h5 %l3";
	default:
	  gcc_unreachable ();
	}
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "8")
		      (const_string "AJ")
		      (const_string "EAJ")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 3) (pc))) (const_int 1000))
		      (const_string "8")
		      (const_string "12")))]
)


(define_insn "new_value_jump2"
  [(set (pc)
	(if_then_else
	  (match_operator 0 "comparison_operator"
	    [(match_operand:SI 1 "nonmemory_operand"		"Iu5Km1,Rg")
	     (unspec:SI [(match_operand:SI 2 "gr_register_operand" " Rg,Rg")]
			UNSPEC_NEW_VALUE)])
	  (label_ref (match_operand 3 "" ""))
	  (pc)))
  (set (match_operand:BI 4 "pr_register_operand"		   "=Rp,Rp")
       (if_then_else:BI
	 (match_op_dup 0 [(match_dup 1)
			  (unspec:SI [(match_dup 2)] UNSPEC_NEW_VALUE)])
	 (const_int 1) (const_int 0)))]
  "TARGET_V4_FEATURES"
  {
    enum rtx_code code = GET_CODE (operands[0]);
    operands[5] = hexagon_branch_hint (insn);

    if (GET_CODE (operands[1]) == CONST_INT)
      switch (code)
	{
	case EQ:
	  return "if (cmp.eq(#%1,%2.new)) jump%h5 %l3";
	case NE:
	  return "if (!cmp.eq(#%1,%2.new)) jump%h5 %l3";
	case GT:
	  return "if (cmp.gt(#%1,%2.new)) jump%h5 %l3";
	case LE:
	  return "if (!cmp.gt(#%1,%2.new)) jump%h5 %l3";
	case GTU:
	  return "if (cmp.gtu(#%1,%2.new)) jump%h5 %l3";
	case LEU:
	  return "if (!cmp.gtu(#%1,%2.new)) jump%h5 %l3";
	default:
	  gcc_unreachable ();
	}
    else
      switch (code)
	{
	case EQ:
	  return "if (cmp.eq(%1,%2.new)) jump%h5 %l3";
	case NE:
	  return "if (!cmp.eq(%1,%2.new)) jump%h5 %l3";
	case GT:
	  return "if (cmp.gt(%1,%2.new)) jump%h5 %l3";
	case LE:
	  return "if (!cmp.gt(%1,%2.new)) jump%h5 %l3";
	case GTU:
	  return "if (cmp.gtu(%1,%2.new)) jump%h5 %l3";
	case LEU:
	  return "if (!cmp.gtu(%1,%2.new)) jump%h5 %l3";
	default:
	  gcc_unreachable ();
	}
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "NewValueJump")
		      (const_string "ENewValueJump")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 3) (pc))) (const_int 1000))
		      (const_string "4")
		      (const_string "8")))]

)


(define_insn "compare_and_jump2"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand:SI 1 "nonmemory_operand" "Iu5Km1,Rg")
			 (match_operand:SI 2 "gr_register_operand"  " Rg,Rg")])
		      (label_ref (match_operand 3 "" ""))
		      (pc)))
  (set (match_operand:BI 4 "pr_register_operand"		    "=Rp,Rp")
       (if_then_else:BI (match_op_dup 0 [(match_dup 1) (match_dup 2)])
			(const_int 1) (const_int 0)))]
  "TARGET_V4_FEATURES && reload_completed"
  {
    enum rtx_code code = GET_CODE (operands[0]);
    operands[5] = hexagon_branch_hint (insn);

    if (GET_CODE (operands[1]) == CONST_INT)
      switch (code)
	{
	case EQ:
	  return "%4 = cmp.eq(#%1, %2); if (%4.new) jump%h5 %l3";
	case NE:
	  return "%4 = cmp.eq(#%1, %2); if (!%4.new) jump%h5 %l3";
	case GT:
	  return "%4 = cmp.gt(#%1, %2); if (%4.new) jump%h5 %l3";
	case LE:
	  return "%4 = cmp.gt(#%1, %2); if (!%4.new) jump%h5 %l3";
	case GTU:
	  return "%4 = cmp.gtu(#%1, %2); if (%4.new) jump%h5 %l3";
	case LEU:
	  return "%4 = cmp.gtu(#%1, %2); if (!%4.new) jump%h5 %l3";
	default:
	  gcc_unreachable ();
	}
    else
      switch (code)
	{
	case EQ:
	  return "%4 = cmp.eq(%1, %2); if (%4.new) jump%h5 %l3";
	case NE:
	  return "%4 = cmp.eq(%1, %2); if (!%4.new) jump%h5 %l3";
	case GT:
	  return "%4 = cmp.gt(%1, %2); if (%4.new) jump%h5 %l3";
	case LE:
	  return "%4 = cmp.gt(%1, %2); if (!%4.new) jump%h5 %l3";
	case GTU:
	  return "%4 = cmp.gtu(%1, %2); if (%4.new) jump%h5 %l3";
	case LEU:
	  return "%4 = cmp.gtu(%1, %2); if (!%4.new) jump%h5 %l3";
	default:
	  gcc_unreachable ();
	}
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "8")
		      (const_string "AJ")
		      (const_string "EAJ")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 3) (pc))) (const_int 1000))
		      (const_string "8")
		      (const_string "12")))]
)


;;----------------;;
;; cbranch{mode}4 ;;
;;----------------;;

(define_expand "cbranchbi4"
  [(set (pc) (if_then_else
	       (match_operator 0 "comparison_operator"
		 [(match_operand:BI 1 "pr_register_operand" "")
		  (match_operand:BI 2 "nonmemory_operand" "")])
	       (label_ref (match_operand 3 "" ""))
	       (pc)))]
  ""
{
  rtx bimode_compare = hexagon_expand_compare (GET_CODE (operands[0]),
					       operands[1], operands[2]);

  emit_insn (gen_hexagon_cbranchbi (operands[3], bimode_compare));

  DONE;
})

(define_expand "cbranchsi4"
  [(set (pc) (if_then_else
	       (match_operator 0 "comparison_operator"
		 [(match_operand:SI 1 "gr_register_operand" "")
		  (match_operand:SI 2 "nonmemory_operand" "")])
	       (label_ref (match_operand 3 "" ""))
	       (pc)))]
  ""
{
  rtx bimode_compare = hexagon_expand_compare (GET_CODE (operands[0]),
					       operands[1], operands[2]);

  emit_insn (gen_hexagon_cbranchbi (operands[3], bimode_compare));

  DONE;
})

(define_expand "cbranch<mode>4"
  [(set (pc) (if_then_else
	       (match_operator 0 "comparison_operator"
		 [(match_operand:REGCMP 1 "gr_register_operand" "")
		  (match_operand:REGCMP 2 "nonmemory_operand" "")])
	       (label_ref (match_operand 3 "" ""))
	       (pc)))]
  "<MODE>mode == DImode || TARGET_V5_FEATURES
   || (TARGET_V4_FEATURES && GET_MODE_CLASS (<MODE>mode) == MODE_INT)"
{
  rtx bimode_compare = hexagon_expand_compare (GET_CODE (operands[0]),
					       operands[1], operands[2]);

  emit_insn (gen_hexagon_cbranchbi (operands[3], bimode_compare));

  DONE;
})

; Helper expander for cbranch<mode>4.

(define_expand "hexagon_cbranchbi"
  [(set (pc) (if_then_else (match_operand 1 "" "")
			   (label_ref (match_operand 0 "" ""))
			   (pc)))]
  ""
  {})


;;------;;
;; jump ;;
;;------;;

(define_insn "jump"
  [(set (pc) (label_ref (match_operand 0 "" "")))]
  ""
  "jump %0"
  [(set_attr "type" "J")]
)


;;------;;
;; call ;;
;;------;;

(define_expand "call"
  [(parallel [(call (match_operand:HI 0 "memory_operand" "m")
		    (match_operand 1 "" ""))
	      (clobber (reg:SI LINK_REGNUM))])]
  ""
  {
    rtx callee = XEXP (operands[0], 0);

    if ((TARGET_LONG_CALLS && !TARGET_V4_FEATURES && !REG_P (callee))
	|| GET_CODE (callee) != SYMBOL_REF)
      XEXP (operands[0], 0) = force_reg (Pmode, callee);
    else if (flag_pic)
      operands[0] = legitimize_pic_address (operands[0], SImode,
					    (can_create_pseudo_p ()
					     ? NULL_RTX : operands[0]));
  }
)

(define_insn "long_call_pc_relative"
  [(call (mem:HI (match_operand:SI 0 "call_target_operand" "Q,?Rg"))
         (match_operand 1 "" ""))
   (clobber (reg:SI LINK_REGNUM))]
  "TARGET_LONG_CALLS && TARGET_V4_FEATURES
   && !(GET_CODE (operands[0]) == SYMBOL_REF
   && SYMBOL_REF_LOCAL_P (operands[0]))"
  "@
   call ##%0
   callr %0"
  [(set_attr "type" "EJ,JR")]
)

(define_insn "call_pc_relative"
  [(call (mem:HI (match_operand:SI 0 "call_target_operand" "Q,?Rg"))
	 (match_operand 1 "" ""))
   (clobber (reg:SI LINK_REGNUM))]
  "!TARGET_LONG_CALLS
   || (GET_CODE (operands[0]) == SYMBOL_REF
       && SYMBOL_REF_LOCAL_P (operands[0]))"
  {
    if (which_alternative == 0)
      {
	if (flag_pic)
	  return "call %0@PLT";
	else
	  return "call %0";
      }
    else
      return "callr %0";
  }
  [(set_attr "type" "J,JR")]
)

(define_expand  "call_register_expand"
  [(call (mem:HI (match_operand:SI 0 "gr_register_operand" "Rg"))
	 (match_operand 1 "" ""))
   (clobber (reg:SI LINK_REGNUM))]
  ""
  {
    if (flag_pic)
      operands[0] = legitimize_pic_address (operands[0], SImode,
					    (can_create_pseudo_p ()
					     ? NULL_RTX : operands[0]));
  }
)

(define_insn "call_register"
  [(call (mem:HI (match_operand:SI 0 "gr_register_operand" "Rg"))
	 (match_operand 1 "" ""))
   (clobber (reg:SI LINK_REGNUM))]
  ""
  "callr %0"
  [(set_attr "type" "JR")]
)

(define_expand "sibcall"
  [(parallel [(call (match_operand:HI 0 "memory_operand" "m")
		    (match_operand 1 "" ""))
	      (return)])]
  "!TARGET_LONG_CALLS || TARGET_V4_FEATURES"
  ""
)

(define_insn "long_sibcall_real"
  [(call (mem:HI (match_operand:SI 0 "call_target_operand" "Q,?Rg"))
         (match_operand 1 "" ""))
   (return)]
  "TARGET_LONG_CALLS && TARGET_V4_FEATURES
   && !(GET_CODE (operands[0]) == SYMBOL_REF
        && SYMBOL_REF_LOCAL_P (operands[0]))"
  "@
   jump ##%0
   jumpr %0"
  [(set_attr "type" "EJ,JR")]
)

(define_insn "sibcall_real"
  [(call (mem:HI (match_operand:SI 0 "call_target_operand" "Q,?Rg"))
	 (match_operand 1 "" ""))
   (return)]
  "!TARGET_LONG_CALLS
   || (GET_CODE (operands[0]) == SYMBOL_REF
       && SYMBOL_REF_LOCAL_P (operands[0]))"
  {
    if (which_alternative == 0)
      {
	if (flag_pic)
	  return "jump %0@PLT";
	else
	  return "jump %0";
      }
    else
      return "jumpr %0";
  }
  [(set_attr "type" "J,JR")]
)


;;------------;;
;; call_value ;;
;;------------;;

(define_expand "call_value"
  [(parallel [(set (match_operand 0 "gr_register_operand"     "=Rg")
		   (call (match_operand:HI 1 "memory_operand" " m")
			 (match_operand 2 "" "")))
	      (clobber (reg:SI LINK_REGNUM))])]
  ""
  {
    rtx callee = XEXP (operands[1], 0);

    if (flag_unsafe_math_optimizations)
      hexagon_fast_math_libfunc (operands[1]);

    if ((TARGET_LONG_CALLS && !TARGET_V4_FEATURES && !REG_P (callee))
	|| GET_CODE (callee) != SYMBOL_REF)
      XEXP (operands[1], 0) = force_reg (Pmode, callee);
  }
)

(define_insn "long_call_value_pc_relative"
  [(set (match_operand 0 "gr_register_operand"                "=Rg,?Rg")
        (call (mem:HI (match_operand:SI 1 "call_target_operand" "Q, Rg"))
              (match_operand 2 "" "")))
   (clobber (reg:SI LINK_REGNUM))]
  "TARGET_LONG_CALLS && TARGET_V4_FEATURES
   && !(GET_CODE (operands[1]) == SYMBOL_REF
        && SYMBOL_REF_LOCAL_P (operands[1]))
   && !hexagon_tls_symbol_p (operands[1])"
  "@
   call ##%1
   callr %1"
  [(set_attr "type" "EJ,JR")]
)

(define_insn "call_value_pc_relative"
  [(set (match_operand 0 "gr_register_operand"			"=Rg,?Rg")
	(call (mem:HI (match_operand:SI 1 "call_target_operand" "  Q, Rg"))
	      (match_operand 2 "" "")))
   (clobber (reg:SI LINK_REGNUM))]
  "(!TARGET_LONG_CALLS
    || (GET_CODE (operands[1]) == SYMBOL_REF
        && SYMBOL_REF_LOCAL_P (operands[1])))
   && !hexagon_tls_symbol_p (operands[1])"
  {
    if (which_alternative == 0)
      {
	if (flag_pic)
	  return "call %1@PLT";
	else
	  return "call %1";
      }
    else
      return "callr %1";
  }
  [(set_attr "type" "J,JR")]
)

(define_insn "call_value_pc_relative_tls"
  [(set (match_operand 0 "gr_register_operand"			"=Rg")
	(call (mem:HI (match_operand:SI 1 "call_target_operand" "  Q"))
	      (match_operand 2 "" "")))
   (clobber (reg:SI LINK_REGNUM))]
  "hexagon_tls_symbol_p (operands[1])"
  {
    switch (SYMBOL_REF_TLS_MODEL (operands[1]))
      {
      case TLS_MODEL_GLOBAL_DYNAMIC:
	return "call %1@GDPLT";
      case TLS_MODEL_LOCAL_DYNAMIC:
	return "call %1@LDPLT";
      default:
	gcc_unreachable ();
      }
  }
  [(set_attr "type" "J")]
)

(define_insn "call_value_register"
  [(set (match_operand 0 "gr_register_operand"			"=Rg")
	(call (mem:HI (match_operand:SI 1 "gr_register_operand" " Rg"))
	      (match_operand 2 "" "")))
   (clobber (reg:SI LINK_REGNUM))]
  ""
  "callr %1"
  [(set_attr "type" "JR")]
)

(define_expand "sibcall_value"
  [(parallel [(set (match_operand 0 "gr_register_operand"     "=Rg")
		   (call (match_operand:HI 1 "memory_operand" " m")
			 (match_operand 2 "" "")))
	      (return)])]
  "!TARGET_LONG_CALLS || TARGET_V4_FEATURES"
  {
    if (flag_unsafe_math_optimizations)
      hexagon_fast_math_libfunc (operands[1]);
  }
)

(define_insn "long_sibcall_value_real"
  [(set (match_operand 0 "gr_register_operand"                "=Rg,?Rg")
        (call (mem:HI (match_operand:SI 1 "call_target_operand" "Q, Rg"))
              (match_operand 2 "" "")))
   (return)]
  "TARGET_LONG_CALLS && TARGET_V4_FEATURES
   && !(GET_CODE (operands[1]) == SYMBOL_REF
        && SYMBOL_REF_LOCAL_P (operands[1]))"
  "@
   jump ##%1
   jumpr %1"
  [(set_attr "type" "EJ,JR")]
)

(define_insn "sibcall_value_real"
  [(set (match_operand 0 "gr_register_operand"			"=Rg,?Rg")
	(call (mem:HI (match_operand:SI 1 "call_target_operand" "  Q, Rg"))
	      (match_operand 2 "" "")))
   (return)]
  "!TARGET_LONG_CALLS
   || (GET_CODE (operands[1]) == SYMBOL_REF
       && SYMBOL_REF_LOCAL_P (operands[1]))"
  {
    if (which_alternative == 0)
      {
	if (flag_pic)
	  return "jump %1@PLT";
	else
	  return "jump %1";
      }
    else
      return "jumpr %1";
  }
  [(set_attr "type" "J,JR")]
)


;;--------;;
;; return ;;
;;--------;;

(define_expand "return"
  [(return)]
  "TARGET_DEALLOC_RETURN && hexagon_direct_return ()"
  {
    if (cfun->machine->frame_info.use_allocframe)
      {
	gcc_assert (TARGET_V4_FEATURES);
	emit_jump_insn (gen_deallocframe_return ());
	DONE;
      }
  }
)

;; Conditional returns when we don't need an epilogue

(define_insn_and_split "cond_return"
  [(set (pc)
	(if_then_else (match_operator 0 "predicate_operator"
			[(match_operand:BI 1 "pr_register_operand" "Rp")
			 (const_int 0)])
		      (return)
		      (pc)))]
  "hexagon_direct_return () && !cfun->machine->frame_info.use_allocframe"
  {
    operands[2] = hexagon_branch_hint (insn);
    return "if (%C0) jumpr%h2 r31";
  }
  "TARGET_DEALLOC_RETURN && cfun->machine->frame_info.use_allocframe"
  [(parallel
     [(set (pc) (if_then_else (match_dup 0) (return) (pc)))
      (cond_exec
	(match_dup 0)
	(parallel
	  [(set (reg:SI SP_REGNUM) (plus:SI (reg:SI FP_REGNUM) (const_int 8)))
	   (set (reg:SI LINK_REGNUM)
		(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
	   (set (reg:SI FP_REGNUM) (mem:SI (reg:SI FP_REGNUM)))]))])]
  {
    gcc_assert (TARGET_V4_FEATURES);
  }
  [(set_attr "type" "JR")
   (set_attr "duplex" "yes")]
)

(define_insn "cond_dealloc_return"
  [(set (pc)
	(if_then_else (match_operator 0 "predicate_operator"
			[(match_operand:BI 1 "pr_register_operand" "Rp")
			 (const_int 0)])
		      (return)
		      (pc)))
   (cond_exec
     (match_dup 0)
     (parallel
       [(set (reg:SI SP_REGNUM) (plus:SI (reg:SI FP_REGNUM) (const_int 8)))
	(set (reg:SI LINK_REGNUM)
	     (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
	(set (reg:SI FP_REGNUM) (mem:SI (reg:SI FP_REGNUM)))]))]
  "TARGET_V4_FEATURES && TARGET_DEALLOC_RETURN && hexagon_direct_return ()"
  {
    operands[2] = hexagon_branch_hint (insn);
    return "if (%C0) dealloc_return%h2";
  }
  [(set_attr "type" "NewValueJump")
   (set_attr "duplex" "yes")]
)


;;-----;;
;; nop ;;
;;-----;;

;; No operation, needed in case the user uses -g but not -O.

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop"
  [(set_attr "type" "A")]
)


;;---------------;;
;; indirect_jump ;;
;;---------------;;

(define_insn "hintjr"
  [(unspec_volatile [(match_operand:SI 0 "gr_register_operand" "Rg")]
		    UNSPEC_HEXAGON_hintjr)]
  "TARGET_V4_FEATURES"
  "hintjr(%0)"
  [(set_attr "type" "JR")
   (set_attr "length" "0")]
)

(define_insn "indirect_jump"
  [(set (pc) (match_operand:SI 0 "nonimmediate_operand" "Rg"))]
  ""
  "jumpr %0"
  [(set_attr "type" "JR")
   (set_attr "duplex" "yes")]
)

(define_insn "cond_jump_reg_indirect"
  [(set (pc)
	(if_then_else (match_operator 0 "predicate_operator"
			[(match_operand:BI 1 "pr_register_operand" "Rp")
			 (const_int 0)])
		      (match_operand:SI 2 "gr_register_operand" "Rg")
		      (pc)))]
  ""
  {
    operands[3] = hexagon_branch_hint (insn);
    return "if (%C0) jumpr%h3 %2";
  }
  [(set_attr "type" "JR")
   (set_attr "duplex" "yes")]
)


;;-----------;;
;; tablejump ;;
;;-----------;;

(define_expand "tablejump"
  [(set (pc) (match_operand:SI 0 "nonimmediate_operand" "Rg"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  {
    if (flag_pic)
      {
	rtx label, addend;
	label = gen_reg_rtx (SImode);
	addend = gen_reg_rtx (SImode);
	emit_move_insn (label, gen_rtx_LABEL_REF (SImode, operands[1]));
	emit_insn (gen_addsi3 (addend, operands[0], label));
	emit_jump_insn (gen_tablejump_real (addend, operands[1]));
      }
    else
      emit_jump_insn (gen_tablejump_real (operands[0], operands[1]));

    DONE;
  }
)

(define_insn "tablejump_real"
  [(set (pc) (match_operand:SI 0 "nonimmediate_operand" "Rg"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "jumpr %0"
  [(set_attr "type" "JR")
   (set_attr "duplex" "yes")]
)


;;------------;;
;; doloop_end ;;
;;------------;;

(define_expand "doloop_end"
  [(parallel [(set (pc) (if_then_else
			  (gtu (match_operand:SI 0 "" "")
			       (const_int 1))
			  (label_ref (match_operand 4 "" ""))
			  (pc)))
	      (set (match_dup 0) (plus:SI (match_dup 0) (const_int -1)))
	      (unspec [(const_int 0)] UNSPEC_DOLOOP_END)
	      (clobber (match_scratch:BI 5 ""))
	      (clobber (match_scratch:SI 6 ""))])]
  "TARGET_HARDWARE_LOOPS"
  {
    if (flag_pic)
      require_pic_register ();
    if (INTVAL (operands[3]) > 2)
      FAIL;
    if (GET_CODE (operands[0]) == REG && GET_MODE (operands[0]) != SImode)
      FAIL;
    /* Mentor local: for CodeBench builds, Qualcomm requested that we turn off
       this edge-case test (issue #13059).  FIXME: Improve middle-end maximum
       iteration count analysis instead.  */
#if 0
    /* An initial loop count of zero will not loop 2^32 times, so we must
       reject this case.  */
    if (!flag_unsafe_loop_optimizations
	&& (unsigned HOST_WIDE_INT) INTVAL (operands[2]) >= 0xffffffff)
      FAIL;
#endif
    hexagon_hardware_loop ();
  }
)

(define_insn "doloop_end_internal"
  [(set (pc)
	(if_then_else (gtu (match_operand:SI 2 "gr_reg_or_memory_operand" "0,0")
			   (const_int 1))
		      (label_ref (match_operand 1 "" ""))
		      (pc)))
   (set (match_operand:SI 0 "gr_reg_or_memory_operand" "=Rg,m")
	(plus:SI (match_dup 2)
		 (const_int -1)))
   (unspec [(const_int 0)] UNSPEC_DOLOOP_END)
   (clobber (match_scratch 3 "=&Rp,&Rp"))
   (clobber (match_scratch 4 "=X,&Rg"))]
  ""
  "@
   // doloop_end_internal
   #"
  [(set_attr "length" "8")
   (set_attr "type" "endloop0")])

;; This split allows us to proceed if we cannot allocate a register for
;; operand 0/2 in doloop_end_internal, but we can allocate one for a temporary
;; clobber.

(define_split
  [(set (pc)
	(if_then_else (gtu (match_operand:SI 0 "memory_operand" "")
			   (const_int 1))
		      (label_ref (match_operand 1 "" ""))
		      (pc)))
   (set (match_dup 0)
	(plus:SI (match_dup 0)
		 (const_int -1)))
   (unspec [(const_int 0)] UNSPEC_DOLOOP_END)
   (clobber (match_scratch:BI 2 ""))
   (clobber (match_scratch:SI 3 ""))]
  ""
  [(set (match_dup 3) (match_dup 0))
   (set (match_dup 3) (plus:SI (match_dup 3) (const_int -1)))
   (set (match_dup 0) (match_dup 3))
   (set (match_dup 2) (gtu:BI (match_dup 3) (const_int 0)))
   (set (pc)
	(if_then_else (ne (match_dup 2) (const_int 0))
		      (label_ref (match_dup 1))
		      (pc)))]
  "")

(define_insn "endloop0"
  [(set (pc) (if_then_else (gtu (reg:SI LC0_REGNUM) (const_int 1))
			   (label_ref (match_operand 0 "" ""))
			   (pc)))
   (set (reg:SI LC0_REGNUM) (if_then_else:SI (gtu (reg:SI LC0_REGNUM)
						  (const_int 1))
					     (plus:SI (reg:SI LC0_REGNUM)
						      (const_int -1))
					     (reg:SI LC0_REGNUM)))
   (use:SI (reg:SI SA0_REGNUM))]
  ""
  "{ nop }:endloop0 // start=%l0"
  [(set_attr "type" "endloop0")
   (set_attr "length" "8")]
)

(define_insn "endloop1"
  [(set (pc) (if_then_else (gtu (reg:SI LC1_REGNUM) (const_int 1))
			   (label_ref (match_operand 0 "" ""))
			   (pc)))
   (set (reg:SI LC1_REGNUM) (if_then_else:SI (gtu (reg:SI LC1_REGNUM)
						  (const_int 1))
					     (plus:SI (reg:SI LC1_REGNUM)
						      (const_int -1))
					     (reg:SI LC1_REGNUM)))
   (use:SI (reg:SI SA1_REGNUM))]
  ""
  "{ nop }:endloop1 // start=%l0"
  [(set_attr "type" "endloop1")
   (set_attr "length" "12")]
)

(define_insn "loop0_v4"
  [(set (reg:SI LC0_REGNUM)
	(match_operand:SI 0 "nonmemory_operand"		    " IuA, Rg, IuA,Rg"))
   (set (reg SA0_REGNUM) (label_ref (match_operand 1 "" "")))
   (clobber (match_operand:SI 2 "gr_reg_or_scratch_operand" "=&Rg,&Rg,*X, *X"))]
  "TARGET_V4_FEATURES"
  {
    gcc_assert (get_attr_length (insn) == 4 || REG_P (operands[2]));

    switch (which_alternative)
      {
      case 0:
      case 2:
	if (get_attr_length (insn) == 4)
	  return "loop0(%l1,#%0)";
	else
	  return "loop0(##%l1,#%0)";
	break;

      case 1:
      case 3:
	if (get_attr_length (insn) == 4)
	  return "loop0(%l1,%0)";
	else
	  return "loop0(##%l1,%0)";
	break;

      default:
	gcc_unreachable ();
      }
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "loop")
		      (const_string "Eloop")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 1) (pc))) (const_int 200))
		      (const_string "4")
		      (const_string "8")))]
)

(define_insn "loop0"
  [(set (reg:SI LC0_REGNUM)
	(match_operand:SI 0 "nonmemory_operand"		    " IuA, Rg, IuA,Rg"))
   (set (reg SA0_REGNUM) (label_ref (match_operand 1 "" "")))
   (clobber (match_operand:SI 2 "gr_reg_or_scratch_operand" "=&Rg,&Rg,*X, *X"))]
  "!TARGET_V4_FEATURES"
  {
    gcc_assert (get_attr_length (insn) == 4 || REG_P (operands[2]));

    if (get_attr_length (insn) == 4)
      {
	if ((which_alternative & 1) == 0)
	  return "loop0(%l1,#%0)";
	else
	  return "loop0(%l1,%0)";
      }
    else
      {
	if ((which_alternative & 1) == 0)
	  return "%2 = #%0\;"
		 "{\;"
		 "  lc0 = %2\;"
		 "  %2.h = #HI(%1)\;"
		 "}\;"
		 "%2.l = #LO(%1)\;"
		 "sa0 = %2";
	else
	  return "%2 = %0\;"
		 "{\;"
		 "  lc0 = %2\;"
		 "  %2.h = #HI(%1)\;"
		 "}\;"
		 "%2.l = #LO(%1)\;"
		 "sa0 = %2";
      }
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "loop")
		      (const_string "multiple")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 1) (pc))) (const_int 200))
		      (const_string "4")
		      (const_string "20")))]
)

(define_insn "loop0_pic"
  [(set (reg:SI LC0_REGNUM)
	(match_operand:SI 0 "nonmemory_operand"		    "  Rg,IuA, Rg,IuA"))
   (set (reg SA0_REGNUM) (label_ref (match_operand 1 "" "")))
   (clobber (match_operand:SI 2 "gr_reg_or_scratch_operand" "=&Rg,&Rg,*X,*X"))
   (use (reg:SI PIC_REGNUM))]
  "flag_pic && !TARGET_V4_FEATURES"
  {
    gcc_assert (get_attr_length (insn) == 4 || REG_P (operands[2]));

    switch (which_alternative)
      {
      case 0:
      case 2:
	if (get_attr_length (insn) == 4)
	  return "loop0(%l1,%0)";
	else
	  return "%2 = %0\;"
		 "{\;"
		 "  lc0 = %2\;"
		 "  %2.h = #HI(%1@GOTOFF)\;"
		 "}\;"
		 "%2.l = #LO(%1@GOTOFF)\;"
		 "%2 = add(%2, %p0)\;"
		 "sa0 = %2";
	break;

      case 1:
      case 3:
	if (get_attr_length (insn) == 4)
	  return "loop0(%l1,#%0)";
	else
	  return "%2 = #%0\;"
		 "{\;"
		 "  lc0 = %2\;"
		 "  %2.h = #HI(%1@GOTOFF)\;"
		 "}\;"
		 "%2.l = #LO(%1@GOTOFF)\;"
		 "%2 = add(%2, %p0)\;"
		 "sa0 = %2";
	break;

      default:
	gcc_unreachable ();
      }
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "loop")
		      (const_string "multiple")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 1) (pc))) (const_int 200))
		      (const_string "4")
		      (const_string "20")))]
)

(define_insn "loop0_pic_v4"
  [(set (reg:SI LC0_REGNUM)
	(match_operand:SI 0 "nonmemory_operand"		    "  Rg,IuA, Rg,IuA"))
   (set (reg SA0_REGNUM) (label_ref (match_operand 1 "" "")))
   (clobber (match_operand:SI 2 "gr_reg_or_scratch_operand" "=&Rg,&Rg,*X,*X"))
   (use (reg:SI PIC_REGNUM))]
  "flag_pic && TARGET_V4_FEATURES"
  {
    gcc_assert (get_attr_length (insn) == 4 || REG_P (operands[2]));

    switch (which_alternative)
      {
      case 0:
      case 2:
	if (get_attr_length (insn) == 4)
	  return "loop0(%l1,%0)";
	else
	  return "loop0(##%l1,%0)";
	break;

      case 1:
      case 3:
	if (get_attr_length (insn) == 4)
	  return "loop0(%l1,#%0)";
	else
	  return "loop0(##%l1,#%0)";
	break;

      default:
	gcc_unreachable ();
      }
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "loop")
		      (const_string "Eloop")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 1) (pc))) (const_int 200))
		      (const_string "4")
		      (const_string "8")))]
)

(define_insn "loop1_v4"
  [(set (reg:SI LC1_REGNUM)
	(match_operand:SI 0 "nonmemory_operand"		    "  Rg,IuA,Rg,IuA"))
   (set (reg SA1_REGNUM) (label_ref (match_operand 1 "" "")))
   (clobber (match_operand:SI 2 "gr_reg_or_scratch_operand" "=&Rg,&Rg,*X,*X"))]
  "TARGET_V4_FEATURES"
  {
    gcc_assert (get_attr_length (insn) == 4 || REG_P (operands[2]));

    switch (which_alternative)
      {
      case 0:
      case 2:
	if (get_attr_length (insn) == 4)
	  return "loop1(%l1,%0)";
	else
	  return "loop1(##%l1,%0)";
	break;

      case 1:
      case 3:
	if (get_attr_length (insn) == 4)
	  return "loop1(%l1,#%0)";
	else
	  return "loop1(##%l1,#%0)";
	break;

      default:
	gcc_unreachable ();
      }
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "loop")
		      (const_string "Eloop")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 1) (pc))) (const_int 200))
		      (const_string "4")
		      (const_string "8")))]
)

(define_insn "loop1"
  [(set (reg:SI LC1_REGNUM)
	(match_operand:SI 0 "nonmemory_operand"		    "  Rg,IuA, Rg,IuA"))
   (set (reg SA1_REGNUM) (label_ref (match_operand 1 "" "")))
   (clobber (match_operand:SI 2 "gr_reg_or_scratch_operand" "=&Rg,&Rg,*X,*X"))]
  "!TARGET_V4_FEATURES"
  {
    gcc_assert (get_attr_length (insn) == 4 || REG_P (operands[2]));

    if (get_attr_length (insn) == 4)
      {
	if ((which_alternative & 1) == 0)
	  return "loop1(%l1,%0)";
	else
	  return "loop1(%l1,#%0)";
      }
    else
      {
	if ((which_alternative & 1) == 0)
	  return "%2 = %0\;"
		 "{\;"
		 "  lc1 = %2\;"
		 "  %2.h = #HI(%1)\;"
		 "}\;"
		 "%2.l = #LO(%1)\;"
		 "sa1 = %2";
	else
	  return "%2 = #%0\;"
		 "{\;"
		 "  lc1 = %2\;"
		 "  %2.h = #HI(%1)\;"
		 "}\;"
		 "%2.l = #LO(%1)\;"
		 "sa1 = %2";
      }
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "loop")
		      (const_string "multiple")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 1) (pc))) (const_int 200))
		      (const_string "4")
		      (const_string "20")))]
)

(define_insn "loop1_pic"
  [(set (reg:SI LC1_REGNUM)
	(match_operand:SI 0 "nonmemory_operand"		    "  Rg,IuA, Rg,IuA"))
   (set (reg SA1_REGNUM) (label_ref (match_operand 1 "" "")))
   (clobber (match_operand:SI 2 "gr_reg_or_scratch_operand" "=&Rg,&Rg,*X,*X"))
   (use (reg:SI PIC_REGNUM))]
  "flag_pic && !TARGET_V4_FEATURES"
  {
    gcc_assert (get_attr_length (insn) == 4 || REG_P (operands[2]));

    switch (which_alternative)
      {
      case 0:
      case 2:
	if (get_attr_length (insn) == 4)
	  return "loop1(%l1,%0)";
	else
	  return "%2 = %0\;"
		 "{\;"
		 "  lc1 = %2\;"
		 "  %2.h = #HI(%1@GOTOFF)\;"
		 "}\;"
		 "%2.l = #LO(%1@GOTOFF)\;"
		 "%2 = add(%2, %p0)\;"
		 "sa1 = %2";
	break;

      case 1:
      case 3:
	if (get_attr_length (insn) == 4)
	  return "loop1(%l1,#%0)";
	else
	  return "%2 = #%0\;"
		 "{\;"
		 "  lc1 = %2\;"
		 "  %2.h = #HI(%1@GOTOFF)\;"
		 "}\;"
		 "%2.l = #LO(%1@GOTOFF)\;"
		 "%2 = add(%2, %p0)\;"
		 "sa1 = %2";
	break;

      default:
	gcc_unreachable ();
      }
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "loop")
		      (const_string "multiple")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 1) (pc))) (const_int 200))
		      (const_string "4")
		      (const_string "20")))]
)

(define_insn "loop1_pic_v4"
  [(set (reg:SI LC1_REGNUM)
	(match_operand:SI 0 "nonmemory_operand"		    "  Rg,IuA, Rg,IuA"))
   (set (reg SA1_REGNUM) (label_ref (match_operand 1 "" "")))
   (clobber (match_operand:SI 2 "gr_reg_or_scratch_operand" "=&Rg,&Rg,*X,*X"))
   (use (reg:SI PIC_REGNUM))]
  "flag_pic && TARGET_V4_FEATURES"
  {
    gcc_assert (get_attr_length (insn) == 4 || REG_P (operands[2]));

    switch (which_alternative)
      {
      case 0:
      case 2:
	if (get_attr_length (insn) == 4)
	  return "loop1(%l1,%0)";
	else
	  return "loop1(##%l1,%0)";
	break;

      case 1:
      case 3:
	if (get_attr_length (insn) == 4)
	  return "loop1(%l1,#%0)";
	else
	  return "loop1(##%l1,#%0)";
	break;

      default:
	gcc_unreachable ();
      }
  }
  [(set (attr "type")
	(if_then_else (eq_attr "length" "4")
		      (const_string "loop")
		      (const_string "Eloop")))
   (set (attr "length")
	(if_then_else (le (abs (minus (match_dup 1) (pc))) (const_int 200))
		      (const_string "4")
		      (const_string "8")))]
)


;;----------;;
;; prologue ;;
;;----------;;

(define_expand "prologue"
  [(clobber (const_int 0))]
  ""
  {
    hexagon_expand_prologue ();
    DONE;
  }
)


;;----------;;
;; epilogue ;;
;;----------;;

(define_expand "epilogue"
  [(return)]
  ""
  {
    hexagon_expand_epilogue (false);
    DONE;
  }
)


;;------------------;;
;; sibcall_epilogue ;;
;;------------------;;

(define_expand "sibcall_epilogue"
  [(return)]
  ""
  {
    hexagon_expand_epilogue (true);
    DONE;
  }
)


;;----------;;
;; prefetch ;;
;;----------;;

(define_expand "prefetch"
  [(prefetch (match_operand:SI 0 "address_operand" "p")
	     (match_operand:SI 1 "const_int_operand" "i")
	     (match_operand:SI 2 "const_int_operand" "i"))]
  ""
  {
    if (!REG_P (operands[0]))
      operands[0] = force_reg (SImode, operands[0]);
  }
)

(define_insn "prefetch_real"
  [(prefetch (match_operand:SI 0 "gr_register_operand" "Rg")
	     (match_operand:SI 1 "const_int_operand" "i")
	     (match_operand:SI 2 "const_int_operand" "i"))]
  ""
  "dcfetch(%0)"
  [(set_attr "type" "dcfetch")]
)


;;---------------------------------;;
;; Patterns Produced by Intrinsics ;;
;;---------------------------------;;

(include "builtins.md")
(include "manual_builtins.md")


;;-------------------------------------------;;
;; Predicate Logic for Compound Conditionals ;;
;;-------------------------------------------;;

(define_code_iterator bit_logic_op [and ior xor])

(define_code_iterator and_ior [and ior])

(define_insn_and_split "<code>ttbisi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(bit_logic_op:SI (ne (match_operand:BI 1 "pr_register_operand" "Rp")
			     (const_int 0))
			 (ne (match_operand:BI 2 "pr_register_operand" "Rp")
			     (const_int 0))))
   (clobber (match_scratch:BI 3 "=&Rp"))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 3) (bit_logic_op:BI (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (if_then_else:SI (ne (match_dup 3) (const_int 0))
				       (const_int 1) (const_int 0)))]
  ""
  [(set_attr "type" "multiple")]
)

(define_insn_and_split "<code>ftbisi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(and_ior:SI (eq (match_operand:BI 1 "pr_register_operand" "Rp")
			(const_int 0))
		    (ne (match_operand:BI 2 "pr_register_operand" "Rp")
			(const_int 0))))
   (clobber (match_scratch:BI 3 "=&Rp"))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 3) (and_ior:BI (not:BI (match_dup 1)) (match_dup 2)))
   (set (match_dup 0) (if_then_else:SI (ne (match_dup 3) (const_int 0))
				       (const_int 1) (const_int 0)))]
  ""
  [(set_attr "type" "multiple")]
)

(define_insn_and_split "xorftbisi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(xor:SI (eq (match_operand:BI 1 "pr_register_operand" "Rp")
		    (const_int 0))
		(ne (match_operand:BI 2 "pr_register_operand" "Rp")
		    (const_int 0))))
   (clobber (match_scratch:BI 3 "=&Rp"))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 3) (xor:BI (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (if_then_else:SI (eq (match_dup 3) (const_int 0))
				       (const_int 1) (const_int 0)))]
  ""
  [(set_attr "type" "multiple")]
)

(define_insn_and_split "<code>tfbisi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(and_ior:SI (ne (match_operand:BI 1 "pr_register_operand" "Rp")
			(const_int 0))
		    (eq (match_operand:BI 2 "pr_register_operand" "Rp")
			(const_int 0))))
   (clobber (match_scratch:BI 3 "=&Rp"))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 3) (and_ior:BI (not:BI (match_dup 2)) (match_dup 1)))
   (set (match_dup 0) (if_then_else:SI (ne (match_dup 3) (const_int 0))
				       (const_int 1) (const_int 0)))]
  ""
  [(set_attr "type" "multiple")]
)

(define_insn_and_split "xortfbisi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(xor:SI (ne (match_operand:BI 1 "pr_register_operand" "Rp")
		    (const_int 0))
		(eq (match_operand:BI 2 "pr_register_operand" "Rp")
		    (const_int 0))))
   (clobber (match_scratch:BI 3 "=&Rp"))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 3) (xor:BI (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (if_then_else:SI (eq (match_dup 3) (const_int 0))
				       (const_int 1) (const_int 0)))]
  ""
  [(set_attr "type" "multiple")]
)

; Implements "!a && !b" as "!(a || b)".

(define_insn_and_split "andffbisi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(and:SI (eq (match_operand:BI 1 "pr_register_operand" "Rp")
		    (const_int 0))
		(eq (match_operand:BI 2 "pr_register_operand" "Rp")
		    (const_int 0))))
   (clobber (match_scratch:BI 3 "=&Rp"))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 3) (ior:BI (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (if_then_else:SI (eq (match_dup 3) (const_int 0))
				       (const_int 1) (const_int 0)))]
  ""
  [(set_attr "type" "multiple")]
)

; Implements "!a || !b" as "!(a && b)".

(define_insn_and_split "iorffbisi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ior:SI (eq (match_operand:BI 1 "pr_register_operand" "Rp")
		    (const_int 0))
		(eq (match_operand:BI 2 "pr_register_operand" "Rp")
		    (const_int 0))))
   (clobber (match_scratch:BI 3 "=&Rp"))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 3) (and:BI (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (if_then_else:SI (eq (match_dup 3) (const_int 0))
				       (const_int 1) (const_int 0)))]
  ""
  [(set_attr "type" "multiple")]
)

; "!a ^ !b" is the same as "a ^ b", so implement former as latter.

(define_insn_and_split "xorffbisi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(xor:SI (eq (match_operand:BI 1 "pr_register_operand" "Rp")
		    (const_int 0))
		(eq (match_operand:BI 2 "pr_register_operand" "Rp")
		    (const_int 0))))
   (clobber (match_scratch:BI 3 "=&Rp"))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 3) (xor:BI (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (if_then_else:SI (ne (match_dup 3) (const_int 0))
				       (const_int 1) (const_int 0)))]
  ""
  [(set_attr "type" "multiple")]
)

;;-------------------;;
;; add/sub halfwords ;;
;;-------------------;;

(define_insn "addhi3_ll"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(sign_extend:SI
	  (plus:HI (match_operand:HI 1 "gr_register_operand" "Rg")
		   (match_operand:HI 2 "gr_register_operand" "Rg"))))]
  ""
  "%0 = add(%1.l,%2.l)"
  [(set_attr "type" "X")]
)

(define_insn "addhi3_lh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(sign_extend:SI
	  (plus:HI
	    (subreg:HI (lshiftrt:SI
			 (match_operand:SI 2 "gr_register_operand" "Rg")
			 (const_int 16)) 0)
	    (match_operand:HI 1 "gr_register_operand" "Rg"))))]
  ""
  "%0 = add(%1.l,%2.h)"
  [(set_attr "type" "X")]
)

(define_insn "subhi3_ll"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(sign_extend:SI
	  (minus:HI (match_operand:HI 1 "gr_register_operand" "Rg")
		    (match_operand:HI 2 "gr_register_operand" "Rg"))))]
  ""
  "%0 = sub(%1.l,%2.l)"
  [(set_attr "type" "X")]
)

(define_insn "subhi3_lh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(sign_extend:SI
	  (minus:HI
	    (match_operand:HI 1 "gr_register_operand" "Rg")
	    (subreg:HI (lshiftrt:SI
			 (match_operand:SI 2 "gr_register_operand" "Rg")
			 (const_int 16)) 0))))]
  ""
  "%0 = sub(%1.l,%2.h)"
  [(set_attr "type" "X")]
)

(define_code_iterator plus_minus [plus minus])

;; Work around transformations that combine makes due to memop add/sub
;; patterns, which prevent addhi3_ll and subhi3_ll from being used effectively.

(define_insn_and_split "*<code>hi3_ll_helper"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg,Rg")
	(sign_extend:SI
	  (plus_minus:HI (match_operand:HI 1 "memory_operand" "Amo,Aem")
			 (match_operand:HI 2 "gr_register_operand" "Rg,Rg"))))
   (set (match_operand:HI 3 "gr_register_operand" "=Rg,Rg")
	(plus_minus:HI (match_dup 1) (match_dup 2)))]
  "TARGET_V4_FEATURES"
  "#"
  "can_create_pseudo_p ()"
  [(set (match_dup 4) (match_dup 1))
   (set (match_dup 0)
	(sign_extend:SI (plus_minus:HI (match_dup 4) (match_dup 2))))
   (set (match_dup 3) (match_dup 5))]
  {
    operands[4] = gen_reg_rtx (HImode);
    operands[5] = gen_lowpart (HImode, operands[0]);
  }
  [(set_attr "length" "12")
   (set_attr "type" "multiple")]
)

;;------------------------------;;
;; saturating add/sub halfwords ;;
;;------------------------------;;

(define_insn "ssaddhi3_ll"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(sign_extend:SI
	  (ss_plus:HI (match_operand:HI 1 "gr_register_operand" "Rg")
		      (match_operand:HI 2 "gr_register_operand" "Rg"))))]
  ""
  "%0 = add(%1.l,%2.l):sat"
  [(set_attr "type" "X")]
)

(define_insn "ssaddhi3_lh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(sign_extend:SI
	  (ss_plus:HI
	    (subreg:HI
	      (lshiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			   (const_int 16)) 0)
	    (match_operand:HI 1 "gr_register_operand" "Rg"))))]
  ""
  "%0 = add(%1.l,%2.h):sat"
  [(set_attr "type" "X")]
)

(define_insn "sssubhi3_ll"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(sign_extend:SI
	  (ss_minus:HI (match_operand:HI 1 "gr_register_operand" "Rg")
		       (match_operand:HI 2 "gr_register_operand" "Rg"))))]
  ""
  "%0 = sub(%1.l,%2.l):sat"
  [(set_attr "type" "X")]
)

(define_insn "sssubhi3_lh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(sign_extend:SI
	  (ss_minus:HI
	    (match_operand:HI 1 "gr_register_operand" "Rg")
	    (subreg:HI (lshiftrt:SI
			 (match_operand:SI 2 "gr_register_operand" "Rg")
			 (const_int 16))
		       0))))]
  ""
  "%0 = sub(%1.l,%2.h):sat"
  [(set_attr "type" "X")]
)


;;-------------------;;
;; compound logicals ;;
;;-------------------;;

(define_insn "andnotsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(and:SI
	  (not:SI
	    (match_operand:SI 1 "gr_register_operand" "Rg"))
	  (match_operand:SI 2 "gr_register_operand" "Rg")))]
  "TARGET_V4_FEATURES"
  "%0 = and(%2,~%1)"
  [(set_attr "type" "A")
   (set_attr "compound" "yes")]
)

(define_insn "ornotsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ior:SI
	  (not:SI
	    (match_operand:SI 1 "gr_register_operand" "Rg"))
	  (match_operand:SI 2 "gr_register_operand" "Rg")))]
  "TARGET_V4_FEATURES"
  "%0 = or(%2,~%1)"
  [(set_attr "type" "A")
   (set_attr "compound" "yes")]
)

(define_insn "andnotdi3"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(and:DI
	  (not:DI
	    (match_operand:DI 1 "gr_register_operand" "Rg"))
	  (match_operand:DI 2 "gr_register_operand" "Rg")))]
  "TARGET_V4_FEATURES"
  "%P0 = and(%P2,~%P1)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

(define_insn "ornotdi3"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(ior:DI
	  (not:DI
	    (match_operand:DI 1 "gr_register_operand" "Rg"))
	  (match_operand:DI 2 "gr_register_operand" "Rg")))]
  "TARGET_V4_FEATURES"
  "%P0 = or(%P2,~%P1)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

(define_insn "andandbi3"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(and:BI
	  (and:BI
	    (match_operand:BI 1 "pr_register_operand" "Rp")
	    (match_operand:BI 2 "pr_register_operand" "Rp"))
	  (match_operand:BI 3 "pr_register_operand" "Rp")))]
  "TARGET_V4_FEATURES"
  "%0 = and(%3,and(%1,%2))"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "andandnotbi3"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(and:BI
	  (and:BI
	    (not:BI (match_operand:BI 1 "pr_register_operand" "Rp"))
	    (match_operand:BI 2 "pr_register_operand" "Rp"))
	  (match_operand:BI 3 "pr_register_operand" "Rp")))]
  "TARGET_V4_FEATURES"
  "%0 = and(%3,and(%2,!%1))"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "andorbi3"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(and:BI
	  (ior:BI
	    (match_operand:BI 1 "pr_register_operand" "Rp")
	    (match_operand:BI 2 "pr_register_operand" "Rp"))
	  (match_operand:BI 3 "pr_register_operand" "Rp")))]
  "TARGET_V4_FEATURES"
  "%0 = and(%3,or(%1,%2))"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "andornotbi3"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(and:BI
	  (ior:BI
	    (not:BI (match_operand:BI 1 "pr_register_operand" "Rp"))
	    (match_operand:BI 2 "pr_register_operand" "Rp"))
	  (match_operand:BI 3 "pr_register_operand" "Rp")))]
  "TARGET_V4_FEATURES"
  "%0 = and(%3,or(%2,!%1))"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "andandsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(and:SI
	  (and:SI
	    (match_operand:SI 1 "gr_register_operand" "Rg")
	    (match_operand:SI 2 "gr_register_operand" "Rg"))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  "TARGET_V4_FEATURES"
  "%0 &= and(%1,%2)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

(define_insn "andandnotsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(and:SI
	  (and:SI
	    (not:SI (match_operand:SI 1 "gr_register_operand" "Rg"))
	    (match_operand:SI 2 "gr_register_operand" "Rg"))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  "TARGET_V4_FEATURES"
  "%0 &= and(%2,~%1)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

(define_insn "andorsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(and:SI
	  (ior:SI
	    (match_operand:SI 1 "gr_register_operand" "Rg")
	    (match_operand:SI 2 "gr_register_operand" "Rg"))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  "TARGET_V4_FEATURES"
  "%0 &= or(%1,%2)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

(define_insn "andxorsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(and:SI
	  (xor:SI
	    (match_operand:SI 1 "gr_register_operand" "Rg")
	    (match_operand:SI 2 "gr_register_operand" "Rg"))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  "TARGET_V4_FEATURES"
  "%0 &= xor(%1,%2)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

(define_insn "orandbi3"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(ior:BI
	  (and:BI
	    (match_operand:BI 1 "pr_register_operand" "Rp")
	    (match_operand:BI 2 "pr_register_operand" "Rp"))
	  (match_operand:BI 3 "pr_register_operand" "Rp")))]
  "TARGET_V4_FEATURES"
  "%0 = or(%3,and(%1,%2))"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "orandnotbi3"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(ior:BI
	  (and:BI
	    (not:BI (match_operand:BI 1 "pr_register_operand" "Rp"))
	    (match_operand:BI 2 "pr_register_operand" "Rp"))
	  (match_operand:BI 3 "pr_register_operand" "Rp")))]
  "TARGET_V4_FEATURES"
  "%0 = or(%3,and(%2,!%1))"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "ororbi3"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(ior:BI
	  (ior:BI
	    (match_operand:BI 1 "pr_register_operand" "Rp")
	    (match_operand:BI 2 "pr_register_operand" "Rp"))
	  (match_operand:BI 3 "pr_register_operand" "Rp")))]
  "TARGET_V4_FEATURES"
  "%0 = or(%3,or(%1,%2))"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "orornotbi3"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(ior:BI
	  (ior:BI
	    (not:BI (match_operand:BI 1 "pr_register_operand" "Rp"))
	    (match_operand:BI 2 "pr_register_operand" "Rp"))
	  (match_operand:BI 3 "pr_register_operand" "Rp")))]
  "TARGET_V4_FEATURES"
  "%0 = or(%3,or(%2,!%1))"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "orandsi3"
  [(set (match_operand:SI 0 "gr_register_operand"     "=Rg,Rg, Rg,Rg,Rg")
	(ior:SI
	  (and:SI
	    (match_operand:SI 1 "gr_register_operand" "  0, 0, Rg,Rg,Rg")
	    (match_operand:SI 2 "nonmemory_operand"   "IsA, i,IsA, i,Rg"))
	  (match_operand:SI 3 "gr_register_operand"   " Rg,Rg,  0, 0, 0")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = or(%3,and(%1,#%2))
   %0 = or(%3,and(%1,##%2))
   %0 |= and(%1,#%2)
   %0 |= and(%1,##%2)
   %0 |= and(%1,%2)"
  [(set_attr "type" "X,EX,X,EX,X")
   (set_attr "compound" "yes")]
)

(define_insn "ororsi3"
  [(set (match_operand:SI 0 "gr_register_operand"     "=Rg,Rg,Rg")
	(ior:SI
	  (ior:SI
	    (match_operand:SI 1 "gr_register_operand" " Rg,Rg,Rg")
	    (match_operand:SI 2 "gr_register_operand" "  0, 0,Rg"))
	  (match_operand:SI 3 "nonmemory_operand"     "IsA, i, 0")))]
  "TARGET_V4_FEATURES"
  "@
   %0 |= or(%1,#%3)
   %0 |= or(%1,##%3)
   %0 |= or(%1,%2)"
  [(set_attr "type" "X,EX,X")
   (set_attr "compound" "yes")]
)

(define_insn "orxorsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ior:SI
	  (xor:SI
	    (match_operand:SI 1 "gr_register_operand" "Rg")
	    (match_operand:SI 2 "gr_register_operand" "Rg"))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  "TARGET_V4_FEATURES"
  "%0 |= xor(%1,%2)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

(define_insn "xorandsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(xor:SI
	  (and:SI
	    (match_operand:SI 1 "gr_register_operand" "Rg")
	    (match_operand:SI 2 "gr_register_operand" "Rg"))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  "TARGET_V4_FEATURES"
  "%0 ^= and(%1,%2)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

(define_insn "xororsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(xor:SI
	  (ior:SI
	    (match_operand:SI 1 "gr_register_operand" "Rg")
	    (match_operand:SI 2 "gr_register_operand" "Rg"))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  "TARGET_V4_FEATURES"
  "%0 ^= or(%1,%2)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

(define_insn "xorxorsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(xor:SI
	  (xor:SI
	    (match_operand:SI 1 "gr_register_operand" "Rg")
	    (match_operand:SI 2 "gr_register_operand" "Rg"))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 ^= xor(%1,%2)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)


;;----------------------------;;
;; V2 add/sub with accumulate ;;
;;----------------------------;;

;; forms with 0 negative inputs
;; A = A+B+C

(define_insn "addaccsi3_v4"
  [(set (match_operand:SI 0 "gr_register_operand"
					    "=Rg,Rg,Rg,Rg,Rg, Rg, Rg,Rg,Rg")
	(plus:SI
	  (plus:SI
	    (match_operand:SI 1 "gr_register_operand"
					    " Rg,Rg,Rg,Rg, 0, Rg,  0,Rg, 0")
	    (match_operand:SI 2 "gr_register_operand"
					    " Rg,Rg,Rg, 0,Rg,  0, Rg, 0,Rg"))
	  (match_operand:SI 3 "nonmemory_operand"
					    "Is6, i, 0,Rg,Rg,Is8,Is8, i, i")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = add(%1,add(%2,#%3))
   %0 = add(%1,add(%2,##%3))
   %0 += add(%1,%2)
   %0 += add(%1,%3)
   %0 += add(%2,%3)
   %0 += add(%1,#%3)
   %0 += add(%2,#%3)
   %0 += add(%1,##%3)
   %0 += add(%2,##%3)"
  [(set_attr "type" "X,EX,X,X,X,X,X,EX,EX")
   (set_attr "compound" "yes")]
)

(define_insn "addaccsi3"
  [(set (match_operand:SI 0 "gr_register_operand"     "=Rg,Rg,Rg, Rg, Rg")
	(plus:SI
	  (plus:SI
	    (match_operand:SI 1 "gr_register_operand" " Rg,Rg, 0, Rg,  0")
	    (match_operand:SI 2 "gr_register_operand" " Rg, 0,Rg,  0, Rg"))
	  (match_operand:SI 3 "nonmemory_operand"     "  0,Rg,Rg,Is8,Is8")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 += add(%1,%2)
   %0 += add(%1,%3)
   %0 += add(%2,%3)
   %0 += add(%1,#%3)
   %0 += add(%2,#%3)"
  [(set_attr "type" "X,X,X,X,X")
   (set_attr "compound" "yes")]
)

;; forms with 1 negative inputs
;; A = A+(B-C)

(define_insn "subacc1si3_v4"
  [(set (match_operand:SI 0 "gr_register_operand"	      "=Rg,Rg,Rg")
	(plus:SI
	  (minus:SI (match_operand:SI 1 "gr_register_operand" " Rg,Rg,Rg")
		    (match_operand:SI 2 "gr_register_operand" " Rg,Rg,Rg"))
	  (match_operand:SI 3 "nonmemory_operand"	      "Is6, i, 0")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = add(%1,sub(#%3,%2))
   %0 = add(%1,sub(##%3,%2))
   %0 += sub(%1,%2)"
  [(set_attr "type" "X,EX,X")
   (set_attr "compound" "yes")]
)

(define_insn "subacc1si3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(plus:SI
	  (minus:SI (match_operand:SI 1 "gr_register_operand" "Rg")
		    (match_operand:SI 2 "gr_register_operand" "Rg"))
	  (match_operand:SI 3 "nonmemory_operand" "0")))]
  "!TARGET_V4_FEATURES"
  "%0 += sub(%1,%2)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

;; A = (A+B)-C

(define_insn "subacc2si3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(minus:SI
	  (plus:SI (match_operand:SI 1 "gr_register_operand" "0")
		   (match_operand:SI 2 "gr_register_operand" "Rg"))
	  (match_operand:SI 3 "gr_register_operand" "Rg")))]
  ""
  "%0 += sub(%2,%3)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

;; A = A-(B-C)

(define_insn "subnaccsi3"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(minus:SI
	  (match_operand:SI 1 "gr_register_operand" "0")
	  (minus:SI (match_operand:SI 2 "gr_register_operand" "Rg")
		    (match_operand:SI 3 "gr_register_operand" "Rg"))))]
  ""
  "%0 += sub(%3,%2)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)


;; forms with 2 negative inputs
;; A = A-(B+C)

(define_insn "addnacc1si3_v4"
  [(set (match_operand:SI 0 "gr_register_operand"	     "=Rg, Rg,Rg")
	(minus:SI
	  (match_operand:SI 1 "gr_register_operand"	     "  0,  0, 0")
	  (plus:SI (match_operand:SI 2 "gr_register_operand" " Rg, Rg,Rg")
		   (match_operand:SI 3 "nonmemory_operand"   " Rg,Is8, i"))))]
  "TARGET_V4_FEATURES"
  "@
   %0 -= add(%2,%3)
   %0 -= add(%2,#%3)
   %0 -= add(%2,##%3)"
  [(set_attr "type" "X,X,EX")
   (set_attr "compound" "yes")]
)

(define_insn "addnacc1si3"
  [(set (match_operand:SI 0 "gr_register_operand"	     "=Rg, Rg")
	(minus:SI
	  (match_operand:SI 1 "gr_register_operand"	     "  0,  0")
	  (plus:SI (match_operand:SI 2 "gr_register_operand" " Rg, Rg")
		   (match_operand:SI 3 "nonmemory_operand"   " Rg,Is8"))))]
  "!TARGET_V4_FEATURES"
  "@
   %0 -= add(%2,%3)
   %0 -= add(%2,#%3)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)

;; A = (A-B)-C

(define_insn "addnacc2si3_v4"
  [(set (match_operand:SI 0 "gr_register_operand"	      "=Rg, Rg,Rg")
	(minus:SI
	  (minus:SI (match_operand:SI 1 "gr_register_operand" "  0,  0, 0")
		    (match_operand:SI 2 "gr_register_operand" " Rg, Rg,Rg"))
	  (match_operand:SI 3 "nonmemory_operand"	      " Rg,Is8, i")))]
  "TARGET_V4_FEATURES"
  "@
   %0 -= add(%2,%3)
   %0 -= add(%2,#%3)
   %0 -= add(%2,##%3)"
  [(set_attr "type" "X,X,EX")
   (set_attr "compound" "yes")]
)

(define_insn "addnacc2si3"
  [(set (match_operand:SI 0 "gr_register_operand"	      "=Rg, Rg")
	(minus:SI
	  (minus:SI (match_operand:SI 1 "gr_register_operand" "  0,  0")
		    (match_operand:SI 2 "gr_register_operand" " Rg, Rg"))
	  (match_operand:SI 3 "nonmemory_operand"	      " Rg,Is8")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 -= add(%2,%3)
   %0 -= add(%2,#%3)"
  [(set_attr "type" "X")
   (set_attr "compound" "yes")]
)


;;--------;;
;; addasl ;;
;;--------;;

(define_insn "addaslmsi4"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(plus:SI
	  (mult:SI (match_operand:SI 1 "gr_register_operand" "Rg")
		   (match_operand:SI 2 "addasl_const_int_operand" "Kp2"))
	  (match_operand:SI 3 "gr_register_operand" "Rg")))]
  ""
  "%0 = addasl(%3,%1,#%J2)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "addaslsi4"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(plus:SI
	  (ashift:SI (match_operand:SI 1 "gr_register_operand" "Rg")
		     (match_operand:SI 2 "u3_const_int_operand" "Iu3"))
	  (match_operand:SI 3 "gr_register_operand" "Rg")))]
  ""
  "%0 = addasl(%3,%1,#%2)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)


;;--------------------;;
;; multiply halfwords ;;
;;--------------------;;

(define_insn "mulhisi3_hh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(mult:SI
	  (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
		       (const_int 16))
	  (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
		       (const_int 16))))]
  ""
  "%0 = mpy(%1.h,%2.h)"
  [(set_attr "type" "M")]
)

(define_insn "mulhisi3_hl"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(mult:SI
	  (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
		       (const_int 16))
	  (sign_extend:SI (match_operand:HI 2 "gr_register_operand" "Rg"))))]
  ""
  "%0 = mpy(%1.h,%2.l)"
  [(set_attr "type" "M")]
)

(define_insn "mulhisi3_lh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(mult:SI
	  (sign_extend:SI (match_operand:HI 1 "gr_register_operand" "Rg"))
	  (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
		       (const_int 16))))]
  ""
  "%0 = mpy(%1.l,%2.h)"
  [(set_attr "type" "M")]
)

(define_insn "mulhisi3_hh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ashift:SI
	  (mult:SI (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
				(const_int 16))
		   (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
				(const_int 16)))
	  (const_int 1)))]
  ""
  "%0 = mpy(%1.h,%2.h):<<1"
  [(set_attr "type" "M")]
)

(define_insn "mulhisi3_hl_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ashift:SI
	  (mult:SI (ashiftrt:SI
		     (match_operand:SI 1 "gr_register_operand" "Rg")
		     (const_int 16))
		   (sign_extend:SI
		     (match_operand:HI 2 "gr_register_operand" "Rg")))
	  (const_int 1)))]
  ""
  "%0 = mpy(%1.h,%2.l):<<1"
  [(set_attr "type" "M")]
)

(define_insn "mulhisi3_lh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ashift:SI
	  (mult:SI (sign_extend:SI
		     (match_operand:HI 1 "gr_register_operand" "Rg"))
		   (ashiftrt:SI
		     (match_operand:SI 2 "gr_register_operand" "Rg")
		     (const_int 16)))
	  (const_int 1)))]
  ""
  "%0 = mpy(%1.l,%2.h):<<1"
  [(set_attr "type" "M")]
)

(define_insn "mulhisi3_ll_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ashift:SI
	  (mult:SI (sign_extend:SI
		     (match_operand:HI 1 "gr_register_operand" "Rg"))
		   (sign_extend:SI
		     (match_operand:HI 2 "gr_register_operand" "Rg")))
	  (const_int 1)))]
  ""
  "%0 = mpy(%1.l,%2.l):<<1"
  [(set_attr "type" "M")]
)


;;-------------------------------;;
;; saturating multiply halfwords ;;
;;-------------------------------;;

(define_insn "ssmulhisi3_hh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_truncate:SI
	  (mult:DI (sign_extend:DI
		     (subreg:HI
		       (lshiftrt:SI
		         (match_operand:SI 1 "gr_register_operand" "Rg")
			 (const_int 16)) 0))
		   (sign_extend:DI
		     (subreg:HI
		       (lshiftrt:SI
		         (match_operand:SI 2 "gr_register_operand" "Rg")
			 (const_int 16)) 0)))))]
  ""
  "%0 = mpy(%1.h,%2.h):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmulhisi3_hl"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_truncate:SI
	  (mult:DI (sign_extend:DI
		     (subreg:HI
		       (lshiftrt:SI
		         (match_operand:SI 1 "gr_register_operand" "Rg")
			 (const_int 16)) 0))
		   (sign_extend:DI
		     (match_operand:HI 2 "gr_register_operand" "Rg")))))]
  ""
  "%0 = mpy(%1.h,%2.l):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmulhisi3_lh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_truncate:SI
	  (mult:DI
	    (sign_extend:DI
	      (match_operand:HI 1 "gr_register_operand" "Rg"))
	    (sign_extend:DI
	      (subreg:HI
	        (lshiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			     (const_int 16)) 0)))))]
  ""
  "%0 = mpy(%1.l,%2.h):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmulhisi3_ll"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_truncate:SI
	  (mult:DI
	    (sign_extend:DI (match_operand:HI 1 "gr_register_operand" "Rg"))
	    (sign_extend:DI (match_operand:HI 2 "gr_register_operand" "Rg")))))]
  ""
  "%0 = mpy(%1.l,%2.l):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmulhisi3_hh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_truncate:SI
	  (ashift:DI
	    (sign_extend:DI
	      (mult:SI
	        (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			     (const_int 16))
		(ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			     (const_int 16))))
	    (const_int 1))))]
  ""
  "%0 = mpy(%1.h,%2.h):<<1:sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmulhisi3_hl_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_truncate:SI
	  (ashift:DI
	    (sign_extend:DI
	      (mult:SI
	        (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			     (const_int 16))
		(sign_extend:SI
		  (match_operand:HI 2 "gr_register_operand" "Rg"))))
	    (const_int 1))))]
  ""
  "%0 = mpy(%1.h,%2.l):<<1:sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmulhisi3_lh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_truncate:SI
	  (ashift:DI
	    (sign_extend:DI
	      (mult:SI
	        (sign_extend:SI (match_operand:HI 1 "gr_register_operand" "Rg"))
		(ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			     (const_int 16))))
	  (const_int 1))))]
  ""
  "%0 = mpy(%1.l,%2.h):<<1:sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmulhisi3_ll_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_truncate:SI
	  (ashift:DI
	    (sign_extend:DI
	      (mult:SI
	        (sign_extend:SI
		  (match_operand:HI 1 "gr_register_operand" "Rg"))
		(sign_extend:SI
		  (match_operand:HI 2 "gr_register_operand" "Rg"))))
	  (const_int 1))))]
  ""
  "%0 = mpy(%1.l,%2.l):<<1:sat"
  [(set_attr "type" "M")]
)


;;-----;;
;; mac ;;
;;-----;;

(define_insn "macsi4"
  [(set
     (match_operand:SI 0 "gr_register_operand"
		     "=Rg, Rg, Rg, Rg, Rg,Rg,   Rg, Rg,Rg,Rg,Rg, Rg, Rg,Rg")
     (plus:SI
       (mult:SI
	 (match_operand:SI 1 "gr_register_operand"
		     "  0,  0, Rg, Rg, Rg,Rg,   Rg, Rg,Rg, 0,Rg, Rg, Rg,Rg")
	 (match_operand:SI 2 "nonmemory_operand"
		     "K1h,K1h,Iu6,Iu6, Rg,Rg,Ju6_2,Iu6, i,Rg,Rg,Iu8,In8, i"))
       (match_operand:SI 3 "nonmemory_operand"
		     "Iu8,  i,Iu6,  i,Iu6, i,   Rg, Rg,Rg,Rg, 0,  0,  0, 0")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = add(#%3,asl(%1,#%J2))
   %0 = add(##%3,asl(%1,#%J2))
   %0 = add(#%3,mpyi(%1,#%2))
   %0 = add(##%3,mpyi(%1,#%2))
   %0 = add(#%3,mpyi(%1,%2))
   %0 = add(##%3,mpyi(%1,%2))
   %0 = add(%3,mpyi(#%2,%1))
   %0 = add(%3,mpyi(%1,#%2))
   %0 = add(%3,mpyi(%1,##%2))
   %0 = add(%3,mpyi(%1,%2))
   %0 += mpyi(%1,%2)
   %0 += mpyi(%1,#%2)
   %0 -= mpyi(%1,#%n2)
   %0 += mpyi(%1,##%2)"
  [(set_attr "type" "S,ES,M,EM,M,EM,M,M,EM,M,M,M,M,EM")
   (set_attr "compound" "yes")]
)

(define_insn "macsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	     "=Rg, Rg, Rg")
	(plus:SI
	  (mult:SI (match_operand:SI 1 "gr_register_operand" " Rg, Rg, Rg")
		   (match_operand:SI 2 "nonmemory_operand"   " Rg,Iu8,In8"))
	  (match_operand:SI 3 "nonmemory_operand"	     "  0,  0,  0")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 += mpyi(%1,%2)
   %0 += mpyi(%1,#%2)
   %0 -= mpyi(%1,#%n2)"
  [(set_attr "type" "M,M,M")
   (set_attr "compound" "yes")]
)

(define_insn "macsidi3"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(plus:DI
	  (mult:DI
	    (sign_extend:DI (match_operand:SI 1 "gr_register_operand" "Rg"))
	    (sign_extend:DI (match_operand:SI 2 "gr_register_operand" "Rg")))
	  (match_operand:DI 3 "gr_register_operand" "0")))]
  ""
  "%P0 += mpy(%1,%2)"
  [(set_attr "type" "M")
   (set_attr "compound" "yes")]
)

(define_insn "mnacsidi3"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(minus:DI
	  (match_operand:DI 3 "gr_register_operand" "0")
	  (mult:DI
	    (sign_extend:DI (match_operand:SI 1 "gr_register_operand" "Rg"))
	    (sign_extend:DI (match_operand:SI 2 "gr_register_operand" "Rg")))))]
  ""
  "%P0 -= mpy(%1,%2)"
  [(set_attr "type" "M")
   (set_attr "compound" "yes")]
)

(define_insn "macn1sidi3"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(plus:DI
	  (mult:DI
	    (sign_extend:DI
	      (neg:SI (match_operand:SI 1 "gr_register_operand" "Rg")))
	      (sign_extend:DI (match_operand:SI 2 "gr_register_operand" "Rg")))
	  (match_operand:DI 3 "gr_register_operand" "0")))]
  ""
  "%P0 -= mpy(%1,%2)"
  [(set_attr "type" "M")
   (set_attr "compound" "yes")]
)

(define_insn "macn2sidi3"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(plus:DI
	  (mult:DI
	    (sign_extend:DI (match_operand:SI 1 "gr_register_operand" "Rg"))
	    (sign_extend:DI
	      (neg:SI (match_operand:SI 2 "gr_register_operand" "Rg"))))
	  (match_operand:DI 3 "gr_register_operand" "0")))]
  ""
  "%P0 -= mpy(%1,%2)"
  [(set_attr "type" "M")
   (set_attr "compound" "yes")]
)

(define_insn "umacsidi3"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(plus:DI
	  (mult:DI
	    (zero_extend:DI (match_operand:SI 1 "gr_register_operand" "Rg"))
	    (zero_extend:DI (match_operand:SI 2 "gr_register_operand" "Rg")))
	  (match_operand:DI 3 "gr_register_operand" "0")))]
  ""
  "%P0 += mpyu(%1,%2)"
  [(set_attr "type" "M")
   (set_attr "compound" "yes")]
)

(define_insn "umnacsidi3"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(minus:DI
	  (match_operand:DI 3 "gr_register_operand" "0")
	  (mult:DI
	    (zero_extend:DI (match_operand:SI 1 "gr_register_operand" "Rg"))
	    (zero_extend:DI (match_operand:SI 2 "gr_register_operand" "Rg")))))]
  ""
  "%P0 -= mpyu(%1,%2)"
  [(set_attr "type" "M")
   (set_attr "compound" "yes")]
)

(define_insn "umacn1sidi3"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(plus:DI
	  (mult:DI
	    (zero_extend:DI
	      (neg:SI (match_operand:SI 1 "gr_register_operand" "Rg")))
	      (zero_extend:DI (match_operand:SI 2 "gr_register_operand" "Rg")))
	  (match_operand:DI 3 "gr_register_operand" "0")))]
  ""
  "%P0 -= mpyu(%1,%2)"
  [(set_attr "type" "M")
   (set_attr "compound" "yes")]
)

(define_insn "umacn2sidi3"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(plus:DI
	  (mult:DI
	    (zero_extend:DI (match_operand:SI 1 "gr_register_operand" "Rg"))
	    (zero_extend:DI
	      (neg:SI (match_operand:SI 2 "gr_register_operand" "Rg"))))
	  (match_operand:DI 3 "gr_register_operand" "0")))]
  ""
  "%P0 -= mpyu(%1,%2)"
  [(set_attr "type" "M")
   (set_attr "compound" "yes")]
)

(define_insn "machisi3_hh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(plus:SI
	  (mult:SI
	    (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			 (const_int 16))
	    (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			 (const_int 16)))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.h,%2.h)"
  [(set_attr "type" "M")]
)

(define_insn "machisi3_hl"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(plus:SI
	  (mult:SI
	    (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			 (const_int 16))
	    (sign_extend:SI (match_operand:HI 2 "gr_register_operand" "Rg")))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.h,%2.l)"
  [(set_attr "type" "M")]
)

(define_insn "machisi3_lh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(plus:SI
	  (mult:SI
	    (sign_extend:SI (match_operand:HI 1 "gr_register_operand" "Rg"))
	    (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			 (const_int 16)))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.l,%2.h)"
  [(set_attr "type" "M")]
)

(define_insn "machisi3_ll"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(plus:SI
	  (mult:SI
	    (sign_extend:SI (match_operand:HI 1 "gr_register_operand" "Rg"))
	    (sign_extend:SI (match_operand:HI 2 "gr_register_operand" "Rg")))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.l,%2.l)"
  [(set_attr "type" "M")]
)

(define_insn "machisi3_hh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(plus:SI
	  (ashift:SI
	    (mult:SI
	      (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			   (const_int 16))
	      (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			   (const_int 16)))
	    (const_int 1))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.h,%2.h):<<1"
  [(set_attr "type" "M")]
)

(define_insn "machisi3_hl_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(plus:SI
	  (ashift:SI
	    (mult:SI
	      (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			   (const_int 16))
	      (sign_extend:SI (match_operand:HI 2 "gr_register_operand" "Rg")))
	    (const_int 1))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.h,%2.l):<<1"
  [(set_attr "type" "M")]
)

(define_insn "machisi3_lh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(plus:SI
	  (ashift:SI
	    (mult:SI
	      (sign_extend:SI (match_operand:HI 1 "gr_register_operand" "Rg"))
	      (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			   (const_int 16)))
	    (const_int 1))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.l,%2.h):<<1"
  [(set_attr "type" "M")]
)

(define_insn "machisi3_ll_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(plus:SI
	  (ashift:SI
	    (mult:SI
	      (sign_extend:SI (match_operand:HI 1 "gr_register_operand" "Rg"))
	      (sign_extend:SI (match_operand:HI 2 "gr_register_operand" "Rg")))
	    (const_int 1))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.l,%2.l):<<1"
  [(set_attr "type" "M")]
)

(define_insn "mnachisi3_hh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (mult:SI
	    (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			 (const_int 16))
	    (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			 (const_int 16)))))]
  ""
  "%0 -= mpy(%1.h,%2.h)"
  [(set_attr "type" "M")]
)

(define_insn "mnachisi3_hl"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (mult:SI
	    (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			 (const_int 16))
	    (sign_extend:SI (match_operand:HI 2 "gr_register_operand" "Rg")))))]
  ""
  "%0 -= mpy(%1.h,%2.l)"
  [(set_attr "type" "M")]
)

(define_insn "mnachisi3_lh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (mult:SI
	    (sign_extend:SI (match_operand:HI 1 "gr_register_operand" "Rg"))
	    (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			 (const_int 16)))))]
  ""
  "%0 -= mpy(%1.l,%2.h)"
  [(set_attr "type" "M")]
)

(define_insn "mnachisi3_ll"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (mult:SI
	    (sign_extend:SI (match_operand:HI 1 "gr_register_operand" "Rg"))
	    (sign_extend:SI (match_operand:HI 2 "gr_register_operand" "Rg")))))]
  ""
  "%0 -= mpy(%1.l,%2.l)"
  [(set_attr "type" "M")]
)

(define_insn "mnachisi3_hh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ashift:SI
	    (mult:SI
	      (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			   (const_int 16))
	      (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			   (const_int 16)))
	    (const_int 1))))]
  ""
  "%0 -= mpy(%1.h,%2.h):<<1"
  [(set_attr "type" "M")]
)

(define_insn "mnachisi3_hl_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ashift:SI
	    (mult:SI
	      (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			   (const_int 16))
	      (sign_extend:SI (match_operand:HI 2 "gr_register_operand" "Rg")))
	    (const_int 1))))]
  ""
  "%0 -= mpy(%1.h,%2.l):<<1"
  [(set_attr "type" "M")]
)

(define_insn "mnachisi3_lh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ashift:SI
	    (mult:SI
	      (sign_extend:SI (match_operand:HI 1 "gr_register_operand" "Rg"))
	      (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			   (const_int 16)))
	    (const_int 1))))]
  ""
  "%0 -= mpy(%1.l,%2.h):<<1"
  [(set_attr "type" "M")]
)

(define_insn "mnachisi3_ll_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ashift:SI
	    (mult:SI
	      (sign_extend:SI (match_operand:HI 1 "gr_register_operand" "Rg"))
	      (sign_extend:SI (match_operand:HI 2 "gr_register_operand" "Rg")))
	    (const_int 1))))]
  ""
  "%0 -= mpy(%1.l,%2.l):<<1"
  [(set_attr "type" "M")]
)


;;-------;;
;; ssmac ;;
;;-------;;

(define_insn "ssmachisi3_hh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_plus:SI
	  (ss_truncate:SI
	    (mult:DI
	      (sign_extend:DI
	        (subreg:HI
		  (lshiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			       (const_int 16)) 0))
	      (sign_extend:DI
	        (subreg:HI
		  (lshiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			       (const_int 16)) 0))))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.h,%2.h):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmachisi3_hl"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_plus:SI
	  (ss_truncate:SI
	    (mult:DI
	      (sign_extend:DI
	        (subreg:HI
		  (lshiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			       (const_int 16)) 0))
	      (sign_extend:DI
	        (match_operand:HI 2 "gr_register_operand" "Rg"))))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.h,%2.l):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmachisi3_lh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_plus:SI
	  (ss_truncate:SI
	    (mult:DI
	      (sign_extend:DI (match_operand:HI 1 "gr_register_operand" "Rg"))
	      (sign_extend:DI
	        (subreg:HI
		  (lshiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			       (const_int 16)) 0))))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.l,%2.h):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmachisi3_ll"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_plus:SI
	  (ss_truncate:SI
	    (mult:DI
	      (sign_extend:DI (match_operand:HI 1 "gr_register_operand" "Rg"))
	      (sign_extend:DI (match_operand:HI 2 "gr_register_operand" "Rg"))))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.l,%2.l):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmachisi3_hh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_plus:SI
	  (ss_truncate:SI
	    (ashift:DI
	      (sign_extend:DI
	        (mult:SI
		  (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			       (const_int 16))
		  (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			       (const_int 16))))
	      (const_int 1)))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.h,%2.h):<<1:sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmachisi3_hl_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_plus:SI
	  (ss_truncate:SI
	    (ashift:DI
	      (sign_extend:DI
	        (mult:SI
		  (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			       (const_int 16))
		  (sign_extend:SI
		    (match_operand:HI 2 "gr_register_operand" "Rg"))))
	      (const_int 1)))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.h,%2.l):<<1:sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmachisi3_lh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_plus:SI
	  (ss_truncate:SI
	    (ashift:DI
	      (sign_extend:DI
	        (mult:SI
		  (sign_extend:SI
		    (match_operand:HI 1 "gr_register_operand" "Rg"))
		  (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			       (const_int 16))))
	      (const_int 1)))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.l,%2.h):<<1:sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmachisi3_ll_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_plus:SI
	  (ss_truncate:SI
	    (ashift:DI
	      (sign_extend:DI
	        (mult:SI
		  (sign_extend:SI
		    (match_operand:HI 1 "gr_register_operand" "Rg"))
		  (sign_extend:SI
		    (match_operand:HI 2 "gr_register_operand" "Rg"))))
	      (const_int 1)))
	  (match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 += mpy(%1.l,%2.l):<<1:sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmnachisi3_hh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ss_truncate:SI
	    (mult:DI
	      (sign_extend:DI
	        (subreg:HI
		  (lshiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			       (const_int 16)) 0))
	      (sign_extend:DI
	        (subreg:HI
		  (lshiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			       (const_int 16)) 0))))))]
  ""
  "%0 -= mpy(%1.h,%2.h):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmnachisi3_hl"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ss_truncate:SI
	    (mult:DI
	      (sign_extend:DI
	        (subreg:HI
		  (lshiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			       (const_int 16)) 0))
	      (sign_extend:DI
		(match_operand:HI 2 "gr_register_operand" "Rg"))))))]
  ""
  "%0 -= mpy(%1.h,%2.l):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmnachisi3_lh"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ss_truncate:SI
	    (mult:DI
	      (sign_extend:DI
	        (match_operand:HI 1 "gr_register_operand" "Rg"))
	      (sign_extend:DI
	        (subreg:HI
		  (lshiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			       (const_int 16)) 0))))))]
  ""
  "%0 -= mpy(%1.l,%2.h):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmnachisi3_ll"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ss_truncate:SI
	    (mult:DI
	      (sign_extend:DI (match_operand:HI 1 "gr_register_operand" "Rg"))
	      (sign_extend:DI
	        (match_operand:HI 2 "gr_register_operand" "Rg"))))))]
  ""
  "%0 -= mpy(%1.l,%2.l):sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmnachisi3_hh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ss_truncate:SI
	    (ashift:DI
	      (sign_extend:DI
	        (mult:SI
		  (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			       (const_int 16))
		  (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			       (const_int 16))))
	      (const_int 1)))))]
  ""
  "%0 -= mpy(%1.h,%2.h):<<1:sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmnachisi3_hl_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ss_truncate:SI
	    (ashift:DI
	      (sign_extend:DI
	        (mult:SI
		  (ashiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			       (const_int 16))
		  (sign_extend:SI
		    (match_operand:HI 2 "gr_register_operand" "Rg"))))
	      (const_int 1)))))]
  ""
  "%0 -= mpy(%1.h,%2.l):<<1:sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmnachisi3_lh_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ss_truncate:SI
	    (ashift:DI
	      (sign_extend:DI
	        (mult:SI
		  (sign_extend:SI
		    (match_operand:HI 1 "gr_register_operand" "Rg"))
		  (ashiftrt:SI (match_operand:SI 2 "gr_register_operand" "Rg")
			       (const_int 16))))
	      (const_int 1)))))]
  ""
  "%0 -= mpy(%1.l,%2.h):<<1:sat"
  [(set_attr "type" "M")]
)

(define_insn "ssmnachisi3_ll_s1"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(ss_minus:SI
	  (match_operand:SI 3 "gr_register_operand" "0")
	  (ss_truncate:SI
	    (ashift:DI
	      (sign_extend:DI
	        (mult:SI
		  (sign_extend:SI
		    (match_operand:HI 1 "gr_register_operand" "Rg"))
		  (sign_extend:SI
		    (match_operand:HI 2 "gr_register_operand" "Rg"))))
	      (const_int 1)))))]
  ""
  "%0 -= mpy(%1.l,%2.l):<<1:sat"
  [(set_attr "type" "M")]
)


;;------;;
;; shac ;;
;;------;;

;; SI asl

(define_insn "addashlsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg, Rg, Rg,Rg")
	(plus:SI (ashift:SI (match_operand:SI 1 "gr_register_operand"
							   "  0,  0, Rg,Rg")
			    (match_operand:SI 2 "nonmemory_operand"
							   "Iu5,Iu5,Iu5,Rg"))
		 (match_operand:SI 3 "nonmemory_operand"   "Iu8,  i,  0, 0")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = add(#%3,asl(%1,#%2))
   %0 = add(##%3,asl(%1,#%2))
   %0 += asl(%1,#%2)
   %0 += asl(%1,%2)"
  [(set_attr "type" "S,ES,S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashlsi3_acc"
  [(set (match_operand:SI 0 "gr_register_operand"		    "=Rg,Rg")
	(plus:SI (ashift:SI (match_operand:SI 1 "gr_register_operand"
								    " Rg,Rg")
			    (match_operand:SI 2 "nonmemory_operand" "Iu5,Rg"))
		 (match_operand:SI 3 "gr_register_operand"	    "  0, 0")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 += asl(%1,#%2)
   %0 += asl(%1,%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "subashlsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	  "=Rg, Rg, Rg,Rg")
	(minus:SI (match_operand:SI 1 "nonmemory_operand" "Iu8,  i,  0, 0")
		  (ashift:SI (match_operand:SI 2 "gr_register_operand"
							  "  0,  0, Rg,Rg")
			     (match_operand:SI 3 "nonmemory_operand"
							  "Iu5,Iu5,Iu5,Rg"))))]
  "TARGET_V4_FEATURES"
  "@
   %0 = sub(#%1,asl(%2,#%3))
   %0 = sub(##%1,asl(%2,#%3))
   %0 -= asl(%2,#%3)
   %0 -= asl(%2,%3)"
  [(set_attr "type" "S,ES,S,S")
   (set_attr "compound" "yes")]
)

(define_insn "submulsi3"
  [(set (match_operand:SI 0 "gr_register_operand"		 "=Rg, Rg")
	(minus:SI (match_operand:SI 1 "immediate_operand"	 "Iu8,  i")
		  (mult:SI (match_operand:SI 2 "gr_register_operand"
								 "  0,  0")
			   (match_operand:SI 3 "power_of_two_operand"
								 "K1h,K1h"))))]
  "TARGET_V4_FEATURES"
  "@
   %0 = sub(#%1,asl(%2,#%J3))
   %0 = sub(##%1,asl(%2,#%J3))"
  [(set_attr "type" "S,ES")
   (set_attr "compound" "yes")]
)

(define_insn "ashlsi3_nacc"
  [(set (match_operand:SI 0 "gr_register_operand"		  "=Rg,Rg")
	(minus:SI (match_operand:SI 1 "gr_register_operand"	  "  0, 0")
		  (ashift:SI (match_operand:SI 2 "gr_register_operand"
								  " Rg,Rg")
			     (match_operand:SI 3 "nonmemory_operand"
								  "Iu5,Rg"))))]
  "!TARGET_V4_FEATURES"
  "@
   %0 -= asl(%2,#%3)
   %0 -= asl(%2,%3)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "andashlsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg, Rg, Rg,Rg")
	(and:SI (ashift:SI (match_operand:SI 1 "gr_register_operand"
							   "  0,  0, Rg,Rg")
			   (match_operand:SI 2 "nonmemory_operand"
							   "Iu5,Iu5,Iu5,Rg"))
		(match_operand:SI 3 "nonmemory_operand"	   "Iu8,  i,  0, 0")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = and(#%3,asl(%1,#%2))
   %0 = and(##%3,asl(%1,#%2))
   %0 &= asl(%1,#%2)
   %0 &= asl(%1,%2)"
  [(set_attr "type" "S,ES,S,S")
   (set_attr "compound" "yes")]
)

(define_insn "andmulsi3"
  [(set (match_operand:SI 0 "gr_register_operand"		   "=Rg, Rg")
	(and:SI (mult:SI (match_operand:SI 1 "gr_register_operand" "  0,  0")
			 (match_operand:SI 2 "power_of_two_operand"
								   "K1h,K1h"))
		(match_operand:SI 3 "immediate_operand"		   "Iu8, i")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = and(#%3,asl(%1,#%J2))
   %0 = and(##%3,asl(%1,#%J2))"
  [(set_attr "type" "S,ES")
   (set_attr "compound" "yes")]
)

(define_insn "ashlsi3_and"
  [(set (match_operand:SI 0 "gr_register_operand"		   "=Rg,Rg")
	(and:SI (ashift:SI (match_operand:SI 1 "gr_register_operand"
								   " Rg,Rg")
			   (match_operand:SI 2 "nonmemory_operand" "Iu5,Rg"))
		(match_operand:SI 3 "gr_register_operand"	   "  0, 0")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 &= asl(%1,#%2)
   %0 &= asl(%1,%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "orashlsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg, Rg, Rg,Rg")
	(ior:SI
	  (ashift:SI
	    (match_operand:SI 1 "gr_register_operand"	   "  0,  0, Rg,Rg")
	    (match_operand:SI 2 "nonmemory_operand"	   "Iu5,Iu5,Iu5,Rg"))
	  (match_operand:SI 3 "nonmemory_operand"	   "Iu8,  i,  0, 0")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = or(#%3,asl(%1,#%2))
   %0 = or(##%3,asl(%1,#%2))
   %0 |= asl(%1,#%2)
   %0 |= asl(%1,%2)"
  [(set_attr "type" "S,ES,S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ormulsi3"
  [(set (match_operand:SI 0 "gr_register_operand"		  "=Rg, Rg")
	(ior:SI
	  (mult:SI
	    (match_operand:SI 1 "gr_register_operand"		  "  0,  0")
	    (match_operand:SI 2 "power_of_two_operand"		  "K1h,K1h"))
	  (match_operand:SI 3 "immediate_operand"		  "Iu8,  i")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = or(#%3,asl(%1,#%J2))
   %0 = or(##%3,asl(%1,#%J2))"
  [(set_attr "type" "S,ES")
   (set_attr "compound" "yes")]
)

(define_insn "ashlsi3_or"
  [(set (match_operand:SI 0 "gr_register_operand"		    "=Rg,Rg")
	(ior:SI (ashift:SI (match_operand:SI 1 "gr_register_operand" "Rg,Rg")
			   (match_operand:SI 2 "nonmemory_operand"  "Iu5,Rg"))
		(match_operand:SI 3 "gr_register_operand"	    "  0, 0")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 |= asl(%1,#%2)
   %0 |= asl(%1,%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashlsi3_xor"
  [(set (match_operand:SI 0 "gr_register_operand"		      "=Rg")
	(xor:SI (ashift:SI (match_operand:SI 1 "gr_register_operand"  " Rg")
			   (match_operand:SI 2 "u5_const_int_operand" "Iu5"))
		(match_operand:SI 3 "gr_register_operand"	      "  0")))]
  ""
  "%0 ^= asl(%1,#%2)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

;; SI asr

(define_insn "ashrsi3_acc"
  [(set (match_operand:SI 0 "gr_register_operand"		   "=Rg,Rg")
	(plus:SI
	  (ashiftrt:SI (match_operand:SI 1 "gr_register_operand"   " Rg,Rg")
		       (match_operand:SI 2 "nonmemory_operand"	   "Iu5,Rg"))
		 (match_operand:SI 3 "gr_register_operand"	   "  0, 0")))]
  ""
  "@
   %0 += asr(%1,#%2)
   %0 += asr(%1,%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashrsi3_nacc"
  [(set (match_operand:SI 0 "gr_register_operand"		  "=Rg,Rg")
	(minus:SI (match_operand:SI 1 "gr_register_operand"	  "  0, 0")
		  (ashiftrt:SI
		    (match_operand:SI 2 "gr_register_operand"	  " Rg,Rg")
		    (match_operand:SI 3 "nonmemory_operand"	  "Iu5,Rg"))))]
  ""
  "@
   %0 -= asr(%2,#%3)
   %0 -= asr(%2,%3)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashrsi3_and"
  [(set (match_operand:SI 0 "gr_register_operand"		   "=Rg,Rg")
	(and:SI (ashiftrt:SI
		  (match_operand:SI 1 "gr_register_operand"	   " Rg,Rg")
		  (match_operand:SI 2 "nonmemory_operand"	   "Iu5,Rg"))
		(match_operand:SI 3 "gr_register_operand"	   "  0, 0")))]
  ""
  "@
   %0 &= asr(%1,#%2)
   %0 &= asr(%1,%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashrsi3_or"
  [(set (match_operand:SI 0 "gr_register_operand"		   "=Rg,Rg")
	(ior:SI (ashiftrt:SI
		  (match_operand:SI 1 "gr_register_operand"	   " Rg,Rg")
		  (match_operand:SI 2 "nonmemory_operand"	   "Iu5,Rg"))
		(match_operand:SI 3 "gr_register_operand"	   "  0, 0")))]
  ""
  "@
   %0 |= asr(%1,#%2)
   %0 |= asr(%1,%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

;; SI lsr

(define_insn "addlshrsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg, Rg, Rg,Rg")
	(plus:SI (lshiftrt:SI
		   (match_operand:SI 1 "gr_register_operand" "0,  0, Rg,Rg")
		   (match_operand:SI 2 "nonmemory_operand" "Iu5,Iu5,Iu5,Rg"))
		 (match_operand:SI 3 "nonmemory_operand"   "Iu8,  i,  0, 0")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = add(#%3,lsr(%1,#%2))
   %0 = add(##%3,lsr(%1,#%2))
   %0 += lsr(%1,#%2)
   %0 += lsr(%1,%2)"
  [(set_attr "type" "S,ES,S,S")
   (set_attr "compound" "yes")]
)

(define_insn "lshrsi3_acc"
  [(set (match_operand:SI 0 "gr_register_operand"		   "=Rg,Rg")
	(plus:SI (lshiftrt:SI
		   (match_operand:SI 1 "gr_register_operand"	   " Rg,Rg")
		   (match_operand:SI 2 "nonmemory_operand"	   "Iu5,Rg"))
		 (match_operand:SI 3 "gr_register_operand"	   "  0, 0")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 += lsr(%1,#%2)
   %0 += lsr(%1,%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "sublshrsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	  "=Rg, Rg, Rg,Rg")
	(minus:SI
	  (match_operand:SI 1 "nonmemory_operand"	  "Iu8,  i,  0, 0")
	  (lshiftrt:SI
	    (match_operand:SI 2 "gr_register_operand"	  "  0,  0, Rg,Rg")
	    (match_operand:SI 3 "nonmemory_operand"	  "Iu5,Iu5,Iu5,Rg"))))]
  "TARGET_V4_FEATURES"
  "@
   %0 = sub(#%1,lsr(%2,#%3))
   %0 = sub(##%1,lsr(%2,#%3))
   %0 -= lsr(%2,#%3)
   %0 -= lsr(%2,%3)"
  [(set_attr "type" "S,ES,S,S")
   (set_attr "compound" "yes")]
)

(define_insn "lshrsi3_nacc"
  [(set (match_operand:SI 0 "gr_register_operand"		  "=Rg,Rg")
	(minus:SI
	  (match_operand:SI 1 "gr_register_operand"	          "  0, 0")
	  (lshiftrt:SI (match_operand:SI 2 "gr_register_operand"  " Rg,Rg")
		       (match_operand:SI 3 "nonmemory_operand"    "Iu5,Rg"))))]
  "!TARGET_V4_FEATURES"
  "@
   %0 -= lsr(%2,#%3)
   %0 -= lsr(%2,%3)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "andlshrsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg, Rg, Rg,Rg")
	(and:SI (lshiftrt:SI
		  (match_operand:SI 1 "gr_register_operand"  "0,  0, Rg,Rg")
		  (match_operand:SI 2 "nonmemory_operand"  "Iu5,Iu5,Iu5,Rg"))
		(match_operand:SI 3 "nonmemory_operand"	   "Iu8,  i,  0, 0")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = and(#%3,lsr(%1,#%2))
   %0 = and(##%3,lsr(%1,#%2))
   %0 &= lsr(%1,#%2)
   %0 &= lsr(%1,%2)"
  [(set_attr "type" "S,ES,S,S")
   (set_attr "compound" "yes")]
)

(define_insn "lshrsi3_and"
  [(set (match_operand:SI 0 "gr_register_operand"		   "=Rg,Rg")
	(and:SI (lshiftrt:SI
		  (match_operand:SI 1 "gr_register_operand"	   " Rg,Rg")
		  (match_operand:SI 2 "nonmemory_operand"	   "Iu5,Rg"))
		(match_operand:SI 3 "gr_register_operand"	   "  0, 0")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 &= lsr(%1,#%2)
   %0 &= lsr(%1,%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "orlshrsi3"
  [(set (match_operand:SI 0 "gr_register_operand"	   "=Rg, Rg, Rg,Rg")
	(ior:SI (lshiftrt:SI
		  (match_operand:SI 1 "gr_register_operand"  "0,  0, Rg,Rg")
		  (match_operand:SI 2 "nonmemory_operand"  "Iu5,Iu5,Iu5,Rg"))
		(match_operand:SI 3 "nonmemory_operand"	   "Iu8,  i,  0, 0")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = or(#%3,lsr(%1,#%2))
   %0 = or(##%3,lsr(%1,#%2))
   %0 |= lsr(%1,#%2)
   %0 |= lsr(%1,%2)"
  [(set_attr "type" "S,ES,S,S")
   (set_attr "compound" "yes")]
)

(define_insn "lshrsi3_or"
  [(set (match_operand:SI 0 "gr_register_operand"		   "=Rg,Rg")
	(ior:SI (lshiftrt:SI
		  (match_operand:SI 1 "gr_register_operand"	   " Rg,Rg")
		  (match_operand:SI 2 "nonmemory_operand"	   "Iu5,Rg"))
		(match_operand:SI 3 "gr_register_operand"	   "  0, 0")))]
  "!TARGET_V4_FEATURES"
  "@
   %0 |= lsr(%1,#%2)
   %0 |= lsr(%1,%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "lshrsi3_xor"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	(xor:SI (lshiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			     (match_operand:SI 2 "u5_const_int_operand" "Iu5"))
		(match_operand:SI 3 "gr_register_operand" "0")))]
  ""
  "%0 ^= lsr(%1,#%2)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

;; DI asl

(define_insn "ashldi3_acc"
  [(set (match_operand:DI 0 "gr_register_operand"		  "=Rg, Rg")
	(plus:DI (ashift:DI
		   (match_operand:DI 1 "gr_register_operand"	  " Rg, Rg")
		   (match_operand:SI 2 "nonmemory_operand"	  " Rg,Iu6"))
		 (match_operand:DI 3 "gr_register_operand"	  "  0,  0")))]
  ""
  "@
   %P0 += asl(%P1,%2)
   %P0 += asl(%P1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashldi3_nacc"
  [(set (match_operand:DI 0 "gr_register_operand"		 "=Rg, Rg")
	(minus:DI (match_operand:DI 1 "gr_register_operand"	 "  0,  0")
		  (ashift:DI
		    (match_operand:DI 2 "gr_register_operand"    " Rg, Rg")
		    (match_operand:SI 3 "nonmemory_operand"      " Rg,Iu6"))))]
  ""
  "@
   %P0 -= asl(%P2,%3)
   %P0 -= asl(%P2,#%3)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashldi3_and"
  [(set (match_operand:DI 0 "gr_register_operand"		  "=Rg, Rg")
	(and:DI (ashift:DI
		  (match_operand:DI 1 "gr_register_operand"	  " Rg, Rg")
		  (match_operand:SI 2 "nonmemory_operand"	  " Rg,Iu6"))
		(match_operand:DI 3 "gr_register_operand"	  "  0,  0")))]
  ""
  "@
   %P0 &= asl(%P1,%2)
   %P0 &= asl(%P1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashldi3_or"
  [(set (match_operand:DI 0 "gr_register_operand"		  "=Rg, Rg")
	(ior:DI (ashift:DI
		  (match_operand:DI 1 "gr_register_operand"	  " Rg, Rg")
		  (match_operand:SI 2 "nonmemory_operand"	  " Rg,Iu6"))
		(match_operand:DI 3 "gr_register_operand"	  "  0,  0")))]
  ""
  "@
   %P0 |= asl(%P1,%2)
   %P0 |= asl(%P1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashldi3_xor"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(xor:DI (ashift:DI (match_operand:DI 1 "gr_register_operand" "Rg")
			   (match_operand:SI 2 "u6_const_int_operand" "Iu6"))
		(match_operand:DI 3 "gr_register_operand" "0")))]
  ""
  "%P0 ^= asl(%P1,#%2)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

;; DI asr

(define_insn "ashrdi3_acc"
  [(set (match_operand:DI 0 "gr_register_operand"		  "=Rg, Rg")
	(plus:DI (ashiftrt:DI
		   (match_operand:DI 1 "gr_register_operand"	  " Rg, Rg")
		   (match_operand:SI 2 "nonmemory_operand"	  " Rg,Iu6"))
		 (match_operand:DI 3 "gr_register_operand"	  "  0,  0")))]
  ""
  "@
   %P0 += asr(%P1,%2)
   %P0 += asr(%P1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashrdi3_nacc"
  [(set (match_operand:DI 0 "gr_register_operand"		 "=Rg, Rg")
	(minus:DI (match_operand:DI 1 "gr_register_operand"	 "  0,  0")
		  (ashiftrt:DI
		    (match_operand:DI 2 "gr_register_operand"	 " Rg, Rg")
		    (match_operand:SI 3 "nonmemory_operand"	 " Rg,Iu6"))))]
  ""
  "@
   %P0 -= asr(%P2,%3)
   %P0 -= asr(%P2,#%3)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashrdi3_and"
  [(set (match_operand:DI 0 "gr_register_operand"		  "=Rg, Rg")
	(and:DI (ashiftrt:DI
		  (match_operand:DI 1 "gr_register_operand"	  " Rg, Rg")
		  (match_operand:SI 2 "nonmemory_operand"	  " Rg,Iu6"))
		(match_operand:DI 3 "gr_register_operand"	  "  0,  0")))]
  ""
  "@
   %P0 &= asr(%P1,%2)
   %P0 &= asr(%P1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "ashrdi3_or"
  [(set (match_operand:DI 0 "gr_register_operand"		  "=Rg, Rg")
	(ior:DI (ashiftrt:DI
		  (match_operand:DI 1 "gr_register_operand"	  " Rg, Rg")
		  (match_operand:SI 2 "nonmemory_operand"	  " Rg,Iu6"))
		(match_operand:DI 3 "gr_register_operand"	  "  0,  0")))]
  ""
  "@
   %P0 |= asr(%P1,%2)
   %P0 |= asr(%P1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

;; DI lsr

(define_insn "lshrdi3_acc"
  [(set (match_operand:DI 0 "gr_register_operand"		  "=Rg, Rg")
	(plus:DI (lshiftrt:DI
		   (match_operand:DI 1 "gr_register_operand"	  " Rg, Rg")
		   (match_operand:SI 2 "nonmemory_operand"	  " Rg,Iu6"))
		 (match_operand:DI 3 "gr_register_operand"	  "  0,  0")))]
  ""
  "@
   %P0 += lsr(%P1,%2)
   %P0 += lsr(%P1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "lshrdi3_nacc"
  [(set (match_operand:DI 0 "gr_register_operand"		 "=Rg, Rg")
	(minus:DI (match_operand:DI 1 "gr_register_operand"	 "  0,  0")
		  (lshiftrt:DI
		    (match_operand:DI 2 "gr_register_operand"	 " Rg, Rg")
		    (match_operand:SI 3 "nonmemory_operand"	 " Rg,Iu6"))))]
  ""
  "@
   %P0 -= lsr(%P2,%3)
   %P0 -= lsr(%P2,#%3)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "lshrdi3_and"
  [(set (match_operand:DI 0 "gr_register_operand"		 "=Rg, Rg")
	(and:DI (lshiftrt:DI
		  (match_operand:DI 1 "gr_register_operand"	 " Rg, Rg")
		  (match_operand:SI 2 "nonmemory_operand"	 " Rg,Iu6"))
		(match_operand:DI 3 "gr_register_operand"	 "  0,  0")))]
  ""
  "@
   %P0 &= lsr(%P1,%2)
   %P0 &= lsr(%P1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "lshrdi3_or"
  [(set (match_operand:DI 0 "gr_register_operand"		  "=Rg, Rg")
	(ior:DI (lshiftrt:DI
		  (match_operand:DI 1 "gr_register_operand"	  " Rg, Rg")
		  (match_operand:SI 2 "nonmemory_operand"	  " Rg,Iu6"))
		(match_operand:DI 3 "gr_register_operand"	  "  0,  0")))]
  ""
  "@
   %P0 |= lsr(%P1,%2)
   %P0 |= lsr(%P1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "lshrdi3_xor"
  [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	(xor:DI (lshiftrt:DI (match_operand:DI 1 "gr_register_operand" "Rg")
			     (match_operand:SI 2 "u6_const_int_operand" "Iu6"))
		(match_operand:DI 3 "gr_register_operand" "0")))]
  ""
  "%P0 ^= lsr(%P1,#%2)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)


;;----------------;;
;; bit operations ;;
;;----------------;;

(define_insn "setbitsi"
  [(set (match_operand:SI 0 "gr_register_operand"		   "=Rg,Rg")
	(ior:SI (ashift:SI (const_int 1)
			   (match_operand:SI 1 "nonmemory_operand" "Iu5,Rg"))
		(match_operand:SI 2 "gr_register_operand"	   " Rg,Rg")))]
  ""
  "@
   %0 = setbit(%2,#%1)
   %0 = setbit(%2,%1)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "clrbitsi"
  [(set (match_operand:SI 0 "gr_register_operand"		   "=Rg,Rg")
	(and:SI
	  (not:SI
	    (ashift:SI (const_int 1)
		       (match_operand:SI 1 "nonmemory_operand"	   "Iu5,Rg")))
		(match_operand:SI 2 "gr_register_operand"	   " Rg,Rg")))]
  ""
  "@
   %0 = clrbit(%2,#%1)
   %0 = clrbit(%2,%1)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "togglebitsi"
  [(set (match_operand:SI 0 "gr_register_operand"		   "=Rg,Rg")
	(xor:SI (ashift:SI (const_int 1)
			   (match_operand:SI 1 "nonmemory_operand" "Iu5,Rg"))
		(match_operand:SI 2 "gr_register_operand"	   " Rg,Rg")))]
  ""
  "@
   %0 = togglebit(%2,#%1)
   %0 = togglebit(%2,%1)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "tstbitsi"
  [(set (match_operand:BI 0 "pr_register_operand"	   "=Rp, Rp")
	(ne:BI (zero_extract:SI
		 (match_operand:SI 1 "gr_register_operand" " Rg, Rg")
		 (const_int 1)
		 (match_operand:SI 2 "nonmemory_operand"   " Rg,Iu5"))
	    (const_int 0)))]
  ""
  "@
   %0 = tstbit(%1,%2)
   %0 = tstbit(%1,#%2)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "not_tstbitsi_v4"
  [(set (match_operand:BI 0 "pr_register_operand"	   "=Rp, Rp")
	(eq:BI (zero_extract:SI
		 (match_operand:SI 1 "gr_register_operand" " Rg, Rg")
		 (const_int 1)
		 (match_operand:SI 2 "nonmemory_operand"   " Rg,Iu5"))
	       (const_int 0)))]
  "TARGET_V4_FEATURES"
  "@
   %0 = !tstbit(%1,%2)
   %0 = !tstbit(%1,#%2)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn_and_split "not_tstbitsi"
  [(set (match_operand:BI 0 "pr_register_operand"	   "=Rp, Rp")
	(eq:BI (zero_extract:SI
		 (match_operand:SI 1 "gr_register_operand" " Rg, Rg")
		 (const_int 1)
		 (match_operand:SI 2 "nonmemory_operand"   " Rg,Iu5"))
	       (const_int 0)))]
  "!TARGET_V4_FEATURES"
  "#"
  "!TARGET_V4_FEATURES"
  [(set (match_dup 3)
	(ne:BI (zero_extract:SI (match_dup 1) (const_int 1) (match_dup 2))
	       (const_int 0)))
   (set (match_dup 0) (not:BI (match_dup 3)))]
  {
    if (reload_completed)
      operands[3] = operands[0];
    else
      operands[3] = gen_reg_rtx (BImode);
  }
  [(set_attr "type" "multiple")]
)

(define_insn "bitsclrsi"
  [(set (match_operand:BI 0 "pr_register_operand"		 "=Rp, Rp")
	(eq:BI (and:SI (match_operand:SI 1 "gr_register_operand" " Rg, Rg")
		       (match_operand:SI 2 "gr_or_u6_operand"    " Rg,Iu6"))
	       (const_int 0)))]
  ""
  "@
   %0 = bitsclr(%1,%2)
   %0 = bitsclr(%1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "bitsclrsi_2"
  [(set (match_operand:BI 0 "pr_register_operand"		   "=Rp, Rp")
	(eq:BI (and:SI
		 (not:SI (match_operand:SI 1 "gr_register_operand" " Rg, Rg"))
			 (match_operand:SI 2 "gr_or_u6_operand"	   " Rg,Iu6"))
	       (match_dup 2)))]
  ""
  "@
   %0 = bitsclr(%1,%2)
   %0 = bitsclr(%1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "not_bitsclrsi_v4"
  [(set (match_operand:BI 0 "pr_register_operand"	         "=Rp, Rp")
	(ne:BI (and:SI (match_operand:SI 1 "gr_register_operand" " Rg, Rg")
		       (match_operand:SI 2 "gr_or_u6_operand"    " Rg,Iu6"))
	       (const_int 0)))]
  "TARGET_V4_FEATURES"
  "@
   %0 = !bitsclr(%1,%2)
   %0 = !bitsclr(%1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn "not_bitsclrsi_2_v4"
  [(set (match_operand:BI 0 "pr_register_operand"		   "=Rp, Rp")
	(ne:BI (and:SI
		 (not:SI (match_operand:SI 1 "gr_register_operand" " Rg, Rg"))
			 (match_operand:SI 2 "gr_or_u6_operand"	   " Rg,Iu6"))
	       (match_dup 2)))]
  "TARGET_V4_FEATURES"
  "@
   %0 = !bitsclr(%1,%2)
   %0 = !bitsclr(%1,#%2)"
  [(set_attr "type" "S,S")
   (set_attr "compound" "yes")]
)

(define_insn_and_split "not_bitsclrsi"
  [(set (match_operand:BI 0 "pr_register_operand"	         "=Rp, Rp")
	(ne:BI (and:SI (match_operand:SI 1 "gr_register_operand" " Rg, Rg")
		       (match_operand:SI 2 "gr_or_u6_operand"    " Rg,Iu6"))
	       (const_int 0)))]
  "!TARGET_V4_FEATURES"
  "#"
  "!TARGET_V4_FEATURES"
  [(set (match_dup 3) (eq:BI (and:SI (match_dup 1) (match_dup 2))
			     (const_int 0)))
   (set (match_dup 0) (not:BI (match_dup 3)))]
{
  if (reload_completed)
    operands[3] = operands[0];
  else
    operands[3] = gen_reg_rtx (BImode);
}
  [(set_attr "type" "multiple")]
)

(define_insn_and_split "not_bitsclrsi_2"
  [(set (match_operand:BI 0 "pr_register_operand"		   "=Rp, Rp")
	(ne:BI (and:SI
		 (not:SI (match_operand:SI 1 "gr_register_operand" " Rg, Rg"))
		 (match_operand:SI 2 "gr_or_u6_operand"		   " Rg,Iu6"))
	       (match_dup 2)))]
  "!TARGET_V4_FEATURES"
  "#"
  "!TARGET_V4_FEATURES"
  [(set (match_dup 4) (eq:BI (and:SI (not:SI (match_dup 1)) (match_dup 2))
			     (match_dup 3)))
   (set (match_dup 0) (not:BI (match_dup 4)))]
  {
    if (reload_completed)
      operands[4] = operands[0];
    else
      operands[4] = gen_reg_rtx (BImode);
  }
  [(set_attr "type" "multiple")]
)

(define_insn "bitssetsi"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(eq:BI (and:SI (match_operand:SI 1 "gr_register_operand" "Rg")
		       (match_operand:SI 2 "gr_register_operand" "Rg"))
	       (match_dup 2)))]
  ""
  "%0 = bitsset(%1,%2)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "not_bitssetsi_v4"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(ne:BI (and:SI (match_operand:SI 1 "gr_register_operand" "Rg")
		       (match_operand:SI 2 "gr_register_operand" "Rg"))
	       (match_dup 2)))]
  "TARGET_V4_FEATURES"
  "%0 = !bitsset(%1,%2)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn_and_split "not_bitssetsi"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(ne:BI (and:SI (match_operand:SI 1 "gr_register_operand" "Rg")
		       (match_operand:SI 2 "gr_register_operand" "Rg"))
	       (match_dup 2)))]
  "!TARGET_V4_FEATURES"
  "#"
  "!TARGET_V4_FEATURES"
  [(set (match_dup 3) (eq:BI (and:SI (match_dup 1) (match_dup 2))
			     (match_dup 2)))
   (set (match_dup 0) (not:BI (match_dup 3)))]
  {
    if (reload_completed)
      operands[3] = operands[0];
    else
      operands[3] = gen_reg_rtx (BImode);
  }
  [(set_attr "type" "multiple")]
)


;;---------;;
;; compare ;;
;;---------;;

(define_insn "r_cmpsi_eq"
  [(set (match_operand:SI 0 "gr_register_operand"        "=Rg,Rg,Rg")
	(eq:SI (match_operand:SI 1 "gr_register_operand" " Rg,Rg,Rg")
	       (match_operand:SI 2 "nonmemory_operand"   "Is8, i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = cmp.eq(%1,#%2)
   %0 = cmp.eq(%1,##%2)
   %0 = cmp.eq(%1,%2)"
  [(set_attr "type" "A,EA,A")
   (set_attr "compound" "yes")]
)

(define_insn "r_cmpsi_ne"
  [(set (match_operand:SI 0 "gr_register_operand"        "=Rg,Rg,Rg")
	(ne:SI (match_operand:SI 1 "gr_register_operand" " Rg,Rg,Rg")
	       (match_operand:SI 2 "nonmemory_operand"   "Is8, i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = !cmp.eq(%1,#%2)
   %0 = !cmp.eq(%1,##%2)
   %0 = !cmp.eq(%1,%2)"
  [(set_attr "type" "A,EA,A")
   (set_attr "compound" "yes")]
)

(define_insn "cmpqi_eq"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp,Rp")
	(eq:BI (match_operand:QI 1 "gr_register_operand" " Rg,Rg")
	       (match_operand:QI 2 "nonmemory_operand"   "Iu8,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = cmpb.eq(%1,#%2)
   %0 = cmpb.eq(%1,%2)"
  [(set_attr "type" "X,X")]
)

(define_insn "cmpqi_gt"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp,Rp")
	(gt:BI (match_operand:QI 1 "gr_register_operand" " Rg,Rg")
	       (match_operand:QI 2 "nonmemory_operand"   "  i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = cmpb.gt(%1,#%2)
   %0 = cmpb.gt(%1,%2)"
  [(set_attr "type" "X,X")]
)

(define_insn "cmpqi_ge"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(ge:BI (match_operand:QI 1 "gr_register_operand" "Rg")
	       (match_operand:QI 2 "immediate_operand" "i")))]
  "TARGET_V4_FEATURES"
  {
    gcc_assert (GET_CODE (operands[2]) == CONST_INT
		&& INTVAL (operands[2]) > -512);
    operands[2] = plus_constant (operands[2], -1);
    return "%0 = cmpb.gt(%1,#%2)";
  }
  [(set_attr "type" "X")]
)

(define_insn "cmpqi_gtu"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp,Rp,Rp")
	(gtu:BI (match_operand:QI 1 "gr_register_operand" " Rg,Rg,Rg")
		(match_operand:QI 2 "nonmemory_operand"   "Iu7, i,Rg")))]
  "TARGET_V4_FEATURES"
  {
    unsigned int low;

    switch (which_alternative)
      {
      case 0:
	return "%0 = cmpb.gtu(%1,#%2)";
      case 1:
	gcc_assert (const_int_operand (operands[2], QImode));
	low = INTVAL (operands[2]);
	operands[2] = gen_int_mode (low & 0x000000FFUL, SImode);
	return "%0 = cmpb.gtu(%1,##%2)";
      case 2:
	return "%0 = cmpb.gtu(%1,%2)";
      default:
	gcc_unreachable ();
      }
  }
  [(set_attr "type" "X,EX,X")]
)

(define_insn "cmpqi_geu"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp,Rp")
	(geu:BI (match_operand:QI 1 "gr_register_operand" " Rg,Rg")
		(match_operand:QI 2 "immediate_operand"   "Ku7, i")))]
  "TARGET_V4_FEATURES"
  {
    operands[2] = plus_constant (operands[2], -1);
    if (which_alternative == 0)
      return "%0 = cmpb.gtu(%1,#%2)";
    else
      return "%0 = cmpb.gtu(%1,##%2)";
  }
  [(set_attr "type" "X,EX")]
)

(define_insn "cmphi_eq"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp,Rp,Rp")
	(eq:BI (match_operand:HI 1 "gr_register_operand" " Rg,Rg,Rg")
	       (match_operand:HI 2 "nonmemory_operand"   "Is8, i,Rg")))]
  "TARGET_V4_FEATURES"
  {
    int low;
    switch (which_alternative)
      {
      case 0:
	return "%0 = cmph.eq(%1,#%2)";
      case 1:
	gcc_assert (const_int_operand (operands[2], HImode));
	low = INTVAL (operands[2]);
	operands[2] = gen_int_mode (low, SImode);
	return "%0 = cmph.eq(%1,##%2)";
      case 2:
	return "%0 = cmph.eq(%1,%2)";
      default:
	gcc_unreachable ();
      }
  }
  [(set_attr "type" "X,EX,X")]
)

(define_insn "cmphi_gt"
  [(set (match_operand:BI 0 "pr_register_operand"        "=Rp,Rp,Rp")
	(gt:BI (match_operand:HI 1 "gr_register_operand" " Rg,Rg,Rg")
	       (match_operand:HI 2 "nonmemory_operand"   "Is8, i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   %0 = cmph.gt(%1,#%2)
   %0 = cmph.gt(%1,##%2)
   %0 = cmph.gt(%1,%2)"
  [(set_attr "type" "X,EX,X")]
)

(define_insn "cmphi_ge"
  [(set (match_operand:BI 0 "pr_register_operand"	 "=Rp,Rp")
	(ge:BI (match_operand:HI 1 "gr_register_operand" " Rg,Rg")
	       (match_operand:HI 2 "immediate_operand"   "K8p, i")))]
  "TARGET_V4_FEATURES"
  {
    operands[2] = plus_constant (operands[2], -1);
    if (which_alternative == 0)
      return "%0 = cmph.gt(%1,#%2)";
    else
      return "%0 = cmph.gt(%1,##%2)";
  }
  [(set_attr "type" "X,EX")]
)

(define_insn "cmphi_gtu"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp,Rp,Rp")
	(gtu:BI (match_operand:HI 1 "gr_register_operand" " Rg,Rg,Rg")
		(match_operand:HI 2 "nonmemory_operand"   "Iu7, i,Rg")))]
  "TARGET_V4_FEATURES"
  {
    unsigned int low;
    switch (which_alternative)
      {
      case 0:
	return "%0 = cmph.gtu(%1,#%2)";
      case 1:
	gcc_assert (const_int_operand (operands[2], HImode));
	low = INTVAL (operands[2]);
	operands[2] = gen_int_mode (low & 0x0000FFFFUL, SImode);
	return "%0 = cmph.gtu(%1,##%2)";
      case 2:
	return "%0 = cmph.gtu(%1,%2)";
      default:
	gcc_unreachable ();
      }
  }
  [(set_attr "type" "X,EX,X")]
)

(define_insn "cmphi_geu"
  [(set (match_operand:BI 0 "pr_register_operand"	  "=Rp,Rp")
	(geu:BI (match_operand:HI 1 "gr_register_operand" " Rg,Rg")
		(match_operand:HI 2 "immediate_operand"   "K8p, i")))]
  "TARGET_V4_FEATURES"
  {
    operands[2] = plus_constant (operands[2], -1);
    if (which_alternative == 0)
      return "%0 = cmph.gtu(%1,#%2)";
    else
      return "%0 = cmph.gtu(%1,##%2)";
  }
  [(set_attr "type" "X,EX")]
)

;; If we have explicit sign- or zero-extensions preceding a (SImode) cmp.<cond>
;; instruction, it's probably better to use a sub-word comparison instead.

;; The use of (ashift:SI (operand:SI) (const_int 16)) here serves two purposes:
;; it works properly for both sign-extending and zero-extending comparison
;; insns, and (more importantly) it is a form that is recognized by combine.

(define_insn_and_split "*cmphi_helper"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(match_operator:BI 3 "subword_reg_compare_operator"
	  [(ashift:SI (match_operand:SI 1 "gr_register_operand" "Rg")
		      (const_int 16))
	   (ashift:SI (match_operand:SI 2 "gr_register_operand" "Rg")
		      (const_int 16))]))]
  "TARGET_V4_FEATURES"
  "#"
  ""
  [(const_int 0)]
  {
    hexagon_split_subword_compare (HImode, operands, operands[3]);
    DONE;
  }
  [(set_attr "type" "X")]
)

;; Similar comments apply for this pattern.

(define_insn_and_split "*cmpqi_helper"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(match_operator:BI 3 "subword_reg_compare_operator"
	  [(ashift:SI (match_operand:SI 1 "gr_register_operand" "Rg")
		      (const_int 24))
	   (ashift:SI (match_operand:SI 2 "gr_register_operand" "Rg")
		      (const_int 24))]))]
  "TARGET_V4_FEATURES"
  "#"
  ""
  [(const_int 0)]
  {
    hexagon_split_subword_compare (QImode, operands, operands[3]);
    DONE;
  }
  [(set_attr "type" "X")]
)

;;-----------------;;
;; predicate logic ;;
;;-----------------;;

(define_insn "andnotbi3"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(and:BI (not:BI (match_operand:BI 1 "pr_register_operand" "Rp"))
		(match_operand:BI 2 "pr_register_operand" "Rp")))]
  ""
  "%0 = and(%2,!%1)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)

(define_insn "ornotbi3"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(ior:BI (not:BI (match_operand:BI 1 "pr_register_operand" "Rp"))
		(match_operand:BI 2 "pr_register_operand" "Rp")))]
  ""
  "%0 = or(%2,!%1)"
  [(set_attr "type" "S")
   (set_attr "compound" "yes")]
)


;;------;;
;; move ;;
;;------;;

(define_insn "storehhi"
  [(set (match_operand:HI 0 "memory_operand"		    "=Anx, m")
	(subreg:HI (lshiftrt:SI
		     (match_operand:SI 1 "register_operand" "  Rg,Rg")
		     (const_int 16)) 0))]
  ""
  "@
   memh(%0) = %1.h
   memh(%E0) = %1.h"
  [(set_attr "type" "Store,EStore")]
)

;; FIXME: All the following patterns contain redundant parallels.
;; There's also no need for the rtx_equal_p checks.

(define_insn "absloadsetbi"
  [(parallel [(set (match_operand:BI 0 "gr_register_operand" "=Rg")
		   (mem:BI (match_operand:SI 1 "absolute_address_operand" "Q")))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memb(%2=##%1)"
  [(set_attr "type" "ELoad")]
)

(define_insn "absloadsetbi_new_mem"
  [(parallel
     [(set (match_operand:BI 0 "gr_register_operand" "=Rg")
	   (unspec:BI [(mem:BI
			 (match_operand:SI 1 "absolute_address_operand" "Q"))]
		      UNSPEC_NEW_VALUE))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V5_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memb(%2=##%1).new"
  [(set_attr "type" "ENewLoad")]
)

(define_insn "absloadsxtsetbi"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (sign_extend:SI
	     (mem:BI (match_operand:SI 1 "absolute_address_operand" "Q"))))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memb(%2=##%1)"
  [(set_attr "type" "ELoad")]
)

(define_insn "absloadsxtsetbi_new_mem"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (sign_extend:SI
	     (unspec:BI [(mem:BI
			   (match_operand:SI 1 "absolute_address_operand" "Q"))]
			UNSPEC_NEW_VALUE)))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V5_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memb(%2=##%1).new"
  [(set_attr "type" "ENewLoad")]
)

(define_insn "absloadzxtsetbi"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (zero_extend:SI
	     (mem:BI (match_operand:SI 1 "absolute_address_operand" "Q"))))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memub(%2=##%1)"
  [(set_attr "type" "ELoad")]
)

(define_insn "absloadzxtsetbi_new_mem"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (zero_extend:SI
	     (unspec:BI [(mem:BI
			   (match_operand:SI 1 "absolute_address_operand" "Q"))]
			UNSPEC_NEW_VALUE)))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V5_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memub(%2=##%1).new"
  [(set_attr "type" "ENewLoad")]
)

(define_insn "absloadsetqi"
  [(parallel
     [(set (match_operand:QI 0 "gr_register_operand" "=Rg")
	   (mem:QI (match_operand:SI 1 "absolute_address_operand" "Q")))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memb(%2=##%1)"
  [(set_attr "type" "ELoad")]
)

(define_insn "absloadsetqi_new_mem"
  [(parallel
     [(set (match_operand:QI 0 "gr_register_operand" "=Rg")
	   (unspec:QI [(mem:QI
			 (match_operand:SI 1 "absolute_address_operand" "Q"))]
		      UNSPEC_NEW_VALUE))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V5_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memb(%2=##%1).new"
  [(set_attr "type" "ENewLoad")]
)

(define_insn "absloadsxtsetqi"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (sign_extend:SI
	     (mem:QI (match_operand:SI 1 "absolute_address_operand" "Q"))))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memb(%2=##%1)"
  [(set_attr "type" "ELoad")]
)

(define_insn "absloadsxtsetqi_new_mem"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (sign_extend:SI
	     (unspec:QI [(mem:QI
			   (match_operand:SI 1 "absolute_address_operand" "Q"))]
			UNSPEC_NEW_VALUE)))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V5_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memb(%2=##%1).new"
  [(set_attr "type" "ENewLoad")]
)

(define_insn "absloadzxtsetqi"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (zero_extend:SI
	     (mem:QI (match_operand:SI 1 "absolute_address_operand" "Q"))))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memub(%2=##%1)"
  [(set_attr "type" "ELoad")]
)

(define_insn "absloadzxtsetqi_new_mem"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (zero_extend:SI
	     (unspec:QI [(mem:QI
			   (match_operand:SI 1 "absolute_address_operand" "Q"))]
			UNSPEC_NEW_VALUE)))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V5_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memub(%2=##%1).new"
  [(set_attr "type" "ENewLoad")]
)

(define_insn "absloadsethi"
  [(parallel [(set (match_operand:HI 0 "gr_register_operand" "=Rg")
		   (mem:HI (match_operand:SI 1 "absolute_address_operand" "Q")))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memh(%2=##%1)"
  [(set_attr "type" "ELoad")]
)

(define_insn "absloadsethi_new_mem"
  [(parallel
     [(set (match_operand:HI 0 "gr_register_operand" "=Rg")
	   (unspec:HI [(mem:HI
			 (match_operand:SI 1 "absolute_address_operand" "Q"))]
		      UNSPEC_NEW_VALUE))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V5_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memh(%2=##%1).new"
  [(set_attr "type" "ENewLoad")]
)

(define_insn "absloadsxtsethi"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (sign_extend:SI
	     (mem:HI (match_operand:SI 1 "absolute_address_operand" "Q"))))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memh(%2=##%1)"
  [(set_attr "type" "ELoad")]
)

(define_insn "absloadsxtsethi_new_mem"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (sign_extend:SI
	     (unspec:HI [(mem:HI
			   (match_operand:SI 1 "absolute_address_operand" "Q"))]
			UNSPEC_NEW_VALUE)))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V5_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memh(%2=##%1).new"
  [(set_attr "type" "ENewLoad")]
)

(define_insn "absloadzxtsethi"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (zero_extend:SI
	     (mem:HI (match_operand:SI 1 "absolute_address_operand" "Q"))))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memuh(%2=##%1)"
  [(set_attr "type" "ELoad")]
)

(define_insn "absloadzxtsethi_new_mem"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (zero_extend:SI
	     (unspec:HI [(mem:HI
			   (match_operand:SI 1 "absolute_address_operand" "Q"))]
			UNSPEC_NEW_VALUE)))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V5_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memuh(%2=##%1).new"
  [(set_attr "type" "ENewLoad")]
)

(define_insn "absloadsetsi"
  [(parallel [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
		   (mem:SI (match_operand:SI 1 "absolute_address_operand" "Q")))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memw(%2=##%1)"
  [(set_attr "type" "ELoad")]
)

(define_insn "absloadsetsi_new_mem"
  [(parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (unspec:SI [(mem:SI
			 (match_operand:SI 1 "absolute_address_operand" "Q"))]
		      UNSPEC_NEW_VALUE))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V5_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memw(%2=##%1).new"
  [(set_attr "type" "ENewLoad")]
)

(define_insn "absloadsetdi"
  [(parallel [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
		   (mem:DI (match_operand:SI 1 "absolute_address_operand" "Q")))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memd(%2=##%1)"
  [(set_attr "type" "ELoad")]
)

(define_insn "absloadsetdi_new_mem"
  [(parallel
     [(set (match_operand:DI 0 "gr_register_operand" "=Rg")
	   (unspec:DI [(mem:DI
			 (match_operand:SI 1 "absolute_address_operand" "Q"))]
		      UNSPEC_NEW_VALUE))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "1"))])]
  "TARGET_V5_FEATURES
   && rtx_equal_p (operands[1], operands[3])"
  "%0 = memd(%2=##%1).new"
  [(set_attr "type" "ENewLoad")]
)

(define_insn "absstoresetbi"
  [(parallel [(set (mem:BI (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (match_operand:BI 1 "gr_register_operand" "Rg"))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memb(%2=##%0) = %1"
  [(set_attr "type" "EStore")]
)

(define_insn "absstoresetbi_new_value"
  [(parallel [(set (mem:BI (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (unspec:BI [(match_operand:BI 1 "gr_register_operand" "Rg")]
			      UNSPEC_NEW_VALUE))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memb(%2=##%0) = %1.new"
  [(set_attr "type" "ENewValue")]
)

(define_insn "absstoresetqi"
  [(parallel [(set (mem:QI (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (match_operand:QI 1 "gr_register_operand" "Rg"))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memb(%2=##%0) = %1"
  [(set_attr "type" "EStore")]
)

(define_insn "absstoresetqi_new_value"
  [(parallel [(set (mem:QI (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (unspec:QI [(match_operand:QI 1 "gr_register_operand" "Rg")]
			      UNSPEC_NEW_VALUE))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memb(%2=##%0) = %1.new"
  [(set_attr "type" "ENewValue")]
)

(define_insn "absstoresethi"
  [(parallel [(set (mem:HI (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (match_operand:HI 1 "gr_register_operand" "Rg"))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memh(%2=##%0) = %1"
  [(set_attr "type" "EStore")]
)

(define_insn "absstoresethi_new_value"
  [(parallel [(set (mem:HI (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (unspec:HI [(match_operand:HI 1 "gr_register_operand" "Rg")]
			      UNSPEC_NEW_VALUE))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memh(%2=##%0) = %1.new"
  [(set_attr "type" "ENewValue")]
)

(define_insn "absstorehsethi"
  [(parallel
     [(set (mem:HI (match_operand:SI 0 "absolute_address_operand" "Q"))
	   (subreg:HI
	     (lshiftrt:SI (match_operand:SI 1 "gr_register_operand" "Rg")
			  (const_int 16)) 0))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memh(%2=##%0) = %1.h"
  [(set_attr "type" "EStore")]
)

(define_insn "absstoresetsi"
  [(parallel [(set (mem:SI (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (match_operand:SI 1 "gr_register_operand" "Rg"))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memw(%2=##%0) = %1"
  [(set_attr "type" "EStore")]
)

(define_insn "absstoresetsi_new_value"
  [(parallel [(set (mem:SI (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (unspec:SI [(match_operand:SI 1 "gr_register_operand" "Rg")]
			      UNSPEC_NEW_VALUE))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memw(%2=##%0) = %1.new"
  [(set_attr "type" "ENewValue")]
)

(define_insn "absstoresetdi"
  [(parallel [(set (mem:DI (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (match_operand:DI 1 "gr_register_operand" "Rg"))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memd(%2=##%0) = %P1"
  [(set_attr "type" "EStore")]
)

(define_insn "absstoresetsf"
  [(parallel [(set (mem:SF (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (match_operand:SF 1 "gr_register_operand" "Rg"))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memw(%2=##%0) = %1"
  [(set_attr "type" "EStore")]
)

(define_insn "absstoresetsf_new_value"
  [(parallel [(set (mem:SF (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (unspec:SF [(match_operand:SF 1 "gr_register_operand" "Rg")]
			      UNSPEC_NEW_VALUE))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memw(%2=##%0) = %1.new"
  [(set_attr "type" "ENewValue")]
)

(define_insn "absstoresetdf"
  [(parallel [(set (mem:DF (match_operand:SI 0 "absolute_address_operand" "Q"))
		   (match_operand:DF 1 "gr_register_operand" "Rg"))
	      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
		   (match_operand:SI 3 "absolute_address_operand" "0"))])]
  "TARGET_V4_FEATURES
   && rtx_equal_p (operands[0], operands[3])"
  "memd(%2=##%0) = %P1"
  [(set_attr "type" "EStore")]
)


;;-------------------------------------------;;
;; Patterns Emitted by Machine Specific Code ;;
;;-------------------------------------------;;

(define_insn "return_jump"
  [(return)]
  ""
  "jumpr r31"
  [(set_attr "type" "JR")
   (set_attr "duplex" "yes")]
)

(define_expand "allocframe"
  [(parallel [(set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -4)))
		   (reg:SI LINK_REGNUM))
	      (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -8)))
		   (reg:SI FP_REGNUM))
	      (set (reg:SI FP_REGNUM)
		   (plus:SI (reg:SI SP_REGNUM) (const_int -8)))
	      (set (reg:SI SP_REGNUM)
		   (minus:SI (reg:SI SP_REGNUM)
			     (match_operand 0 "const_int_operand" "")))])]
  ""
  {
    operands[0] = gen_int_mode (INTVAL (operands[0]) + 8, SImode);
  }
)

(define_insn "allocframe_real"
  [(set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -4)))
	(reg:SI LINK_REGNUM))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -8)))
	(reg:SI FP_REGNUM))
   (set (reg:SI FP_REGNUM)
	(plus:SI (reg:SI SP_REGNUM) (const_int -8)))
   (set (reg:SI SP_REGNUM)
	(minus:SI (reg:SI SP_REGNUM)
		  (match_operand 0 "const_int_operand" "i,K82")))]
  ""
  {
    operands[0] = gen_int_mode (INTVAL (operands[0]) - 8, SImode);
    return "allocframe(#%0)";
  }
  [(set_attr "type" "Allocframe,Allocframe")
   (set_attr "duplex" "no,yes")]
)

(define_expand "allocframe_and_save_r16"
  [(parallel [(set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -4)))
		   (reg:SI LINK_REGNUM))
	      (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -8)))
		   (reg:SI FP_REGNUM))
	      (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -12)))
		   (reg:SI 16))
	      (set (reg:SI FP_REGNUM)
		   (plus:SI (reg:SI SP_REGNUM) (const_int -8)))
	      (set (reg:SI SP_REGNUM)
		   (minus:SI (reg:SI SP_REGNUM)
			     (match_operand 0 "const_int_operand" "")))])]
  "TARGET_V4_FEATURES"
  {
    operands[0] = gen_int_mode (INTVAL (operands[0]) + 8, SImode);
  }
)

(define_insn "allocframe_and_save_r16_real"
  [(set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -4)))
	(reg:SI LINK_REGNUM))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -8)))
	(reg:SI FP_REGNUM))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -12)))
	(reg:SI 16))
   (set (reg:SI FP_REGNUM)
	(plus:SI (reg:SI SP_REGNUM) (const_int -8)))
   (set (reg:SI SP_REGNUM)
	(minus:SI (reg:SI SP_REGNUM)
		  (match_operand 0 "const_int_operand" "i")))]
  "TARGET_V4_FEATURES"
  {
    operands[0] = gen_int_mode (INTVAL (operands[0]) - 8, SImode);
    return "memw(r29+#-12) = r16\;allocframe(#%0)";
  }
  [(set_attr "type" "LoadStore")]
)

(define_expand "allocframe_and_save_r16_and_r17"
  [(parallel [(set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -4)))
		   (reg:SI LINK_REGNUM))
	      (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -8)))
		   (reg:SI FP_REGNUM))
	      (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -12)))
		   (reg:SI 17))
	      (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -16)))
		   (reg:SI 16))
	      (set (reg:SI FP_REGNUM)
		   (plus:SI (reg:SI SP_REGNUM) (const_int -8)))
	      (set (reg:SI SP_REGNUM)
		   (minus:SI (reg:SI SP_REGNUM)
			     (match_operand 0 "const_int_operand" "")))])]
  "TARGET_V4_FEATURES"
  {
    operands[0] = gen_int_mode (INTVAL (operands[0]) + 8, SImode);
  }
)

(define_insn "allocframe_and_save_r16_and_r17_real"
  [(set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -4)))
	(reg:SI LINK_REGNUM))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -8)))
	(reg:SI FP_REGNUM))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -12)))
	(reg:SI 17))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -16)))
	(reg:SI 16))
   (set (reg:SI FP_REGNUM)
	(plus:SI (reg:SI SP_REGNUM) (const_int -8)))
   (set (reg:SI SP_REGNUM)
	(minus:SI (reg:SI SP_REGNUM)
		  (match_operand 0 "const_int_operand" "i")))]
  "TARGET_V4_FEATURES"
  {
    operands[0] = gen_int_mode (INTVAL (operands[0]) - 8, SImode);
    return "memd(r29+#-16) = r17:16\;allocframe(#%0)";
  }
  [(set_attr "type" "LoadStore")]
)

(define_expand "increment_stack_pointer"
  [(set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI SP_REGNUM)
		 (match_operand 0 "nonmemory_operand" "")))]
  ""
  ""
)

(define_insn "allocate_stack_and_save_r16"
  [(set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -4))) (reg:SI 16))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI SP_REGNUM)
		 (match_operand 0 "const_int_operand" "i,Rg")))]
  ""
  "@
   memw(r29+#-4) = r16\;r29 = add(r29,#%0)
   memw(r29+#-4) = r16\;r29 = add(r29,%0)"
  [(set_attr "type" "AStore,AStore")]
)

(define_insn "allocate_stack_and_save_r16_and_r17"
  [(set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -4))) (reg:SI 17))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -8))) (reg:SI 16))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI SP_REGNUM)
		 (match_operand 0 "const_int_operand" "i,Rg")))]
  ""
  "@
   memd(r29+#-8) = r17:16\;r29 = add(r29,#%0)
   memd(r29+#-8) = r17:16\;r29 = add(r29,%0)"
  [(set_attr "type" "AStore,AStore")]
)

(define_insn "allocate_stack_and_save_r16_through_r18"
  [(set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -4))) (reg:SI 17))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -8))) (reg:SI 16))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -12))) (reg:SI 18))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI SP_REGNUM)
		 (match_operand 0 "const_int_operand" "i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   memd(r29+#-8) = r17:16\;memw(r29+#-12) = r18\;r29 = add(r29,#%0)
   memd(r29+#-8) = r17:16\;memw(r29+#-12) = r18\;r29 = add(r29,%0)"
  [(set_attr "type" "ALoadStore,ALoadStore")]
)

(define_insn "allocate_stack_and_save_r16_through_r19"
  [(set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -4))) (reg:SI 17))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -8))) (reg:SI 16))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -12))) (reg:SI 19))
   (set (mem:SI (plus:SI (reg:SI SP_REGNUM) (const_int -16))) (reg:SI 18))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI SP_REGNUM)
		 (match_operand 0 "const_int_operand" "i,Rg")))]
  "TARGET_V4_FEATURES"
  "@
   memd(r29+#-8) = r17:16\;memd(r29+#-16) = r19:18\;r29 = add(r29,#%0)
   memd(r29+#-8) = r17:16\;memd(r29+#-16) = r19:18\;r29 = add(r29,%0)"
  [(set_attr "type" "ALoadStore,ALoadStore")]
)

(define_insn "deallocframe"
  [(set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))
   (clobber (mem:BLK (scratch)))]
  ""
  "deallocframe"
  [(set_attr "type" "Load")
   (set_attr "duplex" "yes")]
)

(define_insn "save_r24_through_r27"
  [(set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))) (reg:SI 26))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))) (reg:SI 27))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))) (reg:SI 24))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))) (reg:SI 25))
   (clobber (reg:SI 28))
   (clobber (reg:SI LINK_REGNUM))]
  ""
  {
    if (flag_pic)
      return "call __save_r24_through_r27@PLT";
    else
      return "call __save_r24_through_r27";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r24_through_r27_and_deallocframe_before_sibcall"
  [(set (reg:SI 26) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 27) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 24) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 25) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))
   (clobber (reg:SI 28))]
  ""
  "call __restore_r24_through_r27_and_deallocframe_before_tailcall"
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r24_through_r25_and_deallocframe_before_sibcall"
  [(set (reg:SI 24) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 25) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))
   (clobber (reg:SI 28))]
  ""
  "call __restore_r24_through_r25_and_deallocframe_before_tailcall"
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r24_through_r27_and_deallocframe"
  [(return)
   (set (reg:SI 26) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 27) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 24) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 25) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))]
  ""
  "jump __restore_r24_through_r27_and_deallocframe"
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r24_through_r25_and_deallocframe"
  [(return)
   (set (reg:SI 24) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 25) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))]
  ""
  "jump __restore_r24_through_r25_and_deallocframe"
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "save_r16_through_r19"
  [(set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))) (reg:SI 18))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))) (reg:SI 19))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))) (reg:SI 16))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))) (reg:SI 17))
   (clobber (reg:SI 28))
   (clobber (reg:SI LINK_REGNUM))]
  ""
  {
    if (flag_pic)
      return "call __save_r16_through_r19@PLT";
    else
      return "call __save_r16_through_r19";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "save_r16_through_r21"
  [(set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))) (reg:SI 20))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))) (reg:SI 21))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))) (reg:SI 18))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))) (reg:SI 19))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))) (reg:SI 16))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))) (reg:SI 17))
   (clobber (reg:SI 28))
   (clobber (reg:SI LINK_REGNUM))]
  ""
  {
    if (flag_pic)
      return "call __save_r16_through_r21@PLT";
    else
      return "call __save_r16_through_r21";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "save_r16_through_r23"
  [(set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -32))) (reg:SI 22))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -28))) (reg:SI 23))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))) (reg:SI 20))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))) (reg:SI 21))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))) (reg:SI 18))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))) (reg:SI 19))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))) (reg:SI 16))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))) (reg:SI 17))
   (clobber (reg:SI 28))
   (clobber (reg:SI LINK_REGNUM))]
  ""
  {
    if (flag_pic)
      return "call __save_r16_through_r23@PLT";
    else
      return "call __save_r16_through_r23";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "save_r16_through_r25"
  [(set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -40))) (reg:SI 24))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -36))) (reg:SI 25))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -32))) (reg:SI 22))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -28))) (reg:SI 23))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))) (reg:SI 20))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))) (reg:SI 21))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))) (reg:SI 18))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))) (reg:SI 19))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))) (reg:SI 16))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))) (reg:SI 17))
   (clobber (reg:SI 28))
   (clobber (reg:SI LINK_REGNUM))]
  ""
  {
    if (flag_pic)
      return "call __save_r16_through_r25@PLT";
    else
      return "call __save_r16_through_r25";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "save_r16_through_r27"
  [(set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -48))) (reg:SI 26))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -44))) (reg:SI 27))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -40))) (reg:SI 24))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -36))) (reg:SI 25))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -32))) (reg:SI 22))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -28))) (reg:SI 23))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))) (reg:SI 20))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))) (reg:SI 21))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))) (reg:SI 18))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))) (reg:SI 19))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))) (reg:SI 16))
   (set (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))) (reg:SI 17))
   (clobber (reg:SI 28))
   (clobber (reg:SI LINK_REGNUM))]
  ""
  {
    if (flag_pic)
      return "call __save_r16_through_r27@PLT";
    else
      return "call __save_r16_through_r27";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r27_and_deallocframe_before_sibcall"
  [(set (reg:SI 26) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -48))))
   (set (reg:SI 27) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -44))))
   (set (reg:SI 24) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -40))))
   (set (reg:SI 25) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -36))))
   (set (reg:SI 22) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -32))))
   (set (reg:SI 23) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -28))))
   (set (reg:SI 20) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))))
   (set (reg:SI 21) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))))
   (set (reg:SI 18) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 19) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))
   (clobber (reg:SI 28))]
  ""
  {
    if (flag_pic)
      return
	"call __restore_r16_through_r27_and_deallocframe_before_tailcall@PLT";
    else
      return
	"call __restore_r16_through_r27_and_deallocframe_before_tailcall";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r25_and_deallocframe_before_sibcall"
  [(set (reg:SI 24) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -40))))
   (set (reg:SI 25) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -36))))
   (set (reg:SI 22) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -32))))
   (set (reg:SI 23) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -28))))
   (set (reg:SI 20) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))))
   (set (reg:SI 21) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))))
   (set (reg:SI 18) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 19) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))
   (clobber (reg:SI 28))]
  ""
  {
    if (flag_pic)
      return
	"call __restore_r16_through_r25_and_deallocframe_before_tailcall@PLT";
    else
      return
	"call __restore_r16_through_r25_and_deallocframe_before_tailcall";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r23_and_deallocframe_before_sibcall"
  [(set (reg:SI 22) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -32))))
   (set (reg:SI 23) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -28))))
   (set (reg:SI 20) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))))
   (set (reg:SI 21) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))))
   (set (reg:SI 18) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 19) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))
   (clobber (reg:SI 28))]
  ""
  {
    if (flag_pic)
      return
	"call __restore_r16_through_r23_and_deallocframe_before_tailcall@PLT";
    else
      return
	"call __restore_r16_through_r23_and_deallocframe_before_tailcall";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r21_and_deallocframe_before_sibcall"
  [(set (reg:SI 20) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))))
   (set (reg:SI 21) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))))
   (set (reg:SI 18) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 19) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))
   (clobber (reg:SI 28))]
  ""
  {
    if (flag_pic)
      return
	"call __restore_r16_through_r21_and_deallocframe_before_tailcall@PLT";
    else
      return
	"call __restore_r16_through_r21_and_deallocframe_before_tailcall";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r19_and_deallocframe_before_sibcall"
  [(set (reg:SI 18) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 19) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))
   (clobber (reg:SI 28))]
  ""
  {
    if (flag_pic)
      return
	"call __restore_r16_through_r19_and_deallocframe_before_tailcall@PLT";
    else
      return
	"call __restore_r16_through_r19_and_deallocframe_before_tailcall";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r17_and_deallocframe_before_sibcall"
  [(set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))
   (clobber (reg:SI 28))]
  ""
  {
    if (flag_pic)
      return
	"call __restore_r16_through_r17_and_deallocframe_before_tailcall@PLT";
    else
      return
	"call __restore_r16_through_r17_and_deallocframe_before_tailcall";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r27_and_deallocframe"
  [(return)
   (set (reg:SI 26) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -48))))
   (set (reg:SI 27) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -44))))
   (set (reg:SI 24) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -40))))
   (set (reg:SI 25) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -36))))
   (set (reg:SI 22) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -32))))
   (set (reg:SI 23) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -28))))
   (set (reg:SI 20) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))))
   (set (reg:SI 21) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))))
   (set (reg:SI 18) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 19) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))]
  ""
  {
    if (flag_pic)
      return "jump __restore_r16_through_r27_and_deallocframe@PLT";
    else
      return "jump __restore_r16_through_r27_and_deallocframe";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r25_and_deallocframe"
  [(return)
   (set (reg:SI 24) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -40))))
   (set (reg:SI 25) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -36))))
   (set (reg:SI 22) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -32))))
   (set (reg:SI 23) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -28))))
   (set (reg:SI 20) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))))
   (set (reg:SI 21) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))))
   (set (reg:SI 18) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 19) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))]
  ""
  {
    if (flag_pic)
      return "jump __restore_r16_through_r25_and_deallocframe@PLT";
    else
      return "jump __restore_r16_through_r25_and_deallocframe";
  }
 [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r23_and_deallocframe"
  [(return)
   (set (reg:SI 22) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -32))))
   (set (reg:SI 23) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -28))))
   (set (reg:SI 20) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))))
   (set (reg:SI 21) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))))
   (set (reg:SI 18) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 19) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))]
  ""
  {
    if (flag_pic)
      return "jump __restore_r16_through_r23_and_deallocframe@PLT";
    else
      return "jump __restore_r16_through_r23_and_deallocframe";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r21_and_deallocframe"
  [(return)
   (set (reg:SI 20) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -24))))
   (set (reg:SI 21) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -20))))
   (set (reg:SI 18) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 19) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))]
  ""
  {
    if (flag_pic)
      return "jump __restore_r16_through_r21_and_deallocframe@PLT";
    else
      return "jump __restore_r16_through_r21_and_deallocframe";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r19_and_deallocframe"
  [(return)
   (set (reg:SI 18) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -16))))
   (set (reg:SI 19) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -12))))
   (set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))]
  ""
  {
    if (flag_pic)
      return "jump __restore_r16_through_r19_and_deallocframe@PLT";
    else
      return "jump __restore_r16_through_r19_and_deallocframe";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "restore_r16_through_r17_and_deallocframe"
  [(return)
   (set (reg:SI 16) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -8))))
   (set (reg:SI 17) (mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int -4))))
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))]
  ""
  {
    if (flag_pic)
      return "jump __restore_r16_through_r17_and_deallocframe@PLT";
    else
      return "jump __restore_r16_through_r17_and_deallocframe";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "deallocframe_return"
  [(return)
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))]
  "TARGET_V4_FEATURES && TARGET_DEALLOC_RETURN && hexagon_direct_return ()"
  "dealloc_return"
  [(set_attr "type" "NewValueJump")
   (set_attr "duplex" "yes")]
)

(define_insn "deallocframe_function"
  [(return)
   (set (reg:SI SP_REGNUM)
	(plus:SI (reg:SI FP_REGNUM) (const_int 8)))
   (set (reg:SI LINK_REGNUM)
	(mem:SI (plus:SI (reg:SI FP_REGNUM) (const_int 4))))
   (set (reg:SI FP_REGNUM)
	(mem:SI (reg:SI FP_REGNUM)))]
  "!TARGET_V4_FEATURES || !TARGET_DEALLOC_RETURN"
  {
    if (flag_pic)
      return "jump __deallocframe@PLT";
    else
      return "jump  __deallocframe";
  }
  [(set_attr "type" "J")
   (set_attr "emulation_call" "yes")]
)

(define_insn "falign"
  [(unspec_volatile [(const_int 0)] UNSPEC_HEXAGON_falign)]
  ""
  ".falign"
  [(set_attr "length" "12")]
)

(define_insn "memcpy_kernelqi"
  [(set (match_operand:QI 0 "memory_operand" "=m")
	(match_operand:QI 1 "gr_register_operand" "Rg"))
   (set (match_operand:QI 2 "gr_register_operand" "=Rg")
	(match_operand:QI 3 "memory_operand" "m"))]
  ""
  "memb(%0) = %1\;%2 = memb(%3)"
  [(set_attr "type" "LoadStore")]
)

(define_insn "memcpy_kernelhi"
  [(set (match_operand:HI 0 "memory_operand" "=m")
	(match_operand:HI 1 "gr_register_operand" "Rg"))
   (set (match_operand:HI 2 "gr_register_operand" "=Rg")
	(match_operand:HI 3 "memory_operand" "m"))]
  ""
  "memh(%0) = %1\;%2 = memh(%3)"
  [(set_attr "type" "LoadStore")]
)

(define_insn "memcpy_kernelsi"
  [(set (match_operand:SI 0 "memory_operand" "=Anx")
	(match_operand:SI 1 "gr_register_operand" "Rg"))
   (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	(match_operand:SI 3 "memory_operand" "Anx"))]
  ""
  "memw(%0) = %1\;%2 = memw(%3)"
  [(set_attr "type" "LoadStore")]
)

(define_insn "memcpy_kerneldi"
  [(set (match_operand:DI 0 "memory_operand" "=Anx")
	(match_operand:DI 1 "gr_register_operand" "Rg"))
   (set (match_operand:DI 2 "gr_register_operand" "=Rg")
	(match_operand:DI 3 "memory_operand" "Anx"))]
  ""
  "memd(%0) = %1\;%2 = memd(%3)"
  [(set_attr "type" "LoadStore")]
)

(define_insn "vcmpb_eq"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(unspec:BI [(match_operand:DI 1 "gr_register_operand" "Rg")
		    (match_operand:DI 2 "gr_register_operand" "Rg")]
		   UNSPEC_HEXAGON_vcmpb_eq))]
  ""
  "%0 = vcmpb.eq(%P1,%P2)"
  [(set_attr "type" "X")]
)

(define_insn "vcmpb_gtu"
  [(set (match_operand:BI 0 "pr_register_operand"  "=Rp")
	(unspec:BI [(match_operand:DI 1 "gr_register_operand" "Rg")
		    (match_operand:DI 2 "gr_register_operand" "Rg")]
		   UNSPEC_HEXAGON_vcmpb_gtu))]
  ""
  "%0 = vcmpb.gtu(%P1,%P2)"
  [(set_attr "type" "X")]
)

(define_insn "any8"
  [(set (match_operand:BI 0 "pr_register_operand"  "=Rp")
	(unspec:BI [(match_operand:BI 1 "pr_register_operand" "Rp")]
		   UNSPEC_HEXAGON_any))]
  ""
  "%0 = any8(%1)"
  [(set_attr "type" "S")]
)

(define_insn "all8"
  [(set (match_operand:BI 0 "pr_register_operand"  "=Rp")
	(unspec:BI [(match_operand:BI 1 "pr_register_operand" "Rp")]
		   UNSPEC_HEXAGON_all))]
  ""
  "%0 = all8(%1)"
  [(set_attr "type" "S")]
)


;;-------------------;;
;; Peephole Patterns ;;
;;-------------------;;

; Optimized case for r0 = mux(!p0, r0, r2)
; Change to if (p0) r0 = r2
; This form can be transformed to a dot-new transfer

(define_peephole2
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(if_then_else:SI
	  (eq (match_operand:BI 1 "pr_register_operand" "")
	      (const_int 0))
	  (match_dup 0)
	  (match_operand:SI 2 "nonmemory_operand" "")))]
  ""
  [(cond_exec
     (ne (match_dup 1) (const_int 0))
     (set (match_dup 0) (match_dup 2)))]
  ""
)

; Optimized case for r0 = mux(!p0, r2, r0)
; Change to if (!p0) r0 = r2
; This form can be transformed to a dot-new transfer

(define_peephole2
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(if_then_else:SI
	  (eq (match_operand:BI 1 "pr_register_operand" "")
	      (const_int 0))
	  (match_operand:SI 2 "nonmemory_operand" "")
	  (match_dup 0)))]
  ""
  [(cond_exec
     (eq (match_dup 1) (const_int 0))
     (set (match_dup 0) (match_dup 2)))]
  ""
)


; Optimized case for r0 = mux(p0, r0, r2)
; Change to if (!p0) r0 = r2
; This form can be transformed to a dot-new transfer

(define_peephole2
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(if_then_else:SI
	  (ne (match_operand:BI 1 "pr_register_operand" "")
	      (const_int 0))
	  (match_dup 0)
	  (match_operand:SI 2 "nonmemory_operand" "")))]
  ""
  [(cond_exec
     (eq (match_dup 1) (const_int 0))
     (set (match_dup 0) (match_dup 2)))]
  ""
)

; Optimized case for r0 = mux(p0, r2, r0)
; Change to if (p0) r0 = r2
; This form can be transformed to a dot-new transfer

(define_peephole2
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(if_then_else:SI
	  (ne (match_operand:BI 1 "pr_register_operand" "")
	      (const_int 0))
	  (match_operand:SI 2 "nonmemory_operand" "")
	  (match_dup 0)))]
  ""
  [(cond_exec
     (ne (match_dup 1) (const_int 0))
     (set (match_dup 0) (match_dup 2)))]
  ""
)

(define_peephole2
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(match_operand:SI 1 "gr_register_operand" ""))
   (set (match_operand:SI 2 "gr_register_operand" "")
	(match_operand:SI 3 "gr_register_operand" ""))]
  "(true_regnum (operands[0]) % 2 == 0
    && true_regnum (operands[0]) + 1 == true_regnum (operands[2]))
   || (true_regnum (operands[2]) % 2 == 0
       && true_regnum (operands[2]) + 1 == true_regnum (operands[0]))"
  [(parallel [(set (match_dup 0) (match_dup 1))
	      (set (match_dup 2) (match_dup 3))])]
  {
    if (true_regnum (operands[3]) == true_regnum (operands[0]))
      operands[3] = operands[1];
  }
)

(define_peephole2
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(match_operand:SI 1 "combine_imm_operand" ""))
   (set (match_operand:SI 2 "gr_register_operand" "")
	(match_operand:SI 3 "combine_imm_operand" ""))]
  "((TARGET_CONST64
     && const_int_operand (operands[1], SImode)
     && const_int_operand (operands[3], SImode))
    || (TARGET_V4_FEATURES
	&& (s8_const_int_operand (operands[1], SImode)
	    || s8_const_int_operand (operands[3], SImode)))
    || (s8_const_int_operand (operands[1], SImode)
	&& s8_const_int_operand (operands[3], SImode)))
   && !(TARGET_V4_FEATURES
	&& !s8_const_int_operand (operands[1], SImode)
	&& !s8_const_int_operand (operands[3], SImode)
	&& (s16_const_int_operand (operands[1], SImode)
	    || s16_const_int_operand (operands[3], SImode)))
   && (!optimize_size
       || s8_const_int_operand (operands[1], SImode)
       || s8_const_int_operand (operands[3], SImode)
       || !s16_const_int_operand (operands[1], SImode)
       || !s16_const_int_operand (operands[3], SImode))
   && ((true_regnum (operands[0]) % 2 == 0
	&& true_regnum (operands[0]) + 1 == true_regnum (operands[2]))
       || (true_regnum (operands[2]) % 2 == 0
	   && true_regnum (operands[2]) + 1 == true_regnum (operands[0])))"
  [(parallel [(set (match_dup 0) (match_dup 1))
	      (set (match_dup 2) (match_dup 3))])]
  ""
)

(define_peephole2
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(match_operand:SI 1 "gr_register_operand" ""))
   (set (match_operand:SI 2 "gr_register_operand" "")
	(match_operand:SI 3 "combine_imm_operand" ""))]
  "TARGET_V4_FEATURES
   && ((true_regnum (operands[0]) % 2 == 0
	&& true_regnum (operands[0]) + 1 == true_regnum (operands[2]))
       || (true_regnum (operands[2]) % 2 == 0
	   && true_regnum (operands[2]) + 1 == true_regnum (operands[0])))"
  [(parallel [(set (match_dup 0) (match_dup 1))
	      (set (match_dup 2) (match_dup 3))])]
  ""
)

(define_peephole2
  [(set (match_operand:SI 0 "gr_register_operand" "")
	(match_operand:SI 1 "combine_imm_operand" ""))
   (set (match_operand:SI 2 "gr_register_operand" "")
	(match_operand:SI 3 "gr_register_operand" ""))]
  "TARGET_V4_FEATURES
   && ((true_regnum (operands[0]) % 2 == 0
	&& true_regnum (operands[0]) + 1 == true_regnum (operands[2]))
       || (true_regnum (operands[2]) % 2 == 0
	   && true_regnum (operands[2]) + 1 == true_regnum (operands[0])))
   && (true_regnum (operands[3]) != true_regnum (operands[0])
       || s8_const_int_operand (operands[1], SImode)
       || (TARGET_CONST64 && const_int_operand (operands[1], SImode)))"
  [(parallel [(set (match_dup 0) (match_dup 1))
	      (set (match_dup 2) (match_dup 3))])]
  {
    if (true_regnum (operands[3]) == true_regnum (operands[0]))
      operands[3] = operands[1];
  }
)

(define_peephole2
  [(set (match_operand:BI 0 "pr_register_operand" "")
	(not:BI (match_operand:BI 1 "pr_register_operand" "")))
   (set (pc)
	(if_then_else (ne (match_operand:BI 2 "pr_register_operand" "")
			  (const_int 0))
		      (match_operand 3 "" "")
		      (match_operand 4 "" "")))]
  "true_regnum (operands[2]) == true_regnum (operands[0])
   && peep2_reg_dead_p (2, operands[0])"
  [(set (pc)
	(if_then_else:SI (eq (match_dup 1) (const_int 0))
			 (match_dup 3)
			 (match_dup 4)))]
  ""
)

(define_peephole2
  [(set (match_operand:BI 0 "pr_register_operand" "")
	(not:BI (match_operand:BI 1 "pr_register_operand" "")))
   (set (pc)
	(if_then_else (eq (match_operand:BI 2 "pr_register_operand" "")
			  (const_int 0))
		      (match_operand 3 "" "")
		      (match_operand 4 "" "")))]
  "true_regnum (operands[2]) == true_regnum (operands[0])
   && peep2_reg_dead_p (2, operands[0])"
  [(set (pc)
	(if_then_else:SI (ne (match_dup 1) (const_int 0))
			 (match_dup 3)
			 (match_dup 4)))]
  ""
)

(define_peephole2
  [(set (match_operand:BI 0 "pr_register_operand" "")
	(not:BI (match_operand:BI 1 "pr_register_operand" "")))
   (set (match_operand 2 "" "")
	(if_then_else (ne (match_operand:BI 3 "pr_register_operand" "")
			  (const_int 0))
		      (match_operand 4 "" "")
		      (match_operand 5 "" "")))]
  "true_regnum (operands[3]) == true_regnum (operands[0])
   && peep2_reg_dead_p (2, operands[0])"
  [(set (match_dup 2)
	(if_then_else:SI (eq (match_dup 1) (const_int 0))
			 (match_dup 4)
			 (match_dup 5)))]
  ""
)

(define_peephole2
  [(set (match_operand:BI 0 "pr_register_operand" "")
	(not:BI (match_operand:BI 1 "pr_register_operand" "")))
   (set (match_operand 2 "" "")
	(if_then_else (eq (match_operand:BI 3 "pr_register_operand" "")
			  (const_int 0))
		      (match_operand 4 "" "")
		      (match_operand 5 "" "")))]
  "true_regnum (operands[3]) == true_regnum (operands[0])
   && peep2_reg_dead_p (2, operands[0])"
  [(set (match_dup 2)
	(if_then_else:SI (ne (match_dup 1) (const_int 0))
			 (match_dup 4)
			 (match_dup 5)))]
  ""
)


;;--------------------------------;;
;; Patterns Produced by Peepholes ;;
;;--------------------------------;;

(define_insn_and_split "combinesi_v4"
  [(set (match_operand:SI 0 "gr_register_operand"
	  "=Rg, Rg, Rg, Rg, Rg, Rg,Rg, Rg, Rg, Rg,Rg,Rg")
	(match_operand:SI 1 "nonmemory_operand"
	  " Rg,Iu2,Is8,Is8,  i, Rg,Rg,Iu0, Rg,Is8, i, i"))
   (set (match_operand:SI 2 "gr_register_operand"
	  "=Rg, Rg, Rg, Rg, Rg, Rg,Rg, Rg, Rg, Rg,Rg,Rg")
	(match_operand:SI 3 "nonmemory_operand"
	  " Rg,Iu2,Is8,  i,Is8,Is8, i, Rg,Iu0, Rg,Rg, i"))]
  "reload_completed && TARGET_V4_FEATURES"
  {
    HOST_WIDE_INT high, low;

    if (REGNO (operands[0]) % 2 == 0)
      switch (which_alternative)
	{
	case 0:
	  return "%P0 = combine(%3,%1)";
	case 1:
	  return "%P0 = combine(#%3,#%1)";
	case 2:
	  return "%P0 = combine(#%3,#%1)";
	case 3:
	  return "%P0 = combine(##%3,#%1)";
	case 4:
	  return "%P0 = combine(#%3,##%1)";
	case 5:
	  return "%P0 = combine(#%3,%1)";
	case 6:
	  return "%P0 = combine(##%3,%1)";
	case 7:
	  return "%P0 = combine(%3,#%1)";
	case 8:
	  return "%P0 = combine(#%3,%1)";
	case 9:
	  return "%P0 = combine(%3,#%1)";
	case 10:
	  return "%P0 = combine(%3,##%1)";
	case 11:
	  gcc_assert (TARGET_CONST64);
	  gcc_assert (const_int_operand (operands[1], SImode));
	  gcc_assert (const_int_operand (operands[3], SImode));
	  low = INTVAL (operands[1]);
	  high = INTVAL (operands[3]);
	  operands[1] =
	    gen_int_mode ((high << 32ULL) | (low & 0x0FFFFFFFFULL), DImode);
	  return "%P0 = CONST64(#%1)";
	default:
	  gcc_unreachable ();
	}
    else
      switch (which_alternative)
	{
	case 0:
	  return "%P2 = combine(%1,%3)";
	case 1:
	  return "%P2 = combine(#%1,#%3)";
	case 2:
	  return "%P2 = combine(#%1,#%3)";
	case 3:
	  return "%P2 = combine(#%1,##%3)";
	case 4:
	  return "%P2 = combine(##%1,#%3)";
	case 5:
	  return "%P2 = combine(%1,#%3)";
	case 6:
	  return "%P2 = combine(%1,##%3)";
	case 7:
	  return "%P2 = combine(#%1,%3)";
	case 8:
	  return "%P2 = combine(%1,#%3)";
	case 9:
	  return "%P2 = combine(#%1,%3)";
	case 10:
	  return "%P2 = combine(##%1,%3)";
	case 11:
	  gcc_assert (TARGET_CONST64);
	  gcc_assert (const_int_operand (operands[1], SImode));
	  gcc_assert (const_int_operand (operands[3], SImode));
	  low = INTVAL (operands[3]);
	  high = INTVAL (operands[1]);
	  operands[1] =
	    gen_int_mode ((high << 32ULL) | (low & 0x0FFFFFFFFULL), DImode);
	  return "%P2 = CONST64(#%1)";
	default:
	  gcc_unreachable ();
	}
  }
  "&& !((REGNO (operands[0]) % 2 == 0
	 && REGNO (operands[0]) + 1 == REGNO (operands[2]))
	|| (REGNO (operands[2]) % 2 == 0
	    && REGNO (operands[2]) + 1 == REGNO (operands[0])))"
  [(set (match_dup 0) (match_dup 1))
   (set (match_dup 2) (match_dup 3))]
  {
    /* When this condition is true, it is likely that we have
       a violation of parallel semantics. This pattern was likely
       produced by a peephole, and later altered by reg rename
       making it inappropriate for paired register usage. Also,
       cprop might have propagated a register usage into the
       parallel structure, resulting in this code.
       If we do not have this king of assignment:
       parallel [ r0=r2; r2=r0]
       we can reverse the order of instructions in parallel
       structure as we split it.
       See bug 3855 for details. */

    if (REG_P (operands[0]) && REG_P (operands[1])
	&& REG_P (operands[2]) && REG_P (operands[3])
	&& REGNO (operands[0]) == REGNO (operands[3])
	&& REGNO (operands[1]) != REGNO (operands[2]))
      {
	rtx tmp;

	tmp = operands[0];
	operands[0] = operands[2];
	operands[2] = tmp;

	tmp = operands[1];
	operands[1] = operands[3];
	operands[3] = tmp;
      }
  }
  [(set_attr "type" "A,A,A,EA,EA,A,EA,A,A,A,EA,Load")
   (set_attr "duplex" "no,yes,no,no,no,no,no,yes,yes,no,no,no")]
)

(define_insn_and_split "combinesi"
  [(set (match_operand:SI 0 "gr_register_operand" "=Rg, Rg,Rg")
	(match_operand:SI 1 "nonmemory_operand"    "Rg,Is8, i"))
   (set (match_operand:SI 2 "gr_register_operand" "=Rg, Rg,Rg")
	(match_operand:SI 3 "nonmemory_operand"    "Rg,Is8, i"))]
  "reload_completed && !TARGET_V4_FEATURES"
  {
    HOST_WIDE_INT high, low;

    if (REGNO (operands[0]) % 2 == 0)
      switch (which_alternative)
	{
	case 0:
	  return "%P0 = combine(%3,%1)";
	case 1:
	  return "%P0 = combine(#%3,#%1)";
	case 2:
	  gcc_assert (TARGET_CONST64);
	  gcc_assert (const_int_operand (operands[1], SImode));
	  gcc_assert (const_int_operand (operands[3], SImode));
	  low = INTVAL (operands[1]);
	  high = INTVAL (operands[3]);
	  operands[1] =
	    gen_int_mode ((high << 32ULL) | (low & 0x0FFFFFFFFULL), DImode);
	  return "%P0 = CONST64(#%1)";
	default:
	  gcc_unreachable ();
	}
    else
      switch (which_alternative)
	{
	case 0:
	  return "%P2 = combine(%1,%3)";
	case 1:
	  return "%P2 = combine(#%1,#%3)";
	case 2:
	  gcc_assert (TARGET_CONST64);
	  gcc_assert (const_int_operand (operands[1], SImode));
	  gcc_assert (const_int_operand (operands[3], SImode));
	  low = INTVAL (operands[3]);
	  high = INTVAL (operands[1]);
	  operands[1] =
	    gen_int_mode ((high << 32ULL) | (low & 0x0FFFFFFFFULL), DImode);
	  return "%P2 = CONST64(#%1)";
	default:
	  gcc_unreachable ();
	}
  }
  "&& !((REGNO (operands[0]) % 2 == 0
	 && REGNO (operands[0]) + 1 == REGNO (operands[2]))
	|| (REGNO (operands[2]) % 2 == 0
	    && REGNO (operands[2]) + 1 == REGNO (operands[0])))"
  [(set (match_dup 0) (match_dup 1))
   (set (match_dup 2) (match_dup 3))]
  {
    /* When this condition is true, it is likely that we have
       a violation of parallel semantics. This pattern was likely
       produced by a peephole, and later altered by reg rename
       making it inappropriate for paired register usage. Also,
       cprop might have propagated a register usage into the
       parallel structure, resulting in this code.
       If we do not have this king of assignment:
       parallel [ r0=r2; r2=r0]
       we can reverse the order of instructions in parallel
       structure as we split it.
       See bug 3855 for details. */

    if (REG_P (operands[0]) && REG_P (operands[1])
	&& REG_P (operands[2]) && REG_P (operands[3])
	&& REGNO (operands[0]) == REGNO (operands[3])
	&& REGNO (operands[1]) != REGNO (operands[2]))
      {
	rtx tmp;

	tmp = operands[0];
	operands[0] = operands[2];
	operands[2] = tmp;

	tmp = operands[1];
	operands[1] = operands[3];
	operands[3] = tmp;
      }
  }
  [(set_attr "type" "A,A,Load")]
)

;;---------------------------;;
;; Floating-point arithmetic ;;
;;---------------------------;;

;;---------;;
;; abs{m}2 ;;
;;---------;;

(define_insn "abssf2"
  [(set (match_operand:SF 0 "gr_register_operand" "=Rg")
	(abs:SF (match_operand:SF 1 "gr_register_operand" "Rg")))]
  ""
  "%0 = clrbit(%1, #31)"
  [(set_attr "type" "X")]
)

;;---------;;
;; neg{m}2 ;;
;;---------;;

(define_insn "negsf2"
  [(set (match_operand:SF 0 "gr_register_operand" "=Rg")
	(neg:SF (match_operand:SF 1 "gr_register_operand" "Rg")))]
  ""
  "%0 = togglebit(%1, #31)"
  [(set_attr "type" "X")]
)

;;------------;;
;; smax[sd]f3 ;;
;;------------;;

(define_insn "smaxsf3"
  [(set (match_operand:SF 0 "gr_register_operand" "=Rg")
	(smax:SF (match_operand:SF 1 "gr_register_operand" "Rg")
		 (match_operand:SF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = sfmax(%1,%2)"
  [(set_attr "type" "X")]
)

;;------------;;
;; smin[sd]f3 ;;
;;------------;;

(define_insn "sminsf3"
  [(set (match_operand:SF 0 "gr_register_operand" "=Rg")
	(smin:SF (match_operand:SF 1 "gr_register_operand" "Rg")
		 (match_operand:SF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = sfmin(%1,%2)"
  [(set_attr "type" "X")]
)

;; FIXME: Many of the patterns below switch to using the "r" constraint rather
;; than "Rg".  We should be consistent.

;;-----------;;
;; add[sd]f3 ;;
;;-----------;;

(define_insn "addsf3"
  [(set (match_operand:SF 0 "gr_register_operand" "=r")
	(plus:SF (match_operand:SF 1 "gr_register_operand" "r")
		 (match_operand:SF 2 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = sfadd(%1, %2)"
  [(set_attr "type" "X")]
)

;;-----------;;
;; sub[sd]f3 ;;
;;-----------;;

(define_insn "subsf3"
  [(set (match_operand:SF 0 "gr_register_operand" "=r")
	(minus:SF (match_operand:SF 1 "gr_register_operand" "r")
		 (match_operand:SF 2 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = sfsub(%1, %2)"
  [(set_attr "type" "X")]
)

;;----------;;
;; mul[sd]3 ;;
;;----------;;

(define_insn "mulsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(mult:SF (match_operand:SF 1 "register_operand" "r")
                 (match_operand:SF 2 "register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = sfmpy(%1,%2)"
  [(set_attr "type" "X")]
)

(define_insn "*muladdsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
        (plus:SF (mult:SF (match_operand:SF 1 "register_operand" "r")
                          (match_operand:SF 2 "register_operand" "r"))
                 (match_operand:SF 3 "register_operand" "0")))]
  "TARGET_V5_FEATURES
   && flag_fp_contract_mode == FP_CONTRACT_FAST"
  "%0 += sfmpy(%1,%2)"
  [(set_attr "type" "X")]
)

(define_insn "*mulsubsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
        (minus:SF (match_operand:SF 3 "register_operand" "0")
                  (mult:SF (match_operand:SF 1 "register_operand" "r")
                           (match_operand:SF 2 "register_operand" "r"))))]
  "TARGET_V5_FEATURES
   && flag_fp_contract_mode == FP_CONTRACT_FAST"
  "%0 -= sfmpy(%1,%2)"
  [(set_attr "type" "X")]
)

;;---------;;
;; cmp[fd] ;;
;;---------;;

;; a > b

(define_insn "cmpsf_gt"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(gt:BI (match_operand:SF 1 "gr_register_operand" "Rg")
	       (match_operand:SF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = sfcmp.gt(%1,%2)"
  [(set_attr "type" "X")]
)

(define_insn "cmpdf_gt"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(gt:BI (match_operand:DF 1 "gr_register_operand" "Rg")
	       (match_operand:DF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = dfcmp.gt(%1,%2)"
  [(set_attr "type" "X")]
)

; a >= b

(define_insn "cmpsf_ge"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(ge:BI (match_operand:SF 1 "gr_register_operand" "Rg")
	       (match_operand:SF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = sfcmp.ge(%1,%2)"
  [(set_attr "type" "X")]
)

(define_insn "cmpdf_ge"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(ge:BI (match_operand:DF 1 "gr_register_operand" "Rg")
	       (match_operand:DF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = dfcmp.ge(%1,%2)"
  [(set_attr "type" "X")]
)

; a <= b

(define_insn "cmpsf_le"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(le:BI (match_operand:SF 1 "gr_register_operand" "Rg")
	       (match_operand:SF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = sfcmp.ge(%2,%1)"
  [(set_attr "type" "X")]
)

(define_insn "cmpdf_le"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(le:BI (match_operand:DF 1 "gr_register_operand" "Rg")
	       (match_operand:DF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = dfcmp.ge(%2,%1)"
  [(set_attr "type" "X")]
)

; a < b

(define_insn "cmpsf_lt"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(lt:BI (match_operand:SF 1 "gr_register_operand" "Rg")
	       (match_operand:SF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = sfcmp.gt(%2,%1)"
  [(set_attr "type" "X")]
)

(define_insn "cmpdf_lt"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(lt:BI (match_operand:DF 1 "gr_register_operand" "Rg")
	       (match_operand:DF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = dfcmp.gt(%2,%1)"
  [(set_attr "type" "X")]
)

; a == b

(define_insn "cmpsf_eq"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(eq:BI (match_operand:SF 1 "gr_register_operand" "Rg")
	       (match_operand:SF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = sfcmp.eq(%1,%2)"
  [(set_attr "type" "X")]
)

(define_insn "cmpdf_eq"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(eq:BI (match_operand:DF 1 "gr_register_operand" "Rg")
	       (match_operand:DF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = dfcmp.eq(%1,%2)"
  [(set_attr "type" "X")]
)

; unordered

(define_insn "cmpsf_uo"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(unordered:BI (match_operand:SF 1 "gr_register_operand" "Rg")
		      (match_operand:SF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = sfcmp.uo(%1,%2)"
  [(set_attr "type" "X")]
)

(define_insn "cmpdf_uo"
  [(set (match_operand:BI 0 "pr_register_operand" "=Rp")
	(unordered:BI (match_operand:DF 1 "gr_register_operand" "Rg")
		      (match_operand:DF 2 "gr_register_operand" "Rg")))]
  "TARGET_V5_FEATURES"
  "%0 = dfcmp.uo(%1,%2)"
  [(set_attr "type" "X")]
)

;;------------------------------------;;
;; Floating / fixed-point conversions ;;
;;------------------------------------;;

;; 32/64 float -> 32/64 uint

(define_insn "fixuns_truncsfsi2"
  [(set (match_operand:SI 0 "gr_register_operand" "=r")
	(unsigned_fix:SI (match_operand:SF 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  {
    if (TARGET_IEEE_RND_NEAR)
      return "%0 = convert_sf2uw(%1)";
    else
      return "%0 = convert_sf2uw(%1):chop";
  }
  [(set_attr "type" "X")]
)

(define_insn "fixuns_truncsfdi2"
  [(set (match_operand:DI 0 "gr_register_operand" "=r")
	(unsigned_fix:DI (match_operand:SF 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  {
    if (TARGET_IEEE_RND_NEAR)
      return "%0 = convert_sf2ud(%1)";
    else
      return "%0 = convert_sf2ud(%1):chop";
  }
  [(set_attr "type" "X")]
)

(define_insn "fixuns_truncdfsi2"
  [(set (match_operand:SI 0 "gr_register_operand" "=r")
	(unsigned_fix:SI (match_operand:DF 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  {
    if (TARGET_IEEE_RND_NEAR)
      return "%0 = convert_df2uw(%1)";
    else
      return "%0 = convert_df2uw(%1):chop";
  }
  [(set_attr "type" "X")]
)

(define_insn "fixuns_truncdfdi2"
  [(set (match_operand:DI 0 "gr_register_operand" "=r")
	(unsigned_fix:DI (match_operand:DF 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  {
    if (TARGET_IEEE_RND_NEAR)
      return "%0 = convert_df2ud(%1)";
    else
      return "%0 = convert_df2ud(%1):chop";
  }
  [(set_attr "type" "X")]
)

;; 32/64 float -> 32/64 int

(define_insn "fix_truncsfsi2"
  [(set (match_operand:SI 0 "gr_register_operand" "=r")
	(fix:SI (match_operand:SF 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  {
    if (TARGET_IEEE_RND_NEAR)
      return "%0 = convert_sf2w(%1)";
    else
      return "%0 = convert_sf2w(%1):chop";
  }
  [(set_attr "type" "X")]
)

(define_insn "fix_truncsfdi2"
  [(set (match_operand:DI 0 "gr_register_operand" "=r")
	(fix:DI (match_operand:SF 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  {
    if (TARGET_IEEE_RND_NEAR)
      return "%0 = convert_sf2d(%1)";
    else
      return "%0 = convert_sf2d(%1):chop";
  }
  [(set_attr "type" "X")]
)

(define_insn "fix_truncdfsi2"
  [(set (match_operand:SI 0 "gr_register_operand" "=r")
	(fix:SI (match_operand:DF 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  {
    if (TARGET_IEEE_RND_NEAR)
      return "%0 = convert_df2w(%1)";
    else
      return "%0 = convert_df2w(%1):chop";
  }
  [(set_attr "type" "X")]
)

(define_insn "fix_truncdfdi2"
  [(set (match_operand:DI 0 "gr_register_operand" "=r")
	(fix:DI (match_operand:DF 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  {
    if (TARGET_IEEE_RND_NEAR)
      return "%0 = convert_df2d(%1)";
    else
      return "%0 = convert_df2d(%1):chop";
  }
  [(set_attr "type" "X")]
)

;; 32/64 uint -> 32/64 float

(define_insn "floatunssisf2"
  [(set (match_operand:SF 0 "gr_register_operand" "=r")
	(unsigned_float:SF (match_operand:SI 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = convert_uw2sf(%1)"
  [(set_attr "type" "X")]
)

(define_insn "floatunssidf2"
  [(set (match_operand:DF 0 "gr_register_operand" "=r")
	(unsigned_float:DF (match_operand:SI 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = convert_uw2df(%1)"
  [(set_attr "type" "X")]
)

(define_insn "floatunsdisf2"
  [(set (match_operand:SF 0 "gr_register_operand" "=r")
	(unsigned_float:SF (match_operand:DI 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = convert_ud2sf(%1)"
  [(set_attr "type" "X")]
)

(define_insn "floatunsdidf2"
  [(set (match_operand:DF 0 "gr_register_operand" "=r")
	(unsigned_float:DF (match_operand:DI 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = convert_ud2df(%1)"
  [(set_attr "type" "X")]
)

;; 32/64 int -> 32/64 float

(define_insn "floatsisf2"
  [(set (match_operand:SF 0 "gr_register_operand" "=r")
	(float:SF (match_operand:SI 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = convert_w2sf(%1)"
  [(set_attr "type" "X")]
)

(define_insn "floatsidf2"
  [(set (match_operand:DF 0 "gr_register_operand" "=r")
	(float:DF (match_operand:SI 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = convert_w2df(%1)"
  [(set_attr "type" "X")]
)

(define_insn "floatdisf2"
  [(set (match_operand:SF 0 "gr_register_operand" "=r")
	(float:SF (match_operand:DI 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = convert_d2sf(%1)"
  [(set_attr "type" "X")]
)

(define_insn "floatdidf2"
  [(set (match_operand:DF 0 "gr_register_operand" "=r")
	(float:DF (match_operand:DI 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = convert_d2df(%1)"
  [(set_attr "type" "X")]
)

;; 32 float -> 64 float

(define_insn "extendsfdf2"
  [(set (match_operand:DF 0 "gr_register_operand" "=r")
	(float_extend:DF (match_operand:SF 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = convert_sf2df(%1)"
  [(set_attr "type" "X")]
)

(define_insn "truncdfsf2"
  [(set (match_operand:SF 0 "gr_register_operand" "=r")
	(float_truncate:SF (match_operand:DF 1 "gr_register_operand" "r")))]
  "TARGET_V5_FEATURES"
  "%0 = convert_df2sf(%1)"
  [(set_attr "type" "X")]
)


(define_insn_and_split "cond_combinesi"
  [(cond_exec
     (match_operator 4 "predicate_operator"
       [(match_operand:BI 5 "pr_register_operand" "Rp")
	(const_int 0)])
   (parallel
     [(set (match_operand:SI 0 "gr_register_operand" "=Rg")
	   (match_operand:SI 1 "gr_register_operand" "Rg"))
      (set (match_operand:SI 2 "gr_register_operand" "=Rg")
	   (match_operand:SI 3 "gr_register_operand" "Rg"))]))]
  "reload_completed"
  {
    if (REGNO (operands[0]) % 2 == 0)
      return "if (%C4) %P0 = combine(%3,%1)";
    else
      return "if (%C4) %P2 = combine(%1,%3)";
  }
  "&& !((REGNO (operands[0]) % 2 == 0
	 && REGNO (operands[0]) + 1 == REGNO (operands[2]))
	|| (REGNO (operands[2]) % 2 == 0
	    && REGNO (operands[2]) + 1 == REGNO (operands[0])))"
  [(cond_exec
     (match_op_dup 4 [(match_dup 5) (const_int 0)])
     (set (match_dup 0) (match_dup 1)))
   (cond_exec
     (match_op_dup 4 [(match_dup 5) (const_int 0)])
     (set (match_dup 2) (match_dup 3)))]
  {
    /* When this condition is true, it is likely that we have
       a violation of parallel semantics. This pattern was likely
       produced by a peephole, and later altered by reg rename
       making it inappropriate for paired register usage. Also,
       cprop might have propagated a register usage into the
       parallel structure, resulting in this code.
       If we do not have this king of assignment:
       parallel [ r0=r2; r2=r0]
       we can reverse the order of instructions in parallel
       structure as we split it.
       See bug 3855 for details. */

    if (REG_P (operands[0]) && REG_P (operands[1])
	&& REG_P (operands[2]) && REG_P (operands[3])
	&& REGNO (operands[0]) == REGNO (operands[3])
	&& REGNO (operands[1]) != REGNO (operands[2]))
      {
	rtx tmp;

	tmp = operands[0];
	operands[0] = operands[2];
	operands[2] = tmp;

	tmp = operands[1];
	operands[1] = operands[3];
	operands[3] = tmp;
      }
  }
  [(set_attr "type" "A")]
)


;;-------;;
;; Other ;;
;;-------;;

;; Instructions emitted in function prologue to compute GOT base

(define_insn "compute_got_base"
  [(set (match_operand:SI 0 "register_operand" "") (pc))
   (use (label_ref (match_operand 1 "" "")))]
  "flag_pic"
  "\n# setup %0 as the GOT pointer\n%l1:\;%0 = pc\n"
  ;; We don't want this instruction to be packetized
  [(set_attr "type" "multiple")]
)

(define_insn "compute_got_base_v4"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (pc)
   (unspec:SI [(const_int 0)] UNSPEC_PIC_SYM_GOT)))]
  "flag_pic && TARGET_V4_FEATURES"
  "%0 = add(pc,##_GLOBAL_OFFSET_TABLE_@PCREL)"
  [(set_attr "type" "ECR")]
)

(define_insn "compute_tls_base"
  [(set (match_operand:SI 0 "register_operand" "=Rg")
	(unspec_volatile:SI [(const_int 0)] UNSPEC_TLS))
   (clobber (reg:SI TLS_REGNUM))]
  "TARGET_HAVE_TLS"
  "%0 = ugp"
  ;; We don't want this instruction to be packetized
  [(set_attr "type" "multiple")]
)

(define_insn "clean_cache"
  [(unspec_volatile [(match_operand:SI 0 "register_operand" "r")]
        UNSPEC_NOP)
    ]
    ""
    {
     return
       "// Flush cache" "\n"
       "\t" "dccleana(%0)" "\n"
       "\t" "barrier" "\n"
       "\t" "icinva(%0)" "\n"
       "\t" "isync" "\n";
    }
  ;; We don't want this instruction to be packetized
  [(set_attr "type" "multiple")]
)
