SCRIPT_NAME=hexagon
ARCH=hexagon
MACHINE=
TEMPLATE_NAME=elf32
EXTRA_EM_FILE=hexagonelf
OUTPUT_FORMAT="elf32-littlehexagon"
MAXPAGESIZE="CONSTANT (MAXPAGESIZE)"
COMMONPAGESIZE="CONSTANT (COMMONPAGESIZE)"
NONPAGED_TEXT_START_ADDR=0
DATA_GOT=yes
SEPARATE_GOTPLT=16
GENERATE_SHLIB_SCRIPT=yes
GENERATE_COMBRELOC_SCRIPT=yes
# Hexagon NOP
NOP=0x00c0007f
# Largest cache-line size
ALIGNMENT=64 # L2
SBSS_START_SYMBOLS="PROVIDE (${USER_LABEL_PREFIX}__sbss_start = .);
    PROVIDE (${USER_LABEL_PREFIX}___sbss_start = .);"
SBSS_END_SYMBOLS="PROVIDE (${USER_LABEL_PREFIX}__sbss_end = .);
    PROVIDE (${USER_LABEL_PREFIX}___sbss_end = .);"
SDATA_START_SYMBOLS="PROVIDE (_SDA_BASE_ = .);"

case "$target" in
  hexagon*-linux*)
    NO_SMALL_DATA=yes
    TEXT_START_ADDR="CONSTANT (MAXPAGESIZE)"
    GENERATE_PIE_SCRIPT=yes
    ENTRY=_start
    ;;
  *)
    EMBEDDED=yes
    DYNAMIC_LINK=FALSE
    OTHER_EXCLUDE_FILES=fini.o
    TEXT_START_ADDR=0
    ENTRY=start
    # Bare metal has baroque segmentation.
    TEXT_SEGMENT_ALIGN="ALIGN (. + ${COMMONPAGESIZE}, ${COMMONPAGESIZE})"
    RODATA_SEGMENT_ALIGN="ALIGN (. + ${COMMONPAGESIZE}, ${COMMONPAGESIZE})"
    DATA_SEGMENT_ALIGN="ALIGN (. + ${COMMONPAGESIZE}, ${COMMONPAGESIZE})"
    ;;
esac
