#!/bin/sh

SOURCE_DIR="$1"
OUTPUT="$2"

if test -z "$SOURCE_DIR" || ! test -d "$SOURCE_DIR" || test -z "$OUTPUT"
then
	echo >&2 "USAGE: $0 <SOURCE_DIR> <OUTPUT>"
	exit 1
fi

print_config_list () {
	cat <<EOF
static const char *config_name_list[] = {
EOF
	grep -h '^[a-zA-Z].*\..*::$' "$SOURCE_DIR"/Documentation/*config.txt "$SOURCE_DIR"/Documentation/config/*.txt |
	sed '/deprecated/d; s/::$//; s/,  */\n/g' |
	sort |
	sed 's/^.*$/	"&",/'
	cat <<EOF
	NULL,
};
EOF
}

{
	echo "/* Automatically generated by generate-configlist.sh */"
	echo
	echo
	print_config_list
} >"$OUTPUT"
