Summary: Secure Shell - encrypts network communications.
Name: ssh
Version: 1.2.20
Release: 6PAMus
URL: http://www.cs.hut.fi/ssh/
Vendor: Martin Ebourne <mje92@ecs.soton.ac.uk>
Packager: Martin Ebourne <mje92@ecs.soton.ac.uk>
Source0: ftp://ftp.cs.hut.fi/pub/ssh/ssh-1.2.20.tar.gz
Source1: ftp://ftp.funet.fi/pub/crypt/mirrors/idea.sec.dsi.unimi.it/math/rsaref20.tar.Z
Source2: sshd.init
Source3: ssh.pam
Patch: ssh-1.2.20-config.patch
Patch1: ssh-1.2.20-alpha-rsaref.patch
Patch2: ssh-1.2.20-pam.patch
Copyright: Non-commercially distributable
Group: Networking/Utilities
BuildRoot: /tmp/ssh-root
Requires: tcp_wrappers pam

%description
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands in a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

This package includes the ssh server and extra documentation.

The 'i' form of the package is compiled with internal RSAREF and is
recommended for use outside the USA, the 'us' form is compiled for
external RSAREF and should be used within the USA.

%package clients
Summary: Clients for connecting to Secure Shell servers
Group: Networking/Utilities
%description clients
This package includes the clients necessary to make encrypted connections
to SSH servers.

%changelog

* Thu Nov 06 1997 Andrew Morgan <morgan@linux.kernel.org>

- created a different PAM patch

* Fri Jul 04 1997 Martin Ebourne <mje92@ecs.soton.ac.uk>

- Added 'echo' into sshd.init so it formats the output correctly
- Added patch for RSAREF on Alpha from Richard Bullington <rbulling@obscure.org>

* Thu Jun 26 1997 Martin Ebourne <mje92@ecs.soton.ac.uk>

- Changes from Charlie Brady <cbrady@ind.tansu.com.au> to include PAM patch
- Fixed bug with upgrading from pre-1.2.20 without a known_hosts file
- Removed /etc/shadow and /etc/login.defs fixes since now unnecessary

%prep
%setup
echo Patching to use installed zlib
%patch -p1 -b .config
mkdir rsaref2
tar -C rsaref2 -xzf $RPM_SOURCE_DIR/rsaref20.tar.Z

if [ -e rsaref2/rsaref.tar ]; then
	cd rsaref2
	tar xf rsaref.tar
	cd ..
%ifarch alpha
	echo Patching RSAREF for 64 bitness
%patch1 -p1 -b .alpha
%endif
fi

echo Patching to use PAM
%patch2 -p1 -b .pam

autoheader
autoconf

%build
USE_RSAREF=--with-rsaref
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr --with-etcdir=/etc/ssh --with-libwrap $USE_RSAREF
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr $RPM_BUILD_ROOT/etc/rc.d/init.d $RPM_BUILD_ROOT/etc/pam.d
make install_prefix=$RPM_BUILD_ROOT install
touch $RPM_BUILD_ROOT/etc/ssh/ssh_host_key
install -m644 $RPM_SOURCE_DIR/ssh.pam $RPM_BUILD_ROOT/etc/pam.d/ssh
install -m755 $RPM_SOURCE_DIR/sshd.init $RPM_BUILD_ROOT/etc/rc.d/init.d/sshd.init
for I in 3 5; do
	DIR=$RPM_BUILD_ROOT/etc/rc.d/rc$I.d
	mkdir -p $DIR
	ln -s ../init.d/sshd.init $DIR/S55sshd
done

for I in 0 1 2 6; do
	DIR=$RPM_BUILD_ROOT/etc/rc.d/rc$I.d
	mkdir -p $DIR
	ln -s ../init.d/sshd.init $DIR/K45sshd
done
install -m600 host_config.sample $RPM_BUILD_ROOT/etc/ssh/ssh_config
sed 's:_ETCDIR_:/etc/ssh:' < server_config.sample > sshd_config
install -m600 sshd_config $RPM_BUILD_ROOT/etc/ssh/sshd_config
strip $RPM_BUILD_ROOT/usr/sbin/* $RPM_BUILD_ROOT/usr/bin/* ||:

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ ! -f /etc/ssh/ssh_host_key -o ! -s /etc/ssh/ssh_host_key ]; then
	# Pre 1.2.20-1 RPM config was directly in /etc
	if [ -f /etc/ssh_host_key -a -s /etc/ssh_host_key ]; then
		mv /etc/ssh_host_key /etc/ssh_host_key.pub /etc/ssh/
		mv /etc/ssh_known_hosts /etc/ssh/ >/dev/null 2>&1 ||:
		mv /etc/ssh_random_seed /etc/ssh/ >/dev/null 2>&1 ||:
	else
        	/usr/bin/ssh-keygen -b 1024 -f /etc/ssh/ssh_host_key -N ''
	fi
fi

%files
%doc COPYING ChangeLog INSTALL README README.CIPHERS README.SECURERPC
%doc README.SECURID README.TIS README.PAM RFC RFC.nroff TODO
/usr/bin/ssh-keygen
/usr/man/man1/ssh-keygen.1
/usr/bin/make-ssh-known-hosts
/usr/sbin/sshd
/usr/man/man8/sshd.8
/usr/man/man1/make-ssh-known-hosts.1
%config /etc/ssh/sshd_config
%config /etc/pam.d/ssh
%config /etc/rc.d/init.d/sshd.init
/etc/rc.d/rc3.d/S55sshd
/etc/rc.d/rc5.d/S55sshd
/etc/rc.d/rc0.d/K45sshd
/etc/rc.d/rc1.d/K45sshd
/etc/rc.d/rc2.d/K45sshd
/etc/rc.d/rc6.d/K45sshd

%files clients
%config /etc/ssh/ssh_config
/usr/bin/ssh
/usr/bin/slogin
/usr/bin/ssh-agent
/usr/bin/ssh-add
/usr/bin/scp
/usr/bin/ssh-askpass
/usr/bin/ssh-keygen
/usr/man/man1/ssh-keygen.1
/usr/man/man1/ssh-agent.1
/usr/man/man1/ssh-add.1
/usr/man/man1/scp.1
/usr/man/man1/slogin.1
/usr/man/man1/ssh.1
